// This program is similar to entlist, but it only collects and writes
// out the keys specified in its command-line argument, and the
// collects and writes out all the values, & cracks spawnflags


#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <math.h>

#include "reader.h"
#include "scanner.h"
#include "buffer.h"
#include "dict2.h"

#include "entlib.h"

//  Note: the code is dangerous, & doesnt check bounds for MXK/F

char target[10][MXK];       // targetted keys, 11 max
int targets;                // number of targets


// an Item with an occurrence-count
class NumItem : public Item {
public:
  NumItem(char *word) : Item(word){ num = 1;}
  int Number() {return num;}
  void Tick(){num++;}
protected:
  int num;
};

// just a wrapper for Item
class Value : public Item {
public:
  Value(char *name) : Item(name) {};
};

// This is just a list of values.
class Values : public Dict<Value> {
public:
  Values() : Dict<Value>() {};
  void add(char *val);
  void Write(ostream &);
  void Write_Cracked(ostream &);
};

class Values_iter : public Dict_iter<Value> {
public:
  Values_iter(Values &values) : Dict_iter<Value>(values) {};
//  int ReadWords(istream &in);
};

void Values::add(char *word)
{
  Values_iter iter(*this);
  if (!iter.find(word))
    iter.add(new Item(word));
}

void Values::Write(ostream &out)
{
  Values_iter iter(*this);
  Value *curr;
  iter.first();
  while (curr = iter.current()) {
    out << ' ' << curr->Name();
    iter.next();
  }
}

void Values::Write_Cracked(ostream &out)
{
  int array[8] = {0, 0, 0, 0, 0, 0, 0, 0};
  int flag, flags, i;
  Values_iter iter(*this);
  Value *curr;
  iter.first();
  while (curr = iter.current()) {
    sscanf(curr->Name(), "%d", &flags);
    int base = 1;
    for (i = 0; i < 8; i++) {
      if (flag = flags&base) {
	array[i] =1;
      }
      base = base*2;
    }
    iter.next();
  }
    for (i = 0; i < 8; i++) {
      if (array[i]) {
	out << "x ";
      }
      else {
	out << "0 ";
      }
    }

}


// Keys have labels and frequency info.
// Somehow I don't think I've grasped the spirit of iterators.

class Key : public NumItem {
public:
  Key(char *word) : NumItem(word){}
  void Write(ostream &out);
//  void Write(ostream &out) {out << Name() << ':' << Number();}
  add(char *val) {values.add(val);}
protected:
  Values values;
};

void Key::Write(ostream &out)
{
  out << Name () << ' ';
  if (strcmp(Name(),"spawnflags")) {
    values.Write(out);
  }
  else {
    values.Write_Cracked(out);
  }
}

class Keys : public Dict<Key> {
public:
  Keys() : Dict<Key>() {}
  Key *add(char *);
  void Write(ostream &, int num);
//  void Read(istream &);
//  void Read(char *);
};

class Keys_iter : public Dict_iter<Key> {
public:
  Keys_iter(Keys &keys) : Dict_iter<Key>(keys) {};
//  int ReadWords(istream &in);
};


Key* Keys::add(char *word)
{
  Keys_iter iter(*this);
  Key *found;
  if (found=iter.find(word)) {
    found->Tick();               // increase the count
    return found;
  }
  else {
    iter.add(new Key(word));   // count starts at 1
    return iter.current();
  }
}

void Keys::Write(ostream &out, int num) //num=#occ. of entity Keys are in
{
  Keys_iter iter(*this);
  Key *curr;
  iter.first();
  while (curr = iter.current()) {
    out << "     ";
    curr->Write(out);
    out << '\n';
    iter.next();
  }
  out.flush();
}

// entities record info about how many occurrences, and what keys

class Entity : public NumItem {
public:
  Entity(char *name) : NumItem(name) {};
  void Write(ostream &);
  Key *add(char *key) {keys.add(key);}
protected:
  Keys keys;
};

void Entity::Write(ostream &out)
{
  out  << Name() << '\n';
//  out  << Name() << ':' << Number() << ":\n";
  keys.Write(out, Number());
}

class EntDict : public Dict<Entity> {
public:
  EntDict() : Dict<Entity>() {};
  Entity *add(char *);
  void Write(ostream &);
};

class EntDict_iter : public Dict_iter<Entity> {
public:
  EntDict_iter(EntDict &entdict) : Dict_iter<Entity>(entdict) {};
};

Entity  *EntDict::add(char *word)
{
  EntDict_iter iter(*this);
  if (iter.find(word))
    iter.current()->Tick();       // register occurrence
  else
    iter.add(new Entity(word)); // count starts at 1
  return iter.current();
}

void EntDict::Write(ostream &out)
{
  EntDict_iter iter(*this);
  iter.first();
  Entity *curr;
  while (curr = iter.current()) {
    curr->Write(out);
//    out << '\n';
    iter.next();
  }
  cout.flush();
}

EntDict entdict;


void Read_Entry(Reader &reader)
{
   char linebuf[BFL];
   char entname[MXK]; // entity name
   char entity[MXF][2][MXK]; // 0 for key, 1 for value
   Entity *curr_ent;
   int f = 0;   // initialize index to fields for reading-in
   while (reader.Get(linebuf,BFL-1)) {
     if (linebuf[0]=='}') {               // end of entity, time to dump it
//      cout << " ***** \n";
       if (f) {  // f!= only if some targetted fields were found
	 int i;
	 for (i = 0; i < f; i++) {
	   curr_ent = entdict.add(entname);
//	   cout<<entity[i][0]<<':'<<entity[i][1]<<'\n';
	   curr_ent->add(entity[i][0])->add(entity[i][1]);
	 }
       }
       return;
     }
     else {       // pull in a field
       Get_Field(linebuf,entity[f][0],entity[f][1]);
       char *fieldname = entity[f][0];
       char *valname = entity[f][1];
       if (!strcmp(fieldname,"classname")) {
	 strcpy(entname,valname);
//	   curr_ent = entdict.add(entity[f][1]);
	 // since f doesn't incr, classname isn't recorded in entity
       }
       else if (blank_spawnflags(fieldname, valname)) {
	 // blank spawnflags likewise always ignored
       } else {  // otherwise targetted fields recorded
	 int i;
	 for (i=0; i < targets; i++) {
	   if (!strcmp(fieldname,target[i])) {
	     if (!strcmp(fieldname,"spawnflags")) { // if spawn, shave
	       sprintf(valname,"%d",shave_spawnflags(valname));
	     }
	     f++;
	     break;
	   }
	 }
       }
     }
  }
}

void bad_usage()
{
    cerr << "usage:  ents [-f <filespec>] [classname]\n";
    cerr << "  reads entity lists extracted from .bsp's";
    cerr << "  no classname means all entities\n";
    cerr << "  no filespec reads *.ent files in current directory\n";
    cerr << "  add `> [filename' to direct useful output to file\n";
    exit(1);
}

main(int argc, char **argv)
{
   struct ffblk ffblk;
   char filemask[32];
   int argp;
   int done;

  if (argv[1][0] == '-') {
    if (argc < 3)
      bad_usage();
    strcpy(filemask, argv[2]);
    argp = 3;
  }
  else {
    strcpy(filemask, "*.ent");
    argp = 1;
  }
// get targetted keys, if any
   if (argc <= argp) {             //if no keys are specified, spawnflag will be collected
       strcpy(target[0],"spawnflags");
       targets = 0;
   }
   else {
     int i = -1;
     while (argp + (++i) < argc) {
       strcpy(target[i], argv[argp+i]);
     }
     targets = i;
   }

// do the real work
   char linebuf[BFL];
   done = findfirst(filemask,&ffblk,0);
   if (done) {
      cerr << "No entity files found\n";
      bad_usage();
   }
   while (!done) {
      cerr << "reading: " << ffblk.ff_name << '\n';
      Reader reader(ffblk.ff_name, cout);
      while (reader.Get(linebuf,BFL-1))
	if (linebuf[0] == '{')
	  Read_Entry(reader);
      done = findnext(&ffblk);
   }
   entdict.Write(cout);
}


