#include <stdio.h>
#include <stdlib.h>
#include <dir.h>

#include "reader.h"
#include "scanner.h"
#include "buffer.h"
#include "word.h"
#include "dict2.h"

#include "entlib.h"

//  Note: the code is dangerous, & doesnt check bounds for MXK/F

char filename[32];  // name of file currently being read.
int entityfound;    // whether useful entity found in current file


/*
   The purpose of the EntDict class is to be a dictionary of
   entity-types, keyed by classname, with each entry being a
   KeyDict, that is a list of Keys that appear with that Entity.
*/

class KeyDict : public Words {
public:
  KeyDict() : Words() {};
  void Write(ostream &);
};

void KeyDict::Write(ostream &out)
{
  Words_iter iter(*this);  // OK since KeyDict is based on Words
  iter.first();
  Word *curr;
  while (curr = iter.current()) {
    cout << "     ";
    curr->Write(out);
    iter.next();
  }
  cout.flush();
}

class Entity : public Item {
public:
  Entity(char *name) : Item(name) {};
  void Write(ostream &);
  void add(char *key) {keys.add(key);}
  friend class EntKey_iter;
protected:
  KeyDict keys;
};

class EntKey_iter {
public:
  EntKey_iter(Entity *entity) {iter = new Words_iter(entity->keys);}
  Words_iter *iter;
};

void Entity::Write(ostream &out)
{
  out  << Name() << ":\n";
  keys.Write(out);
}

Entity *theentity;


void write_spawnflags(ostream &out, char *chspawn)
{
  char strspawn[32];
  int sspawn = shave_spawnflags(chspawn);

  sprintf(strspawn,"%d %d %d %d %d %d %d %d",
    sspawn&1,sspawn&2,sspawn&4,sspawn&8,
    sspawn&16,sspawn&32, sspawn&64,sspawn&128);

  out << '\"' << chspawn << "\" = " << strspawn  << '\n';
}


void Read_Entry(Reader &reader)
{
   char linebuf[BFL];
   char entity[MXF][2][MXK]; // 0 for key, 1 for value
//   Entity *curr_ent;

   int relevant = 0; // entity assumed to be uninteresting
   int f = 0;   // initialize index to fields for reading-in
   while (reader.Get(linebuf,BFL-1)) {
     if (linebuf[0]=='}') {
	if (relevant) { // if it has the right classname, check keys
	  EntKey_iter iter(theentity);
	  iter.iter->first();
	  Word *curr;
	  while (curr = iter.iter->current()) { // look at each key
	    int i;
	    int found = 0;
	    for (i=0; i<f; i++) {
	      if (!strcmp(entity[i][0],curr->Name())) {
		found = 1;
		break;      // if key is found stop looking for it
	      }
	    }
	    if (!found)    // if key isn't found, forget it.
	      return;
	    iter.iter->next();
	  }
	}
	if (relevant) {
	  if (!entityfound) {// global
	    cout <<">> " << filename << "<<\n";
	    entityfound = 1;
	  }
	  cout << " ***** \n";
	  int i;
	  for (i = 0; i < f; i++) {
	    if (!strcmp(entity[i][0],"spawnflags")) {
	      cout<<"  \"spawnflags\" ";
	      write_spawnflags(cout, entity[i][1]);
	    }
	    else
	      cout<<"   \""<<entity[i][0]<<'\"'<<" "<<'\"'<<entity[i][1]<<'\"'<<'\n';
//	 curr_ent->add(entity[i][0]);
	 }
       }
       return;
     }
     else {
       Get_Field(linebuf,entity[f][0],entity[f][1]);
       if (!strcmp(entity[f][0],"classname")) {
	 if (!strcmp(entity[f][1],theentity->Name()))
	   relevant = 1;
				    // since f doesn't incr, the classname
				    //  doesn't get into the entity record
       }
       else
	 f++;
     }
  }
}

void bad_usage()
{
    cerr << "usage:  entfind [-f filespec] <classname> [<key1> ... <keyn>]\n";
    cerr << "purpose: find the entities with classname and specified keys\n";
    exit(1);
}
main(int argc, char **argv)
{
// parsing the command-line

  char classname[MXK];
  char filemask[32];
  int argp;

  if (argc == 1) {
    bad_usage();
  }

  if (!strcmp(argv[1],"-f")) {
    if (argc == 2)
      bad_usage();
    strcpy(filemask,argv[2]);
    argp = 3;
  }
  else {
    strcpy(filemask,"*.ent");
    argp = 1;
  }

  theentity = new Entity(argv[argp]);

  argp++;
  int i;
  for (i = argp; i < argc; i++)
    theentity->add(argv[i]);

   cout << "results of search for:\n";
   theentity->Write(cout);
   cout << "\n";

// the actual work
   struct ffblk ffblk;
   int done;
   char linebuf[BFL];

   done = findfirst(filemask,&ffblk,0);
   while (!done) {
      strcpy(filename,ffblk.ff_name);
      entityfound=0;
      if (entityfound)
	cout << "\n";
      cerr << "reading " << filename <<'\n';
      Reader reader(filename, cout);
      while (reader.Get(linebuf,BFL-1))
	if (linebuf[0] == '{')
	  Read_Entry(reader);
      done = findnext(&ffblk);
   }
   exit(0);  // wouldn't that be nice
}


