#include <string.h>
#include "buffer.h"

Buffer &Buffer::operator << (const char *from)
{
  char c;
  while (c == *from++)
    Push(c);
  return *this;
}

ostream &operator <<(ostream &out, Buffer &buf) {
  return out << (char *) buf;
}

/*
void Buffer::Dump(char *out) const
{

  for (char *cp = string; cp < ptr;  cp++)
   (*out++) = *cp;
  *out = '\0';
}


char *Buffer::operator()() const
{
  char *cpt = new char(sizeof(char)*(Len()+1));
  Dump(cpt);
  return cpt;
}
*/

HBuffer::HBuffer(const HBuffer &buf) :
	  Buffer(new char[buf.Len()+1],buf.Len()) {
  max = buf.max;
  ptr = buf.ptr;
  strcpy(string,buf);
}

HBuffer &HBuffer::operator = (HBuffer &buf)
{
  if (this != &buf) {
    delete[] string;
    string = new char[buf.max-buf.string+1];
    max=buf.max;
    ptr = buf.ptr;
    strcpy(string, buf);
  }
  return *this;
}

