#  reads the .ec files & tries to make sense of some of what's in them

use Lick;

open SPAWN, ">spawn.qkf";       #spawnflag info written here
open SPAWNKEYS, ">spnkeys.qkf"; #a dictionary linking ents to their spawn
open SPECHINTS, ">spec.qkf";    #entities, specifics, & hints
open DROPPOS, ">droppos.qkf";   #droppox info here
open DROPKEYS, ">dropkeys.qkf"; #keys here
open INFO, ">info.qkf";         #bbox etc. info
open ENTSPECS, ">entspec.qkf";   #the file for entfrm.pl & entqtx.pl

$boxes =  "droppos.qkf";        #which keys have value-lists
$entfile = "mapents";   #the entfind outpu

#
# find the specifics in the maps
#
if (!($entdata = Lick->new($entfile))) {
  die "can't open file: $entfile\n";
}

while ($line = $entdata->next) { 
  $line =~ /(\w+)/;
  $ent = $1;
#print "$ent\n";
  while ($line = $entdata->more) {
    if ($line =~ /^\s*\((\w+)\)/) {
      push @{$mapents{$ent}{opt}}, $1;
    } elsif  ($line =~ /^\s*(\w+)/) {
      push @{$mapents{$ent}{obl}}, $1;
    } else {last;}
    push @{$specifics{$1}}, $ent;
  }
}

#
# get the specifics with alternative-value lists (like thingtype)
#
if (open BOXES, $boxes) {
  @boxes = <BOXES>;
  @boxes = split '\s+', join ' ', @boxes;
  close BOXES;
#  print STDERR join ' ', @boxes
 } else {
   print STDERR "No file `$boxes' for combobox-type values\n";
 }


#
# this function tries out various ways of matching single lines
#  against standard patterns for giving info about flags & specifics,
#  & returns the results & name of the first one found.
#
sub flagmatch {
  my $line = shift;
  #
  # if flag is set, something terrible happens  
  if ($line =~ /if\s*(\w+)\s*is\s*set,\s*(.*)\s*/i) {
    $type = 'set';
  }
  #
  # flag =/-/: something terrible happens
  elsif ($line =~ /^\s*(\w+)\s*[=\-:]\s*(.+)\s*$/i) {
    $type = 'eq';
  }
  #
  # 'flag' (=/-/:) something terrible happens
  elsif ($line =~ /^\s*['"`](\w+)['"]\s*[=\-:\s]\s*(.+)\s*$/i) {
    $type = 'quote';
  }
  # 'flag' (not followed by any description, prolly by combo stuff)
  elsif ($line =~ /^\s*['"`](\w+)['"]\s*/) {
    return ($1, "", 'quote');
  }
  #
  # 1) something terrible happens
  elsif ($line =~ /^\s*(\d+)\)\s*(.+)\s*$/i) {
    $type = 'paren';
  }
  #
  # flag something terrible happens 
  #   this should be the last one.
  elsif ($line =~ /^\s*(\w+)\s*(.+)\s*$/i) {
    $type = 'plain';
  } else {
    return (0, 0, 0);
  }
  
  return ($1, $2, $type);
}

while ($file = <*.ec>) {
  open FILE, $file;
  $spawn = "";
  while ($line = <FILE>) {
    if ($line =~ m|/\*\s*QU\S+\s*(\S+)\s*\(.*?\)|) {
      #
      # read the first line, get entity name, bbox info, spawnflag tags
      #
      $entity = $1;
      print INFO "$entity:\n  file: $file\n";
      if ($' =~ /^\s*\?/) {
      } elsif ($' =~ /^\s*\((.*?)\)\s*\((.*?)\)/) {
        print INFO "  bb: $1 $2\n";
      } else {
        print "Oddness with $1 in $file\n";
        next;
      }
      $' =~ /^\s*(.*)\s*$/;
      $spawn = $1;
      #
      # note that $spawn will always be "" or the actual spawnflags
      # and that the spawnflags are normalized to upper case
      #
      if ($spawn =~/\S/) {
        @spawn = split /\s+/,uc $spawn;
        $len = @spawn;
        $spawn = join ' ',@spawn;
        #
        #  $spawn is now normalized, so organize lookup.  entities
        #   hash spawnkeys, then there's a table connecting these
        #   to the flags.
        #
        if (exists $spawnkey_lookup{$spawn}) {
          $key = $spawnkey_lookup{$spawn};
        }
        else {
          $key = $spawnkey_lookup{$spawn} = uc $entity;
        }
        $spawnkeys{$entity}=$key;
        print SPAWNKEYS "$entity $key\n";
        @{$spawnflags{$key}{flaglist}} = @spawn;
      }
      print SPECHINTS "$entity\n";
      #
      #  now read the rest of it, trying to get spawnflag & specifics
      #   hints, & drop-box info.  The idea is that this info will be
      #   found in lines of certain stereotyped forms, for spawnflags
      #   noted on the first line, and specifics that occur in the map. 
      #
      # 
      $descfound = 0; 
      SLURP: while ($line = <FILE>) {
        if ($line =~ m|\*/|) {
          last;
        }
        #
        # this function tries to find descriptions of specifics & spawnflags
        #
        ($flag, $desc, $type) = flagmatch($line);
        #
        # $type is 0 when line is blank, and not often otherwise
        #
        if  ($type) {
          #
          # checking for spawnflag info
          #
          if ($spawn =~ /\b$flag\b/i) {
            @descs = @{$spawnflags{$key}{flagdesc}{uc $flag}};
            $diff = 1;
            foreach $prior (@descs) {
              if ($desc eq $prior) {
                $diff = 0;
                last;
              }
            }
            if ($diff) {
              push @{$spawnflags{$key}{flagdesc}{uc $flag}}, $desc;
            }
#           print STDERR "$flag\n";
            #
            # since we've got it as a spawnflag, it's not
            #  a specific
            next;
          }
          #
          # going for specifics info: spec should either exist in
          # the maps (tho not necessarily for that entity), or have
          # a `marked' format, eg. a separator and/or quotes, this
          # latter case is marked as questionable
          #
          if ($flag =~ /^(default|note)$/i ||  # these are not specifics
              $desc =~/^\d+$/) {               # this is prolly a default
            next;
          }
          if (!$descfound) {
            if ($line =~ /$------/ || ($type != 0 && $type ne 'plain')) {
              $descfound = 1;   # actually it just won't be
            } elsif ($type eq plain) {
              print INFO "  desc: $line";
              $descfound = 1;
            }
          }
          if (exists $specifics{$flag}) {
             print SPECHINTS "  $flag:  $desc\n";
             $codents{$entity}{$flag} =  $desc;
          } elsif ($type ne 'plain') {
             print SPECHINTS "  $flag:  ?? $desc\n";
             $codents{$entity}{$flag} = "?? $desc\n";
          }
          #
          #  next, the stuff coming after a specific might be an
          #  enumeration of possible values, but only if the flags 
          #  are numeric, & one of the non-plain formats
          #  is used
          #
          $specific = "$flag";   # we might need this later
          $dropkey = "";       # initialize this
          while ($line = <FILE>) {
          ($flag, $desc, $type) = flagmatch($line);
            if ($flag !~ /^\d+$/ || $type eq 'plain' || !$type) {
              #
              # cool PERL control structure
              #
              if ($dropkey) {
                if (exists $dropkeys{$dropkey}) {
                  $droptag = $dropkeys{$dropkey}
                } else {
                  $droptag = $dropkeys{$dropkey} = uc "$entity\_$specific";
                  print DROPPOS "$droptag\n$dropkey";
                }
                print DROPKEYS "$entity $specific $droptag\n";
                $dropkeys{$entity}{$specific} = $droptag;
              }
              redo SLURP;
            } else {
              $dropkey .= "  $flag $flag) $desc\n";
            }
          }
        }
      }
    }
  }
}

foreach $flagtype (sort keys %spawnflags) {
  print SPAWN "$flagtype\n";
  $i = 0;
  foreach $flag (@{$spawnflags{$flagtype}{flaglist}}) {
    $fl = 2**($i++);
    if ($flag eq 'X') {
      next;
    }
    @desc = @{$spawnflags{$flagtype}{flagdesc}{$flag}};
    print SPAWN "  $fl $flag @desc[0]\n";
    if (@desc > 1) {
      foreach $desc (@desc[1..$#desc]) {
        print SPAWN " ... $desc\n";
      }
    }
  }
}

sub finish {
  my ($ent, $spec) = @_;
  if ($spec eq 'spawnflags' && exists $spawnkeys{$ent}) {
    print  ENTSPECS " $spawnkeys{$ent}";
  }
  if  (exists $dropkeys{$ent}{$spec}) {
    print ENTSPECS " $dropkeys{$ent}{$spec}";
  }
  if (exists $codents{$ent}{$spec}) {
    print ENTSPECS qq| "$codents{$ent}{$spec}|;
  }
  print ENTSPECS "\n";
  $specs{$spec} = 1;
}

foreach $entity (sort keys %codents) {
  undef %specs;
#  print "$entity: $codents{$entity}{_codefile}\n";
  print "  $entity\n";
  print ENTSPECS "$entity: 1\n";
  if (!exists $mapents{$entity}) {
    print "  not in maps\n";
  }
  # the obligatory ones
  foreach $spec  (@{$mapents{$entity}{obl}}) {
    print ENTSPECS "  $spec";
    finish $entity, $spec;
  }
  # the optional ones
  foreach $spec  (@{$mapents{$entity}{opt}}) {
    print ENTSPECS "  ($spec) 1";
    finish $entity, $spec;
  }
  # the ones not found in the maps
  foreach $spec (keys %{$codents{$entity}}) {
    if (!exists $specs{$spec}) {
    print ENTSPECS "  ($spec) 1";
    finish $entity, $spec;
    }
  }
}
