package Lick;

## a simple line-at-time filereading package for indent-formatted data:
#
#  $data = Lick->new("data.txt")  # opens data.txt for reading
#  $line = $data->next;            # sets $line to the next non-indented line;
#                                  #   returns "" if there isn't one.
#  $line = $data->more;            # sets $line to the next non-blank
#                                  #   indented line, "" if there is none.


$handle = 'fh00';

sub new {

  my $class = shift; 
  my $filename = shift;


  if (!open($handle, $filename)) {
    return "";
  }

  $self = {};
  $self->{file} = $handle;
  $self->{name} = $filename;
  $self->{line} = 0;

  $handle++;

  bless $self;
  return $self;

}

sub next {
  $self = shift;

#print "trying to read ", $self{"filename"};

  my $lookahead = $self->{look};

  if ($lookahead && $lookahead =~ /^\S/) {
    $self->{look} = "";
    $self->{line}++;
    return $lookahead
  }

  my $file = $self->{file};
  while (<$file>) {
    $self->{line}++;
    if (/^\S/) {
      return $_;
    }
  }
  return "";
}


sub more  {
  my $self = shift;

  my $file = $self->{file};

  while (<$file>) {
    if (/^\S/) {
      $self->{look} = $_;
      return "";
    } elsif (/^\s+\S+/) {
      $self->{line}++;
      return $_;
    }
  }
  return "";
}

sub name {
  return $self->{name};
}

sub line {
  return $self->{line};
}
