# extracts entity comments from source code, attempting to identify
#  entities that have been commented out.  These are written to the
#  file 'dropped.txt', & on a second pass they're omitted from the
#  output.  A list of entities is also written to 'ents.txt'.

use Cwd; # standard library for tracking current working diretory


#
# reads in list of entities that seem to be commented out
#
if (open DROPPED, "dropped.txt") {
  while ($line = <DROPPED>) {
    if ($line =~/^(\w+)\:\s*(\S+)/) {
       $dropped{$1} = $2;
    }
  }
  close DROPPED;
}


open DROPPED, ">dropped.txt";
open ENTNAMES, ">ents.txt";

$neardir = cwd();
$fardir = $ARGV[0] or $fardir = $homedir;


sub check_line {
  my $line = shift;
  if ($ent && $line =~ /void.*$ent/) {
    print DROPPED "$ent: $file\n"
  }
} 


chdir($fardir);
@files = <*.c>;

@files or die "No .hc files in this directory.\n  Specify .hc directory as argument\n.";

foreach $file (@files) {
  chdir($fardir);
  open INFILE, "<$file";
  $file =~ s/\.c/\.ec/i;
#  print "$file\n";
  chdir($neardir);
  open OUTFILE, ">$file";
  while ($line = <INFILE>) {
    if ($line =~ m|/\*\s*QU\S+\s*(\w+)|) {
      $ent = $1;
      if (exists $dropped{$ent}) {
        print STDERR "dropping $ent\n";
        next;
      }
      print ENTNAMES "$ent\n";
      print OUTFILE $line;
      while ($line = <INFILE>) {
        print OUTFILE $line;
        &check_line($line);
        if ($line =~ m|\*/|) {
          print OUTFILE "\n******************\n\n";
          last;
        }
      }
    } elsif ($line =~ m|/\*|) {
        &check_line($');
        while ($line = <INFILE>) {
          if ($line =~ m|\*/|) {
            last;
          }    
          &check_line($line);        
      }
    }
  }
}
