#define VERSION "1.30"

/*
 -- QDATA Scripter --
 This program generates a QDATA script to convert PCX images to M8
 Heretic2 Textures .. It is meant to be a frontend to EASY creation
 of script files for QDATA .. because they are such a pain in the ass =)

 This program just prints out the script.. so you just pipe it to a text
 file.. that will turn it to a file (I included a batch file to do that
 for you.

 Revision History:

	= 1.30 =
		* Glyphus pointed out an intermittant bug that would detect some pcx's as not 256 color
		  while they really are. After some tinkering I found that it was a problem with reading
		  the pallete info block... well now I don't read it.. 
		* the pcxheader functions were moved into sperate source files, it's moving towards
		  being a class.
		* this is a quickfix release I have a more major release planned that fixes some of the
		  ugliness that was started with. =)

    = 1.20 =
		* Fixed the Power of 2 Bug... now should properly detect if the image has a power
		  of 2 problem and warn about it.
		* Packaged new Source with 1.20 .. I think I've been packagaing it with ancient code
		  before =)

	= 1.15 =
		* Implemented checking if the pcx is really 256 colors
		* Implemented a warning when the image is not a power of 2 (thanks Balr14)

	= 1.10 =
		* put the filenames in the script in quites.. QData likes it.. and it avoids a problem
		  I've run it when a file had a space in the name and QData wouldn't recoginze the space
		  properly.
		* Added checks for oversized ( >256 pixels ) images
		* Added checks for bad size ( not multiple of 16 ) images

	= 1.00a =
		* a small bug in the config file would make qdata not find the files addresed that

	= 1.00 =
		* not using Allegro library anymore.. (this reduces the size of the exe
		  and should be easier on memory)
		  Many thanks to Robin for giving me a hand with the PCX header info
		* some major code cleanup .. (closed files after opening them.. etc)

	= 0.95 (Internal) =
		* removed the use of apstrings to not infringe possible copyrights
		  readme.txt touchups =)

	= 0.90 =
		* Initial Release

-----------------------------------------------------------------------------------------------

*/

// TO BE COMPILED WITH DJGPP

// ==================================================================================

#include <stdio.h>
#include <fstream.h>
#include <string>
#include <math.h>
#include "../pcx/pcxheader.h"

// Functions declared here
double	logB			(double base, double number);
bool	checkheader		( const pcxheader & header , const string & file );
bool	loadPCX			( string filename , int &height , int &width );
int		realbpp			( const pcxheader & header );
void	processlist		( const string & filename );
void	loadCFG			( string &s_spath , string &s_dpath );
void	versionfoo		( );
// End of function declares


// ----------------------------------------------------------------------
// this is the main
main()
{
	system( "dir *.pcx /b > pcx.lst" ); // do a system call to do a dir (simplest thing I could think of =)

	versionfoo();
	
	processlist("pcx.lst");

}

// ===== The Rest Of The Functions are below this ======================================

// ----------------------------------------------------------------------
// this interprets the data in the pcxheader structure and uses what is needed
// returns false if there was a problem
bool loadPCX( string filename , int &height , int &width )
{
	pcxheader	header;
	bool		error;
	
	readPCXheader ( header , (char *)filename.c_str() );
	
	if (!checkheader( header , filename ))
		return false;
	
	height = header.height;
	width  = header.width;
	
	return true; 	// analize header for probs
}

// ----------------------------------------------------------------------
// pre: well nada I think .. well the config file is valid
// post: loads the source and dest paths (for use in the script)
void loadCFG( string &s_spath , string &s_dpath )
{
	ifstream in( (char *) "scripter.cfg" );
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening scripter.cfg ..\n Exiting.." );
		exit( 1 );
	}
	getline( in , s_spath );
	getline( in , s_dpath );
}

// ----------------------------------------------------------------------
// pre: nada
// post: displays the version , other foo about this prog with "//" infront
//       so it is ignored by qdata
void versionfoo()
{
	printf( "//Created with QDATA Scripter Version: %s\n" , VERSION );
}

// ----------------------------------------------------------------------
// this is masicaly the main chunk.. this takes the list of pcx's
// and goes through them 1 by 1 and makes the script file..
void processlist( const string & filename )
{
	int			height,
				width;
	
	bool		error;

	string		s_line,
				s_source,
				s_dest,
                s_spath,
                s_dpath;

	loadCFG( s_spath , s_dpath );

	ifstream in( filename.c_str( ) ); // open the list of pcx's
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening pcx.lst ..\n Exiting.." );
		exit( 1 );
	}

	getline( in , s_line ); // get first line from list
	while( !in.eof() )
	{
		error = loadPCX( s_line.c_str() , height , width );
		if( error ) // check if succesfuly loaded.
		{
			s_source = s_spath + s_line;  //  put the source path together
			s_dest = s_dpath + s_line.substr( 0 , s_line.length( ) - 4 );  // and the destination
			printf( "$load \"%s\" $mip \"%s\" 0 0 %i %i\n" , s_source.c_str( ) , s_dest.c_str( ) , width , height ); // now print the formatted string
		}
		getline( in , s_line ); // get the next line from the list  
	}

}

// ----------------------------------------------------------------------
// this runs through the header and checks for not allowed pcx's
// and returns true if ok.. false if problem .. also dumps an error
// message to stderr
bool checkheader( const pcxheader & header , const string & file)
{
/*	
	
	 - critical -
	1 - width and height need to be multiples of 16
	2 - max height and width is 256
	3 - bpp is not 8
	 - non critical -
	1 - width or height are not powers of 2
	*/

	// critical errors
	if ( (header.width%16 != 0 ) || ( header.height%16 != 0 ) )
	{
		fprintf( stderr , "Skipping %s -> width or height is not a multiple of 16. \n", file.c_str( ) );
		return false;
	}
	if ( ( header.width > 256 ) || ( header.height > 256 ) )
	{
		fprintf( stderr , "Skipping %s -> width or height is greater than 256. \n", file.c_str( ) );
		return false;
	}
	if ( realbpp(header) != 8 )
	{
		fprintf( stderr , "Skipping %s -> is not a 256 Color PCX image. \n", file.c_str( ) );
		return false;
	}
	// non critical errors
	// I still don't understand why I need to (int)(float) it.. instead of just (int)
	// just (int) would subtract 1 from what the answer was.. so after some trail and error
	// I came up with this.. weird.. but works..
	if ( header.height != pow(2,(int)(float) logB(2,header.height)) || header.width != pow(2 ,(int)(float) logB(2,header.width)) )
	{
		fprintf( stderr , "!Warning! %s -> width or height is not a power of 2.\n", file.c_str( ) );
	}


	return true;
}

// ----------------------------------------------------------------------
// this tests the image's real bpp
int realbpp( const pcxheader & header )
{
	if ( header.bpp != 8 ) // non 8bit return bpp properly
		return header.bpp;

	if ( ( header.bpp == 8 ) && ( header.nplanes == 3 ) ) // 24 bit = bpp8 + nplanes3
		return 24;
	
	if ( ( header.bpp == 8 ) && ( header.nplanes == 1 ) ) // 8 bit = bpp8 + nplanes1
		return 8;
	return (-1); // should never get here
}

// ----------------------------------------------------------------------
// logartithm with a base (used for some checks.. might aswell make it easier)
double logB(double base, double number)
{
	return ( log( number ) / log( base ) );
}