#define VERSION "1.20"

/*
 -- QDATA Scripter --
 This program generates a QDATA script to convert PCX images to M8
 Heretic2 Textures .. It is meant to be a frontend to EASY creation
 of script files for QDATA .. because they are such a pain in the ass =)

 This program just prints out the script.. so you just pipe it to a text
 file.. that will turn it to a file (I included a batch file to do that
 for you.

 Revision History:
  = 1.20 =
   * Fixed the Power of 2 Bug... now should properly detect if the image has a power
     of 2 problem and warn about it.
   * Packaged new Source with 1.20 .. I think I've been packagaing it with ancient code
     before =)

  = 1.15 =
   * Implemented checking if the pcx is really 256 colors
   * Implemented a warning when the image is not a power of 2 (thanks Balr14)

  = 1.10 =
   * put the filenames in the script in quites.. QData likes it.. and it avoids a problem
     I've run it when a file had a space in the name and QData wouldn't recoginze the space
     properly.
   * Added checks for oversized ( >256 pixels ) images
   * Added checks for bad size ( not multiple of 16 ) images

  = 1.00a =
   * a small bug in the config file would make qdata not find the files addresed that

  = 1.00 =
   * not using Allegro library anymore.. (this reduces the size of the exe
     and should be easier on memory)
     Many thanks to Robin for giving me a hand with the PCX header info
   * some major code cleanup .. (closed files after opening them.. etc)

  = 0.95 (Internal) =
   * removed the use of apstrings to not infringe possible copyrights
     readme.txt touchups =)

  = 0.90 =
   * Initial Release

-----------------------------------------------------------------------------------------------

*/

/*
This is the PCX header layout..
Byte      Item          Size   Description/Comments
 0         Manufacturer 1      Constant Flag, 10 = ZSoft .pcx
 1         Version      1      Version information
                               0 = Version 2.5 of PC Paintbrush
                               2 = Version 2.8 w/palette information
                               3 = Version 2.8 w/o palette information
                               4 = PC Paintbrush for Windows(Plus for Windows uses Ver 5)
                               5 = Version 3.0 and > of PC Paintbrush and PC Paintbrush +, includes Publisher's Paintbrush . Includes 24-bit .PCX files
 2         Encoding      1     1 = .PCX run length encoding
 3         BitsPerPixel  1     Number of bits to represent a pixel (per Plane) - 1, 2, 4, or 8
 4         Window        8     Image Dimensions: Xmin,Ymin,Xmax,Ymax
12         HDpi          2     Horizontal Resolution of image in DPI*
14         VDpi          2     Vertical Resolution of image in DPI* 
16         Colormap     48     Color palette setting, see text 
64         Reserved      1     Should be set to 0. 
65         NPlanes       1     Number of color planes 
66         BytesPerLine  2     Number of bytes to allocate for a scanline
                                  plane.  MUST be an EVEN number.  Do NOT
                                  calculate from Xmax-Xmin. 
68         PaletteInfo   2     How to interpret palette- 1 = Color/BW,
                                  2 = Grayscale (ignored in PB IV/ IV +) 
70         HscreenSize   2     Horizontal screen size in pixels. New field
                                  found only in PB IV/IV Plus 
72         VscreenSize   2     Vertical screen size in pixels. New field
                                  found only in PB IV/IV Plus 
74         Filler       54     Blank to fill out 128 byte header.  Set all
                                  bytes to 0 
*/


// TO BE COMPILED WITH DJGPP

// ==================================================================================

#include <stdio.h>
#include <fstream.h>
#include <string>
#include <math.h>

typedef unsigned char byte;
typedef unsigned short word;

// PCX header structure.. I got it all here.. except for the filler..
struct pcxheader
{
	byte	manafacturer; //0
	byte	version;      //1
	byte	encoding;     //2
	byte	bpp;          //3
	word	xmin;         //4
	word	ymin;         //6
	word	xmax;         //8
	word	ymax;         //10
	word	hres;         //12
	word	vres;         //14
	char    colormap[48]; //16
	byte	reserved;	  //64
	byte	nplanes;	  //65
	word    bytesperline; //66
	word	palleteinfo;  //68
	word    hscreensize;  //70
	word    vscreensize;  //72

	int  height;
	int  width;
}; 

// Functions declared here
double	logB			(double base, double number);
word	byteflip		( word x );
word	getword			( FILE * file );
bool	checkheader		( const pcxheader & header , const string & file );
bool	loadPCX			( string filename , int &height , int &width );
int		realbpp			( const pcxheader & header );
void	processlist		( const string & filename );
void	readPCXheader	( pcxheader & header , string filename );
void	loadCFG			( string &s_spath , string &s_dpath );
void	versionfoo		( );
// End of function declares


// ----------------------------------------------------------------------
// this is the main
main()
{
	system( "dir *.pcx /b > pcx.lst" ); // do a system call to do a dir (simplest thing I could think of =)

	versionfoo();
	
	processlist("pcx.lst");

}

// ===== The Rest Of The Functions are below this ======================================

// ----------------------------------------------------------------------
// this is supposed to flip a word..
// eg: AB CD => CD AB
word byteflip ( word x )
{
	byte high	= x>>8;
	byte low	= x&255;
	return ( ( low<<8 ) + high );
}


// ----------------------------------------------------------------------
// this is a rewrite of getw(FILE *) ..
// the getw seemed to grab wrong size words.. so I made one that works
// just right =)
word getword ( FILE * file )
{
	byte low = getc(file);
	byte high = getc(file);
	return ( ( low<<8 ) + high );
}

// ----------------------------------------------------------------------
// reads the pcx header into the header structiure..
void readPCXheader( pcxheader & header , string filename )
{
	FILE * file = fopen ( filename.c_str( ) , "rwb+" );
	header.manafacturer	= getc ( file );
	header.version		= getc ( file );
	header.encoding		= getc ( file );
	header.bpp			= getc ( file );
	// the following words are byteflipped because they are written least
	// significant byte first
	header.xmin			= byteflip ( getword( file ) );
	header.ymin			= byteflip ( getword( file ) );
	header.xmax			= byteflip ( getword( file ) );
	header.ymax			= byteflip ( getword( file ) );
	header.hres			= byteflip ( getword( file ) );
	header.vres			= byteflip ( getword( file ) );

	header.height		= header.ymax - header.ymin + 1;
	header.width		= header.xmax - header.xmin + 1;
	for (int a=0; a<=47; a++) // get the 48 byte color map block
		header.colormap[a] = getc( file );
    // might aswell read the rest.. I need the nplanes anyways
	header.reserved		= getc ( file );
	header.nplanes		= getc ( file );
	header.bytesperline = byteflip ( getword( file ) );
	header.palleteinfo	= byteflip ( getword( file ) );
	header.hscreensize	= byteflip ( getword( file ) );
	header.vscreensize	= byteflip ( getword( file ) );

	fclose ( file );
}

// ----------------------------------------------------------------------
// this interprets the data in the pcxheader structure and uses what is needed
// returns false if there was a problem
bool loadPCX( string filename , int &height , int &width )
{
	pcxheader	header;
	bool		error;
	
	readPCXheader ( header , filename );
	
	if (!checkheader( header , filename ))
		return false;
	
	height = header.height;
	width  = header.width;
	
	return true; 	// analize header for probs
}

// ----------------------------------------------------------------------
// pre: well nada I think .. well the config file is valid
// post: loads the source and dest paths (for use in the script)
void loadCFG( string &s_spath , string &s_dpath )
{
	ifstream in( (char *) "scripter.cfg" );
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening scripter.cfg ..\n Exiting.." );
		exit( 1 );
	}
	getline( in , s_spath );
	getline( in , s_dpath );
}

// ----------------------------------------------------------------------
// pre: nada
// post: displays the version , other foo about this prog with "//" infront
//       so it is ignored by qdata
void versionfoo()
{
	printf( "//Created with QDATA Scripter Version: %s\n" , VERSION );
}

// ----------------------------------------------------------------------
// this is masicaly the main chunk.. this takes the list of pcx's
// and goes through them 1 by 1 and makes the script file..
void processlist( const string & filename )
{
	int			height,
				width;
	
	bool		error;

	string		s_line,
				s_source,
				s_dest,
                s_spath,
                s_dpath;

	loadCFG( s_spath , s_dpath );

	ifstream in( filename.c_str( ) ); // open the list of pcx's
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening pcx.lst ..\n Exiting.." );
		exit( 1 );
	}

	getline( in , s_line ); // get first line from list
	while( !in.eof() )
	{
		error = loadPCX( s_line.c_str() , height , width );
		if( error ) // check if succesfuly loaded.
		{
			s_source = s_spath + s_line;  //  put the source path together
			s_dest = s_dpath + s_line.substr( 0 , s_line.length( ) - 4 );  // and the destination
			printf( "$load \"%s\" $mip \"%s\" 0 0 %i %i\n" , s_source.c_str( ) , s_dest.c_str( ) , width , height ); // now print the formatted string
		}
		getline( in , s_line ); // get the next line from the list  
	}

}

// ----------------------------------------------------------------------
// this runs through the header and checks for not allowed pcx's
// and returns true if ok.. false if problem .. also dumps an error
// message to stderr
bool checkheader( const pcxheader & header , const string & file)
{
/*	
	
	 - critical -
	1 - width and height need to be multiples of 16
	2 - max height and width is 256
	3 - bpp is not 8
	 - non critical -
	1 - width or height are not powers of 2
	*/

	// critical errors
	if ( (header.width%16 != 0 ) || ( header.height%16 != 0 ) )
	{
		fprintf( stderr , "Skipping %s -> width or height is not a multiple of 16. \n", file.c_str( ) );
		return false;
	}
	if ( ( header.width > 256 ) || ( header.height > 256 ) )
	{
		fprintf( stderr , "Skipping %s -> width or height is greater than 256. \n", file.c_str( ) );
		return false;
	}
	if ( realbpp(header) != 8 )
	{
		fprintf( stderr , "Skipping %s -> is not a 256 Color PCX image. \n", file.c_str( ) );
		return false;
	}
	// non critical errors
	// I still don't understand why I need to (int)(float) it.. instead of just (int)
	// just (int) would subtract 1 from what the answer was.. so after some trail and error
	// I came up with this.. weird.. but works..
	if ( header.height != pow(2,(int)(float) logB(2,header.height)) || header.width != pow(2 ,(int)(float) logB(2,header.width)) )
	{
		fprintf( stderr , "!Warning! %s -> width or height is not a power of 2.\n", file.c_str( ) );
	}


	return true;
}

// ----------------------------------------------------------------------
// this tests the image's real bpp
int realbpp( const pcxheader & header )
{
	if ( header.bpp != 8 ) // non 8bit return bpp properly
		return header.bpp;

	if ( ( header.bpp == 8 ) && ( header.nplanes == 3 ) ) // 24 bit = bpp8 + nplanes3
		return 24;
	
	if ( ( header.bpp == 8 ) && ( header.nplanes == 1 ) ) // 8 bit = bpp8 + nplanes1
		return 8;
	return (-1); // should never get here
}

// ----------------------------------------------------------------------
// logartithm with a base (used for some checks.. might aswell make it easier)
double logB(double base, double number)
{
	return ( log( number ) / log( base ) );
}