/*
This is the PCX header layout..
Byte      Item          Size   Description/Comments
 0         Manufacturer 1      Constant Flag, 10 = ZSoft .pcx
 1         Version      1      Version information
                               0 = Version 2.5 of PC Paintbrush
                               2 = Version 2.8 w/palette information
                               3 = Version 2.8 w/o palette information
                               4 = PC Paintbrush for Windows(Plus for Windows uses Ver 5)
                               5 = Version 3.0 and > of PC Paintbrush and PC Paintbrush +, includes Publisher's Paintbrush . Includes 24-bit .PCX files
 2         Encoding      1     1 = .PCX run length encoding
 3         BitsPerPixel  1     Number of bits to represent a pixel (per Plane) - 1, 2, 4, or 8
 4         Window        8     Image Dimensions: Xmin,Ymin,Xmax,Ymax
12         HDpi          2     Horizontal Resolution of image in DPI*
14         VDpi          2     Vertical Resolution of image in DPI* 
16         Colormap     48     Color palette setting, see text 
64         Reserved      1     Should be set to 0. 
65         NPlanes       1     Number of color planes 
66         BytesPerLine  2     Number of bytes to allocate for a scanline
                                  plane.  MUST be an EVEN number.  Do NOT
                                  calculate from Xmax-Xmin. 
68         PaletteInfo   2     How to interpret palette- 1 = Color/BW,
                                  2 = Grayscale (ignored in PB IV/ IV +) 
70         HscreenSize   2     Horizontal screen size in pixels. New field
                                  found only in PB IV/IV Plus 
72         VscreenSize   2     Vertical screen size in pixels. New field
                                  found only in PB IV/IV Plus 
74         Filler       54     Blank to fill out 128 byte header.  Set all
                                  bytes to 0 
*/


// a few typedefs
typedef unsigned char byte;
typedef unsigned short word;

// PCX header structure.. I got it all here.. except for the filler..
struct pcxheader
{
	// these are actually in the header
	byte	manafacturer; //0
	byte	version;      //1
	byte	encoding;     //2
	byte	bpp;          //3
	word	xmin;         //4
	word	ymin;         //6
	word	xmax;         //8
	word	ymax;         //10
	word	hres;         //12
	word	vres;         //14
	byte	reserved;	  //64
	byte	nplanes;	  //65
	word    bytesperline; //66
	word	palleteinfo;  //68
	word    hscreensize;  //70
	word    vscreensize;  //72
	
	// these are put in later
	char	*filename;
	int		height; 
	int		width;
}; 

// function declares
word	byteflip		( word x );
word	getword			( FILE * file );
void	readPCXheader	( pcxheader & header , char * filename );
// --------------------------------------------------------------------------


#include "pcxheader.cpp"