// ----------------------------------------------------------------------
// this is supposed to flip a word..
// eg: AB CD => CD AB
word byteflip ( word x )
{
	byte high	= x>>8;
	byte low	= x&255;
	return ( ( low<<8 ) + high );
}

// ----------------------------------------------------------------------
// this is a rewrite of getw(FILE *) ..
// the getw seemed to grab wrong size words.. so I made one that works
// just right =)
word getword ( FILE * file )
{
	byte low = getc(file);
	byte high = getc(file);
	return ( ( low<<8 ) + high );
}

// ----------------------------------------------------------------------
// reads the pcx header into the header structiure..
void readPCXheader( pcxheader & header , char * filename )
{
	unsigned long pos = 64;
	
	FILE * file = fopen ( filename , "rwb+" );
	if (file == NULL ) { // check if something went wrong
		printf("Something Went wrong opening %s!\n",filename);
		exit(1);
	}
	header.manafacturer	= getc ( file );
	header.version		= getc ( file );
	header.encoding		= getc ( file );
	header.bpp			= getc ( file );
	// the following words are byteflipped because they are written least
	// significant byte first
	header.xmin			= byteflip ( getword( file ) );
	header.ymin			= byteflip ( getword( file ) );
	header.xmax			= byteflip ( getword( file ) );
	header.ymax			= byteflip ( getword( file ) );
	header.hres			= byteflip ( getword( file ) );
	header.vres			= byteflip ( getword( file ) );

	header.height		= header.ymax - header.ymin + 1;
	header.width		= header.xmax - header.xmin + 1;
	// we're not gonna bother with the 48 byte pallete block
	fsetpos(file,&pos);
	
	header.reserved		= getc ( file );
	header.nplanes		= getc ( file );
	header.bytesperline = byteflip ( getword( file ) );
	header.palleteinfo	= byteflip ( getword( file ) );
	header.hscreensize	= byteflip ( getword( file ) );
	header.vscreensize	= byteflip ( getword( file ) );

	header.filename		= filename;
	fclose ( file );
}
