#define VERSION "0.50"

/*
 -- PCX header Dumper --
 what is this? well it takes a pcx file as a parameter and tells you about it... that's it
 it mainly a debuging tool for my pcx header routines and a tool to quicky tell you things about
 a pcx that you cannot find out from other programs.


 Revision History:
  = 0.50 =
	* Initial Release

-----------------------------------------------------------------------------------------------

*/


// TO BE COMPILED WITH DJGPP

// ==================================================================================

#include <stdio.h>
#include "pcxheader.h"

// Struct declares
struct pref_struct
{
	char * filename;
};
// end of structs

// Functions declared here
pref_struct	parse_params	( pref_struct & pref, int argc, char * argv[] );
void		versionfoo		( );
void		do_the_dump		( const pcxheader & header );
// End of function declares



// ----------------------------------------------------------------------
// this is the main
main( int argc, char *argv[] )
{
	pref_struct pref;
	pcxheader header;
	versionfoo();

	parse_params( pref, argc, argv );

	readPCXheader(header,pref.filename);
	
	do_the_dump(header);
}


// ===== The Rest Of The Functions are below this ======================================

// ----------------------------------------------------------------------
// pre: nada
// post: displays the version , other foo about this prog with "//" infront
//       so it is ignored by qdata
void versionfoo()
{
	printf( "PCX Header Dumper Version: %s\n" , VERSION );
	printf( "-------------------------------\n" );
}

// ----------------------------------------------------------------------
// parse the parameters.. just drops whatever into the pref struct
pref_struct parse_params(pref_struct & pref, int argc, char * argv[] )
{
	if ( argc == 2 )
	{
		pref.filename = argv[1];
	}
	else
	{
		printf("Uage:\n");
		printf("headerdump pcxfilename.pcx\n");
		exit(1);
	}
}

// ----------------------------------------------------------------------
// print out all the info
void do_the_dump( const pcxheader & header )
{
	printf("File                  : %s\n",header.filename);
	printf("Manafacturer          : %i\n",header.manafacturer);
	printf("Version               : %i\n",header.version);
	printf("Encoding              : %i\n",header.encoding);
	printf("BitsPerPixel          : %i\n",header.bpp);
	printf("Window                : (%i,%i) - (%i,%i)\n",header.xmin,header.ymin,header.xmax,header.ymax);
	printf("Horizontal Resolution : %i\n",header.hres);
	printf("Vertical Resolution   : %i\n",header.vres);
	printf("Resevered byte        : %i\n",header.reserved);
	printf("Number of Planes      : %i\n",header.nplanes);
	printf("Bytes per Line        : %i\n",header.bytesperline);
	printf("PalleteInfo           : %i\n",header.palleteinfo);
	printf("Screen Size           : %ix%i\n",header.hscreensize,header.vscreensize);
}
