//
//	Heirarchy
//
//	Convert the motion capture data generated by h2mocap to an heirarchical
//	form.
//
//	The input data is of the form (x,y,z), (x_angle,y_angle,z_angle). All
//	(x,y,z) locations are the positions of "joints" in the figure. All
//	angles give the angle of rotation of a "bone" in the figure, assuming
//	that it started out in a specific orientation along the x (horizontal)
//	axis. See the header files "bones.h" and "mocap.h" for more information.
//
//	The input data is converted to heirarchical form using a known set of
//	joints and bone lengths. The heirarchy begins at the hips. Each position
//	of the figure is recreated by:
//
//	1)	Translating the hip at (0,0,0) and all joints that branch off of it
//		by the x, y, and z amounts needed to move the hip to its captured
//		location; this is recorded as the translation of the figure;
//
//	2)	For each bone that starts at the hip, that bone and all bones that
//		branch off of it are rotated through whatever angles are needed to
//		match the motion-captured rotation of the bone that starts at the
//		hip; the resulting angles are saved as the corresponding bone
//		rotations;
//
//	3)	Step 2 is repeated (recursively) using bones starting at the far
//		end (initially, the end that is not the hip) of the bones just
//		processed in the previous Step 2, until all bones have been
//		processed.
//
///	Note that this algorithm preserves the angles between bones, and relies
//	completely on these angles to obtain the desired locations of the joints
//	for a given pose. This works because the bones stay the same length (or
//	very nearly so) in all positions in the original motion capture data.
//	Note also that this algorithm does not use the bone length data at all.
//
//	Date			Who		Description
//	----------		---		-----------------------------
//	08/04/1999		CJB		Coded
//

#include	<stdio.h>
#include	<string.h>

#include	"CondComp.h"
#include	"bones.h"
#include	"mocap.h"

main()
{
}