//
//	Conditional compilation controls for H2MoCap program
//
//	By Chris Burke
//	serotonin@earthlink.net
//
//	Date			Who		Description
//	----------		---		-------------------------------------------------------
//	07/01/1999		CJB		Coded
//

#ifndef	__CONDCOMPHINCLUDED__
#define	__CONDCOMPHINCLUDED__

#define	__EXPORT_DXF__			0			//	Non-zero to export model in AutoCAD .DXF format
#define	__EXPORT_OBJ__			0			//	Non-zero to export model in WaveFront .OBJ format
#define	__EXPORT_PARTS__		0			//	Non-zero to export one model meshnode per file

#define	__MODEL_IS_CORVUS__		1
#define	__MODEL_IS_KIERA__		0
#define	__MODEL_IS_PLAGUE_ELF__	0
#define	__MODEL_IS_SSITHRA__	0
#define	__MODEL_IS_CHICKEN__	0
#define	__MODEL_IS_IMP__		0

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
//#define	__EXPORT_FRAME_NAME__	"pain101"	//	This is a Quake2 frame
//#define	__EXPORT_FRAME_NAME__	"swipeA6"
//#define	__EXPORT_FRAME_NAME__	"rollA11"
//#define	__EXPORT_FRAME_NAME__	"conjure11"
//#define	__EXPORT_FRAME_NAME__	"roll7"
#define	__EXPORT_FRAME_NAME__	"partfly"
//#define	__EXPORT_MESHMASK__		0xEC63		//	Corvus, no weaps
//#define	__EXPORT_MESHMASK__		0x8000
//#define	__EXPORT_MESHMASK__		(~0xEC63)	//	Corvus weaps only
//#define	__EXPORT_MESHMASK__		0x0004
#define	__EXPORT_MESHMASK__		0xFFFF		//	All parts
#else
#define	__EXPORT_FRAME_NAME__	"dummy"		//	Dummy value
#define	__EXPORT_MESHMASK__		0			//	Dummy value
#endif

#define	__CAPTURE_MOTION__		0
#define	__WRITE_MOCAP_DATA__	1

#define	__WRITE_REFS_DATA__		0
#define	__REFS_FILE_NAME__		"refs.bin"

#define	__WRITE_SKEL_DATA__		0
#define	__SKEL_FILE_NAME__		"skel.bin"

#define	__INSTALL_SWORD__		0
#define	__DO_LIGHT_SABRE__		0
#define	__ZERO_LIGHT_SABRE__	0
#define	__NEW_SWORD_REFS__		0
#define	__NEW_SWORD_GLCMDS__	0
#define	__MAP_HILT_TO_STAFF__	0

#define	__WRITE_TWEAK_FILE__	0
#define	__TWEAK_FRAMES__		0
#define	__ENABLE_RESCALE__		0

#define	__MAKE_MINI_ME__		0
#define	__USE_NATIVE_IO__		0

#define	__CHECK_FRAMECNT__		0

#define	__GUESS_SKEL_DATA__		0
#define	__FIND_SKEL_PARTS__		0

#define	__FIND_BONE_LENGTHS__	0

#define	__EXCLUDE_PARTFLY__		0				//	The "partfly" frame has incorrect joint positions

#define	__POSER4_OBJS__			0				//	Rotate coordinates in .obj file to make Poser 4 happy
#define	__TRUESPACE2_OBJS__		0				//	Swap coordinates in .obj file to make TrueSpace 2 happy

#define	__ADD_SKIN_NAME__		0
#define	__NEW_SKIN_PATH__		"/models/monsters/imp/imp2.m8"

#endif
