//
//	Header file for section I/O routines for Heretic II FlexModels
//
#ifndef	__SECTIOHINCLUDED__
#define	__SECTIOHINCLUDED__

#define		OUTPUT_FILE_NAME	"tris.fm"

#define		SKIN_NUM_SKINS		2
#define		SKIN_NAME_1			"models/player/elf/!skin.m8"
#define		SKIN_NAME_2			"models/player/elf/!skindmg.m8"

#define		REFSKEL_FILE_NAME	"refskel.bin"	//	Scratch file for reference and skeleton data

//	header		Some header information (40 bytes)
extern void*	WritePMHeader1( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	skin		List of paths to skin texture files (a few kbytes)
extern void*	WritePMDummySkins( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	st coord	Skin texture coordinates (a few kbytes)
extern void*	WritePMSTCoords( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	tris		Model triangle information (about 10 kbytes)
extern void*	WritePMTris( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	frames		Animation frames (about 3 megabytes)
extern void*	WritePMFrames( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	glcmds		Model triangle information (about 20 kbytes)
extern void*	WritePMGLCmds( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	mesh nodes	Model node information (about 10 kbytes)
extern void*	WritePMNodes( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	skeleton	Model skeleton information (about 150 kbytes)
extern void*	WritePMSkels( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	references	Other stuff (about 350 kbytes)
extern void*	WritePMRefs( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

//	Update the header
extern void*	WritePMHeader2( FILE*, fmheader_t*, RawPlayerModel_t*, mocapdata_t* );

#endif
