//
//	Read in a motion capture data file to memory
//
//	This version reads the whole file all at once,
//	which uses a lot of RAM but not much code.
//

#include	<stdio.h>
#include	<stdlib.h>

#include	"CondComp.h"
#include	"FlexModel.h"
#include	"mocap.h"
#include	"mocapio.h"


mocapdata_t*
ReadMocapDataFile( char* fileName )
{
	mocapdata_t*	pData = (void*)0;
	FILE*			fp1;
	long			dataSize;

	//	Make sure the data file exists
	if ( !( fp1 = fopen( fileName, "rb" ) ) )
		return pData;

	//	Get size of data file
	fseek( fp1, 0L, SEEK_END );
	dataSize = ftell( fp1 );
	if ( !( pData = malloc( dataSize ) ) )
		return	pData;

	//	Read in the data
	fseek( fp1, 0L, SEEK_SET );
	fread( pData, dataSize, 1L, fp1 );
	fclose( fp1 );

	//	All done
	return	pData;
}
