//
//  Header file for bone structure of a new Heretic II player model
//
//	By Chris Burke
//	serotonin@earthlink.net
//
//	Date			Who		Description
//	----------		---		-------------------------------------------------------
//	07/01/1999		CJB		Coded
//	09/04/1999		CJB		Eliminated extra bones for reference points.
//							Added extra joints and bones for staff tip
//							and hell head. The reference and skeleton
//							information can be derived from the standard
//							model bones, although it will not exactly
//							match the original Corvus model, it will
//							be more accurate since our joint locations
//							are slightly different than the original.
//							Changed the names of some bones, to make it
//							easier to catch old code and update it for
//							the new bones. The new staff bones / joints
//							are:
//								JOINT_RIGHT_STAFF_BASE_END
//								JOINT_RIGHT_STAFF_TIP_END
//								JOINT_RIGHT_HELL_BASE_END
//								JOINT_RIGHT_HELL_HEAD_END
//								BONE_RIGHT_STAFF_BASE
//								BONE_RIGHT_STAFF_TIP
//								BONE_RIGHT_HELL_BASE
//								BONE_RIGHT_HELL_HEAD
//

#ifndef __BONESHINCLUDED__
#define __BONESHINCLUDED__

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
//  Names for the joints
enum
{
	JOINT_HIP_POSITION = 0,
	JOINT_HIP_LEFT_UPPER_LEG,
	JOINT_LEFT_UPPER_LOWER_LEG,
	JOINT_LEFT_LOWER_LEG_FOOT,
	JOINT_LEFT_FOOT_END,
	JOINT_HIP_RIGHT_UPPER_LEG,
	JOINT_RIGHT_UPPER_LOWER_LEG,
	JOINT_RIGHT_LOWER_LEG_FOOT,
	JOINT_RIGHT_FOOT_END,
	JOINT_HIP_LOWER_TORSO,
	JOINT_LOW_TORSO_HIGH_TORSO,
	JOINT_TORSO_LEFT_UPPER_ARM,
	JOINT_LEFT_UPPER_LOWER_ARM,
	JOINT_LEFT_LOWER_ARM_HAND,
	JOINT_LEFT_OPEN_HAND_END,
	JOINT_LEFT_CLOSED_HAND_BOW,
	JOINT_LEFT_BOW_END,
	JOINT_TORSO_RIGHT_UPPER_ARM,
	JOINT_RIGHT_UPPER_LOWER_ARM,
	JOINT_RIGHT_LOWER_ARM_HAND,
	JOINT_RIGHT_OPEN_HAND_END,
	JOINT_RIGHT_CLOSED_HAND_STAFF,
	JOINT_RIGHT_STAFF_BASE_END,
	JOINT_RIGHT_STAFF_TIP_END,
	JOINT_RIGHT_HELL_BASE_END,
	JOINT_RIGHT_HELL_HEAD_END,
	JOINT_TORSO_NECK,
	JOINT_NECK_HEAD,
	JOINT_HEAD_END,						//	For hair, replace with JOINT_HEAD_HAIR and JOINT_HAIR_END, e.g.
	JOINT_TORSO_SHOULDER_BOW,
	JOINT_SHOULDER_BOW_END,
	JOINT_TORSO_ARMOR,
	JOINT_ARMOR_LEFT_PAD,
	JOINT_LEFT_PAD_END,
	JOINT_ARMOR_RIGHT_PAD,
	JOINT_RIGHT_PAD_END,
	JOINT_HIP_STORED_STAFF,
	JOINT_STORED_STAFF_END,

	JOINT_NUM_JOINTS
};

//	Names for the bones

enum
{
	BONE_HIPS_LEFT = 0,
	BONE_LEFT_UPPER_LEG,
	BONE_LEFT_LOWER_LEG,
	BONE_LEFT_FOOT,

	BONE_HIPS_RIGHT,
	BONE_RIGHT_UPPER_LEG,
	BONE_RIGHT_LOWER_LEG,
	BONE_RIGHT_FOOT,

	BONE_HIPS_SPINE,
	BONE_LOWER_TORSO,

	BONE_LEFT_UPPER_TORSO,
	BONE_LEFT_UPPER_ARM,
	BONE_LEFT_LOWER_ARM,
	BONE_LEFT_HAND_OPEN,
	BONE_LEFT_HAND_CLOSED,
	BONE_BOW,

	BONE_RIGHT_UPPER_TORSO,
	BONE_RIGHT_UPPER_ARM,
	BONE_RIGHT_LOWER_ARM,
	BONE_RIGHT_HAND_OPEN,
	BONE_RIGHT_HAND_CLOSED,

	BONE_RIGHT_STAFF_BASE,
	BONE_RIGHT_STAFF_TIP,
	BONE_RIGHT_HELL_BASE,
	BONE_RIGHT_HELL_HEAD,

	BONE_UPPER_TORSO_SPINE,
	BONE_NECK,
	BONE_HEAD,								//	For hair, add BONE_HAIR, e.g.
	BONE_SHOULDER_BOW,
	BONE_STORED_BOW,

	BONE_ARMOR_LEFT,
	BONE_LEFT_PAD,
	BONE_ARMOR_RIGHT,
	BONE_RIGHT_PAD,

	BONE_HIPS_STAFF,
	BONE_STORED_STAFF,

	BONE_NUM_BONES
};
#else
#define	JOINT_NUM_JOINTS	1	//	Dummy value
#define	BONE_NUM_BONES		1	//	Dummy value
#endif

//	Pairs indicating which joints define each bone.
//	For the code to work right, these MUST be defined
//	with the end closest (fewest hops) to the hip first,
//	and in the same order as the bones

typedef struct {
	int		n[2];				//	+ means use a joint, - means use a reference point
} ends_t;

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)

#define	ENDS_NUM_ENDS			(BONE_NUM_BONES)

#define	ENDS_HIPS_LEFT			{ { JOINT_HIP_POSITION, JOINT_HIP_LEFT_UPPER_LEG } }
#define	ENDS_LEFT_UPPER_LEG		{ { JOINT_HIP_LEFT_UPPER_LEG, JOINT_LEFT_UPPER_LOWER_LEG } }
#define	ENDS_LEFT_LOWER_LEG		{ { JOINT_LEFT_UPPER_LOWER_LEG, JOINT_LEFT_LOWER_LEG_FOOT } }
#define	ENDS_LEFT_FOOT			{ { JOINT_LEFT_LOWER_LEG_FOOT, JOINT_LEFT_FOOT_END } }

#define	ENDS_HIPS_RIGHT			{ { JOINT_HIP_POSITION, JOINT_HIP_RIGHT_UPPER_LEG } }
#define	ENDS_RIGHT_UPPER_LEG	{ { JOINT_HIP_RIGHT_UPPER_LEG, JOINT_RIGHT_UPPER_LOWER_LEG } }
#define	ENDS_RIGHT_LOWER_LEG	{ { JOINT_RIGHT_UPPER_LOWER_LEG, JOINT_RIGHT_LOWER_LEG_FOOT } }
#define	ENDS_RIGHT_FOOT			{ { JOINT_RIGHT_LOWER_LEG_FOOT, JOINT_RIGHT_FOOT_END } }

#define	ENDS_HIPS_SPINE			{ { JOINT_HIP_POSITION, JOINT_HIP_LOWER_TORSO } }
#define	ENDS_LOWER_TORSO		{ { JOINT_HIP_LOWER_TORSO, JOINT_LOW_TORSO_HIGH_TORSO } }

#define	ENDS_LEFT_UPPER_TORSO	{ { JOINT_LOW_TORSO_HIGH_TORSO, JOINT_TORSO_LEFT_UPPER_ARM } }
#define	ENDS_LEFT_UPPER_ARM		{ { JOINT_TORSO_LEFT_UPPER_ARM, JOINT_LEFT_UPPER_LOWER_ARM } }
#define	ENDS_LEFT_LOWER_ARM		{ { JOINT_LEFT_UPPER_LOWER_ARM, JOINT_LEFT_LOWER_ARM_HAND } }
#define	ENDS_LEFT_HAND_OPEN		{ { JOINT_LEFT_LOWER_ARM_HAND, JOINT_LEFT_OPEN_HAND_END } }
#define	ENDS_LEFT_HAND_CLOSED	{ { JOINT_LEFT_LOWER_ARM_HAND, JOINT_LEFT_CLOSED_HAND_BOW } }
#define	ENDS_BOW				{ { JOINT_LEFT_CLOSED_HAND_BOW, JOINT_LEFT_BOW_END } }

#define	ENDS_RIGHT_UPPER_TORSO	{ { JOINT_LOW_TORSO_HIGH_TORSO, JOINT_TORSO_RIGHT_UPPER_ARM } }
#define	ENDS_RIGHT_UPPER_ARM	{ { JOINT_TORSO_RIGHT_UPPER_ARM, JOINT_RIGHT_UPPER_LOWER_ARM } }
#define	ENDS_RIGHT_LOWER_ARM	{ { JOINT_RIGHT_UPPER_LOWER_ARM, JOINT_RIGHT_LOWER_ARM_HAND } }
#define	ENDS_RIGHT_HAND_OPEN	{ { JOINT_RIGHT_LOWER_ARM_HAND, JOINT_RIGHT_OPEN_HAND_END } }
#define	ENDS_RIGHT_HAND_CLOSED	{ { JOINT_RIGHT_LOWER_ARM_HAND, JOINT_RIGHT_CLOSED_HAND_STAFF } }
#define	ENDS_STAFF_BASE			{ { JOINT_RIGHT_CLOSED_HAND_STAFF, JOINT_RIGHT_STAFF_BASE_END } }
#define	ENDS_STAFF_TIP			{ { JOINT_RIGHT_CLOSED_HAND_STAFF, JOINT_RIGHT_STAFF_TIP_END } }
#define	ENDS_HELL_BASE			{ { JOINT_RIGHT_CLOSED_HAND_STAFF, JOINT_RIGHT_HELL_BASE_END } }
#define	ENDS_HELL_HEAD			{ { JOINT_RIGHT_CLOSED_HAND_STAFF, JOINT_RIGHT_HELL_HEAD_END } }

#define	ENDS_UPPER_TORSO_SPINE	{ { JOINT_LOW_TORSO_HIGH_TORSO, JOINT_TORSO_NECK } }
#define	ENDS_NECK				{ { JOINT_TORSO_NECK, JOINT_NECK_HEAD } }
#define	ENDS_HEAD				{ { JOINT_NECK_HEAD, JOINT_HEAD_END } }
//	For hair, add ENDS_HAIR, e.g.
#define	ENDS_SHOULDER_BOW		{ { JOINT_LOW_TORSO_HIGH_TORSO, JOINT_TORSO_SHOULDER_BOW } }
#define	ENDS_STORED_BOW			{ { JOINT_TORSO_SHOULDER_BOW, JOINT_SHOULDER_BOW_END } }

#define	ENDS_ARMOR_LEFT			{ { JOINT_TORSO_ARMOR, JOINT_ARMOR_LEFT_PAD } }
#define	ENDS_LEFT_PAD			{ { JOINT_ARMOR_LEFT_PAD, JOINT_LEFT_PAD_END } }
#define	ENDS_ARMOR_RIGHT		{ { JOINT_TORSO_ARMOR, JOINT_ARMOR_RIGHT_PAD } }
#define	ENDS_RIGHT_PAD			{ { JOINT_ARMOR_RIGHT_PAD, JOINT_RIGHT_PAD_END } }

#define	ENDS_HIPS_STAFF			{ { JOINT_HIP_POSITION, JOINT_HIP_STORED_STAFF } }
#define	ENDS_STORED_STAFF		{ { JOINT_HIP_STORED_STAFF, JOINT_STORED_STAFF_END } }

#endif

//	Definition of locus of each joint (in other words, the points around
//	each joint that determine its position). These are based on manual
//	examination of a few frames of animation. In the lists below, the
//	first number is the number of vertex indeces to follow. The vertex
//	indeces are based on the Corvus model.

#define	kMaxLocusPoints	10		//	Max. # verteces in a locus

typedef	struct {
	int	v[ kMaxLocusPoints+1 ];
} locus_t;

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
#define	LOCI_NUM_LOCI					(BONE_NUM_BONES)
#endif

#if	__MODEL_IS_CORVUS__
#define	LOCUS_HIP_POSITION				{ {	3,	40,	7,	18	} }
#define	LOCUS_HIP_LEFT_UPPER_LEG		{ {	5,	21,	42,	44,	1,	23	} }
#define	LOCUS_LEFT_UPPER_LOWER_LEG		{ {	8,	417,414,413,434,418,412,411,405	} }
#define	LOCUS_LEFT_LOWER_LEG_FOOT		{ {	10,	432,424,426,429,436,432,424,426,428,433	} }
#define	LOCUS_LEFT_FOOT_END				{ {	3,	440,422,421	} }
#define	LOCUS_HIP_RIGHT_UPPER_LEG		{ {	5,	6,	5,	1,	41,	46	} }
#define	LOCUS_RIGHT_UPPER_LOWER_LEG		{ {	8,	396,382,375,373,395,391,390,374	} }
#define	LOCUS_RIGHT_LOWER_LEG_FOOT		{ {	10,	386,392,370,369,384,386,392,372,383,384	} }
#define	LOCUS_RIGHT_FOOT_END			{ {	3,	377,387,388	} }
#define	LOCUS_HIP_LOWER_TORSO			{ {	10,	14,	19,	10,	8,	11,	14,	19,	18,	3,	7	} }			//	Not sure about this - doesn't quite match SKELETON section
#define	LOCUS_LOW_TORSO_HIGH_TORSO		{ {	10,	34,	35,	9,	13,	12,	34,	35,	10,	8,	11	} }
//#define	LOCUS_LOW_TORSO_HIGH_TORSO		{ {	5,	34,	35,	10,	8,	11	} }							//	Based on SKELETON section (cluster 2)
#define	LOCUS_TORSO_LEFT_UPPER_ARM		{ {	10,	281,286,282,264,292,284,37,	25,	20,	24	} }
#define	LOCUS_LEFT_UPPER_LOWER_ARM		{ {	8,	278,279,276,275,278,280,283,275	} }
#define	LOCUS_LEFT_LOWER_ARM_HAND		{ {	6,	274,266,265,269,270,272	} }
#define	LOCUS_LEFT_OPEN_HAND_END		{ {	4,	310,299,297,296	} }
#define	LOCUS_LEFT_CLOSED_HAND_BOW		{ {	6,	347,348,349,350,358,359	} }
#define	LOCUS_LEFT_BOW_END				{ {	3,	339,340,346	} }
#define	LOCUS_TORSO_RIGHT_UPPER_ARM		{ {	10,	129,130,131,148,126,127,26,	22,	27,	36	} }
#define	LOCUS_RIGHT_UPPER_LOWER_ARM		{ {	8,	134,136,149,141,134,136,154,133	} }
#define	LOCUS_RIGHT_LOWER_ARM_HAND		{ {	6,	158,159,153,145,144,146	} }
#define	LOCUS_RIGHT_OPEN_HAND_END		{ {	4,	166,181,178,170	} }
#define	LOCUS_RIGHT_CLOSED_HAND_STAFF	{ {	4,	188,189,193,194	} }
#define	LOCUS_RIGHT_STAFF_BASE_END		{ {	4,	207,217,205,206	} }
#define	LOCUS_RIGHT_STAFF_TIP_END		{ {	4,	210,208,214,209	} }
#define	LOCUS_RIGHT_HELL_BASE_END		{ {	4,	220,219,222,221	} }
#define	LOCUS_RIGHT_HELL_HEAD_END		{ {	3,	252,256,258	} }
#define	LOCUS_TORSO_NECK				{ {	4,	29,	31,	30,	28	} }
#define	LOCUS_NECK_HEAD					{ {	6,	456,455,481,482,472,471	} }						//	Based on SKELETON section (cluster 0)
#define	LOCUS_HEAD_END					{ {	4,	475,479,486,470	} }
//	For hair, replace with LOCUS_HEAD_HAIR and LOCUS_HAIR_END, e.g.
#define	LOCUS_TORSO_SHOULDER_BOW		{ {	8,	84,	81,	82,	83,	38,	37,	32,	36	} }
#define	LOCUS_SHOULDER_BOW_END			{ {	3,	55,	58,	80	} }
#define	LOCUS_TORSO_ARMOR				{ {	8,	93,	105,101,87,	38,	37,	32,	36	} }
#define	LOCUS_ARMOR_LEFT_PAD			{ {	8,	115,116,111,114,95,	94,	93,	92	} }
#define	LOCUS_LEFT_PAD_END				{ {	4,	113,109,108,110	} }
#define	LOCUS_ARMOR_RIGHT_PAD			{ {	8,	123,125,124,120,101,90,	88,	87	} }
#define	LOCUS_RIGHT_PAD_END				{ {	4,	119,121,118,117	} }
#define	LOCUS_HIP_STORED_STAFF			{ {	8,	54,	52,	51,	50,	14,	6,	5,	7	} }
#define	LOCUS_STORED_STAFF_END			{ {	4,	53,	49,	48,	47	} }

//	Thes are the loci of the points for the Y-axis of the
//	frame of reference of each bone.

#define	LOCUS_Y_HIPS_LEFT				{ {	2,	18,	9	} }
#define	LOCUS_Y_LEFT_UPPER_LEG			{ {	1,	409	} }
#define	LOCUS_Y_LEFT_LOWER_LEG			{ {	1,	431	} }
#define	LOCUS_Y_LEFT_FOOT				{ {	1,	437	} }

#define	LOCUS_Y_HIPS_RIGHT				{ {	2,	6,	45	} }
#define	LOCUS_Y_RIGHT_UPPER_LEG			{ {	1,	399	} }
#define	LOCUS_Y_RIGHT_LOWER_LEG			{ {	1,	393	} }
#define	LOCUS_Y_RIGHT_FOOT				{ {	2,	389,378	} }

#define	LOCUS_Y_HIPS_SPINE				{ {	2,	7,	14	} }
#define	LOCUS_Y_LOWER_TORSO				{ {	2,	11,	34	} }

#define	LOCUS_Y_LEFT_UPPER_TORSO		{ {	2,	17,	29	} }
#define	LOCUS_Y_LEFT_UPPER_ARM			{ {	1,	290	} }
#define	LOCUS_Y_LEFT_LOWER_ARM			{ {	2,	267,269	} }
#define	LOCUS_Y_LEFT_HAND_OPEN			{ {	2,	311,314	} }
#define	LOCUS_Y_LEFT_HAND_CLOSED		{ {	2,	321,323	} }
#define	LOCUS_Y_BOW						{ {	2,	337,336	} }

#define	LOCUS_Y_RIGHT_UPPER_TORSO		{ {	2,	12,	32	} }
#define	LOCUS_Y_RIGHT_UPPER_ARM			{ {	1,	138	} }
#define	LOCUS_Y_RIGHT_LOWER_ARM			{ {	2,	159,140	} }
#define	LOCUS_Y_RIGHT_HAND_OPEN			{ {	2,	173,171	} }
#define	LOCUS_Y_RIGHT_HAND_CLOSED		{ {	2,	198,197	} }

#define	LOCUS_Y_RIGHT_STAFF_BASE		{ {	2,	205,206	} }
#define	LOCUS_Y_RIGHT_STAFF_TIP			{ {	2,	205,206	} }
#define	LOCUS_Y_RIGHT_HELL_BASE			{ {	2,	221,222	} }
#define	LOCUS_Y_RIGHT_HELL_HEAD			{ {	2,	221,222	} }

#define	LOCUS_Y_UPPER_TORSO_SPINE		{ {	2,	27,	17	} }
#define	LOCUS_Y_NECK					{ {	2,	30,	472	} }
#define	LOCUS_Y_HEAD					{ {	1,	477	} }
#define	LOCUS_Y_SHOULDER_BOW			{ {	2,	60,	61	} }
#define	LOCUS_Y_STORED_BOW				{ {	2,	83,	82	} }

#define	LOCUS_Y_ARMOR_LEFT				{ {	2,	95,	92	} }
#define	LOCUS_Y_LEFT_PAD				{ {	1,	112	} }
#define	LOCUS_Y_ARMOR_RIGHT				{ {	2,	91,	101	} }
#define	LOCUS_Y_RIGHT_PAD				{ {	2,	120,119	} }

#define	LOCUS_Y_HIPS_STAFF				{ {	2,	4,	46	} }
#define	LOCUS_Y_STORED_STAFF			{ {	1,	47	} }

//	Thes are the loci of the points for the Z-axis of the
//	frame of reference of each bone.

#define	LOCUS_Z_HIPS_LEFT				{ {	1,	40	} }
#define	LOCUS_Z_LEFT_UPPER_LEG			{ {	1,	406	} }
#define	LOCUS_Z_LEFT_LOWER_LEG			{ {	1,	427	} }
#define	LOCUS_Z_LEFT_FOOT				{ {	2,	440,442	} }

#define	LOCUS_Z_HIPS_RIGHT				{ {	1,	45	} }
#define	LOCUS_Z_RIGHT_UPPER_LEG			{ {	1,	400	} }
#define	LOCUS_Z_RIGHT_LOWER_LEG			{ {	1,	376	} }
#define	LOCUS_Z_RIGHT_FOOT				{ {	2,	377,385	} }

#define	LOCUS_Z_HIPS_SPINE				{ {	1,	43	} }
#define	LOCUS_Z_LOWER_TORSO				{ {	2,	34,	35	} }

#define	LOCUS_Z_LEFT_UPPER_TORSO		{ {	2,	24,	37	} }
#define	LOCUS_Z_LEFT_UPPER_ARM			{ {	1,	261	} }
#define	LOCUS_Z_LEFT_LOWER_ARM			{ {	2,	273,269	} }
#define	LOCUS_Z_LEFT_HAND_OPEN			{ {	2,	311,317	} }
#define	LOCUS_Z_LEFT_HAND_CLOSED		{ {	2,	324,321	} }
#define	LOCUS_Z_BOW						{ {	1,	340	} }

#define	LOCUS_Z_RIGHT_UPPER_TORSO		{ {	2,	27,	36	} }
#define	LOCUS_Z_RIGHT_UPPER_ARM			{ {	1,	156	} }
#define	LOCUS_Z_RIGHT_LOWER_ARM			{ {	2,	153,142	} }
#define	LOCUS_Z_RIGHT_HAND_OPEN			{ {	2,	173,167	} }
#define	LOCUS_Z_RIGHT_HAND_CLOSED		{ {	2,	196,197	} }

#define	LOCUS_Z_RIGHT_STAFF_BASE		{ {	2,	206,207	} }
#define	LOCUS_Z_RIGHT_STAFF_TIP			{ {	2,	206,207	} }
#define	LOCUS_Z_RIGHT_HELL_BASE			{ {	2,	219,222	} }
#define	LOCUS_Z_RIGHT_HELL_HEAD			{ {	2,	219,222	} }

#define	LOCUS_Z_UPPER_TORSO_SPINE		{ {	2,	24,	37	} }
#define	LOCUS_Z_NECK					{ {	2,	28,	29	} }
#define	LOCUS_Z_HEAD					{ {	1,	493	} }
#define	LOCUS_Z_SHOULDER_BOW			{ {	1,	64	} }
#define	LOCUS_Z_STORED_BOW				{ {	1,	73	} }

#define	LOCUS_Z_ARMOR_LEFT				{ {	1,	93	} }
#define	LOCUS_Z_LEFT_PAD				{ {	2,	110,111	} }
#define	LOCUS_Z_ARMOR_RIGHT				{ {	1,	87	} }
#define	LOCUS_Z_RIGHT_PAD				{ {	2,	120,118	} }

#define	LOCUS_Z_HIPS_STAFF				{ {	2,	14,	45	} }
#define	LOCUS_Z_STORED_STAFF			{ {	1,	48	} }

//	Lengths of bones for standard Corvus model
//	(calculated average for all animation frames)
//	Quick check: legs + hips + torso + head = 57,
//	height of foot is 3-4, height of Corvus should
//	be nominally 64

#define	CORVUS_HIPS_LEFT_LEN			4.44
#define	CORVUS_LEFT_UPPER_LEG_LEN		14.62
#define	CORVUS_LEFT_LOWER_LEG_LEN		15.74
#define	CORVUS_LEFT_FOOT_LEN			7.79

#define	CORVUS_HIPS_RIGHT_LEN			4.05
#define	CORVUS_RIGHT_UPPER_LEG_LEN		14.66
#define	CORVUS_RIGHT_LOWER_LEG_LEN		15.62
#define	CORVUS_RIGHT_FOOT_LEN			7.76

#define	CORVUS_HIPS_SPINE_LEN			1.89
#define	CORVUS_LOWER_TORSO_LEN			2.68

#define	CORVUS_LEFT_UPPER_TORSO_LEN		10.47
#define	CORVUS_LEFT_UPPER_ARM_LEN		9.64
#define	CORVUS_LEFT_LOWER_ARM_LEN		9.97
#define	CORVUS_LEFT_HAND_OPEN_LEN		5.10
#define	CORVUS_LEFT_HAND_CLOSED_LEN		3.10
#define	CORVUS_BOW_LEN					8.37

#define	CORVUS_RIGHT_UPPER_TORSO_LEN	10.65
#define	CORVUS_RIGHT_UPPER_ARM_LEN		9.54
#define	CORVUS_RIGHT_LOWER_ARM_LEN		9.96
#define	CORVUS_RIGHT_HAND_OPEN_LEN		5.20
#define	CORVUS_RIGHT_HAND_CLOSED_LEN	3.59

#define	CORVUS_RIGHT_STAFF_BASE_LEN		26.77
#define	CORVUS_RIGHT_STAFF_TIP_LEN		27.02
#define	CORVUS_RIGHT_HELL_BASE_LEN		11.53
#define	CORVUS_RIGHT_HELL_HEAD_LEN		24.09

#define	CORVUS_UPPER_TORSO_SPINE_LEN	11.69
#define	CORVUS_NECK_LEN					2.35
#define	CORVUS_HEAD_LEN					5.08
#define	CORVUS_SHOULDER_BOW_LEN			7.35
#define	CORVUS_STORED_BOW_LEN			9.99

#define	CORVUS_ARMOR_LEFT_LEN			6.37
#define	CORVUS_LEFT_PAD_LEN				5.55
#define	CORVUS_ARMOR_RIGHT_LEN			5.25
#define	CORVUS_RIGHT_PAD_LEN			5.38

#define	CORVUS_HIPS_STAFF_LEN			4.62
#define	CORVUS_STORED_STAFF_LEN			8.00

#elif	__MODEL_IS_KIERA__

//	WARNING: Mostly dummy data for Kiera
#define	LOCUS_HIP_POSITION				{ {	1,	0	} }
#define	LOCUS_HIP_LEFT_UPPER_LEG		{ {	1,	0	} }
#define	LOCUS_LEFT_UPPER_LOWER_LEG		{ {	1,	0	} }
#define	LOCUS_LEFT_LOWER_LEG_FOOT		{ {	1,	0	} }
#define	LOCUS_LEFT_FOOT_END				{ {	1,	0	} }
#define	LOCUS_HIP_RIGHT_UPPER_LEG		{ {	1,	0	} }
#define	LOCUS_RIGHT_UPPER_LOWER_LEG		{ {	1,	0	} }
#define	LOCUS_RIGHT_LOWER_LEG_FOOT		{ {	1,	0	} }
#define	LOCUS_RIGHT_FOOT_END			{ {	1,	0	} }
#define	LOCUS_HIP_LOWER_TORSO			{ {	1,	0	} }			//	Not sure about this - doesn't quite match SKELETON section
#define	LOCUS_LOW_TORSO_HIGH_TORSO		{ {	1,	0	} }
//#define	LOCUS_LOW_TORSO_HIGH_TORSO		{ {	1,	0	} }							//	Based on SKELETON section (cluster 2)
#define	LOCUS_TORSO_LEFT_UPPER_ARM		{ {	1,	0	} }
#define	LOCUS_LEFT_UPPER_LOWER_ARM		{ {	1,	0	} }
#define	LOCUS_LEFT_LOWER_ARM_HAND		{ {	1,	0	} }
#define	LOCUS_LEFT_OPEN_HAND_END		{ {	1,	0	} }
#define	LOCUS_LEFT_CLOSED_HAND_BOW		{ {	1,	0	} }
#define	LOCUS_LEFT_BOW_END				{ {	1,	0	} }
#define	LOCUS_TORSO_RIGHT_UPPER_ARM		{ {	1,	0	} }
#define	LOCUS_RIGHT_UPPER_LOWER_ARM		{ {	1,	0	} }
#define	LOCUS_RIGHT_LOWER_ARM_HAND		{ {	1,	0	} }
#define	LOCUS_RIGHT_OPEN_HAND_END		{ {	1,	0	} }
#define	LOCUS_RIGHT_CLOSED_HAND_STAFF	{ {	6,	217, 218, 221, 222, 223, 224	} }
//	WARNING: INCORRECT - OLD
#define	LOCUS_RIGHT_STAFF_END			{ {	2,	235, 246	} }
#define	LOCUS_RIGHT_HELLSTAFF_END		{ {	1,	0	} }
//	NEW
#define	LOCUS_RIGHT_STAFF_BASE_END		{ {	4,	234,235,236,246	} }
#define	LOCUS_RIGHT_STAFF_TIP_END		{ {	4,	210,208,214,209	} }
#define	LOCUS_RIGHT_HELL_BASE_END		{ {	1,	0	} }
#define	LOCUS_RIGHT_HELL_HEAD_END		{ {	1,	0	} }
//	END NEW
#define	LOCUS_TORSO_NECK				{ {	1,	0	} }
#define	LOCUS_NECK_HEAD					{ {	1,	0	} }						//	Based on SKELETON section (cluster 0)
#define	LOCUS_HEAD_END					{ {	1,	0	} }
//	For hair, replace with LOCUS_HEAD_HAIR and LOCUS_HAIR_END, e.g.
#define	LOCUS_TORSO_SHOULDER_BOW		{ {	1,	0	} }
#define	LOCUS_SHOULDER_BOW_END			{ {	1,	0	} }
#define	LOCUS_TORSO_ARMOR				{ {	1,	0	} }
#define	LOCUS_ARMOR_LEFT_PAD			{ {	1,	0	} }
#define	LOCUS_LEFT_PAD_END				{ {	1,	0	} }
#define	LOCUS_ARMOR_RIGHT_PAD			{ {	1,	0	} }
#define	LOCUS_RIGHT_PAD_END				{ {	1,	0	} }
#define	LOCUS_HIP_STORED_STAFF			{ {	1,	0	} }
#define	LOCUS_STORED_STAFF_END			{ {	1,	0	} }

//	These are the loci of the points for the Y-axis of the
//	frame of reference of each bone.

#define	LOCUS_Y_HIPS_LEFT				{ {	1,	0	} }
#define	LOCUS_Y_LEFT_UPPER_LEG			{ {	1,	0	} }
#define	LOCUS_Y_LEFT_LOWER_LEG			{ {	1,	0	} }
#define	LOCUS_Y_LEFT_FOOT				{ {	1,	0	} }

#define	LOCUS_Y_HIPS_RIGHT				{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_UPPER_LEG			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_LOWER_LEG			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_FOOT				{ {	1,	0	} }

#define	LOCUS_Y_HIPS_SPINE				{ {	1,	0	} }
#define	LOCUS_Y_LOWER_TORSO				{ {	1,	0	} }

#define	LOCUS_Y_LEFT_UPPER_TORSO		{ {	1,	0	} }
#define	LOCUS_Y_LEFT_UPPER_ARM			{ {	1,	0	} }
#define	LOCUS_Y_LEFT_LOWER_ARM			{ {	1,	0	} }
#define	LOCUS_Y_LEFT_HAND_OPEN			{ {	1,	0	} }
#define	LOCUS_Y_LEFT_HAND_CLOSED		{ {	1,	0	} }
#define	LOCUS_Y_BOW						{ {	1,	0	} }

#define	LOCUS_Y_RIGHT_UPPER_TORSO		{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_UPPER_ARM			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_LOWER_ARM			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_HAND_OPEN			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_HAND_CLOSED		{ {	1,	0	} }

#define	LOCUS_Y_RIGHT_STAFF_BASE		{ {	2,	234,235	} }
#define	LOCUS_Y_RIGHT_STAFF_TIP			{ {	2,	234,235	} }
#define	LOCUS_Y_RIGHT_HELL_BASE			{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_HELL_HEAD			{ {	1,	0	} }

#define	LOCUS_Y_UPPER_TORSO_SPINE		{ {	1,	0	} }
#define	LOCUS_Y_NECK					{ {	1,	0	} }
#define	LOCUS_Y_HEAD					{ {	1,	0	} }
#define	LOCUS_Y_SHOULDER_BOW			{ {	1,	0	} }
#define	LOCUS_Y_STORED_BOW				{ {	1,	0	} }

#define	LOCUS_Y_ARMOR_LEFT				{ {	1,	0	} }
#define	LOCUS_Y_LEFT_PAD				{ {	1,	0	} }
#define	LOCUS_Y_ARMOR_RIGHT				{ {	1,	0	} }
#define	LOCUS_Y_RIGHT_PAD				{ {	1,	0	} }

#define	LOCUS_Y_HIPS_STAFF				{ {	1,	0	} }
#define	LOCUS_Y_STORED_STAFF			{ {	1,	0	} }

//	These are the loci of the points for the Z-axis of the
//	frame of reference of each bone.

#define	LOCUS_Z_HIPS_LEFT				{ {	1,	0	} }
#define	LOCUS_Z_LEFT_UPPER_LEG			{ {	1,	0	} }
#define	LOCUS_Z_LEFT_LOWER_LEG			{ {	1,	0	} }
#define	LOCUS_Z_LEFT_FOOT				{ {	1,	0	} }

#define	LOCUS_Z_HIPS_RIGHT				{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_UPPER_LEG			{ {	1,	400	} }
#define	LOCUS_Z_RIGHT_LOWER_LEG			{ {	1,	376	} }
#define	LOCUS_Z_RIGHT_FOOT				{ {	1,	0	} }

#define	LOCUS_Z_HIPS_SPINE				{ {	1,	0	} }
#define	LOCUS_Z_LOWER_TORSO				{ {	1,	0	} }

#define	LOCUS_Z_LEFT_UPPER_TORSO		{ {	1,	0	} }
#define	LOCUS_Z_LEFT_UPPER_ARM			{ {	1,	0	} }
#define	LOCUS_Z_LEFT_LOWER_ARM			{ {	1,	0	} }
#define	LOCUS_Z_LEFT_HAND_OPEN			{ {	1,	0	} }
#define	LOCUS_Z_LEFT_HAND_CLOSED		{ {	1,	0	} }
#define	LOCUS_Z_BOW						{ {	1,	0	} }

#define	LOCUS_Z_RIGHT_UPPER_TORSO		{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_UPPER_ARM			{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_LOWER_ARM			{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_HAND_OPEN			{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_HAND_CLOSED		{ {	1,	0	} }

#define	LOCUS_Z_RIGHT_STAFF_BASE		{ {	2,	235,236	} }
#define	LOCUS_Z_RIGHT_STAFF_TIP			{ {	2,	235,236	} }
#define	LOCUS_Z_RIGHT_HELL_BASE			{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_HELL_HEAD			{ {	1,	0	} }

#define	LOCUS_Z_UPPER_TORSO_SPINE		{ {	1,	0	} }
#define	LOCUS_Z_NECK					{ {	1,	0	} }
#define	LOCUS_Z_HEAD					{ {	1,	0	} }
#define	LOCUS_Z_SHOULDER_BOW			{ {	1,	0	} }
#define	LOCUS_Z_STORED_BOW				{ {	1,	0	} }

#define	LOCUS_Z_ARMOR_LEFT				{ {	1,	0	} }
#define	LOCUS_Z_LEFT_PAD				{ {	1,	0	} }
#define	LOCUS_Z_ARMOR_RIGHT				{ {	1,	0	} }
#define	LOCUS_Z_RIGHT_PAD				{ {	1,	0	} }

#define	LOCUS_Z_HIPS_STAFF				{ {	1,	0	} }
#define	LOCUS_Z_STORED_STAFF			{ {	1,	0	} }

//	Lengths of bones for standard Kiera model
//	(calculated average for all animation frames)
//	Quick check: legs + hips + torso + head = 57,
//	height of foot is 3-4, height of Kiera should
//	be nominally 64.
//
//	NOTE: THESE ARE DUMMY VALUES TAKEN FROM
//	CORVUS, NOT FROM KIERA.

#define	KIERA_HIPS_LEFT_LEN				4.44
#define	KIERA_LEFT_UPPER_LEG_LEN		14.62
#define	KIERA_LEFT_LOWER_LEG_LEN		15.74
#define	KIERA_LEFT_FOOT_LEN				7.79

#define	KIERA_HIPS_RIGHT_LEN			4.05
#define	KIERA_RIGHT_UPPER_LEG_LEN		14.66
#define	KIERA_RIGHT_LOWER_LEG_LEN		15.62
#define	KIERA_RIGHT_FOOT_LEN			7.76

#define	KIERA_HIPS_SPINE_LEN			1.89
#define	KIERA_LOWER_TORSO_LEN			2.68

#define	KIERA_LEFT_UPPER_TORSO_LEN		10.47
#define	KIERA_LEFT_UPPER_ARM_LEN		9.64
#define	KIERA_LEFT_LOWER_ARM_LEN		9.97
#define	KIERA_LEFT_HAND_OPEN_LEN		5.10
#define	KIERA_LEFT_HAND_CLOSED_LEN		3.10
#define	KIERA_BOW_LEN					8.37

#define	KIERA_RIGHT_UPPER_TORSO_LEN		10.65
#define	KIERA_RIGHT_UPPER_ARM_LEN		9.54
#define	KIERA_RIGHT_LOWER_ARM_LEN		9.96
#define	KIERA_RIGHT_HAND_OPEN_LEN		5.20
#define	KIERA_RIGHT_HAND_CLOSED_LEN		3.59

#define	KIERA_RIGHT_STAFF_BASE_LEN		26.77
#define	KIERA_RIGHT_STAFF_TIP_LEN		27.02
#define	KIERA_RIGHT_HELL_BASE_LEN		11.53
#define	KIERA_RIGHT_HELL_HEAD_LEN		24.09

#define	KIERA_UPPER_TORSO_SPINE_LEN		11.69
#define	KIERA_NECK_LEN					2.35
#define	KIERA_HEAD_LEN					5.08
#define	KIERA_SHOULDER_BOW_LEN			7.35
#define	KIERA_STORED_BOW_LEN			9.99

#define	KIERA_ARMOR_LEFT_LEN			6.37
#define	KIERA_LEFT_PAD_LEN				5.55
#define	KIERA_ARMOR_RIGHT_LEN			5.25
#define	KIERA_RIGHT_PAD_LEN				5.38

#define	KIERA_HIPS_STAFF_LEN			4.62
#define	KIERA_STORED_STAFF_LEN			8.00

#endif


//	Flag values for bone reference frames.
//
//	Each bone has a frame of reference consisting of
//	the two ends of the bone and two additional points
//	which define a left-handed set of X, Y, Z axes.
//	The axes are defined such that, with the model
//	facing you, Z points from you toward the model,
//	Y points up, and X points to the right.
//
//	The frame of reference for each bone is generated
//	using the end of the bone farthest from the hip
//	to define the direction of the X axis. Also, the
//	points of reference for the Y and Z axes are chosen
//	based on "folding" the model skeleton so that it
//	is all along the positive X axis, by first pushing
//	each bone into alignment with the XY plane of the
//	hips. and then pivoting the far end of each bone
//	around the near end to align it with the X axis
//	with the far end more positive X than the near end.
//
//	For example, if the skeleton looks like
//	this:
//	    A
//	 B4C1D5E
//	    F
//	    0
//	   G H
//	  2   3
//	  I   J
//	 K6   7L
//	Where letters are bones and digits are joints, the
//	folded skeleton looks conceptually like this:
//
//	0(FGH)(123)(ACDIJ)(4567)(BEKL)
//
#endif

