#ifndef	__MATRIXMATHHINCLUDED__
#define	__MATRIXMATHHINCLUDED__

//	Degrees to radians conversion factor
#define kD2R  0.01745329251994

//	PI
#ifndef	PI
#define	PI	3.1415926838
#endif

//	A 4x4 matrix is used so that rotation and translation can
//	be performed at the same time.
typedef struct
{
	double	m00, m01, m02, m03;
	double	m10, m11, m12, m13;
	double	m20, m21, m22, m23;
	double	m30, m31, m32, m33;
} mat3d_t;


//	A 1x4 matrix is used to perform simultaneous translation
//	and rotation
typedef struct
{
	double	c[4];
} vec4dbl_t;


typedef struct
{
	double	c[3];
} vec3dbl_t;

//
//	Functions
//

//	Copy matrix at pS to pD
extern void	M3DAssign( mat3d_t* pD, mat3d_t* pS );

//	Initialize the members of patrix pM
extern void	M3DInit(
	mat3d_t* pM,
	double v00, double v01, double v02, double v03,
	double v10, double v11, double v12, double v13,
	double v20, double v21, double v22, double v23,
	double v30, double v31, double v32, double v33
);

//	Add matrix at p1 and matrix at p2, store result in matrix at pM
extern void	M3DAdd( mat3d_t* pM, mat3d_t* p1, mat3d_t* p2 );

//	Add matrix at pS to matrix at pD
extern void	M3DAddAssign( mat3d_t* pD, mat3d_t* pS );

//	Multiply matrix p1 and matrix p2 together, storing result at pM
extern void	M3DMul( mat3d_t* pM, mat3d_t* p1, mat3d_t* p2 );

//	Multiply matrix p1 and matrix p2 together, storing result at p1
extern void	M3DMulAssign( mat3d_t* p1, mat3d_t* p2 );

//	Multiply a point (in a vec3dbl_t with coordinates ordered X, Y, Z)
//	by a 3x3 matrix. Essentially this rotates the point around axes.
extern void	M3DPointMul( vec3dbl_t* pD, mat3d_t* pM, vec3dbl_t* pS );

//	Rotate a point (in a vec3dbl_t with coordinates ordered X, Y, Z)
//	n degrees around each axis (specified in a vec3dbl_t with
//	rotations ordered rx, ry, rz).
extern void	M3DRotate( vec3dbl_t* pD, vec3dbl_t* pR );

//	Rotate, using degrees instead of radians
extern void M3DRotateDeg( vec3dbl_t* pD, vec3dbl_t* pR );

//	Translate a point (in a vec3dbl_t with coordinates ordered X, Y, Z)
//	by a given vector.
extern void	M3DTranslate( vec3dbl_t* pD, vec3dbl_t* pT );

//	Untranslate a point (in a vec3dbl_t with coordinates ordered X, Y, Z)
//	by a given vector.
extern void	M3DUnTranslate( vec3dbl_t* pD, vec3dbl_t* pT );

//	Scale a point (in a vec3dbl_t with coordinates ordered X, Y, Z)
//	by a given vector.
extern void M3DScale( vec3dbl_t* pD, vec3dbl_t* pN );

//	Return the length of a line segment bounded by two
//	points in 3D space, each in a vec3dbl_t
extern double	M3DLength( vec3dbl_t* p1, vec3dbl_t*p2 );

//	Return the squared length of a line segment bounded by two
//	points in 3D space, each in a vec3dbl_t
extern double	M3DSqrLength( vec3dbl_t* p1, vec3dbl_t*p2 );

//	Return the magnitude of a vector in a vec3dbl_t
extern double	M3DMagnitude( vec3dbl_t* pV );

//	Convert a given vector to a unit vector
extern void	M3DUnitVector( vec3dbl_t* pD, vec3dbl_t* pS );

//	Calculate the cross product UxV of two vectors ordered X, Y, Z,
//	storing the result in a given vector.
extern void	M3DCrossProduct( vec3dbl_t* pD, vec3dbl_t* pU, vec3dbl_t* pV );

#endif
