//
//	Header file for FlexModel file structure
//
//	WARNING:	It is assumed that sizeof(int) = 4
//	WARNING:	It is assumed the structures are
//				aligned on 4-byte boundaries
//
//	By Chris Burke
//	serotonin@earthlink.net
//
//	Date			Who		Description
//	----------		---		-------------------------------------------------------
//	07/01/1999		CJB		Coded
//	08/21/1999		CJB		Revised
//

#ifndef	__FLEXMODELHINCLUDED__
#define	__FLEXMODELHINCLUDED__

//
//	Data manipulation macros
//	NOTE: p MUST be a pointer to unsigned char
//
#define	FM_GETINT(p)	( ((unsigned long)(*((p)+0))<<0)  | \
						  ((unsigned long)(*((p)+1))<<8)  | \
						  ((unsigned long)(*((p)+2))<<16) | \
						  ((unsigned long)(*((p)+3))<<24)   \
						)

#define	FM_GETSHORT(p)	( ((unsigned short)(*((p)+0))<<0)  | \
						  ((unsigned short)(*((p)+1))<<8)    \
						)

#define	FM_GETFLOAT(p)	( ( ((unsigned long)(*((p)+0))<<0)  | \
						    ((unsigned long)(*((p)+1))<<8)  | \
						    ((unsigned long)(*((p)+2) | 0x80)<<16) \
						  ) \
						  * twotothe( (int)(*((p)+3)) - 89 ) \
						  * ( (*((p)+2) & 0x80) ? -1.0 : 1.0 \
						)


//
//	Absolute limits (from QData / QMView source)
//
#define	MAX_FM_TRIANGLES	2048
#define MAX_FM_VERTS		2048
#define MAX_FM_FRAMES		2048
#define MAX_FM_SKINS		64
#define	MAX_FM_SKINNAME		64
#define MAX_FM_MESH_NODES	16

#define DTRIVERTX_V0   0
#define DTRIVERTX_V1   1
#define DTRIVERTX_V2   2
#define DTRIVERTX_LNI  3
#define DTRIVERTX_SIZE 4

#define SKINPAGE_WIDTH 640
#define SKINPAGE_HEIGHT 480

#define ENCODED_WIDTH_X 92
#define ENCODED_WIDTH_Y 475
#define ENCODED_HEIGHT_X 128
#define ENCODED_HEIGHT_Y 475

#define SCALE_ADJUST_FACTOR 0.96

#define INFO_HEIGHT 5
#define INFO_Y (SKINPAGE_HEIGHT-INFO_HEIGHT)


//
//	Unique data types
//
typedef unsigned char	byte;			//	A byte
typedef	struct {
	float			c[3];				//	A floating-point (X,Y,Z) set
} vec3_t;
typedef	struct {
	int				c[2];				//	An integer (u,v) set
} texpoint_t;
typedef	struct {
	float			c[2];				//	A floating (u,v) set
} ftexpoint_t;
typedef struct {
	int				v[3];				//	An integer set of vertex indeces (triangle)
} trividx_t;

//
//	Generic header on every chunk
//
#define	FM_MAXCHUNKIDENT	32L
#define	FM_HEADERSIZE		(FM_MAXCHUNKIDENT + 8L)
typedef struct
{
	char				ident[FM_MAXCHUNKIDENT];
	unsigned int		version;
	unsigned int		size;
} header_t;

//
//	The format of the "header" chunk
//
#define	FM_HEADERCHUNKNAME	"header"
#define	FM_HEADERCHUNKVER	2
#define	FM_HEADERCHUNKSIZE	40
typedef struct
{
	int			skinwidth;		// in pixels
	int			skinheight;		// in pixels
	int			framesize;		// size of each frame (in bytes)
	int			skincnt;		// number of skins
	int			vert3dcnt;		// number of unique vertices in 3D space
	int			vertuvcnt;		// number of unique vertices in texture space
	int			tricnt;			// number of unique triangles
	int			glcmdcnt;		// # 32-bit elements in strip/fan command list
	int			framecnt;		// number of animation frames
	int			meshnodecnt;	// number of mesh nodes
} fmheader_t;

//
//	The format of an entry in the "skin" chunk.
//	The number of entries is given in the fmheader chunk
//
#define	FM_SKINCHUNKNAME	"skin"
#define	FM_SKINCHUNKVER		1
#define	FM_MAXPATHLENGTH	64L
#define	FM_SKINPATHSIZE	(FM_MAXPATHLENGTH)
typedef struct
{
	char				path[64];	//	path, relative to 'base'
} skinpath_t;

//
//	The format of the "st coord" chunk. This is a list
//	of unique skin texture (u, v) coordinates to be mapped
//	to verteces of the model
//
#define FM_STCOORDCHUNKNAME	"st coord"
#define FM_STCOORDCHUNKVER	1
#define	FM_STCOORDUVSIZE	(2L + 2L)

typedef struct
{
	short	u;
	short	v;
} stcoord_t;

//
//	The format of the "tris" chunk. This is a list of vertex indeces
//	in 3D space, and the corresponding vertex indeces in texture space.
//
#define FM_TRISCHUNKNAME	"tris"
#define FM_TRISCHUNKVER		1
#define	FM_TRISINFOSIZE		(2L*3 + 2L*3)

typedef struct 
{
	short	index_3d[3];
	short	index_uv[3];
} triangle_t;


//
//	The format of the "frames" chunk. This is a list of animation
//	frames, each specifying the coordinates and "light normal" index
//	of every vertex of the model in 3D space.
//
#define FM_FRAMESCHUNKNAME	"frames"
#define FM_FRAMESCHUNKVER	1

#define FM_NUMVERTEXNORMALS	162

// Frame info
typedef struct
{
	byte			v[3];				//	scaled by header info
	byte			lightnormalindex;	//	index in canned table of closest vertex normal
} vertex3d_t;

typedef struct
{
	float			scale[3];			//	multiply byte verts by this
	float			translate[3];		//	then add this
	char			name[16];			//	frame name
} framehdr_t;

typedef struct
{
	framehdr_t		header;				//	One header per frame
	vertex3d_t		verts[1];			//	variable number of these
} frame_t;

//
//	The format of the "glcmds" chunk.
//	This chunk specifies a canonical model as a series of
//	triangle strips and triangle fans. The chunk contains a
//	variable number of command structures.
//
#define FM_GLCMDSCHUNKNAME	"glcmds"
#define FM_GLCMDSCHUNKVER	1

#define	GL_TRISTRIP		(+1)
#define	GL_TRIFAN		(-1)

typedef struct
{
	int		theCmd;		//	32-bit integer command
} glcmd_t;

typedef struct
{
	float	u;						//	Texture 's' coordinate (?)
	float	v;						//	Texture 't' coordinate (?)
	int		index_3d;				//	Index of 3D vertex coordinate in list XXX
} glvert_t;


//
//	The format of the "mesh nodes" chunk.
//	This chunk specifies parts of the model that are drawn, or not,
//	depending on weapon selection, dismemberment, etc.
//

#define FM_MESHNODESCHUNKNAME	"mesh nodes"
#define FM_MESHNODESCHUNKVER	3

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
//	Nodes are stored in the following order:
enum
{
	H2MODELNODE_FRONT_TORSO = 0,	//	0: Front torso, shoulders, pelvis
	H2MODELNODE_BACK_TORSO,			//	1: Back torso, shoulders, pelvis
	H2MODELNODE_STAFF_AWAY,			//	2: The thingy on the right hip when the staff is stowed
	H2MODELNODE_BOW_AWAY,			//	3: The bow, slung over the shoulder
	H2MODELNODE_ARMOR,				//	4: Armor
	H2MODELNODE_RIGHT_ARM,			//	5: The right upper and lower arm (no hand)
	H2MODELNODE_RT_HAND_OPEN,		//	6: The right hand, empty and open
	H2MODELNODE_RT_HAND_STAFF,		//	7: The right hand, gripping the staff thingy (no staff)
	H2MODELNODE_STAFF,				//	8: The Durnwood Staff
	H2MODELNODE_HELLSTAFF,			//	9: The Hellstaff
	H2MODELNODE_LEFT_ARM,			//	A: The left upper and lower arm (no hand)
	H2MODELNODE_LF_HAND_OPEN,		//	B: The left hand, empty and open
	H2MODELNODE_LF_HAND_BOW,		//	C: The left hand gripping the entire bow
	H2MODELNODE_RT_LEG,				//	D: The right upper leg, lower leg, and foot
	H2MODELNODE_LF_LEG,				//	E: The left upper leg, lower leg, and bag thingy on the hip
	H2MODELNODE_HEAD,				//	F: The head and hair
	H2NUM_MESHNODES
};
#else
#define	H2NUM_MESHNODES		1		//	Dummy value
#endif

typedef struct
{
	byte	trimap[ MAX_FM_TRIANGLES >> 3 ];	//	Bit set for each triangle part of this node
	byte	vertmap[ MAX_FM_VERTS >> 3 ];		//	Bit set for each vertex part of this node
	short	glcmdstart;							//	Offset into GLCMDS chunk to start of this node's GLCMDS
	short	glcmdcnt;							//	Number of GLCMDS for this node (units of 32 bits)
} meshnode_t;


//
//	The format of the "skeleton" chunk.
//	This chunk contains joint / skeleton information,
//	which I'm not sure how its used yet :-)
//

#define	FM_SKELETONCHUNKNAME	"skeleton"
#define	FM_SKELETONCHUNKVER		1

#define	FM_SKELTYPE_CORVUS		5				//	ID Code for CORVUS skeleton

#define	SKELETON_POSITION_VECTOR_LENGTH	20.

typedef struct
{
	int		skeltype;		//	Skeleton type, always 5 for Corvus / Kiera
	int		numjoints;		//	Joint count, always 3 for Corvus / Kiera
	int		jointverts[1];	//	Variable length; # elements = # joints
} skelhdr_t;

typedef struct
{
	vec3_t	origin;			//	Joint location
	vec3_t	direction;		//	Direction vector up through spine
	vec3_t	up;				//	Direction vector out backside
} positioning_t;

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
//	Order of stored vertex clusters
enum
{
	H2CORVUS_HDCLUSTER=0,	//	Head cluster (first set of verteces in chunk)
	H2CORVUS_UBCLUSTER,		//	Upper back cluster
	H2CORVUS_LBCLUSTER,		//	Lower back cluster (last set of verteces in chunk)
	H2CORVUS_NUMCLUSTERS
};
//	Order of stored skeleton references
enum
{
	H2CORVUS_UBJOINT=0,		//	Upper back JOINT
	H2CORVUS_LBJOINT,		//	Lower back JOINT (last set of verteces in chunk)
	H2CORVUS_HDJOINT,		//	Head JOINT (first set of verteces in chunk)
	H2CORVUS_NUMJOINTS
};

typedef struct
{
	positioning_t	pos[H2CORVUS_NUMJOINTS];
} skelpos_t;
#endif


//
//	The format of the "references" chunk.
//	This chunk gives the location of important points
//	on the model during every frame of animation.
//

#define	FM_REFERENCESCHUNKNAME	"references"
#define	FM_REFERENCESCHUNKVER	1

#define	REFERENCE_POSITION_VECTOR_LENGTH	20.

#if	(__MODEL_IS_CORVUS__ || __MODEL_IS_KIERA__)
enum
{
	H2CORVUS_LH = 0,			//	0: Location of left hand
	H2CORVUS_RH,				//	1: Location of right hand
	H2CORVUS_RF,				//	2: Location of right foot
	H2CORVUS_LF,				//	3: Location of left foot
	H2CORVUS_STAFF,				//	4: Location of the staff
	H2CORVUS_BLADE,				//	5: Location of the blade
	H2CORVUS_HELLHEAD,			//	6: Location of the head of the hellstaff
	H2CORVUS_NUMREFPOINTS
};
#else
#define	H2CORVUS_NUMREFPOINTS	1	//	Dummy value
#endif

typedef struct
{
	int		reftype;			//	What type of reference data (0 for Corvus)
	int		idunno;				//	??? (1 for Curvus)
} refheader_t;

#define	FM_REFTYPE_CORVUS	0	//	Standard value for reftype field
#define	FM_IDUNNO_CORVUS	1	//	Standard value for idunno field

typedef struct
{
	vec3_t	origin;				//	Where the important point is
	vec3_t	direction;			//	Direction of first positioning vector
	vec3_t	up;					//	Direction of second positioning vector
} imp_point_t;

typedef struct
{
	imp_point_t	refpoints[H2CORVUS_NUMREFPOINTS];
} refskel_t;


#if	0

// Frame for compression, just the names
#define FM_SHORT_FRAME_NAME	"short frames"
#define FM_SHORT_FRAME_VER	1

// Normals for compressed frames
#define FM_NORMAL_NAME	"normals"
#define FM_NORMAL_VER	1

// Compressed Frame Data
#define FM_COMP_NAME	"comp data"
#define FM_COMP_VER	1

#endif

#endif
