//
//	Format of data stored in the mocap.bin motion capture file
//	created by h2mocap
//
//	The data will be stored in the following format:
//
//		File header (# frames)
//		For every frame (as ordered in tris.fm file)
//			Name of frame (from tris.fm file)
//			For every bone (BONE_NUM_BONES as enumerated in bones.h)
//				X translation of joint closest to hip (double)
//				Y translation of joint closest to hip (double)
//				Z translation of joint closest to hip (double)
//			For every bone (BONE_NUM_BONES as enumerated in bones.h)
//				Rotation about X axis of joint closest to hip (double)
//				Rotation about Y axis of joint closest to hip (double)
//				Rotation about Z axis of joint closest to hip (double)
//
//	The number of frames is determined by the length of the file.
//
//	Translation is given in "units". Translations are added to the
//	location of the joint, assuming the joint begins at (0,0,0).
//
//	Rotation is given in radians. Rotations use a coordinate system in
//	which the X axis points right, the Y axis points up, and the Z axis
//	points away from the viewer, assuming the bone begins aligned along
//	the positive X axis and got there by applying the reverse rotations
//	in reverse order.
//
//	To reconstruct the motion, the order of application of the various
//	elements to a given bone MUST be:
//
//	1) Apply X-axis rotation
//	2) Apply Z-axis rotation
//	3) Apply Y-axis rotation
//	4) Apply translations in any order
//

#ifndef	__MOCAPHINCLUDED__
#define	__MOCAPHINCLUDED__

#include	"bones.h"

#ifndef	__MAX_FM_FRAMES__
#define MAX_FM_FRAMES		2048
#endif

//	The header at the start of the file
typedef struct
{
	int		framecnt;	//	# frames captured
} mocaphdr_t;

//	The name of each frame is stored in this structure,
//	null-terminated.
typedef struct
{
	char	name[16];	//	frame name
} framename_t;

//	Format of each translation or rotation element of the file.
//	Each DOUBLE is stored in the same format and byte order as
//	the DOUBLE data type in Microsoft Visual C++ Version 5.0
//	(same as IEEE standard)
//
//	This MUST be identical to vec3dbl_t as defined
//	in MatrixMath.h of the h2mocap program.
typedef struct
{
	double	c[3];		//	X, Y, Z values
} v3d_t;

#endif
