//
//	Bit map data structure and access routines.
//	The structure is chosen to match the bitmaps used
//	in Heretic 2 player models: LSB of 0th byte is the
//	0th bit, MSB of 0th byte is the 7th bit, etc.
//
//	By Chris Burke
//	serotonin@earthlink.net
//
//	Date			Who		Description
//	----------		---		-------------------------------------------------------
//	07/01/1999		CJB		Coded
//

#ifndef	__H2BITMAPSHINCLUDED__
#define	__H2BITMAPSHINCLUDED__

typedef struct
{
	int		numbits;
	int		mapbytes;
	unsigned char*	bitdata;
} h2bitmap_t;

#define	H2BM_BIT_ZERO	0x01

//	Create and zero a bitmap of a given size
h2bitmap_t*		NewBitMap( int numbits );

//	Dispose of a bitmap
h2bitmap_t*		FreeBitMap( h2bitmap_t* pMap );

//	Get size of a bitmap
int				SizeBitMap( h2bitmap_t* pMap );

//	Set bit(s) in a bitmap
void			SetBitMap( h2bitmap_t* pMap, int startbit, int numbits );

//	Clear bit(s) in a bitmap
void			ClrBitMap( h2bitmap_t* pMap, int startbit, int numbits );

//	Test a given bit in a bitmap
int				TstBitMap( h2bitmap_t* pMap, int startbit );

//	Find a given number of free bits in a bitmap
int				FindClrBitMap( h2bitmap_t* pMap, int startbit, int numbits );

//	Find a given number of set bits in a bitmap
int				FindSetBitMap( h2bitmap_t* pMap, int startbit, int numbits );

#endif