/*
====================================================================================

The SARACEN's Item Flags

====================================================================================
*/

#include "ui_local.h"

#define ITFLAGS_BACK0			"menu/art/back_0"
#define ITFLAGS_BACK1			"menu/art/back_1"	
#define ITFLAGS_FRAMEL			"menu/art/frame2_l"

#define ITFLAGS_WEAPONS	  10
#define ITFLAGS_POWERUPS	  11
#define ITFLAGS_MODULES	  12
#define ITFLAGS_MISC	  13
#define ITFLAGS_BACK	  14
// individual ID values are ITFLAGS_XXFLAGS + x
#define ITFLAGS_DMFLAGS	 100
#define ITFLAGS_WPFLAGS	 200
#define ITFLAGS_WIFLAGS	 300
#define ITFLAGS_WAFLAGS	 400
#define ITFLAGS_PPFLAGS	 500
#define ITFLAGS_PIFLAGS	 600
#define ITFLAGS_MPFLAGS	 700
#define ITFLAGS_MSFLAGS	 800	// Not actually a Flags cvar - really the three Skitz cvars.

#define ITFLAGS_MENUX	256
#define ITFLAGS_MENUY	256
#define ITFLAGS_NAMEX	640 - 220
#define ITFLAGS_NAMEX2	640 - 148
#define ITFLAGS_NAMEY	96
#define ITFLAGS_TOPY	128

#define ITFLAGS_COL1X	640 - 216
#define ITFLAGS_COL2X	640 - 144
#define ITFLAGS_COL3X	640 - 72

#define TOTAL_POWERUPS	HI_NUM_HOLDABLE + PW_REDFLAG - 1

static void UI_ServerItemFlags_Event (void *ptr, int event);

// ============================ WEAPONS =======================================

typedef struct
{
	menuframework_s	menu;
	menutext_s		banner;
	menubitmap_s		framel;

	menutext_s		weapons;
	menutext_s		powerups;
	menutext_s		modules;
	menutext_s		misc;

	menuradiobutton_s	wp[WP_NUM_WEAPONS];	// WPFlags
	menuradiobutton_s	wi[WP_NUM_WEAPONS];	// WIFlags
	menuradiobutton_s	wa[WP_NUM_WEAPONS];	// WAFlags

	menubitmap_s		back;
} itemflagsweapons_t;
static itemflagsweapons_t s_itemflagsweapons;

static void UI_ServerItemFlags_SetMenuItems_Weapons (void)
{
	int x;

	for (x = 1 ; x < WP_NUM_WEAPONS ; x++)
	{
		s_itemflagsweapons.wp[x].curvalue = (int)Com_Clamp (0, 1, ui_wpflags.integer & (1 << (x - 1)));
		s_itemflagsweapons.wi[x].curvalue = (int)Com_Clamp (0, 1, ui_wiflags.integer & (1 << (x - 1)));
		if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
			s_itemflagsweapons.wa[x].curvalue =
						(int)Com_Clamp (0, 1, ui_waflags.integer & (1 << (x - 1)));
		if (s_itemflagsweapons.wp[x].curvalue)
		{
			s_itemflagsweapons.wi[x].generic.flags |= QMF_GRAYED;
			if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
				s_itemflagsweapons.wa[x].generic.flags |= QMF_GRAYED;
		}
	}
}

static void UI_ServerItemFlags_Event_Weapons (void *ptr, int event)
{
	int x, splat;

	for (x = 1 ; x < WP_NUM_WEAPONS ; x++)
	{
		if (((menucommon_s*)ptr)->id == ITFLAGS_WPFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_wpflags.integer;
			if (s_itemflagsweapons.wp[x].curvalue == 1)
			{
				splat |= (1 << (x - 1));
				s_itemflagsweapons.wi[x].generic.flags |= QMF_GRAYED;
				if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
					s_itemflagsweapons.wa[x].generic.flags |= QMF_GRAYED;
			}
			else
			{
				splat &= ~(1 << (x - 1));
				s_itemflagsweapons.wi[x].generic.flags &= ~QMF_GRAYED;
				if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
					s_itemflagsweapons.wa[x].generic.flags &= ~QMF_GRAYED;
			}
			trap_Cvar_SetValue ("wpflags", splat);
			break;
		}
		else if (((menucommon_s*)ptr)->id == ITFLAGS_WIFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_wiflags.integer;
			if (s_itemflagsweapons.wi[x].curvalue == 1) splat |= (1 << (x - 1));
			else  splat &= ~(1 << (x - 1));
			trap_Cvar_SetValue ("wiflags", splat);
			break;
		}
		else if (((menucommon_s*)ptr)->id == ITFLAGS_WAFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_waflags.integer;
			if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
				if (s_itemflagsweapons.wa[x].curvalue == 1) splat |= (1 << (x - 1));
			else  splat &= ~(1 << (x - 1));
			trap_Cvar_SetValue ("waflags", splat);
			break;
		}
	}
}

static void UI_ServerItemFlags_Draw_Weapons (void)
{
	int x, y;

	Menu_Draw (&s_itemflagsweapons.menu);

	UI_DrawString (ITFLAGS_COL1X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"PREVENT", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL1X+32, ITFLAGS_NAMEY,
			"SPAWN", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"INITIAL", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY,
			"WEAPON", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"AMMO", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY,
			"UNLIMITED", UI_SMALLFONT|UI_CENTER, color_orange );

	for (x = 1, y = ITFLAGS_TOPY; x < WP_NUM_WEAPONS ; x++, y += BIGCHAR_HEIGHT+2)
		UI_DrawString (ITFLAGS_NAMEX, y, BG_FindItemForWeapon (x)->pickup_name,
				UI_SMALLFONT|UI_RIGHT, color_orange);
}

void UI_ServerItemFlags_Init_Weapons (void)
{
	int x, y;

	memset (&s_itemflagsweapons, 0, sizeof (itemflagsweapons_t));

	UI_ServerItemFlags_Cache ();

	s_itemflagsweapons.menu.wrapAround = qtrue;
	s_itemflagsweapons.menu.fullscreen = qtrue;
	s_itemflagsweapons.menu.draw = UI_ServerItemFlags_Draw_Weapons;

	s_itemflagsweapons.banner.generic.type			= MTYPE_BTEXT;
	s_itemflagsweapons.banner.generic.flags			= QMF_CENTER_JUSTIFY;
	s_itemflagsweapons.banner.generic.x			= 320;
	s_itemflagsweapons.banner.generic.y			= 16;
	s_itemflagsweapons.banner.string				= "ITEM FLAGS";
	s_itemflagsweapons.banner.color				= color_white;
	s_itemflagsweapons.banner.style				= UI_CENTER;

	s_itemflagsweapons.framel.generic.type			= MTYPE_BITMAP;
	s_itemflagsweapons.framel.generic.name			= ITFLAGS_FRAMEL;
	s_itemflagsweapons.framel.generic.flags			= QMF_INACTIVE;
	s_itemflagsweapons.framel.generic.x			= 8;
	s_itemflagsweapons.framel.generic.y			= 76;
	s_itemflagsweapons.framel.width				= 256;
	s_itemflagsweapons.framel.height				= 334;

	y = 2 * PROP_HEIGHT;
	s_itemflagsweapons.weapons.generic.type			= MTYPE_PTEXT;
	s_itemflagsweapons.weapons.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_HIGHLIGHT_IF_FOCUS|QMF_HIGHLIGHT;
	s_itemflagsweapons.weapons.generic.callback 		= UI_ServerItemFlags_Event;
	s_itemflagsweapons.weapons.generic.id			= ITFLAGS_WEAPONS;
	s_itemflagsweapons.weapons.generic.x 			= ITFLAGS_MENUX;
	s_itemflagsweapons.weapons.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagsweapons.weapons.string				= "WEAPONS";
	s_itemflagsweapons.weapons.color				= color_red;
	s_itemflagsweapons.weapons.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsweapons.powerups.generic.type			= MTYPE_PTEXT;
	s_itemflagsweapons.powerups.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsweapons.powerups.generic.callback		= UI_ServerItemFlags_Event;
	s_itemflagsweapons.powerups.generic.id			= ITFLAGS_POWERUPS;
	s_itemflagsweapons.powerups.generic.x			= ITFLAGS_MENUX;
	s_itemflagsweapons.powerups.generic.y			= ITFLAGS_MENUY - y;
	s_itemflagsweapons.powerups.string				= "POWERUPS";
	s_itemflagsweapons.powerups.color				= color_red;
	s_itemflagsweapons.powerups.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsweapons.modules.generic.type			= MTYPE_PTEXT;
	s_itemflagsweapons.modules.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsweapons.modules.generic.callback 		= UI_ServerItemFlags_Event;
	s_itemflagsweapons.modules.generic.id			= ITFLAGS_MODULES;
	s_itemflagsweapons.modules.generic.x 			= ITFLAGS_MENUX;
	s_itemflagsweapons.modules.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagsweapons.modules.string				= "MODULES";
	s_itemflagsweapons.modules.color				= color_red;
	s_itemflagsweapons.modules.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsweapons.misc.generic.type 			= MTYPE_PTEXT;
	s_itemflagsweapons.misc.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsweapons.misc.generic.callback			= UI_ServerItemFlags_Event;
	s_itemflagsweapons.misc.generic.id				= ITFLAGS_MISC;
	s_itemflagsweapons.misc.generic.x				= ITFLAGS_MENUX;
	s_itemflagsweapons.misc.generic.y				= ITFLAGS_MENUY - y;
	s_itemflagsweapons.misc.string				= "MISC";
	s_itemflagsweapons.misc.color 				= color_red;
	s_itemflagsweapons.misc.style 				= UI_RIGHT;

	for (x = 1, y = ITFLAGS_TOPY; x < WP_NUM_WEAPONS ; x++, y += BIGCHAR_HEIGHT+2)
	{
		s_itemflagsweapons.wp[x].generic.type		= MTYPE_RADIOBUTTON;
		s_itemflagsweapons.wp[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagsweapons.wp[x].generic.x			= ITFLAGS_COL1X;
		s_itemflagsweapons.wp[x].generic.y			= y;
		s_itemflagsweapons.wp[x].generic.id 		= ITFLAGS_WPFLAGS + x;
		s_itemflagsweapons.wp[x].generic.callback		= UI_ServerItemFlags_Event_Weapons;
		s_itemflagsweapons.wp[x].generic.name		= "";

		s_itemflagsweapons.wi[x].generic.type		= MTYPE_RADIOBUTTON;
		s_itemflagsweapons.wi[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagsweapons.wi[x].generic.x			= ITFLAGS_COL2X;
		s_itemflagsweapons.wi[x].generic.y			= y;
		s_itemflagsweapons.wi[x].generic.id 		= ITFLAGS_WIFLAGS + x;
		s_itemflagsweapons.wi[x].generic.callback		= UI_ServerItemFlags_Event_Weapons;
		s_itemflagsweapons.wi[x].generic.name		= "";

		if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
		{
			s_itemflagsweapons.wa[x].generic.type		= MTYPE_RADIOBUTTON;
			s_itemflagsweapons.wa[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
			s_itemflagsweapons.wa[x].generic.x			= ITFLAGS_COL3X;
			s_itemflagsweapons.wa[x].generic.y			= y;
			s_itemflagsweapons.wa[x].generic.id 		= ITFLAGS_WAFLAGS + x;
			s_itemflagsweapons.wa[x].generic.callback		= UI_ServerItemFlags_Event_Weapons;
			s_itemflagsweapons.wa[x].generic.name		= "";
		}
	}

	s_itemflagsweapons.back.generic.type 			= MTYPE_BITMAP;
	s_itemflagsweapons.back.generic.name			= ITFLAGS_BACK0;
	s_itemflagsweapons.back.generic.flags			= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsweapons.back.generic.callback			= UI_ServerItemFlags_Event;
	s_itemflagsweapons.back.generic.id				= ITFLAGS_BACK;
	s_itemflagsweapons.back.generic.x				= 0;
	s_itemflagsweapons.back.generic.y				= 480-64;
	s_itemflagsweapons.back.width 				= 128;
	s_itemflagsweapons.back.height				= 64;
	s_itemflagsweapons.back.focuspic				= ITFLAGS_BACK1;

	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.banner);
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.framel);
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.weapons);
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.powerups);
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.modules);
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.misc);
	for (x = 1 ; x < WP_NUM_WEAPONS ; x++)
	{
		Menu_AddItem (&s_itemflagsweapons.menu, &s_itemflagsweapons.wp[x]);	// WPFlags
		Menu_AddItem (&s_itemflagsweapons.menu, &s_itemflagsweapons.wi[x]);	// WIFlags
		if (x != WP_GAUNTLET && x != WP_GRAPPLING_HOOK)
			Menu_AddItem (&s_itemflagsweapons.menu, &s_itemflagsweapons.wa[x]);	// WAFlags
	}
	Menu_AddItem (&s_itemflagsweapons.menu, (void *)&s_itemflagsweapons.back);

	UI_ServerItemFlags_SetMenuItems_Weapons ();
}

void UI_ServerItemFlags_Weapons (void)
{
	UI_ServerItemFlags_Init_Weapons ();
	UI_PushMenu (&s_itemflagsweapons.menu);
	Menu_SetCursorToItem (&s_itemflagsweapons.menu, &s_itemflagsweapons.weapons);
}

// ============================ POWERUPS ======================================

typedef struct
{
	menuframework_s	menu;
	menutext_s		banner;
	menubitmap_s		framel;

	menutext_s		weapons;
	menutext_s		powerups;
	menutext_s		modules;
	menutext_s		misc;

	menuradiobutton_s	pp[TOTAL_POWERUPS];	// PPFlags
	menuradiobutton_s	pi[TOTAL_POWERUPS];	// PIFlags
	menufield_s		quadfactor;
	menufield_s		suitfactor;
	menufield_s		speedfactorweapon;
	menufield_s		speedfactormove;

	menubitmap_s		back;
} itemflagspowerups_t;
static itemflagspowerups_t s_itemflagspowerups;

static void UI_ServerItemFlags_SaveChanges_Powerups (void)
{
	trap_Cvar_SetValue ("g_quadfactor",        atoi (s_itemflagspowerups.quadfactor.field.buffer));
	trap_Cvar_SetValue ("g_suitfactor",        atoi (s_itemflagspowerups.suitfactor.field.buffer));
	trap_Cvar_SetValue ("g_speedfactorweapon", atoi (s_itemflagspowerups.speedfactorweapon.field.buffer));
	trap_Cvar_SetValue ("g_speedfactormove",   atoi (s_itemflagspowerups.speedfactormove.field.buffer));
}

static sfxHandle_t UI_ServerItemFlags_MenuKey_Powerups (int key)
{
	if (key == K_MOUSE2 || key == K_ESCAPE) UI_ServerItemFlags_SaveChanges_Powerups ();
	return Menu_DefaultKey (&s_itemflagspowerups.menu, key);
}

static void UI_ServerItemFlags_SetMenuItems_Powerups (void)
{
	int x;

	for (x = 1 ; x < TOTAL_POWERUPS ; x++)
	{
		s_itemflagspowerups.pp[x].curvalue = (int)Com_Clamp (0, 1, ui_ppflags.integer & (1 << (x - 1)));
		s_itemflagspowerups.pi[x].curvalue = (int)Com_Clamp (0, 1, ui_piflags.integer & (1 << (x - 1)));
	}
	Com_sprintf (s_itemflagspowerups.quadfactor.field.buffer, 4, "%i",
			(int)Com_Clamp (0, 100, ui_quadfactor.integer));
	Com_sprintf (s_itemflagspowerups.suitfactor.field.buffer, 4, "%i",
			(int)Com_Clamp (0, 100, ui_suitfactor.integer));
	Com_sprintf (s_itemflagspowerups.speedfactorweapon.field.buffer, 4, "%i",
			(int)Com_Clamp (0, 100, ui_speedfactorweapon.integer));
	Com_sprintf (s_itemflagspowerups.speedfactormove.field.buffer, 4, "%i",
			(int)Com_Clamp (0, 100, ui_speedfactormove.integer));
}

static void UI_ServerItemFlags_Event_Powerups (void *ptr, int event)
{
	int x, splat;

	for (x = 1 ; x < TOTAL_POWERUPS ; x++)
	{
		if (((menucommon_s*)ptr)->id == ITFLAGS_PPFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_ppflags.integer;
			if (s_itemflagspowerups.pp[x].curvalue == 1) splat |= (1 << (x - 1));
			else	splat &= ~(1 << (x - 1));
			trap_Cvar_SetValue ("ppflags", splat);
			break;
		}
		else if (((menucommon_s*)ptr)->id == ITFLAGS_PIFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_piflags.integer;
			if (s_itemflagspowerups.pi[x].curvalue == 1) splat |= (1 << (x - 1));
			else  splat &= ~(1 << (x - 1));
			trap_Cvar_SetValue ("piflags", splat);
			break;
		}
	}
}

static void UI_ServerItemFlags_EventBuffer_Powerups (void *ptr, int event)
{
// We have to save the Factor fields before we can go to a different menu.
	UI_ServerItemFlags_SaveChanges_Powerups ();
	UI_ServerItemFlags_Event (ptr, event);
}

static void UI_ServerItemFlags_Draw_Powerups (void)
{
	int x, y;

	Menu_Draw (&s_itemflagspowerups.menu);

	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"PREVENT", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY,
			"SPAWN", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"INITIAL", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY,
			"POWERUP", UI_SMALLFONT|UI_CENTER, color_orange );

	for (x = 1, y = ITFLAGS_TOPY ; x < HI_NUM_HOLDABLE ; x++, y += BIGCHAR_HEIGHT+2)
		UI_DrawString (ITFLAGS_NAMEX2, y, BG_FindItemForHoldable (x)->pickup_name,
				UI_SMALLFONT|UI_RIGHT, color_orange);
	for (x = 1 ; x < TOTAL_POWERUPS - HI_NUM_HOLDABLE + 1 ; x++, y += BIGCHAR_HEIGHT+2)
		UI_DrawString (ITFLAGS_NAMEX2, y, BG_FindItemForPowerup (x)->pickup_name,
				UI_SMALLFONT|UI_RIGHT, color_orange);
}

void UI_ServerItemFlags_Init_Powerups (void)
{
	int x, y;

	memset (&s_itemflagspowerups, 0, sizeof (itemflagspowerups_t));

	UI_ServerItemFlags_Cache ();

	s_itemflagspowerups.menu.key = UI_ServerItemFlags_MenuKey_Powerups;
	s_itemflagspowerups.menu.wrapAround = qtrue;
	s_itemflagspowerups.menu.fullscreen = qtrue;
	s_itemflagspowerups.menu.draw = UI_ServerItemFlags_Draw_Powerups;

	s_itemflagspowerups.banner.generic.type			= MTYPE_BTEXT;
	s_itemflagspowerups.banner.generic.flags			= QMF_CENTER_JUSTIFY;
	s_itemflagspowerups.banner.generic.x			= 320;
	s_itemflagspowerups.banner.generic.y			= 16;
	s_itemflagspowerups.banner.string				= "ITEM FLAGS";
	s_itemflagspowerups.banner.color				= color_white;
	s_itemflagspowerups.banner.style				= UI_CENTER;

	s_itemflagspowerups.framel.generic.type			= MTYPE_BITMAP;
	s_itemflagspowerups.framel.generic.name			= ITFLAGS_FRAMEL;
	s_itemflagspowerups.framel.generic.flags			= QMF_INACTIVE;
	s_itemflagspowerups.framel.generic.x			= 8;
	s_itemflagspowerups.framel.generic.y			= 76;
	s_itemflagspowerups.framel.width				= 256;
	s_itemflagspowerups.framel.height				= 334;

	y = 2 * PROP_HEIGHT;
	s_itemflagspowerups.weapons.generic.type			= MTYPE_PTEXT;
	s_itemflagspowerups.weapons.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagspowerups.weapons.generic.callback 		= UI_ServerItemFlags_EventBuffer_Powerups;
	s_itemflagspowerups.weapons.generic.id			= ITFLAGS_WEAPONS;
	s_itemflagspowerups.weapons.generic.x 			= ITFLAGS_MENUX;
	s_itemflagspowerups.weapons.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagspowerups.weapons.string				= "WEAPONS";
	s_itemflagspowerups.weapons.color				= color_red;
	s_itemflagspowerups.weapons.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagspowerups.powerups.generic.type			= MTYPE_PTEXT;
	s_itemflagspowerups.powerups.generic.flags		= QMF_RIGHT_JUSTIFY|QMF_HIGHLIGHT_IF_FOCUS|QMF_HIGHLIGHT;
	s_itemflagspowerups.powerups.generic.callback		= UI_ServerItemFlags_EventBuffer_Powerups;
	s_itemflagspowerups.powerups.generic.id			= ITFLAGS_POWERUPS;
	s_itemflagspowerups.powerups.generic.x			= ITFLAGS_MENUX;
	s_itemflagspowerups.powerups.generic.y			= ITFLAGS_MENUY - y;
	s_itemflagspowerups.powerups.string			= "POWERUPS";
	s_itemflagspowerups.powerups.color				= color_red;
	s_itemflagspowerups.powerups.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagspowerups.modules.generic.type			= MTYPE_PTEXT;
	s_itemflagspowerups.modules.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagspowerups.modules.generic.callback 		= UI_ServerItemFlags_EventBuffer_Powerups;
	s_itemflagspowerups.modules.generic.id			= ITFLAGS_MODULES;
	s_itemflagspowerups.modules.generic.x 			= ITFLAGS_MENUX;
	s_itemflagspowerups.modules.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagspowerups.modules.string				= "MODULES";
	s_itemflagspowerups.modules.color				= color_red;
	s_itemflagspowerups.modules.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagspowerups.misc.generic.type 			= MTYPE_PTEXT;
	s_itemflagspowerups.misc.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagspowerups.misc.generic.callback			= UI_ServerItemFlags_EventBuffer_Powerups;
	s_itemflagspowerups.misc.generic.id			= ITFLAGS_MISC;
	s_itemflagspowerups.misc.generic.x				= ITFLAGS_MENUX;
	s_itemflagspowerups.misc.generic.y				= ITFLAGS_MENUY - y;
	s_itemflagspowerups.misc.string				= "MISC";
	s_itemflagspowerups.misc.color 				= color_red;
	s_itemflagspowerups.misc.style 				= UI_RIGHT;

	for (x = 1, y = ITFLAGS_TOPY; x < TOTAL_POWERUPS ; x++, y += BIGCHAR_HEIGHT+2)
	{
		s_itemflagspowerups.pp[x].generic.type		= MTYPE_RADIOBUTTON;
		s_itemflagspowerups.pp[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagspowerups.pp[x].generic.x		= ITFLAGS_COL2X;
		s_itemflagspowerups.pp[x].generic.y		= y;
		s_itemflagspowerups.pp[x].generic.id 		= ITFLAGS_PPFLAGS + x;
		s_itemflagspowerups.pp[x].generic.callback	= UI_ServerItemFlags_Event_Powerups;
		s_itemflagspowerups.pp[x].generic.name		= "";

		s_itemflagspowerups.pi[x].generic.type		= MTYPE_RADIOBUTTON;
		s_itemflagspowerups.pi[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagspowerups.pi[x].generic.x		= ITFLAGS_COL3X;
		s_itemflagspowerups.pi[x].generic.y		= y;
		s_itemflagspowerups.pi[x].generic.id 		= ITFLAGS_PIFLAGS + x;
		s_itemflagspowerups.pi[x].generic.callback	= UI_ServerItemFlags_Event_Powerups;
		s_itemflagspowerups.pi[x].generic.name		= "";
	}

	y += PROP_HEIGHT;
	s_itemflagspowerups.quadfactor.generic.type 		= MTYPE_FIELD;
	s_itemflagspowerups.quadfactor.generic.flags		= QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_itemflagspowerups.quadfactor.generic.name		= "Quad Damage Factor:";
	s_itemflagspowerups.quadfactor.generic.x			= ITFLAGS_COL3X;
	s_itemflagspowerups.quadfactor.generic.y			= y;
	s_itemflagspowerups.quadfactor.field.widthInChars	= 3;
	s_itemflagspowerups.quadfactor.field.maxchars		= 3;

	y += BIGCHAR_HEIGHT + 2;
	s_itemflagspowerups.suitfactor.generic.type 		= MTYPE_FIELD;
	s_itemflagspowerups.suitfactor.generic.flags		= QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_itemflagspowerups.suitfactor.generic.name		= "Battle Suit Factor:";
	s_itemflagspowerups.suitfactor.generic.x			= ITFLAGS_COL3X;
	s_itemflagspowerups.suitfactor.generic.y			= y;
	s_itemflagspowerups.suitfactor.field.widthInChars	= 3;
	s_itemflagspowerups.suitfactor.field.maxchars		= 3;

	y += BIGCHAR_HEIGHT + 2;
	s_itemflagspowerups.speedfactorweapon.generic.type		= MTYPE_FIELD;
	s_itemflagspowerups.speedfactorweapon.generic.flags		= QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_itemflagspowerups.speedfactorweapon.generic.name		= "Speed Factor (Rate of Fire):";
	s_itemflagspowerups.speedfactorweapon.generic.x			= ITFLAGS_COL3X;
	s_itemflagspowerups.speedfactorweapon.generic.y			= y;
	s_itemflagspowerups.speedfactorweapon.field.widthInChars	= 3;
	s_itemflagspowerups.speedfactorweapon.field.maxchars		= 3;

	y += BIGCHAR_HEIGHT + 2;
	s_itemflagspowerups.speedfactormove.generic.type	= MTYPE_FIELD;
	s_itemflagspowerups.speedfactormove.generic.flags	= QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_itemflagspowerups.speedfactormove.generic.name	= "Speed Factor (Movement):";
	s_itemflagspowerups.speedfactormove.generic.x		= ITFLAGS_COL3X;
	s_itemflagspowerups.speedfactormove.generic.y		= y;
	s_itemflagspowerups.speedfactormove.field.widthInChars	= 3;
	s_itemflagspowerups.speedfactormove.field.maxchars	= 3;

	s_itemflagspowerups.back.generic.type 			= MTYPE_BITMAP;
	s_itemflagspowerups.back.generic.name			= ITFLAGS_BACK0;
	s_itemflagspowerups.back.generic.flags			= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagspowerups.back.generic.callback			= UI_ServerItemFlags_EventBuffer_Powerups;
	s_itemflagspowerups.back.generic.id			= ITFLAGS_BACK;
	s_itemflagspowerups.back.generic.x				= 0;
	s_itemflagspowerups.back.generic.y				= 480-64;
	s_itemflagspowerups.back.width 				= 128;
	s_itemflagspowerups.back.height				= 64;
	s_itemflagspowerups.back.focuspic				= ITFLAGS_BACK1;

	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.banner);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.framel);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.weapons);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.powerups);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.modules);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.misc);
	for (x = 1 ; x < TOTAL_POWERUPS ; x++)
	{
		Menu_AddItem (&s_itemflagspowerups.menu, &s_itemflagspowerups.pp[x]);	// PPFlags
		Menu_AddItem (&s_itemflagspowerups.menu, &s_itemflagspowerups.pi[x]);	// PIFlags
	}
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.quadfactor);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.suitfactor);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.speedfactorweapon);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.speedfactormove);
	Menu_AddItem (&s_itemflagspowerups.menu, (void *)&s_itemflagspowerups.back);

	UI_ServerItemFlags_SetMenuItems_Powerups ();
}

void UI_ServerItemFlags_Powerups (void)
{
	UI_ServerItemFlags_Init_Powerups ();
	UI_PushMenu (&s_itemflagspowerups.menu);
	Menu_SetCursorToItem (&s_itemflagspowerups.menu, &s_itemflagspowerups.powerups);
}

// ============================ MODULES =======================================

typedef struct
{
	menuframework_s	menu;
	menutext_s		banner;
	menubitmap_s		framel;

	menutext_s		weapons;
	menutext_s		powerups;
	menutext_s		modules;
	menutext_s		misc;

	menuradiobutton_s	mp[MD_NUM_MODULES];	// MPFlags
	menuradiobutton_s	ms[MD_NUM_MODULES];	// g_****skitz
	menufield_s		maxModules;

	menubitmap_s		back;
} itemflagsmodules_t;
static itemflagsmodules_t s_itemflagsmodules;

static void UI_ServerItemFlags_SaveChanges_Modules (void)
{
	trap_Cvar_SetValue ("g_maxModules", atoi (s_itemflagsmodules.maxModules.field.buffer));
}

static sfxHandle_t UI_ServerItemFlags_MenuKey_Modules (int key)
{
	if (key == K_MOUSE2 || key == K_ESCAPE) UI_ServerItemFlags_SaveChanges_Modules ();
	return Menu_DefaultKey (&s_itemflagsmodules.menu, key);
}

static void UI_ServerItemFlags_SetMenuItems_Modules (void)
{
	int x;

	for (x = 1 ; x < MD_NUM_MODULES ; x++)
	{
		s_itemflagsmodules.mp[x].curvalue = (int)Com_Clamp (0, 1, ui_mpflags.integer & (1 << (x - 1)));
		if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
			switch (x)
			{
				case MD_AMPLIFIER: s_itemflagsmodules.ms[x].curvalue =
					(int)Com_Clamp (0, 1, ui_quadskitz.integer);
						break;
				case MD_DAMPENER:  s_itemflagsmodules.ms[x].curvalue =
					(int)Com_Clamp (0, 1, ui_suitskitz.integer);
						break;
				case MD_BOOSTER:   s_itemflagsmodules.ms[x].curvalue =
					(int)Com_Clamp (0, 1, ui_speedskitz.integer);
						break;
				default:           s_itemflagsmodules.ms[x].curvalue = -1;
			}
		if (s_itemflagsmodules.mp[x].curvalue)
			if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
				s_itemflagsmodules.ms[x].generic.flags |= QMF_GRAYED;
	}
	Com_sprintf (s_itemflagsmodules.maxModules.field.buffer, 4, "%i",
			(int)Com_Clamp (0, 100, ui_maxModules.integer));
}

static void UI_ServerItemFlags_Event_Modules (void *ptr, int event)
{
	int x, splat;

	for (x = 1 ; x < MD_NUM_MODULES ; x++)
	{
		if (((menucommon_s*)ptr)->id == ITFLAGS_MPFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_mpflags.integer;
			if (s_itemflagsmodules.mp[x].curvalue == 1)
			{
				splat |= (1 << (x - 1));
				if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
					s_itemflagsmodules.ms[x].generic.flags |= QMF_GRAYED;
			}
			else
			{
				splat &= ~(1 << (x - 1));
				if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
					s_itemflagsmodules.ms[x].generic.flags &= ~QMF_GRAYED;
			}
			trap_Cvar_SetValue ("mpflags", splat);
			break;
		}
		else if (((menucommon_s*)ptr)->id == ITFLAGS_MSFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			switch (x)
			{
				case MD_AMPLIFIER:
					trap_Cvar_SetValue ("g_quadskitz", s_itemflagsmodules.ms[x].curvalue);
					break;
				case MD_DAMPENER:
					trap_Cvar_SetValue ("g_suitskitz", s_itemflagsmodules.ms[x].curvalue);
					break;
				case MD_BOOSTER:
					trap_Cvar_SetValue ("g_speedskitz", s_itemflagsmodules.ms[x].curvalue);
					break;
				default: break;
			}
		}
	}
}

static void UI_ServerItemFlags_EventBuffer_Modules (void *ptr, int event)
{
// We have to save the Factor fields before we can go to a different menu.
	UI_ServerItemFlags_SaveChanges_Modules ();
	UI_ServerItemFlags_Event (ptr, event);
}

static void UI_ServerItemFlags_Draw_Modules (void)
{
	int x, y;

	Menu_Draw (&s_itemflagsmodules.menu);

	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"PREVENT", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL2X+32, ITFLAGS_NAMEY,
			"SPAWN", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY-(BIGCHAR_HEIGHT+2),
			"ALLOW", UI_SMALLFONT|UI_CENTER, color_orange );
	UI_DrawString (ITFLAGS_COL3X+32, ITFLAGS_NAMEY,
			"SKITZ", UI_SMALLFONT|UI_CENTER, color_orange );

	for (x = 1, y = ITFLAGS_TOPY; x < MD_NUM_MODULES ; x++, y += BIGCHAR_HEIGHT+2)
		UI_DrawString (ITFLAGS_NAMEX2, y, BG_FindItemForModule (x)->pickup_name,
				UI_SMALLFONT|UI_RIGHT, color_orange);
}

void UI_ServerItemFlags_Init_Modules (void)
{
	int x, y;

	memset (&s_itemflagsmodules, 0, sizeof (itemflagsmodules_t));

	UI_ServerItemFlags_Cache ();

	s_itemflagsmodules.menu.wrapAround = qtrue;
	s_itemflagsmodules.menu.fullscreen = qtrue;
	s_itemflagsmodules.menu.draw = UI_ServerItemFlags_Draw_Modules;

	s_itemflagsmodules.banner.generic.type			= MTYPE_BTEXT;
	s_itemflagsmodules.banner.generic.flags			= QMF_CENTER_JUSTIFY;
	s_itemflagsmodules.banner.generic.x			= 320;
	s_itemflagsmodules.banner.generic.y			= 16;
	s_itemflagsmodules.banner.string				= "ITEM FLAGS";
	s_itemflagsmodules.banner.color				= color_white;
	s_itemflagsmodules.banner.style				= UI_CENTER;

	s_itemflagsmodules.framel.generic.type			= MTYPE_BITMAP;
	s_itemflagsmodules.framel.generic.name			= ITFLAGS_FRAMEL;
	s_itemflagsmodules.framel.generic.flags			= QMF_INACTIVE;
	s_itemflagsmodules.framel.generic.x			= 8;
	s_itemflagsmodules.framel.generic.y			= 76;
	s_itemflagsmodules.framel.width				= 256;
	s_itemflagsmodules.framel.height				= 334;

	y = 2 * PROP_HEIGHT;
	s_itemflagsmodules.weapons.generic.type			= MTYPE_PTEXT;
	s_itemflagsmodules.weapons.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmodules.weapons.generic.callback 		= UI_ServerItemFlags_EventBuffer_Modules;
	s_itemflagsmodules.weapons.generic.id			= ITFLAGS_WEAPONS;
	s_itemflagsmodules.weapons.generic.x 			= ITFLAGS_MENUX;
	s_itemflagsmodules.weapons.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagsmodules.weapons.string				= "WEAPONS";
	s_itemflagsmodules.weapons.color				= color_red;
	s_itemflagsmodules.weapons.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmodules.powerups.generic.type			= MTYPE_PTEXT;
	s_itemflagsmodules.powerups.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmodules.powerups.generic.callback		= UI_ServerItemFlags_EventBuffer_Modules;
	s_itemflagsmodules.powerups.generic.id			= ITFLAGS_POWERUPS;
	s_itemflagsmodules.powerups.generic.x			= ITFLAGS_MENUX;
	s_itemflagsmodules.powerups.generic.y			= ITFLAGS_MENUY - y;
	s_itemflagsmodules.powerups.string				= "POWERUPS";
	s_itemflagsmodules.powerups.color				= color_red;
	s_itemflagsmodules.powerups.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmodules.modules.generic.type			= MTYPE_PTEXT;
	s_itemflagsmodules.modules.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_HIGHLIGHT_IF_FOCUS|QMF_HIGHLIGHT;
	s_itemflagsmodules.modules.generic.callback 		= UI_ServerItemFlags_EventBuffer_Modules;
	s_itemflagsmodules.modules.generic.id			= ITFLAGS_MODULES;
	s_itemflagsmodules.modules.generic.x 			= ITFLAGS_MENUX;
	s_itemflagsmodules.modules.generic.y 			= ITFLAGS_MENUY - y;
	s_itemflagsmodules.modules.string				= "MODULES";
	s_itemflagsmodules.modules.color				= color_red;
	s_itemflagsmodules.modules.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmodules.misc.generic.type 			= MTYPE_PTEXT;
	s_itemflagsmodules.misc.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmodules.misc.generic.callback			= UI_ServerItemFlags_EventBuffer_Modules;
	s_itemflagsmodules.misc.generic.id				= ITFLAGS_MISC;
	s_itemflagsmodules.misc.generic.x				= ITFLAGS_MENUX;
	s_itemflagsmodules.misc.generic.y				= ITFLAGS_MENUY - y;
	s_itemflagsmodules.misc.string				= "MISC";
	s_itemflagsmodules.misc.color 				= color_red;
	s_itemflagsmodules.misc.style 				= UI_RIGHT;

	for (x = 1, y = ITFLAGS_TOPY; x < MD_NUM_MODULES ; x++, y += BIGCHAR_HEIGHT+2)
	{
		s_itemflagsmodules.mp[x].generic.type		= MTYPE_RADIOBUTTON;
		s_itemflagsmodules.mp[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagsmodules.mp[x].generic.x			= ITFLAGS_COL2X;
		s_itemflagsmodules.mp[x].generic.y			= y;
		s_itemflagsmodules.mp[x].generic.id 		= ITFLAGS_MPFLAGS + x;
		s_itemflagsmodules.mp[x].generic.callback		= UI_ServerItemFlags_Event_Modules;
		s_itemflagsmodules.mp[x].generic.name		= "";

		if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
		{
			s_itemflagsmodules.ms[x].generic.type		= MTYPE_RADIOBUTTON;
			s_itemflagsmodules.ms[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
			s_itemflagsmodules.ms[x].generic.x			= ITFLAGS_COL3X;
			s_itemflagsmodules.ms[x].generic.y			= y;
			s_itemflagsmodules.ms[x].generic.id 		= ITFLAGS_MSFLAGS + x;
			s_itemflagsmodules.ms[x].generic.callback		= UI_ServerItemFlags_Event_Modules;
			s_itemflagsmodules.ms[x].generic.name		= "";
		}
	}

	y += PROP_HEIGHT;
	s_itemflagsmodules.maxModules.generic.type 		= MTYPE_FIELD;
	s_itemflagsmodules.maxModules.generic.flags		= QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_itemflagsmodules.maxModules.generic.name		= "Number of Module groups:";
	s_itemflagsmodules.maxModules.generic.x			= ITFLAGS_COL3X;
	s_itemflagsmodules.maxModules.generic.y			= y;
	s_itemflagsmodules.maxModules.field.widthInChars	= 3;
	s_itemflagsmodules.maxModules.field.maxchars		= 3;

	s_itemflagsmodules.back.generic.type 			= MTYPE_BITMAP;
	s_itemflagsmodules.back.generic.name			= ITFLAGS_BACK0;
	s_itemflagsmodules.back.generic.flags			= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmodules.back.generic.callback			= UI_ServerItemFlags_EventBuffer_Modules;
	s_itemflagsmodules.back.generic.id				= ITFLAGS_BACK;
	s_itemflagsmodules.back.generic.x				= 0;
	s_itemflagsmodules.back.generic.y				= 480-64;
	s_itemflagsmodules.back.width 				= 128;
	s_itemflagsmodules.back.height				= 64;
	s_itemflagsmodules.back.focuspic				= ITFLAGS_BACK1;

	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.banner);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.framel);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.weapons);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.powerups);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.modules);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.misc);
	for (x = 1 ; x < MD_NUM_MODULES ; x++)
	{
		Menu_AddItem (&s_itemflagsmodules.menu, &s_itemflagsmodules.mp[x]);	// MPFlags
		if (x != MD_HEALER && x != MD_LIFTER && x != MD_CLOAKER)
			Menu_AddItem (&s_itemflagsmodules.menu, &s_itemflagsmodules.ms[x]);	// Skitz Values
	}
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.maxModules);
	Menu_AddItem (&s_itemflagsmodules.menu, (void *)&s_itemflagsmodules.back);

	UI_ServerItemFlags_SetMenuItems_Modules ();
}

void UI_ServerItemFlags_Modules (void)
{
	UI_ServerItemFlags_Init_Modules ();
	UI_PushMenu (&s_itemflagsmodules.menu);
	Menu_SetCursorToItem (&s_itemflagsmodules.menu, &s_itemflagsmodules.modules);
}

// ============================ MISC ==========================================

typedef struct
{
	menuframework_s	menu;
	menutext_s		banner;
	menubitmap_s		framel;

	menutext_s		weapons;
	menutext_s		powerups;
	menutext_s		modules;
	menutext_s		misc;

	menuradiobutton_s	dm[DF_NUM_VALUES];	// DMFlags

	menubitmap_s		back;
} itemflagsmisc_t;
static itemflagsmisc_t s_itemflagsmisc;

static const char *dmFlagNames_list[] =
{
	NULL,
	"Prevent Health Spawn",
	"Prevent Armor Spawn",
	"Weapons Stay",
	"No Falling Damage",
	"Fixed Field Of View",
	"No Footstep Sounds"
};

static void UI_ServerItemFlags_SetMenuItems_Misc (void)
{
	int x;
	for (x = 1 ; (1 << (x - 1) < DF_NUM_VALUES) ; x++)
		s_itemflagsmisc.dm[x].curvalue = (int)Com_Clamp (0, 1, ui_dmflags.integer & (1 << (x - 1)));
}

static void UI_ServerItemFlags_Event_Misc (void *ptr, int event)
{
	int x, splat;

	for (x = 1 ; (1 << (x - 1) < DF_NUM_VALUES) ; x++)
	{
		if (((menucommon_s*)ptr)->id == ITFLAGS_DMFLAGS + x)
		{
			if (event != QM_ACTIVATED) break;
			splat = ui_dmflags.integer;
			if (s_itemflagsmisc.dm[x].curvalue == 1) splat |= (1 << (x - 1));
			else  splat &= ~(1 << (x - 1));
			trap_Cvar_SetValue ("dmflags", splat);
			break;
		}
	}
}

void UI_ServerItemFlags_Init_Misc (void)
{
	int x, y;

	memset (&s_itemflagsmisc, 0, sizeof (itemflagsmisc_t));

	UI_ServerItemFlags_Cache ();

	s_itemflagsmisc.menu.wrapAround = qtrue;
	s_itemflagsmisc.menu.fullscreen = qtrue;

	s_itemflagsmisc.banner.generic.type			= MTYPE_BTEXT;
	s_itemflagsmisc.banner.generic.flags			= QMF_CENTER_JUSTIFY;
	s_itemflagsmisc.banner.generic.x				= 320;
	s_itemflagsmisc.banner.generic.y				= 16;
	s_itemflagsmisc.banner.string				= "ITEM FLAGS";
	s_itemflagsmisc.banner.color				= color_white;
	s_itemflagsmisc.banner.style				= UI_CENTER;

	s_itemflagsmisc.framel.generic.type			= MTYPE_BITMAP;
	s_itemflagsmisc.framel.generic.name			= ITFLAGS_FRAMEL;
	s_itemflagsmisc.framel.generic.flags			= QMF_INACTIVE;
	s_itemflagsmisc.framel.generic.x				= 8;
	s_itemflagsmisc.framel.generic.y				= 76;
	s_itemflagsmisc.framel.width				= 256;
	s_itemflagsmisc.framel.height				= 334;

	y = 2 * PROP_HEIGHT;
	s_itemflagsmisc.weapons.generic.type			= MTYPE_PTEXT;
	s_itemflagsmisc.weapons.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmisc.weapons.generic.callback 			= UI_ServerItemFlags_Event;
	s_itemflagsmisc.weapons.generic.id				= ITFLAGS_WEAPONS;
	s_itemflagsmisc.weapons.generic.x 				= ITFLAGS_MENUX;
	s_itemflagsmisc.weapons.generic.y 				= ITFLAGS_MENUY - y;
	s_itemflagsmisc.weapons.string				= "WEAPONS";
	s_itemflagsmisc.weapons.color				= color_red;
	s_itemflagsmisc.weapons.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmisc.powerups.generic.type			= MTYPE_PTEXT;
	s_itemflagsmisc.powerups.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmisc.powerups.generic.callback			= UI_ServerItemFlags_Event;
	s_itemflagsmisc.powerups.generic.id			= ITFLAGS_POWERUPS;
	s_itemflagsmisc.powerups.generic.x				= ITFLAGS_MENUX;
	s_itemflagsmisc.powerups.generic.y				= ITFLAGS_MENUY - y;
	s_itemflagsmisc.powerups.string				= "POWERUPS";
	s_itemflagsmisc.powerups.color				= color_red;
	s_itemflagsmisc.powerups.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmisc.modules.generic.type			= MTYPE_PTEXT;
	s_itemflagsmisc.modules.generic.flags			= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmisc.modules.generic.callback 			= UI_ServerItemFlags_Event;
	s_itemflagsmisc.modules.generic.id				= ITFLAGS_MODULES;
	s_itemflagsmisc.modules.generic.x 				= ITFLAGS_MENUX;
	s_itemflagsmisc.modules.generic.y 				= ITFLAGS_MENUY - y;
	s_itemflagsmisc.modules.string				= "MODULES";
	s_itemflagsmisc.modules.color				= color_red;
	s_itemflagsmisc.modules.style				= UI_RIGHT;

	y -= PROP_HEIGHT;
	s_itemflagsmisc.misc.generic.type 				= MTYPE_PTEXT;
	s_itemflagsmisc.misc.generic.flags				= QMF_RIGHT_JUSTIFY|QMF_HIGHLIGHT_IF_FOCUS|QMF_HIGHLIGHT;
	s_itemflagsmisc.misc.generic.callback			= UI_ServerItemFlags_Event;
	s_itemflagsmisc.misc.generic.id				= ITFLAGS_MISC;
	s_itemflagsmisc.misc.generic.x				= ITFLAGS_MENUX;
	s_itemflagsmisc.misc.generic.y				= ITFLAGS_MENUY - y;
	s_itemflagsmisc.misc.string					= "MISC";
	s_itemflagsmisc.misc.color 					= color_red;
	s_itemflagsmisc.misc.style 					= UI_RIGHT;

	for (x = 1, y = ITFLAGS_TOPY; (1 << (x - 1) < DF_NUM_VALUES) ; x++, y += BIGCHAR_HEIGHT+2)
	{
		s_itemflagsmisc.dm[x].generic.type			= MTYPE_RADIOBUTTON;
		s_itemflagsmisc.dm[x].generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_itemflagsmisc.dm[x].generic.x			= ITFLAGS_COL3X;
		s_itemflagsmisc.dm[x].generic.y			= y;
		s_itemflagsmisc.dm[x].generic.id 			= ITFLAGS_DMFLAGS + x;
		s_itemflagsmisc.dm[x].generic.callback		= UI_ServerItemFlags_Event_Misc;
		s_itemflagsmisc.dm[x].generic.name			= dmFlagNames_list[x];
	}

	s_itemflagsmisc.back.generic.type 				= MTYPE_BITMAP;
	s_itemflagsmisc.back.generic.name				= ITFLAGS_BACK0;
	s_itemflagsmisc.back.generic.flags				= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_itemflagsmisc.back.generic.callback			= UI_ServerItemFlags_Event;
	s_itemflagsmisc.back.generic.id				= ITFLAGS_BACK;
	s_itemflagsmisc.back.generic.x				= 0;
	s_itemflagsmisc.back.generic.y				= 480-64;
	s_itemflagsmisc.back.width 					= 128;
	s_itemflagsmisc.back.height					= 64;
	s_itemflagsmisc.back.focuspic				= ITFLAGS_BACK1;

	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.banner);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.framel);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.weapons);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.powerups);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.modules);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.misc);
	for (x = 1, y = ITFLAGS_TOPY; (1 << (x - 1) < DF_NUM_VALUES) ; x++, y += BIGCHAR_HEIGHT+2)
		Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.dm[x]);
	Menu_AddItem (&s_itemflagsmisc.menu, (void *)&s_itemflagsmisc.back);

	UI_ServerItemFlags_SetMenuItems_Misc ();
}

void UI_ServerItemFlags_Misc (void)
{
	UI_ServerItemFlags_Init_Misc ();
	UI_PushMenu (&s_itemflagsmisc.menu);
	Menu_SetCursorToItem (&s_itemflagsmisc.menu, &s_itemflagsmisc.misc);
}

// ============================ FUNDAMENTAL ===================================

static void UI_ServerItemFlags_Event (void *ptr, int event)
{
	if (event != QM_ACTIVATED)
		return;

	switch (((menucommon_s*)ptr)->id)
	{
		case ITFLAGS_WEAPONS:
			UI_PopMenu ();
			UI_ServerItemFlags_Weapons ();
			break;
		case ITFLAGS_POWERUPS:
			UI_PopMenu ();
			UI_ServerItemFlags_Powerups ();
			break;
		case ITFLAGS_MODULES:
			UI_PopMenu ();
			UI_ServerItemFlags_Modules ();
			break;
		case ITFLAGS_MISC:
			UI_PopMenu ();
			UI_ServerItemFlags_Misc ();
			break;
		case ITFLAGS_BACK:
			UI_PopMenu ();
			break;
	}
}

void UI_ServerItemFlags_Cache (void)
{
	trap_R_RegisterShaderNoMip (ITFLAGS_FRAMEL);
	trap_R_RegisterShaderNoMip (ITFLAGS_BACK0);
	trap_R_RegisterShaderNoMip (ITFLAGS_BACK1);
}

void UI_ServerItemFlags (void) {UI_ServerItemFlags_Weapons ();}
