/*
**
**
** Server Information Routines
**
**
**
**
** $Id$
**
*/

#include <winsock.h>
#include <stdio.h>

#include <q2_util.h>

/*
**
** defines & macros
**
*/

#define PRINT_VERBOSE
#define CHECK_WINSOCK_VERSION
#define PRINT_ERRORS




#define RCV_TIMEOUT_SEC 5

#define MAX_ERRORS      2

#ifdef WIN32
#pragma warning( disable : 4002 )
#endif

#if defined(_DEBUG) && defined(PRINT_VERBOSE)
#define dbg_printf printf
#else
#define dbg_printf() 
#endif

#if defined(_DEBUG) && defined(PRINT_ERRORS)
#define err_printf printf
#else
#define err_printf() 
#endif

#define inf_printf printf

/*
**
** Private Data
**
*/
static SERVER *pServerList =   NULL;

static const unsigned char aStrHead[]   = { 0xff,0xff,0xff,0xff };
static const unsigned char aStatusStr[] = "status";
static const unsigned char aInfo31Str[] = "info 31";
static const unsigned char aInfo32Str[] = "info 32";


static const unsigned char aStatusRespStr[] = "print\n";

/*
** Private Function Definitsions
*/

static void disp_err(void);
static unsigned long atoaddr(char *address);

static SERVER *getServerNode( const char *pServerAddr );
static SERVER *createServerNode( const char *pServerAddr );
static void setServerStatusResp( SERVER *pServer, const char *pStatusResp );
static void setServerIPAndPort( SERVER *pServer, const char *pServerIP, unsigned long ulServerPort );
static void clearServerInfo( SERVER *pServer );

/*
**
** Public Functions
**
*/

const SERVER *getQ2ServerInfo( const char *pServerAddress )
{
    SERVER            *pServer;
    
    pServer = getServerNode( pServerAddress );

    return pServer;
}

const SERVER *pingQ2ServerInfo( const char *pServerAddress )
{
    SOCKET             socQuake2   = INVALID_SOCKET;
    SERVER            *pServer     = NULL;
    struct sockaddr_in myaddr      = {0};
    unsigned int       portnum     = 27910;
    int                fCont       = 1;
    char              *pServerAddr = NULL;
    char              *pServerMem  = NULL;
#ifdef WIN32
    WORD               wVersionRequested = 0;
#endif

    /* Find or Create Server Node in LinkList */
    if( fCont )
    {
        pServer = getServerNode( pServerAddress );
        if( NULL != pServer )
        {
            /* Clear Server information */
            clearServerInfo( pServer );
        }
        else
        {
            fCont = 0;
        }
    }
    
    /* Sort out arguments */

    /* copy address for manipulation */
    if( fCont )
    {
        pServerMem = malloc( strlen(pServerAddress)+1 );
        if( pServerMem )
        {
            strcpy( pServerMem, pServerAddress );
            pServerAddr = pServerMem;
        }
        else
        {
            err_printf("WSAStartup().\n");
            disp_err();
            fCont = 0;
        }            
    }

    /* Get port number */
    if( fCont )
    {
        char *pPort = strchr( pServerAddr, ':' );

        if( pPort )
        {
            portnum = (unsigned int)atoi((pPort+1));
            *pPort  = '\0';
        }
    }

    /* Set Server IP and Port Number */
    if( fCont )
    {
        setServerIPAndPort( pServer, pServerAddr, portnum );
    }


#ifdef WIN32
    if( fCont )
    {
        WSADATA wsaData;
        int err;

        wVersionRequested = MAKEWORD( 2, 0 );

        err = WSAStartup( wVersionRequested, &wsaData );
        if ( err != 0 ) {
            /* Tell the user that we couldn't find a usable */
            /* WinSock DLL.                                  */
            err_printf("WSAStartup().\n");
            disp_err();
            fCont = 0;
        }

        /* Confirm that the WinSock DLL supports 2.0.*/
        /* Note that if the DLL supports versions greater    */
        /* than 2.0 in addition to 2.0, it will still return */
        /* 2.0 in wVersion since that is the version we      */
        /* requested.                                        */

        if( fCont )
        {
            dbg_printf("WinSock DLL Version %#.4lx.\n", wsaData.wVersion);
#ifdef CHECK_WINSOCK_VERSION
            if ( LOBYTE( wsaData.wVersion ) != 2 ||
                 HIBYTE( wsaData.wVersion ) != 0 )
            {
                /* Tell the user that we couldn't find a usable */
                /* WinSock DLL.                                  */
                err_printf("Wrong Version %#.4lx.\n", wsaData.wVersion);
                fCont = 0;
            }
#endif
        }
    }
#endif


    /* Create Socket */
    if( fCont )
    {
        socQuake2 = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if (socQuake2 == INVALID_SOCKET)
        {
            err_printf("socket() failed.\n");
            disp_err();
            fCont = 0;
        }
    }

    /* Set receive timeout */
    if( fCont )
    {
        int rcvTimeout = RCV_TIMEOUT_SEC * 1000;
        
        if( setsockopt(socQuake2, SOL_SOCKET, SO_RCVTIMEO,
                       (const char*) &rcvTimeout, sizeof(rcvTimeout)) )
        {

            err_printf("setsockopt(SO_RCVTIMEO) failed.\n");
            disp_err();
            fCont = 0;
        }
    }

    /* Set linger */
#if 0
    if( fCont )
    {
        BOOL fLinger = TRUE;

        if( setsockopt(socQuake2, SOL_SOCKET, SO_DONTLINGER,
                       (const char*) &fLinger, sizeof(fLinger)) )
        {

            err_printf("setsockopt(SO_DONTLINGER) failed.\n");
            disp_err();
            fCont = 0;
        }
    }
#endif
    
    /* Bind Socket */
    if( fCont )
    {
        myaddr.sin_family = AF_INET;
        myaddr.sin_port   = 0;
        
        if( bind(socQuake2, (struct sockaddr *) &myaddr, sizeof(SOCKADDR_IN)) )
        {
            err_printf("bind() failed.\n");
            disp_err();
            return 0;
        }
    }

    /* Setup socket destination */
    if( fCont )
    {
        struct sockaddr_in serAddr = {0};
        int                addrlen = sizeof(serAddr);

        serAddr.sin_family      = AF_INET;
        serAddr.sin_addr.s_addr = atoaddr(pServerAddr);
        serAddr.sin_port        = htons((u_short)portnum);

        dbg_printf( "I.P. %s [%s], Port %d\n",
                    pServerAddr,
                    inet_ntoa(serAddr.sin_addr),
                    portnum );

        
        setServerIPAndPort( pServer, inet_ntoa(serAddr.sin_addr), portnum );
        
        if (connect(socQuake2,(struct sockaddr *)&serAddr, sizeof(serAddr))< 0)
        {
            err_printf("connect() failed.\n");
            disp_err();
        }
    }

    /* Send/Receive packets */
    if( fCont )
    {
        int i = 0;
        const unsigned char *aMessages[] =
        {
            aStatusStr,
/*            aInfo31Str, aInfo32Str,*/
            NULL
        };

        unsigned long ulPings[sizeof(aMessages)/sizeof(aMessages[0])-1];
        
        while( fCont && aMessages[i] )
        {
            unsigned int nErrors = 0;
            
            ulPings[i] = NO_PING;

            while( fCont && (NO_PING == ulPings[i]) )
            {
                int           nSent;
                unsigned char aSend[1024] = { 0 };
                DWORD         sendTick;

                memcpy( &aSend, aStrHead, sizeof(aStrHead) );
                memcpy( &aSend[sizeof(aStrHead)], aMessages[i], strlen(aMessages[i])+1 );


                dbg_printf("send [%s].\n", &aSend[4] );

                sendTick = GetTickCount();

                nSent = send( socQuake2,
                              &aSend[0],
                              sizeof(aSend),
                              0 );
                if( nSent != sizeof(aSend) )
                {
                    err_printf("send failed.\n");
                    disp_err();
                    fCont = 0;
                }


                /* wait for response */
                if( fCont )
                {
                    char            aPacket [8192] = {0};	// Don't know the real MTU; seems like enough.
                    char           *pPacket = &aPacket[0];
                    int             nRead;
#if 0
                    SOCKADDR_IN     ServerAddress;
                    int             addrlen = sizeof(ServerAddress);

                    nRead = recvfrom( socQuake2,
                                      pPacket,
                                      sizeof(aPacket),
                                      0,
                                      (struct sockaddr *) &ServerAddress,
                                      &addrlen);
#else
                    nRead = recv( socQuake2,
                                  pPacket,
                                  sizeof(aPacket),
                                  0 );
#endif

                    if (nRead == SOCKET_ERROR)
                    {
                        err_printf("recvfrom() failed.\n");
                        disp_err();
                        fCont = 0;
                        /* May need to wait a bit before we can do
                         ** another recvfrom() */
                    }
                    else
                    {
                        ulPings[i] = GetTickCount() - sendTick;

                        /* Parse response */

#if defined(_DEBUG) && defined(PRINT_PACKET)
                        {
                            int             nLeft;

                            pPacket = &aPacket[0];

                            nLeft = nRead;
                            /* Test to see if the packet is a string packet. */
                            if ( !memcmp( aStrHead, pPacket, sizeof(aStrHead) ) )
                            {
                                dbg_printf( "String Packet :\n" );
                                pPacket += sizeof(aStrHead);
                                nLeft   -= sizeof(aStrHead);

                                while( nLeft )
                                {
                                    dbg_printf( "%c", *pPacket, *pPacket );
                                    pPacket++;
                                    nLeft--;
                                }
                            }
                            else
                            {
                                dbg_printf( "Data :\n" );

                                /* Dump out packet in hex */
                                while( nLeft )
                                {
                                    dbg_printf( "%#.2x (%c) ", *pPacket, ((*pPacket) >= 0x20)?(*pPacket):'\0' );
                                    pPacket++;
                                    nLeft--;
                                }
                            }
                        }
#endif
                        /* Test to see if the packet is a string packet. */
                        pPacket = &aPacket[0];
                        if ( !memcmp( aStrHead, pPacket, sizeof(aStrHead) ) )
                        {
                            pPacket += sizeof(aStrHead);

                            if( !strncmp( pPacket, aStatusRespStr, strlen(aStatusRespStr)) )
                            {
                                /* Response from "status" packet */
                                setServerStatusResp(pServer, pPacket+strlen(aStatusRespStr) );
                            }
                            else
                            {
                                /* Unknown packet */

                                /* Treat as no response */
                                ulPings[i] = NO_PING;
                            }
                        }
                        else
                        {
                                /* Unknown packet */

                                /* Treat as no response */
                            ulPings[i] = NO_PING;
	                      }
                    }
                }

                /* Handle errors */
                if( !fCont || (NO_PING == ulPings[i]) )
                {
                    nErrors ++;
                    if( nErrors >= MAX_ERRORS )
                    {
                        err_printf( "Too many errors\n" );
                        fCont = 0;
                    }
                    else
                        fCont = 1;
                }
            }
            
            /* Next message */
            i++;
        }

        /* Set server ping */
        if( fCont )
        {
            unsigned long ulPing = 0;
            int           j = 0;
            int           k;

            for( k=0; k < i; k++ )
            {
                dbg_printf( "Ping[%d] = %u\n", k, ulPings[k] );
                
                if( NO_PING != ulPings[k] )
                {
                    ulPing += ulPings[k]/2;
                    j++;
                }
            }

            if( 0 != j )
            {
                ulPing /= j;
                pServer->ulPing = ulPing;
            }
        }
    }

   
    /* Cleanup */
    if (INVALID_SOCKET != socQuake2)
    {
        closesocket( socQuake2 );
        socQuake2 = INVALID_SOCKET;
    }
    

#ifdef WIN32
    if( 0 != wVersionRequested )
    {
        WSACleanup();
        wVersionRequested = 0;
    }
#endif

    if( pServerMem )
    {
        free(pServerMem);
        pServerMem = NULL;
    }

    return pServer;
} /* end of getQ2ServerInfo() */















/*
**
** Private Functions
**
*/



struct socErrs
{
    int    err;
    char  *pString;
};

static const struct socErrs aScocketErrors[] =
{
    { WSAEACCES,          "WSAEACCES" },
    { WSAEADDRINUSE,      "WSAEADDRINUSE" },
    { WSAEADDRNOTAVAIL,   "WSAEADDRNOTAVAIL" },
    { WSAEAFNOSUPPORT,    "WSAEAFNOSUPPORT" },
    { WSAEALREADY,        "WSAEALREADY" },
    { WSAECONNABORTED,    "WSAECONNABORTED" },
    { WSAECONNREFUSED,    "WSAECONNREFUSED" },
    { WSAECONNRESET,      "WSAECONNRESET" },
    { WSAEFAULT,          "WSAEFAULT" },
    { WSAEFAULT,          "WSAEFAULT" },
    { WSAEINPROGRESS,     "WSAEINPROGRESS" },
    { WSAEINPROGRESS,     "WSAEINPROGRESS" },
    { WSAEINTR,           "WSAEINTR" },
    { WSAEINTR,           "WSAEINTR" },
    { WSAEINVAL,          "WSAEINVAL" },
    { WSAEINVAL,          "WSAEINVAL" },
    { WSAEISCONN,         "WSAEISCONN" },
    { WSAEMFILE,          "WSAEMFILE" },
    { WSAEMSGSIZE,        "WSAEMSGSIZE" },
    { WSAENETDOWN,        "WSAENETDOWN" },
    { WSAENETDOWN,        "WSAENETDOWN" },
    { WSAENETRESET,       "WSAENETRESET" },
    { WSAENETUNREACH,     "WSAENETUNREACH" },
    { WSAENOBUFS,         "WSAENOBUFS" },
    { WSAENOTCONN,        "WSAENOTCONN" },
    { WSAENOTSOCK,        "WSAENOTSOCK" },
    { WSAENOTSOCK,        "WSAENOTSOCK" },
    { WSAEOPNOTSUPP,      "WSAEOPNOTSUPP" },
    { WSAEPROTONOSUPPORT, "WSAEPROTONOSUPPORT" },
    { WSAEPROTOTYPE,      "WSAEPROTOTYPE" },
    { WSAESHUTDOWN,       "WSAESHUTDOWN" },
    { WSAESOCKTNOSUPPORT, "WSAESOCKTNOSUPPORT" },
    { WSAETIMEDOUT,       "WSAETIMEDOUT" },
    { WSAETIMEDOUT,       "WSAETIMEDOUT" },
    { WSAEWOULDBLOCK,     "WSAEWOULDBLOCK" },
    { WSAEWOULDBLOCK,     "WSAEWOULDBLOCK" },
    { WSANOTINITIALISED,  "WSANOTINITIALISED" },
    { WSANOTINITIALISED,  "WSANOTINITIALISED" },
    { 0, NULL }
};


static void disp_err(void)
{
    const struct socErrs *a = aScocketErrors;
    int                   err;

    err = WSAGetLastError ();
    while( a->pString && (a->err != err) )
        a++;

    if( a->pString )
        err_printf("%s.\n", a->pString);
}


/* Converts ascii text to in_addr struct.  NULL is returned if the
address can not be found. */
static unsigned long atoaddr(char *address)
{
    struct hostent *host;
    struct in_addr saddr;

    /* First try it as aaa.bbb.ccc.ddd. */
    saddr.s_addr = inet_addr(address);
    if (saddr.s_addr != -1) {
        return saddr.s_addr;
    }
    host = gethostbyname(address);
    if (host != NULL) {
        return ((struct in_addr *) *host->h_addr_list)->s_addr;
    }
    return 0L;
}



static SERVER *getServerNode( const char *pServerAddr )
{
    SERVER *pServer = pServerList;

    /* Find */
    while( pServer )
    {
        if( !strcmp( pServer->pServerAddr, pServerAddr ) )
        {
            break;
        }
        
        pServer = pServer->pNext;
    }

    /* Create */
    if( NULL == pServer )
    {
        pServer = createServerNode( pServerAddr );
    }
    
    return pServer;
}


static SERVER *createServerNode( const char *pServerAddr )
{
    SERVER *pServer = calloc( sizeof(*pServer), 1 );

    if( NULL != pServer )
    {
        /* alloc mem for string */
        pServer->pServerAddr = malloc( strlen(pServerAddr)+1 );
        if( NULL != pServer->pServerAddr )
        {
            strcpy( pServer->pServerAddr, pServerAddr );
        }
        else
        {
            free( pServer );
            pServer = NULL;
        }
    }

    /* Add to list */
    if( pServer )
    {
        pServer->pNext = pServerList;
        pServerList = pServer;
    }
    
    return pServer;
}

static void setServerStatusResp( SERVER *pServer, const char *pStatusResp )
{
    if( NULL != pServer->pStatusResp )
    {
        free( pServer->pStatusResp );
        pServer->pStatusResp = NULL;
    }

    pServer->pStatusResp = malloc( strlen(pStatusResp)+1 );
    if( NULL != pServer->pStatusResp )
    {
        strcpy( pServer->pStatusResp, pStatusResp );
    }
}

static void setServerIPAndPort( SERVER *pServer, const char *pServerIP, unsigned long ulServerPort )
{
    if( NULL != pServer->pServerIP )
    {
        free( pServer->pServerIP );
        pServer->pServerIP = NULL;
    }

    pServer->pServerIP = malloc( strlen(pServerIP)+1 );
    if( NULL != pServer->pServerIP )
    {
        strcpy( pServer->pServerIP, pServerIP );
    }

    pServer->ulServerPort = ulServerPort;
}

void printServerInfo( const SERVER *pServer )
{
    if( pServer )
    {
        char aPing[50] = "";

        itoa( pServer->ulPing, aPing, 10 );
        
        inf_printf( "%s (%s:%u) %sms\n%s",
                    (pServer->pServerAddr)?pServer->pServerAddr:"<NULL>",
                    (pServer->pServerIP)?pServer->pServerIP:"<NULL>",
                    pServer->ulServerPort,
                    (NO_PING != pServer->ulPing)?aPing:"<NONE>",
                    (pServer->pStatusResp)?pServer->pStatusResp:"<NULL>\n" );
    }
}

static void clearServerInfo( SERVER *pServer )
{
    if( NULL != pServer->pStatusResp )
    {
        free( pServer->pStatusResp );
        pServer->pStatusResp = NULL;
    }

    if( NULL != pServer->pServerIP )
    {
        free( pServer->pServerIP );
        pServer->pServerIP = NULL;
    }

    pServer->ulPing = NO_PING;
}


int __stdcall DLLMain(void *a, unsigned long b, void *c)
{
    return 1;
}


/*
**
** PING SERVER
**
** Return 1 if succesfull
**        0 if failure
**
*/
int _stdcall VB_pingQ2ServerInfo( const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = pingQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);
    
    return fCont;
}


int _stdcall VB_getQ2ServerInfo_Addr( LPSTR pDest, long dest_len, const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = getQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);

    if( fCont )
    {
        if( pServer->pServerAddr )
            strncpy( pDest, pServer->pServerAddr, dest_len );
        else
            strncpy( pDest, "", dest_len );
    }
    
    return fCont;
}

int _stdcall VB_getQ2ServerInfo_IP( LPSTR pDest, long dest_len, const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = getQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);

    if( fCont )
    {
        if( pServer->pServerIP )
            strncpy( pDest, pServer->pServerIP, dest_len );
        else
            strncpy( pDest, "", dest_len );
    }

    return fCont;
}

int _stdcall VB_getQ2ServerInfo_Port( long *pDest, const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = getQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);

    if( fCont )
    {
        *pDest = pServer->ulServerPort;
    }

    return fCont;
}

int _stdcall VB_getQ2ServerInfo_Ping( long *pDest, const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = getQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);

    if( fCont )
    {
        *pDest = pServer->ulPing;
    }

    return fCont;
}

int _stdcall VB_getQ2ServerInfo_Resp( LPSTR pDest, long dest_len, const char *pServerAddress )
{
    const SERVER *pServer = NULL;
    int     fCont = 1;

    pServer = getQ2ServerInfo( pServerAddress );
    fCont   = (NULL != pServer);

    if( fCont )
    {
        if( pServer->pStatusResp )
            strncpy( pDest, pServer->pStatusResp, dest_len );
        else
            strncpy( pDest, "", dest_len );
    }

    return fCont;
}

/* end of file */
