/*
**
**
** Server Information Routines
**
**
**
**
** $Id$
**
*/


/*
**
** defines
**
*/

#define NO_PING -1

/*
**
** typedefs
**
*/

typedef struct
{
    struct cvar_tag    *pNext;
    char               *pName;
    char               *pString;
} C_VAR;

typedef struct player_tag
{
    struct player_tag  *pNext;
    char               *pName;
    unsigned int        frags;
    unsigned int        ping;
} PLAYER;

typedef struct server_tag
{
    struct server_tag  *pNext;

    char               *pServerAddr;    /* Server [and port] */
    char               *pServerIP;      /* Server IP */
    unsigned long       ulServerPort;   /* Server port */
    
    unsigned long       ulPing;         /* Average of pings     */

    char               *pStatusResp;    /* "status"  response string */
} SERVER;


/*
**
** prototypes
**
*/


extern const SERVER *getQ2ServerInfo( const char *pServerAddress );
extern const SERVER *pingQ2ServerInfo( const char *pServerAddress );

extern void printServerInfo( const SERVER *pServer );

