/*
**
**
** Output received log entries
**
**
**
**
** $Id: recvlog.c 1.1 1999/04/02 17:12:29 mdavies Exp $
**
*/

#include <winsock.h>
#include <stdio.h>

#include <sl_packet.h>

/******************************************************************************
**
**	DEFINES
**
******************************************************************************/

/******************************************************************************
**
**	Typedefs
**
******************************************************************************/


/*
**
** defines & macros
**
*/

#define RCV_TIMEOUT_SEC 10
//#define SET_RECVTIMEOUT

//#define SET_ACCEPT_CONN

#define MAX_ERRORS      2

#define PRINT_ERRORS
//#define PRINT_VERBOSE
#define BIND_SOC

#ifdef WIN32
#pragma warning( disable : 4002 )
#endif

#if defined(_DEBUG) && defined(PRINT_VERBOSE)
#define dbg_printf printf
#else
#define dbg_printf() 
#endif

#if defined(_DEBUG) && defined(PRINT_ERRORS)
#define err_printf printf
#else
#define err_printf() 
#endif

#define inf_printf printf

#define K(x) (x *1024)

/*
**
** Private Data
**
*/

/*
** Private Function Definitsions
*/

static void disp_err(void);
static void disp_err_num(int err);
static unsigned long atoaddr(char *address);


/*
**
** Public Functions
**
*/


const int main( int argc, char *argv[] )
{
    SOCKET             socQuake2   = INVALID_SOCKET;
    SOCKET             socAcc      = INVALID_SOCKET;
    SOCKET             socRx       = INVALID_SOCKET;
    struct sockaddr_in myaddr      = {0};
    unsigned short     portnum     = 27910;
    FILE              *fpFile      = NULL;
    int                fCont       = 1;
    int                fUDP        = 1;
    int                fInfo       = 0;
    int                arg         = 1;
    const char        *pFilename   = NULL;
    SOCKADDR_IN        ServerAddress;
    int                addrlen = sizeof(ServerAddress);
#ifdef WIN32
    WORD               wVersionRequested = 0;
#endif

    /* Sort out arguments */
    while( arg < argc )
    {
        if( '/' == argv[arg][0] )         /* Port Definition ? */
        {
            switch( argv[arg][1] )
            {
                default:
                {
                    fprintf( stderr, "Warning: Unknown switch /%c\n", argv[arg][1] );
                } /* fallthrough */
                case '?':
                case 'h':
                {
                    fprintf( stderr, "Usage: RecvLog [:port] [UDP/TCP] [INFO] [filename] [/{?,h}]\n" );
                    return 1;
                }                    
            }
        }
        else if( ':' == argv[arg][0] )         /* Port Definition ? */
        {
            /* Get port number */
            portnum = atoi( &argv[arg][1] );
        }
        else if( !strcmp( argv[arg], "UDP" ) ) /* UDP Connection ? */
        {
            fUDP = 1;
        }
        else if( !strcmp( argv[arg], "TCP" ) ) /* TCP Connection ? */
        {
            fUDP = 0;
        }
        else if( !strcmp( argv[arg], "INFO" ) ) /* Display Info ? */
        {
            fInfo = 1;
        }
        else
        {
            /* File name */
            if( pFilename )
            {
                fprintf( stderr, "Warning: Filename redefinition\n" );
            }

            pFilename = argv[arg];
        }

        arg++;                          /* next argument */
    }
    
    if( pFilename )
    {
        fpFile = fopen( pFilename, "wt" );
        if( NULL == fpFile )
        {
            fprintf( stderr, "Unable to open file %s\n", pFilename );
        }
    }

    if( fCont && fInfo )
    {
        printf( "Using Port %d\n", portnum );

        if( fpFile )
            printf( "Logging to file %s\n", pFilename );
    }
    
#ifdef WIN32
    if( fCont )
    {
        WSADATA wsaData;
        int err;

        wVersionRequested = MAKEWORD( 2, 0 );

        err = WSAStartup( wVersionRequested, &wsaData );
        if ( err != 0 ) {
            /* Tell the user that we couldn't find a usable */
            /* WinSock DLL.                                  */
            err_printf("WSAStartup().\n");
            disp_err();
            fCont = 0;
        }

        /* Confirm that the WinSock DLL supports 2.0.*/
        /* Note that if the DLL supports versions greater    */
        /* than 2.0 in addition to 2.0, it will still return */
        /* 2.0 in wVersion since that is the version we      */
        /* requested.                                        */

        if( fCont )
        {
            dbg_printf("WinSock DLL Version %#.4lx.\n", wsaData.wVersion);
#ifdef CHECK_WINSOCK_VERSION
            if ( LOBYTE( wsaData.wVersion ) != 2 ||
                 HIBYTE( wsaData.wVersion ) != 0 )
            {
                /* Tell the user that we couldn't find a usable */
                /* WinSock DLL.                                  */
                err_printf("Wrong Version %#.4lx.\n", wsaData.wVersion);
                fCont = 0;
            }
#endif
        }
    }
#endif


    /* Create Socket */
    if( fCont )
    {
        if( fUDP )
            socQuake2 = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        else
            socQuake2 = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
            
        if (socQuake2 == INVALID_SOCKET)
        {
            err_printf("socket() failed.\n");
            disp_err();
            fCont = 0;
        }
    }

    /* Set receive timeout */
#ifdef SET_RECVTIMEOUT
    if( fCont )
    {
        int rcvTimeout = RCV_TIMEOUT_SEC * 1000;
        
        if( setsockopt(socQuake2, SOL_SOCKET, SO_RCVTIMEO,
                       (const char*) &rcvTimeout, sizeof(rcvTimeout)) )
        {

            err_printf("setsockopt(SO_RCVTIMEO) failed.\n");
            disp_err();
            fCont = 0;
        }
    }
#endif

    /* Set linger */
#ifdef SET_LINGER
    if( fCont )
    {
        BOOL fLinger = TRUE;

        if( setsockopt(socQuake2, SOL_SOCKET, SO_DONTLINGER,
                       (const char*) &fLinger, sizeof(fLinger)) )
        {

            err_printf("setsockopt(SO_DONTLINGER) failed.\n");
            disp_err();
            fCont = 0;
        }
    }
#endif

        /* Set Accept Connection */
#ifdef SET_ACCEPT_CONN
    if( fCont && !fUDP)
    {
        BOOL fAccept = TRUE;

        if( setsockopt(socQuake2, IPPROTO_TCP, SO_ACCEPTCONN,
                       (const char*) &fAccept, sizeof(fAccept)) )
        {

            err_printf("setsockopt(SO_ACCEPTCONN) failed.\n");
            disp_err();
            fCont = 0;
        }
    }
#endif

    /* Bind Socket */
#ifdef BIND_SOC
    if( fCont )
    {
        myaddr.sin_family = AF_INET;
        myaddr.sin_addr.s_addr = INADDR_ANY;
        myaddr.sin_port   = htons(portnum);

        dbg_printf("bind(%d)\n", ntohs(myaddr.sin_port) );
        if( bind(socQuake2, (struct sockaddr *) &myaddr, sizeof(SOCKADDR_IN)) )
        {
            err_printf("bind() failed.\n");
            disp_err();
            return 0;
        }
    }
#endif


    /* Setup socket destination */
#ifdef SET_SOC_DEST
    if( fCont )
    {
        struct sockaddr_in serAddr = {0};
        int                addrlen = sizeof(serAddr);

        serAddr.sin_family      = AF_INET;
        serAddr.sin_addr.s_addr = atoaddr(pServerAddr);
        serAddr.sin_port        = htons((u_short)portnum);

        dbg_printf( "I.P. %s [%s], Port %d\n",
                    pServerAddr,
                    inet_ntoa(serAddr.sin_addr),
                    portnum );
        
        if (connect(socQuake2,(struct sockaddr *)&serAddr, sizeof(serAddr))< 0)
        {
            err_printf("connect() failed.\n");
            disp_err();
        }
    }
#endif

    /* Output Message */
    if( fCont )
    {
        struct sockaddr_in serAddr = {0};
        int namelen = sizeof(serAddr);

        getsockname( socQuake2, (struct sockaddr *)&serAddr, &namelen );
        
        inf_printf( "Using Port %d\n", ntohs(serAddr.sin_port) );
    }

    /* wait for connection */
    while( fCont )
    {
        if( !fUDP )
        {
            if( SOCKET_ERROR == listen( socQuake2, 1 ) )
            {
                err_printf("listen() failed.\n");
                disp_err();
                fCont = 0;
            }
            else
            {
                socAcc = accept( socQuake2,
                                 (struct sockaddr *) &ServerAddress,
                                 &addrlen );
                socRx = socAcc;

                if( INVALID_SOCKET == socAcc )
                {
                    err_printf("accept() failed.\n");
                    disp_err();
                    fCont = 0;
                }
            }
        }
        else
        {
            socRx = socQuake2;
        }

        /* wait for log packet */
        while( fCont && (INVALID_SOCKET != socRx) )
        {
            char            aPacket [K(4)] = {0};	// Don't know the real MTU; seems like enough.
            char           *pPacket = &aPacket[0];
            int             nRead;

            dbg_printf( "\nCalling recvfrom()\n" );
            nRead = recvfrom( socRx,
                              pPacket,
                              sizeof(aPacket),
                              0,
                              (struct sockaddr *) &ServerAddress,
                              &addrlen);


            if (nRead == SOCKET_ERROR)
            {
                err_printf("recvfrom() failed.\n");
                disp_err();
                /*fCont = 0;*/
                /* May need to wait a bit before we can do
                 ** another recvfrom() */
            }
            else if ( nRead > 0 )
            {
                if( fUDP )
                {
                    PACKET_STRUCT *pPacketStruct = NULL;
                    int retCode;

                    /* Parse response */
                    retCode = sl_DeconstructPacketBytes( &pPacketStruct,
                        (PACKET_BYTES*)pPacket,
                        nRead,
                        SL_FLAGS_NONE );
                    if(  SL_ERROR_NONE == retCode )
                    {
                        unsigned int i;
                        
                        inf_printf( "-------------------------\n%s [%#lx]\nSERVER INFO\n%s\nLOG\n%sCLIENTS\n",
                                    inet_ntoa(ServerAddress.sin_addr),
                                    pPacketStruct->nPacket,
                                    pPacketStruct->pServerInfo,
                                    pPacketStruct->pLogString );

                        i=0;
                        while(i < pPacketStruct->nClients)
                            inf_printf( "%s", pPacketStruct->ppClientInfo[i++] );

                        if( fpFile )
                        {
                            fprintf( fpFile,
                                     "-------------------------\n%s [%#lx]\nSERVER INFO\n%s\nLOG\n%sCLIENTS\n",
                                     inet_ntoa(ServerAddress.sin_addr),
                                     pPacketStruct->nPacket,
                                     pPacketStruct->pServerInfo,
                                     pPacketStruct->pLogString );

                            i=0;
                            while(i < pPacketStruct->nClients)
                                fprintf( fpFile, "%s", pPacketStruct->ppClientInfo[i++] );

                            fflush( fpFile );
                        }

                    }
                    else
                    {
                        err_printf("Bad Packet (%#lx).\n", retCode);
                    }
                }
                else
                {
                    inf_printf( "%s : %s",
                                inet_ntoa(ServerAddress.sin_addr),
                                pPacket );

                    if( fpFile )
                    {
                        fprintf( fpFile,
                                 "%s : %s",
                                 inet_ntoa(ServerAddress.sin_addr),
                                 pPacket );
                        fflush( fpFile );
                    }
                }
            }
            else
            {
                /* Connection closed */
                err_printf("connection closed.\n");
                socRx = INVALID_SOCKET;
            }
        }


        /* Close TCP connection */
        if ( 0 && INVALID_SOCKET != socAcc)
        {
            closesocket( socAcc );
            socAcc = INVALID_SOCKET;
        }
    }
    
    /* Cleanup */
    if ( INVALID_SOCKET != socQuake2)
    {
        closesocket( socQuake2 );
        socQuake2 = INVALID_SOCKET;
    }
    

#ifdef WIN32
    if( 0 != wVersionRequested )
    {
        WSACleanup();
        wVersionRequested = 0;
    }
#endif

    return 0;
} /* end of getQ2ServerInfo() */















/*
**
** Private Functions
**
*/



struct socErrs
{
    int    err;
    char  *pString;
};

static const struct socErrs aScocketErrors[] =
{
    { WSAEACCES,          "WSAEACCES" },
    { WSAEADDRINUSE,      "WSAEADDRINUSE" },
    { WSAEADDRNOTAVAIL,   "WSAEADDRNOTAVAIL" },
    { WSAEAFNOSUPPORT,    "WSAEAFNOSUPPORT" },
    { WSAEALREADY,        "WSAEALREADY" },
    { WSAECONNREFUSED,    "WSAECONNREFUSED" },
    { WSAEFAULT,          "WSAEFAULT" },
    { WSAEINPROGRESS,     "WSAEINPROGRESS" },
    { WSAEINTR,           "WSAEINTR" },
    { WSAEINVAL,          "WSAEINVAL" },
    { WSAEISCONN,         "WSAEISCONN" },
    { WSAEMFILE,          "WSAEMFILE" },
    { WSAENETDOWN,        "WSAENETDOWN" },
    { WSAENETUNREACH,     "WSAENETUNREACH" },
    { WSAENOBUFS,         "WSAENOBUFS" },
    { WSAENOTSOCK,        "WSAENOTSOCK" },
    { WSAEPROTONOSUPPORT, "WSAEPROTONOSUPPORT" },
    { WSAEPROTOTYPE,      "WSAEPROTOTYPE" },
    { WSAESOCKTNOSUPPORT, "WSAESOCKTNOSUPPORT" },
    { WSAETIMEDOUT,       "WSAETIMEDOUT" },
    { WSAEWOULDBLOCK,     "WSAEWOULDBLOCK" },
    { WSANOTINITIALISED,  "WSANOTINITIALISED" },

    { WSAEINTR,             "WSAEINTR" },
    { WSAEBADF,             "WSAEBADF" },
    { WSAEACCES,            "WSAEACCES" },
    { WSAEFAULT,            "WSAEFAULT" },
    { WSAEINVAL,            "WSAEINVAL" },
    { WSAEMFILE,            "WSAEMFILE" },
    { WSAEWOULDBLOCK,       "WSAEWOULDBLOCK" },
    { WSAEINPROGRESS,       "WSAEINPROGRESS" },
    { WSAEALREADY,          "WSAEALREADY" },
    { WSAENOTSOCK,          "WSAENOTSOCK" },
    { WSAEDESTADDRREQ,      "WSAEDESTADDRREQ" },
    { WSAEMSGSIZE,          "WSAEMSGSIZE" },
    { WSAEPROTOTYPE,        "WSAEPROTOTYPE" },
    { WSAENOPROTOOPT,       "WSAENOPROTOOPT" },
    { WSAEPROTONOSUPPORT,   "WSAEPROTONOSUPPORT" },
    { WSAESOCKTNOSUPPORT,   "WSAESOCKTNOSUPPORT" },
    { WSAEOPNOTSUPP,        "WSAEOPNOTSUPP" },
    { WSAEPFNOSUPPORT,      "WSAEPFNOSUPPORT" },
    { WSAEAFNOSUPPORT,      "WSAEAFNOSUPPORT" },
    { WSAEADDRINUSE,        "WSAEADDRINUSE" },
    { WSAEADDRNOTAVAIL,     "WSAEADDRNOTAVAIL" },
    { WSAENETDOWN,          "WSAENETDOWN" },
    { WSAENETUNREACH,       "WSAENETUNREACH" },
    { WSAENETRESET,         "WSAENETRESET" },
    { WSAECONNABORTED,      "WSAECONNABORTED" },
    { WSAECONNRESET,        "WSAECONNRESET" },
    { WSAENOBUFS,           "WSAENOBUFS" },
    { WSAEISCONN,           "WSAEISCONN" },
    { WSAENOTCONN,          "WSAENOTCONN" },
    { WSAESHUTDOWN,         "WSAESHUTDOWN" },
    { WSAETOOMANYREFS,      "WSAETOOMANYREFS" },
    { WSAETIMEDOUT,         "WSAETIMEDOUT" },
    { WSAECONNREFUSED,      "WSAECONNREFUSED" },
    { WSAELOOP,             "WSAELOOP" },
    { WSAENAMETOOLONG,      "WSAENAMETOOLONG" },
    { WSAEHOSTDOWN,         "WSAEHOSTDOWN" },
    { WSAEHOSTUNREACH,      "WSAEHOSTUNREACH" },
    { WSAENOTEMPTY,         "WSAENOTEMPTY" },
    { WSAEPROCLIM,          "WSAEPROCLIM" },
    { WSAEUSERS,            "WSAEUSERS" },
    { WSAEDQUOT,            "WSAEDQUOT" },
    { WSAESTALE,            "WSAESTALE" },
    { WSAEREMOTE,           "WSAEREMOTE" },
    { WSAEDISCON,           "WSAEDISCON" },

    { SOCKET_ERROR,         "SOCKET_ERROR" },
    
    { 0, NULL }
};


static void disp_err(void)
{
    int                   err;

    err = WSAGetLastError ();
    disp_err_num( err );
}

static void disp_err_num(int err)
{
    const struct socErrs *a = aScocketErrors;

    while( a->pString && (a->err != err) )
        a++;

    if( a->pString )
        err_printf("%s.\n", a->pString);
    else
        err_printf("<unknown error> [%#lx].\n", err);
}


/* Converts ascii text to in_addr struct.  NULL is returned if the
address can not be found. */
static unsigned long atoaddr(char *address)
{
    struct hostent *host;
    struct in_addr saddr;

    /* First try it as aaa.bbb.ccc.ddd. */
    saddr.s_addr = inet_addr(address);
    if (saddr.s_addr != -1) {
        return saddr.s_addr;
    }
    host = gethostbyname(address);
    if (host != NULL) {
        return ((struct in_addr *) *host->h_addr_list)->s_addr;
    }
    return 0L;
}



/* end of file */
