/******************************************************************************
**
**	Standard Logging functions - Packet Functions
**
**
**	$Id: stdlog.c 1.6 1998/08/29 13:51:57 mdavies Exp mdavies $
**
******************************************************************************/

#ifndef __SL_PACKET_H__
#define __SL_PACKET_H__


#define __SL_PACKET_ID__ "$Id: stdlog.h 1.8 1998/08/29 13:52:24 mdavies Exp mdavies $"

/******************************************************************************
**
**	DEFINES
**
******************************************************************************/

#define SL_ERROR_NONE        0
#define SL_ERROR_NOMEM      -1
#define SL_ERROR_BADPACKET  -2

#define SL_FLAGS_NONE        0
#define SL_FLAGS_COMPRESS    (1<<0)


/******************************************************************************
**
**	Typedefs
**
******************************************************************************/

typedef unsigned long DWORD;
typedef unsigned char BYTE;

typedef struct
{
    DWORD   nPacket;
    DWORD   nClients;
    char   *pServerInfo;
    char   *pLogString;
    char  **ppClientInfo;               /* NULL terminated Array of strings pointers */
} PACKET_STRUCT;

typedef unsigned char   PACKET_BYTES;



extern int sl_ConstructPacketBytes( PACKET_BYTES  **ppPacketBytes,
                                    unsigned long  *pPacketBytesLength,
                                    PACKET_STRUCT  *pPacketStruct,
                                    unsigned long   ulFlags );

extern void sl_DestroyPacketBytes( PACKET_BYTES  *pPacketBytes,
                                   unsigned long  ulPacketBytesLength );


extern int sl_DeconstructPacketBytes( PACKET_STRUCT **ppPacketStruct,
                                      PACKET_BYTES   *pPacketBytes,
                                      unsigned long   ulPacketBytesLength,
                                      unsigned long   ulFlags );

#endif /* __SL_PACKET_H__ */

/* end of file */
