/*
 *  GibStats Logging functions
 *
 *
 * $Id: stdlog.h 1.4 1998/03/14 13:19:09 mdavies Exp mdavies $
 */

#ifndef __STDLOG_H__
#define __STDLOG_H__

// #include "g_local.h"

#define _USE_LOGGING_
#ifdef _USE_LOGGING_

#define __STDLOG_ID__ "$Id: stdlog.h 1.4 1998/03/14 13:19:09 mdavies Exp $"

/*
 *   NEW API
 *
 */

extern int  sl_OpenLogFile( game_import_t  *gi );
extern void sl_CloseLogFile( void );
extern void sl_LogVers( game_import_t  *gi );

extern void sl_LogPatch( game_import_t  *gi,
                         char           *pPatchName );

extern void sl_LogDate( game_import_t  *gi );
extern void sl_LogTime( game_import_t  *gi );

extern void sl_LogDeathFlags( game_import_t  *gi,
                              unsigned long   dmFlags);

extern void sl_LogMapName( game_import_t  *gi,
                           char           *pMapName );

extern void sl_LogPlayerName( game_import_t  *gi,
                              char           *pPlayerName,
                              char           *pTeamName,
                              int             iTimeInSeconds );

extern void sl_LogScore( game_import_t  *gi,
                         char           *pKillerName,
                         char           *pTargetName,
                         char           *pScoreType,
                         char           *pWeaponName,
                         int             iScore,
                         int             iTimeInSeconds );

extern void sl_LogPlayerLeft( game_import_t  *gi,
                              char           *pPlayerName,
                              int             iTimeInSeconds );

extern void sl_LogGameStart( game_import_t  *gi,
                             int            iTimeInSeconds );

extern void sl_LogGameEnd( game_import_t  *gi,
                           int            iTimeInSeconds );

extern void sl_LogPlayerConnect( game_import_t  *gi,
                                 char           *pPlayerName,
                                 char           *pTeamName,
                                 int             iTimeInSeconds);

extern void sl_LogPlayerTeamChange( game_import_t  *gi,
                                    char           *pPlayerName,
                                    char           *pTeamName,
                                    int             iTimeInSeconds);

extern void sl_LogPlayerRename( game_import_t  *gi,
                                char           *pOldPlayerName,
                                char           *pNewPlayerName,
                                int             iTimeInSeconds);



/*
 *   OLD API
 *
 */

extern int  sl_Logging( game_import_t  *gi,
                        char           *pPatchName );

extern void sl_GameStart( game_import_t    *gi,
                          level_locals_t    level );

extern void sl_GameEnd( game_import_t      *gi,
                        level_locals_t      level );

extern void sl_WriteStdLogDeath( game_import_t     *gi,
                                 level_locals_t     level,
                                 edict_t           *self,
                                 edict_t           *inflictor,
                                 edict_t           *attacker );

extern void sl_WriteStdLogPlayerEntered( game_import_t     *gi,
                                         level_locals_t     level,
                                         edict_t           *ent );

extern void sl_LogPlayerDisconnect( game_import_t      *gi,
                                    level_locals_t      level,
                                    edict_t            *ent );

#else
#define sl_Logging( gi, pPatchName )
#define sl_GameStart( gi, level )
#define sl_GameEnd( gi, level )
#define sl_WriteStdLogDeath( gi, level, self, inflictor, attacker )
#define sl_WriteStdLogPlayerEntered( gi, level, ent )
#define sl_LogPlayerDisconnect( gi, level, ent )
#endif

#endif

/* end of file */