/*
======================================
Skeleton MCI Interface class
	
	  
Wed, May26th, 1999
Gaz "Skid" Iqbal
skid@planetquake.com
======================================
*/


#include "gmci.h"

enum mid_state
{
	OPENING,
	INACTIVE,
	PLAYING,
	PAUSED,
	STOPPED
};

mid_state midstate;

unsigned int unpausePos;
MCIDEVICEID mciDevice =0;

/*
======================================
Init -
starts up the sequencer

======================================
*/
bool CMidi::Init()
{
	midstate = OPENING;
	return true;
}

/*
======================================
Shutdown
======================================
*/
bool CMidi::Shutdown()
{
	DWORD err;

	if(midstate != OPENING)
	{
		Stop();
		if(err = mciSendCommand(mciDevice, MCI_CLOSE, MCI_NOTIFY, NULL))
		{
			dprintf("CMidi::Shutdown - error closing sequencer\n");
			Error(err);
			return false;
		}
		midstate = OPENING;
	}
	dprintf("CMidi::Shutdown Ok\n");
    return true;
}


/*
======================================
Play
======================================
*/
bool CMidi::Play(char *filename)
{
    DWORD dwReturn;
    MCI_PLAY_PARMS mciPlayParms;
	char midifilename[_MAX_PATH];

	strcpy(midifilename,searchdir);
	strcat(midifilename,"\\");
	strcat(midifilename,filename);

	if((midstate == PLAYING) || (midstate == PAUSED))
	{
		if(!Shutdown())
		{
			dprintf("CMidi::Play - unable to stop playback\n");
			return false;
		}
	}


		MCI_OPEN_PARMS mciOpenParms;
		
		// Open the device by specifying the device and filename.
		// MCI will attempt to choose the MIDI mapper as the output port.
		mciOpenParms.lpstrDeviceType = "sequencer";
		mciOpenParms.lpstrAlias = "genmidi";
		mciOpenParms.lpstrElementName = midifilename;
		if (dwReturn = mciSendCommand(NULL, MCI_OPEN,
			MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
			(DWORD)(LPVOID) &mciOpenParms))
		{
			// Failed to open device. Don't close it; just return error.
			dprintf("CMidi::Play - unable to open sequencer\n");
			Error(dwReturn);
			return false;
		}

		// The device opened successfully; get the device ID.
		mciDevice = mciOpenParms.wDeviceID;


    // Begin playback. The window procedure function for the parent 
    // window will be notified with an MM_MCINOTIFY message when 
    // playback is complete. At this time, the window procedure closes 
    // the device.
    mciPlayParms.dwCallback = (DWORD) g_hWnd;
    if (dwReturn = mciSendCommand(mciDevice, MCI_PLAY, MCI_NOTIFY, 
        (DWORD)&mciPlayParms))
    {
        mciSendCommand(mciDevice, MCI_CLOSE, 0, NULL);
        dprintf("CMidi::Play - unable to play %s\n",midifilename);
		Error(dwReturn);
    }
	midstate = PLAYING;
	return true;
}

/*
======================================
Resume
======================================
*/
bool CMidi::Resume()
{
	if(midstate != PAUSED)
	{
		dprintf("CMidi::Resume() - sequencer was not paused\n");
		return false;
	}
	
	MCI_SET_PARMS setParms;
	MCI_PLAY_PARMS playParms;
	DWORD	error;

	setParms.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
	if(error = mciSendCommand(mciDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&setParms))
	{
		dprintf("CMidi::Resume - unable to set Time Format\n");
		Error(error);
		return false;
	}
	
	playParms.dwCallback = (DWORD)g_hWnd;
	playParms.dwTo = 0;
	playParms.dwFrom = unpausePos;
	if(error = mciSendCommand(mciDevice, MCI_PLAY, (MCI_NOTIFY|MCI_FROM), (DWORD)&playParms))
	{
		dprintf("CMidi::Resume - unable to resume playback\n");
		Error(error);
		return false;
	}
	midstate = PLAYING;
	return true;
}


/*
======================================
Pause
======================================
*/
bool CMidi::Pause()
{
	if(midstate != PLAYING)
	{
		dprintf("CMidi::Pause() - were not playing\n");
		return false;
	}
	MCI_SET_PARMS setParms;
	MCI_STATUS_PARMS statusParms;
	DWORD	error;

	setParms.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
	if(error = mciSendCommand(mciDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&setParms))
	{
		dprintf("CMidi::Pause - unable to set Time Format\n");
		Error(error);
		return false;
	}

	statusParms.dwCallback = (DWORD)g_hWnd;
	statusParms.dwItem = MCI_STATUS_POSITION;
	if(error = mciSendCommand(mciDevice, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&statusParms))
	{
		dprintf("CMidi::Pause - unable to get current position\n");
		Error(error);
		return false;
	}

	unpausePos = statusParms.dwReturn;
	if(error = mciSendCommand(mciDevice, MCI_STOP, 0, NULL))
	{
		dprintf("CMidi::Pause - error stopping sequencer\n");
		Error(error);
		return false;
	}
	midstate = PAUSED;
	return true;
}

/*
======================================
Stop
======================================
*/
bool CMidi::Stop()
{
	if(midstate != INACTIVE)
	{
		DWORD err;
		if(err = mciSendCommand(mciDevice, MCI_STOP, MCI_WAIT, NULL))
		{
			dprintf("CMidi::Shutdown - error stopping playback\n");
			Error(err);
			return false;
		}
		midstate = INACTIVE;
	}
	return true;
}


/*
======================================
Error
======================================
*/

void CMidi::Error(unsigned int error)
{	
	char ErrorBuf[256];

    if(mciGetErrorString(error, (LPSTR)ErrorBuf, 256))
        dprintf("CMidi:MCI Error - %s\n", ErrorBuf);
    else
		dprintf("CMidi:MCI Error - unknown error\n");
}


/*
======================================
Seek To Start - for looping
======================================
*/

bool CMidi::SeekToStart()
{
	if(midstate == INACTIVE)
	{
		dprintf("CMidi::SeektoStart: Sequencer is inactive\n");
		return false;
	}
	
	DWORD err;
	MCI_SEEK_PARMS seekParms;
	seekParms.dwCallback = 0;
	seekParms.dwTo = 0;

	if(err = mciSendCommand(mciDevice, MCI_SEEK, MCI_SEEK_TO_START, (DWORD) &seekParms))
	{
		dprintf("CMidi::SeektoStart: Failed rewind\n");
		Error(err);
		return false;
	}
//	dprintf("CMidi::SeekToStart - ok\n");
	return true;
}









