/*
======================================
Skeleton DirectMusic Interface class
	
	  
Wed, May26th, 1999
Gaz "Skid" Iqbal
skid@planetquake.com
======================================
*/


#include "gdxmusic.h"

#include <mmsystem.h>
#include <winuser.h>
#include <memory.h>

enum dxm_state
{
	INACTIVE,
	PLAYING,
	PAUSED,
	STOPPED
};

dxm_state dmstate;


IDirectMusicLoader*      CDirectMusic::m_pLoader;
IDirectMusicPerformance* CDirectMusic::m_pPerformance;
IDirectMusicSegment*     CDirectMusic::m_pSegment;
IDirectMusicPort*		 CDirectMusic::m_pPort;
IDirectMusic*			 CDirectMusic::m_pDirect;
IDirectMusicComposer* 	 CDirectMusic::m_pComposer;
IDirectMusicStyle*       CDirectMusic::m_pStyle;
IDirectMusicSegmentState* CDirectMusic::m_pSegstate;

//IDirectSound		*	m_pdSound = 0;	// The global sound object.
//IDirectSoundBuffer  *	m_pdsBuf = 0;	// The global Sound buffer




REFERENCE_TIME			 CDirectMusic::m_refStartTime;
REFERENCE_TIME			 CDirectMusic::m_refOffTime;
MUSIC_TIME				 CDirectMusic::m_musStartTime;
MUSIC_TIME				 CDirectMusic::m_musOffTime;

#define MULTI_TO_WIDE( x,y )	MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, y, -1, x, _MAX_PATH );

/*
=======================================
Constructor
=======================================
*/
CDirectMusic::CDirectMusic()
{
	m_refStartTime = 0;
	m_refOffTime = 0;
	m_musStartTime = 0;
	m_musOffTime = 0;
	dmstate = INACTIVE;
}

/*
=======================================
Destructor
=======================================
*/
CDirectMusic::~CDirectMusic()
{
}



/*
=======================================
Adds a Capable Port
=======================================
*/
HRESULT CDirectMusic::InitPort(DWORD minChannelGroups)
{
	// Create the software synth port.
    // An alternate, easier method is to call
    // pPerf->AddPort(NULL), which automatically
    // creates the synth port, adds it to the
    // performance, and assigns PChannels.
	
	HRESULT			  hr;
	DMUS_PORTPARAMS   dmos;
    GUID              guidSink;

    ZeroMemory( &dmos, sizeof(DMUS_PORTPARAMS) );
    dmos.dwSize = sizeof(DMUS_PORTPARAMS);  
    dmos.dwChannelGroups = minChannelGroups;	// create 1 channel groups on the port
    dmos.dwValidParams = DMUS_PORTPARAMS_CHANNELGROUPS; 

    ZeroMemory( &guidSink, sizeof(GUID) );

    hr = m_pDirect->CreatePort( CLSID_DirectMusicSynth, &dmos, &m_pPort, NULL );
    if ( FAILED(hr) )
	{
		messagebox("CDirectMusic::InitPort:Could not create port");
        return hr;
	}

#if 0
	m_pPort->SetDirectSound(m_pdSound,m_pdsBuf);
	if( FAILED(hr))
	{
		messagebox("CDirectMusic::InitPort::Could not add DS or DSBuffers");
		return hr;
	}
#endif

    hr = m_pDirect->Activate( TRUE );
    if ( FAILED(hr) )
	{
		messagebox("CDirectMusic::InitPort: Could not activate DMusic");
        return hr;
	}

    // Succeeded in creating the port. Add the port to the
    // Performance with five groups of 16 midi channels.
    hr = m_pPerformance->AddPort( m_pPort );
    if ( FAILED(hr) )
	{
		messagebox("CDirectMusic::InitPort:Could not add port"); 
		return hr;
	}

    // Assign a block of 16 PChannels to this port.
    // Block 0, port pPort, and group 1 means to assign
    // PChannels 0-15 to group 1 on port pPort.
    // PChannels 0-15 correspond to the standard 16
    // MIDI channels.
    m_pPerformance->AssignPChannelBlock( 0, m_pPort, 1 );

    // Release the port since the performance now has its own reference.
    m_pPort->Release();

    // release the DirectMusic object. The performance has its
    // own reference and we just needed it to call CreatePort.
    m_pDirect->Release();

    return S_OK;
}



/*
=======================================
Initialize the software synthesizer into the performance.
=======================================
*/

HRESULT CDirectMusic::InitSynth()
{
    HRESULT hr;
	
	// Calling AddPort with NULL automatically initializes the Performance
    // by calling IDirectMusicPerformance.Init(), adds a default
    // port with one channel group, and assigns PChannels 0-15 
    // to the synth port's channel group MChannels 0-15.
    // Please refer to the PlayMotf example for a more flexible, yet slightly
    // more complicated, way of doing this.

#if 0
	HWND	h_wnd;
	h_wnd = FindWindow(NULL,"Quake 2");
	if(h_wnd == NULL)
	{
		h_wnd = GetForegroundWindow();
		if(h_wnd == NULL)
			h_wnd = GetDesktopWindow();
	}

	// Create the DirectSound object.
	hr = CoCreateInstance(CLSID_DirectSound, 0, CLSCTX_ALL,
							  IID_IDirectSound, (void**)&m_pdSound);

	if (FAILED(hr))
	{ 
		dprintf("CDirectMusic::InitSynth: Failed to get DirectSound Interface\n");
		return false; 
	}

	// Initialize the DirectSound object.
	// Defaulting to Primary Sound Driver right now
	hr = m_pdSound->Initialize(0);
	if (FAILED(hr)) 
	{ 
		dprintf("CDirectMusic::InitSynth: Failed Init Directsound\n");
		m_pdSound->Release();
		return false; 
	}

	// Set the cooperative level.
	hr = m_pdSound->SetCooperativeLevel(h_wnd,DSSCL_PRIORITY);//DSSCL_PRIORITY
	if (FAILED(hr)) 
	{ 
		dprintf("CDirectMusic::InitSynth: Failed SetCoopLevel\n");
		m_pdSound->Release();
		return false; 
	}

	//Create the Sound buffer
	DSBUFFERDESC dsBufDesc;
	
//	WAVEFORMATEX waveFmt;
//	memset(&waveFmt, 0, sizeof(WAVEFORMATEX));
//	waveFmt.wFormatTag = WAVE_FORMAT_PCM;
	//waveFmt.nSamplesPerSec = 22050;
	//waveFmt.wBitsPerSample = bitDepth;
	//waveFmt.nChannels = 1;
	//waveFmt.nBlockAlign = (channels*bitDepth)>>3;
	//waveFmt.nAvgBytesPerSec = sampleRate*waveFmt.nBlockAlign;

	memset(&dsBufDesc, 0, sizeof(DSBUFFERDESC));
	dsBufDesc.dwSize = sizeof(DSBUFFERDESC);
	dsBufDesc.dwFlags = DSBCAPS_CTRLDEFAULT |DSBCAPS_STATIC | DSBCAPS_GLOBALFOCUS |DSBCAPS_STICKYFOCUS ;
	dsBufDesc.dwBufferBytes = 0;
	dsBufDesc.lpwfxFormat = NULL;

	hr = m_pdSound->CreateSoundBuffer(&dsBufDesc, &m_pdsBuf, 0);
	if (FAILED(hr)) 
	{ 
		dprintf("CDirectMusic::InitSynth: Failed to create DSBuffer\n");
//		m_pdsBuf = 0;
//		m_pdSound->Release();
//		return false; 
	}
#endif


	hr = m_pPerformance->Init(&m_pDirect,0,g_hWnd); 
		//m_pPerformance->Init(&m_pDirect,m_pdSound,h_wnd); 
    if ( FAILED(hr) )
    {
		messagebox("CDirectMusic::InitSynth: Could not initialize performance");
        return hr;
	}
    
	// Set autodownloading to be on.  This will cause DLS instruments to be downloaded
	// whenever a segment is played, and unloaded whenever it stops.  Please see the
	// DirectMusic documentation for more information.
	
	BOOL fAutoDownload = TRUE;
	m_pPerformance->SetGlobalParam(GUID_PerfAutoDownload,&fAutoDownload,sizeof(BOOL));

	//m_pPerformance->AddPort(0);
	hr= InitPort(1);

    if( FAILED(hr) )
	{
		messagebox("CDirectMusic::InitSynth: Could not add port to performance");
		return hr;
	}

    return S_OK;
}


/*
=======================================
Init System
=======================================
*/
bool CDirectMusic::Init(char *gamepath)
{
	HRESULT hr;
	WCHAR           wszDir[_MAX_PATH];

	//COM library
	hr = CoInitialize(NULL);
    if ( FAILED(hr) )
    {
		messagebox("CDirectMusic::Init: Could not initialize COM");
		CoUninitialize();
        return false;
	}

		// Create loader object
    hr = CoCreateInstance( CLSID_DirectMusicLoader, NULL, CLSCTX_INPROC, 
                           IID_IDirectMusicLoader, (void**)&m_pLoader );
    if ( FAILED(hr) )
    {
		messagebox("CDirectMusic::Init: Couldnt create loader object");
		CoUninitialize();
        return false;
	}
	
	// Change the loader's current search directory 
	MULTI_TO_WIDE( wszDir, gamepath);
    m_pLoader->SetSearchDirectory( GUID_DirectMusicAllTypes, wszDir, FALSE );
	m_pLoader->EnableCache(GUID_DirectMusicAllTypes, true);

	
	hr = CoCreateInstance(CLSID_DirectMusicComposer, NULL, CLSCTX_INPROC,
						  IID_IDirectMusicComposer, (void**)(&m_pComposer));
	if (FAILED(hr)) 
	{
		messagebox("CDirectMusic::Init: Couldnt create composer object");
		m_pLoader->Release();
		m_pComposer->Release();
		CoUninitialize();
		return false;
	}

	// Create performance object
    hr = CoCreateInstance( CLSID_DirectMusicPerformance, 
							NULL, 
							CLSCTX_INPROC, 
                           IID_IDirectMusicPerformance, (void**)&m_pPerformance );
    if ( FAILED(hr) )
    {
		messagebox("CDirectMusic::Init: Couldnt create performance object");
		m_pPerformance->Release();
		m_pLoader->Release();
		m_pComposer->Release();
		CoUninitialize();
        return false;
	}

	hr = InitSynth();
    if ( FAILED(hr) )
    {  
		m_pPerformance->Release();
		m_pLoader->Release();
		m_pComposer->Release();
		CoUninitialize();
		dprintf("CDirectMusic:: FAILED INIT SYNTH\n");
		return false;
	}

	dmstate = STOPPED;
//	dprintf("CDirectMusic::Init OK\n");
	return true;
}

/*
=======================================
Shutdown
=======================================
*/
void CDirectMusic::Shutdown()
{
	// If there is any music playing, stop it.
	if(m_pPerformance)
	{
		m_pPerformance->Stop( NULL, NULL, 0, 0 );

    // CloseDown and Release the performance object
		m_pPerformance->CloseDown();
		m_pPerformance->Release();
	}

    // Release the loader object
	if(m_pLoader)
	{
		m_pLoader->ClearCache(GUID_DirectMusicAllTypes);
		m_pLoader->Release();
	}

	//Composer
	if(m_pComposer)
		m_pComposer->Release();

#if 0
	if(m_pdsBuf)
		m_pdsBuf->Release();

	if(m_pdSound)
		m_pdSound->Release();
#endif

	//COM
	CoUninitialize(); 

	dprintf("CDirectMusic::Shutdown - OK\n");
}

/*
=======================================
Play
=======================================
*/
bool CDirectMusic::Play(char *file)
{
	HRESULT         hr;
	GUID			guid;
	DMUS_OBJECTDESC ObjDesc; // Object descriptor for pLoader->GetObject()


	if(dmstate != STOPPED)
	{
		if(Stop())
		{
			dprintf("CDirectMusic::Play - couldnt stop current music\n");
			return false;
		}
	}
	
    // now load the segment file.
    // sections load as type Segment, as do MIDI files, for example.
    ObjDesc.guidClass = CLSID_DirectMusicSegment;
    ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
    
	MULTI_TO_WIDE(ObjDesc.wszFileName, file);
    
	ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_FILENAME;
    hr = m_pLoader->GetObject( &ObjDesc, IID_IDirectMusicSegment, (void**)&m_pSegment );

    if(FAILED(hr))
	{
		dprintf("CDirectMusic::Play:Couldnt load %s\n",file);
		return false;
	}

	m_pSegment->SetRepeats(999);

	// Get the Style from the Segment by calling the Segment's GetData()
	// with the data type GUID_StyleTrackStyle.
	// 0xffffffff indicates to look at Tracks in all TrackGroups in the segment.
	// The first 0 indicates to retrieve the Style from the first Track 
	// in the indicated TrackGroup.
	// The second 0 indicates to retrieve the Style from the beginning
	// of the Segment, i.e. time 0 in Segment time.
	// If this Segment was loaded from a Section file, there is only one 
	// Style and it is at time 0.
	// Note that the GetData() call with GUID_IDirectMusicStyle assumes the
	// third parameter is the address of a pointer to an IDirectMusicStyle.
		
	guid = GUID_IDirectMusicStyle;
	hr = m_pSegment->GetParam( guid, 0xffffffff, 0, 0, NULL, (void*)&m_pStyle );
	if ( FAILED(hr) )
	{
		dprintf("CDirectMusic::Play: Could not get DMusic style\n");
//		return false;
	}

    // Play the segment and wait. The DMUS_SEGF_BEAT indicates to play on the next beat 
    // if there is a segment currently playing. The first 0 indicates to
    // play (on the next beat from) now.
    // The final NULL means do not return an IDirectMusicSegmentState* in
    // the last parameter.
    m_pPerformance->PlaySegment( m_pSegment, DMUS_SEGF_BEAT, 0, &m_pSegstate);

	// Find out the performance time when segment began playing and
    // convert to reference time. This way if the tempo changes later
    // in the file, we will still have the correct reference start time
    m_pSegstate->GetStartTime(&m_musStartTime);                                                
    m_pPerformance->MusicToReferenceTime(m_musStartTime,&m_refStartTime);


	dprintf("CDirectMusic::Playing %s\n",file);
	return true;
}


/*
=======================================
Stop
=======================================
*/
bool CDirectMusic::Stop()
{
	// Release the Segment
    m_pSegment->Release();

   // If there is any music playing, stop it.
    m_pPerformance->Stop( NULL, NULL, 0, 0 );

	m_refStartTime = 0;
	m_refOffTime = 0;
	m_musStartTime = 0;
	m_musOffTime = 0;
	return true;
}


/*
=======================================
Resume
=======================================
*/
bool CDirectMusic::Resume()
{
	if(dmstate != PAUSED)
	{
		dprintf("CDirectMusic::Resume - not paused\n");
		return false;
	}
     
	if(SUCCEEDED(m_pPerformance->PlaySegment(m_pSegment,
                                             DMUS_SEGF_BEAT,
                                             0,
                                             &m_pSegstate)))
    {
		// Find out the performance time when segment began playing and
		// convert to reference time. This way if the tempo changes later
		// in the file, we will still have the correct reference start time
        m_pSegstate->GetStartTime(&m_musStartTime);                                                
		m_pPerformance->MusicToReferenceTime(m_musStartTime,&m_refStartTime);
		return true;
	}
	dprintf("CDirectMusic::Failed to resume playback\n");
	return false;
}


/*
=======================================
Pause
=======================================
*/
bool CDirectMusic::Pause()
{
	MUSIC_TIME          mtNow;
    REFERENCE_TIME      rtNow;
                
    m_pPerformance->Stop(NULL,NULL,0,0);

    //Find out the current performance time so that we can figure out 
    //where we stopped in the segment.
    m_pPerformance->GetTime(&rtNow,&mtNow);

    // Caculate the offset into the segment in music time (ticks)
    // and reference time (milliseconds) and add to previous offset in 
    // cause there has been more than one pause in this segment playback
    m_musOffTime = (mtNow - m_musStartTime) + m_musOffTime; 
    m_refOffTime = (rtNow - m_refStartTime) + m_refOffTime;

    // Set restart point
    m_pSegment->SetStartPoint(m_musOffTime);
 
    m_pSegstate->Release();
    m_pSegstate = NULL;
	return true;
}



