/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _SYSTEM_H_
#define _SYSTEM_H_

/*
system dependent function exported to the rest of the application
redefine these for each platform being ported
*/

#ifdef WIN32
	#include <windows.h>
	#include <windowsx.h>
#endif

#include <GL\gl.h>
#include <GL\glu.h>
#include <iostream.h>
#include <memory.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

double getDoubleTime (void);

void	repaint_main();
void	set_cursor( int x, int y );

bool	file_exists( char *fname );
char	*getCmdLine();
void	swap_buffers();

typedef int GLMODEL_DBLPTR;
void	tagMenu_append( char *name, GLMODEL_DBLPTR model );
void    tagMenu_seperatorAppend( char *name );
void    tagMenu_remove( GLMODEL_DBLPTR tagid );

#include "Error.h"
#include "Base.h"
#include "BaseMesh.h"

#endif