/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "ndictionary.h"
#include <iostream.h>

void NodeDictionaryInfo::insert( Object element, Object key )
{
        NodeLocator nL = new NodeLocatorInfo( this, element, key );
        insertLast( nL );
};


Object NodeDictionaryInfo::insertReplace( Object element, Object key )
{
	Object toReturn;
        for (NodeLocator nL = (NodeLocator)first(); nL != NULL; nL = (NodeLocator)after(nL))
        {
                if (m_keyComp->equal( nL->key(), key )) {
		  toReturn = nL->element();
		  nL->setElement( element );
                  return toReturn;
                }
        }

	// found nothing so append
	nL = new NodeLocatorInfo( this, element, key );
        insertLast( nL );
        return NULL;
};


Object NodeDictionaryInfo::find(Object key)
{
        for (NodeLocator nL = (NodeLocator)first(); nL != NULL; nL = (NodeLocator)after(nL))
        {       
                if (m_keyComp->equal( nL->key(), key )) {
                        return nL->element();
                }
        }       
        return NULL; // found nothing   
}

Object NodeDictionaryInfo::remove( Object key )
{
        for (NodeLocator nL = (NodeLocator)first(); nL != NULL; nL = (NodeLocator)after(nL))
        {
                if (m_keyComp->equal( nL->key(), key )) {
                        return remove( nL );                                            
                }
        }       
        return NULL; // found nothing   
}


Object NodeDictionaryInfo::replace( Object element, Object key )
{
  Object toReturn;
        for (NodeLocator nL = (NodeLocator)first(); nL != NULL; nL = (NodeLocator)after(nL))
        {
                if (m_keyComp->equal( nL->key(), key )) {
		  toReturn = nL->element();
		  nL->setElement( element );
                  return toReturn;                                         
                }
        }       
        return NULL; // found nothing   
}


void NodeDictionaryInfo::dumpDictionary()
{      
  cout << "Dictionary Dump, size " <<  size() << endl; 
  for (NodeLocator nL = (NodeLocator)first(); nL != NULL; nL = (NodeLocator)after(nL))
  {
    cout << "           Position " << nL; 
    cout << " next " << nL->getNextNode();
    cout << " prev " << nL->getPrevNode();
    cout << " element " << nL->element();
    cout << " key " << (char *)nL->key() << endl;
  }   
}
