/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "system.h"
#include "ndictionary.h"
#include "md3gl.h"
#include "md3view.h"

MDViewState mdview;

/*
renders the view which so far is just a model frame
*/
void render_mdview()
{
	//draw_view();	
	draw_viewSkeleton();
}

/*
initializes the viewer global state data
*/
void init_mdview()
{
	mdview.zPos = -2.f;
    mdview.rotAngleX = mdview.rotAngleY = 0;	
	mdview.animSpeed = 5.0;
	mdview.timeStamp1 = getDoubleTime();
	mdview.texMode = TEX_UNFILTERED;
	mdview.faceSide = GL_CCW;
	mdview.animate = false;
	mdview.interpolate = false;

	// allocate texture resource manager
	mdview.textureRes = new NodeDictionaryInfo( new StrKeyComparatorInfo() );
	mdview.topTextureBind = 0;

	// allocate model list
	mdview.modelList = new NodeSequenceInfo();

	strcpy( mdview.basepath, "/");
	SetCurrentDirectory( mdview.basepath );
}

void	delete_gl_model( gl_model *model );
bool	loadmd3(gl_model& newModel, char* filename);

/* ------------------------------------------------ loading code -------------------------------------------------- */

/*
loads up md3 data
*/
bool loadmdl( char *filename )
{	
	gl_model* model = new gl_model; memset( model, 0, sizeof(gl_model) );
	if (!loadmd3( *model, filename )) {
		delete_gl_model( model );model = NULL;
		return false;
	}


	model->modelListPosition = mdview.modelList->insertLast( model );
	mdview.baseModel = (gl_model *)mdview.modelList->first()->element();

	tagMenu_seperatorAppend( filename );
	for (unsigned int i=0 ; i<model->tagNum ; i++) {
		tagMenu_append( model->tags[0][i].Name, (GLMODEL_DBLPTR)&model->linkedModels[i] );
	}

	return true;
}




/*
loads a model into the slot pointed to by dblptr
*/
void loadmdl_totag( char *fullName, GLMODEL_DBLPTR dblptr )
{
	gl_model **m_dblptr = (gl_model **)dblptr;
	gl_model *newmodel;
	
	NodePosition pos;
	if (loadmdl( fullName )) {
		pos = mdview.modelList->last();
		newmodel = (gl_model *)pos->element();
		*m_dblptr = newmodel;		
	}

}


/*
loads a new skin
*/
void importNewSkin( char *fullName )
{
	GLuint newTexBind = loadTexture( fullName );
	NodePosition pos;
	gl_model *model;
	gl_mesh *mesh;
	int meshNum,i;
	unsigned int j;

	for (pos=mdview.modelList->first() ; pos!=NULL ; pos=mdview.modelList->after(pos)) {
		model = (gl_model *)pos->element();
		meshNum = model->meshNum;
		for (i=0 ; i<meshNum ; i++) {
			mesh = &model->meshes[i];
			for (j=0 ; j<mesh->skinNum ; j++) {
				mesh->bindings[j] = newTexBind;
			}
		}
	}
}


/* ------------------------------------------ delete code ------------------------------------------------------- */


/*
frees all mdviewdata, and effectively resets the data state back to init
*/
void free_mdviewdata()
{
	NodePosition pos;
	gl_model *model;

	/*
	for(pos = mdview.modelList->first() ; pos!=NULL ; pos=next) {		
		model = (gl_model *)pos->element();
		// takes care of removing model from the list and everything, so assume pos is invalid		
		delete_gl_model( model );

		// get next after cuz the list might have been changed by delete_gl_model
		next = mdview.modelList->after(pos);
	}
	*/


	if (!mdview.modelList->isEmpty()) {
		do {
			pos = mdview.modelList->first();	

			model = (gl_model *)pos->element();
			delete_gl_model( model ); // this removes its own position from the list

		} while (mdview.modelList->first()!=NULL);
	}

	// if there is anything else left in texture res remove, 
	// though deleting all gl_models in list should make it empty
	freeTextureRes();	
}


/*
frees a model that has been loaded before by loadmdl_totag into the modelptr slot
*/
void freemdl_fromtag( GLMODEL_DBLPTR modelptr )
{
	gl_model **m_dblptr = (gl_model **)modelptr;
	gl_model *model = *m_dblptr;
	
	if (!model) return;
	
	delete_gl_model( model );
	
	*m_dblptr = NULL;		
}

/*
frees data as for shutdown, call this only as the last thing before exiting or bad thigns will happen
*/
void shutdown_mdviewdata()
{
	free_mdviewdata();
	delete mdview.modelList; mdview.modelList = NULL;
	delete mdview.textureRes; mdview.textureRes = NULL;
}
