/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _MD3_GL_H_
#define _MD3_GL_H_

typedef struct
{
	unsigned char          *Data;              // actual texture bitmap
	unsigned int            Width, Height;     // size of TextureData
	GLenum                  Type;              // type of texture ie.	
	GLuint       		    Bind;			   // id the texture is bound to
	char                   *File;              // allocated string storing path name
	int                     numUsed;
} TextureGL;

typedef struct
{			
	GLuint         *textureBinds;              // array of texture binds, one for each mesh
	int            topTextureBind;    
	Vec3		   *iterVerts;                // arrays of vertices for interpolation, one for each mesh	
	NodeDictionary textureRes;                 // map of texture names to TextureGL data, stores texture resources
} MD3GL;

typedef Vec3 *FMeshFrame;                // frame of VertexFloats

/*
run time model data structure
*/

struct gl_mesh
{
	char          name[64];
	unsigned int  vertexNum;                    // number of vertices in model
	unsigned int  triangleNum;                  // number of triangles in gl_model
	unsigned int  meshFrameNum;                 // same as global frame but convenient
	
	TriVec	     *triangles;                    // array of triangle vertex indices of size triangleNum
	TexVec       *textureCoord;                 // array of float s/t texture cooridnates of sie vertexNum
	FMeshFrame   *meshFrames;                   // 2d array of size of [frameNum][vertexNum] stores mesh frame vertices
	Vec3		 *iterMesh;                     // buffer mesh frame used to store interpolated mesh of size vertexNum

	unsigned int  skinNum;                      // number of skins this model has
	GLuint       *bindings;                     // array of texture bindings of size skinNum;	
};

struct gl_model;
struct gl_model
{
	unsigned int   frameNum;                     // number of frames in gl_model
	unsigned int   tagNum;	                     // number of tags in gl_model     	
	unsigned int   meshNum;                      // number of meshes in whole model
	NodePosition   modelListPosition;            // link to its mdview.modelList
	float          CTM_matrix[16];               // object transformation matrix for manipulating mesh
		
	gl_mesh       *meshes;                       // array of meshes of size meshNum

	gl_model     **linkedModels;                 // array of links of size tagNum, each link corresponds to a tag
	gl_model      *parent;
	TagFrame      *tags;                         // 2d array of tags size [frameNum][tagNum]
	BoneFrame     *boneFrames;                   // 2d array of bone frames size [frameNum][tagNum]

	unsigned int   currentFrame;                // current frame being displayed

	// this requires more work once the script parser is done
	bool          isBlended;                    
	GLenum        blendParam1, blendParam2;     	
};


#define NEAR_GL_PLANE 0.1
#define FAR_GL_PLANE 512

void initialize_glstate();
bool loadmd3gl( MD3GL &data );
void rendermd3gl( MD3GL &mdl );
void freemd3gl( MD3GL &data );
void renderFrame();

void oglStateFlatTextured();
void oglStateShadedTextured();
void oglStateShadedFlat();
void oglStateWireframe();


/*
damn smart and efficient texture loader, 
first searches for an existing teature name is parent directories
then checks if texture has already been loaded,
otherwise it loads it up, enters in textureRes manager and returns the new binding
*/
GLuint loadTexture( char *texturepath );

/*
frees a texture resource, called whenever a mesh is being freed. a texture is freed only if nothing is using it anymore
*/
void freeTexture( GLuint bind );

/*
deletes the entire texture resource manager with all its textures, usually called at the end of the program
or when a whole new model is loaded
*/
void freeTextureRes();

/*
reloads all texture resources from disk
*/
void refreshTextureRes();

/*
chooses the specific filter to be applied based on current mode
*/
void setTextureToFilter();

/*
sets texture parameters to the current texMode
*/
void setTextureFilter();

/*
renders the current frame 
*/
void draw_view();
void draw_viewSkeleton();

#endif