/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "system.h"
#include "ndictionary.h"
#include "md3gl.h"
#include "md3view.h"

double getDoubleTime (void);

/*
sets all model frames to 0
*/
void rewindAnim()
{
	NodePosition pos;	
	gl_model *model;

	for (pos=mdview.modelList->first() ; pos!=NULL ; pos=mdview.modelList->after(pos)) {
		model = (gl_model *)pos->element();
		model->currentFrame = 0;
	}			
//	for (unsigned int i=0; i<mdview.model->Header.Mesh_num ; i++) {
//		mdview.frames[i]=0;		
//	}
}

/*
exectues every frame
*/
void animation_loop() 
{ 
	if (!mdview.animate) return;
	if (mdview.modelList->isEmpty()) return;

	NodePosition pos;	
	gl_model *model;

	double timeStamp2 = getDoubleTime();
	mdview.frameFrac = (float)((timeStamp2 - mdview.timeStamp1) / mdview.animSpeed);
	
	if (mdview.frameFrac > 1.f) {
		mdview.frameFrac = 0;
		mdview.timeStamp1 = timeStamp2;		

			for (pos=mdview.modelList->first() ; pos!=NULL ; pos=mdview.modelList->after(pos)) {
				model = (gl_model *)pos->element();
				model->currentFrame++;
				if (model->currentFrame == model->frameNum) model->currentFrame = 0;				
			}			
			render_mdview();
		    swap_buffers();
		
	}
	else if (mdview.interpolate) {
		render_mdview();
		swap_buffers();
	}	
}
