/*
Copyright (C) Matthew 'pagan' Baranowski & Sander 'FireStorm' van Rossen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _BASEMESH_H_
#define _BASEMESH_H_

/**START OLD STRUCTURES**/

//These structures are exactly the same in the md3 file structure.
//It is very likely that these structures will be replaced with a
//very different internal structure.
typedef struct 
{
	//start guess
	float				Mins[3];
	float				Maxs[3];
	float				Position[3];
	float				Scale;
	//end guess
	char				Creator[16];		//i think this is the "creator" name..
											//but i'm only guessing.
} BoneFrame;

typedef struct 
{
	char				Name[12];			//name of 'tag' as it's usually called in the md3 files
											//try to see it as a sub-mesh/seperate mesh-part
	char				unknown[52];		//normally filled with zeros, but there is an exception 
											//where it's filled with other numbers...
											//it would be logical if it was part of name, because 
											//then name would have 64 chars.
	
	//unverified:
	Vec3				Position;			//relative position of tag
	
	Mat3x3				Matrix;				//3x3 rotation matrix
} Tag;
typedef Tag*				TagFrame;
/**END OLD STRUCTURES**/

#endif