#include	"g_local.h"
#include	"m_player.h"

#define	total_team	none
#define	loopTeam	for (i = red; i < total_team; i++)
#define	loopPlayer	for (i = 0; i < maxclients->value; i++)
#define	loopBody	for (i = maxclients->value + BODY_QUEUE_SIZE; i < maxclients->value + BODY_QUEUE_SIZE + freeze_queue_size; i++)
#define	maplist_size	32
#define	far_time	100000000
#define	chan_hook	5
#define	hook_on	0x00000001
#define	hook_in	0x00000002
#define	grow_on	0x00000004
#define	shrink_on	0x00000008
#define	hook_entity	0x00000010
#define	motor_start	0
#define	motor_on	1
#define	motor_off	2
#define	g_(a)	a = g_edicts + 1 + i; if (!a->inuse) continue;
#define	body_hook(a)	a->style
#define	body_team(a)	a->count
#define	body_melt(a)	a->delay
#define	body_moan(a)	a->air_finished
#define	body_respawn(a)	a->powerarmor_time
#define	body_laser(a)	a->show_hostile
#define	random_small	random() < 0.1

enum align_enum {
	align_left, align_center, align_right };

cvar_t	*hook_min_len;
cvar_t	*hook_max_len;
cvar_t	*hook_rpf;
cvar_t	*hook_speed;
cvar_t	*pointlimit;
cvar_t	*newteam;
cvar_t	*body_total;
cvar_t	*break_all;
qboolean	motd;
int	team_count;
int	stat_pos[4];
int	sound_moan_index;

struct {
	char	*name;
	int	used;
} maplist[maplist_size];

struct {
	int	score;
	int	team_icon;
	float	score_time;
	int	count;
	float	break_time;
} g_team[total_team];

qboolean Is_freeze_body(edict_t *ent)
{
	if (!ent->inuse)
		return false;
	if (ent->client || !ent->classname)
		return false;
	if (Q_stricmp(ent->classname, "freeze_body") == 0)
		return true;
	return false;
}

qboolean Is_freeze(edict_t *ent)
{
	if (!ent->inuse)
		return false;
	if (ent->client)
	{
		if (ent->client->freeze)
			return true;
		return false;
	}
	if (Is_freeze_body(ent))
		return true;
	return false;
}

static qboolean Is_hook(edict_t *ent)
{
	if (!ent->inuse)
		return false;
	if (ent->client)
	{
		if (ent->client->hookstate &hook_in)
			return true;
		return false;
	}
	if (Is_freeze_body(ent))
	{
		if (body_hook(ent) &hook_in)
			return true;
		return false;
	}
	return false;
}

qboolean Is_team(edict_t *ent)
{
	if (!ent->inuse)
		return none;
	if (ent->client)
	{
		if (ent->client->resp.spectator)
			return none;
		return ent->client->resp.team;
	}
	if (Is_freeze_body(ent))
		return body_team(ent);
	return none;
}

static void team_pos(void)
{
	int	i, j, k;
	int	team[4];

	for (i = 0; i < 4; i++)
		team[i] = none;
	for (i = red; i <= team_count; i++)
	{
		k = 0;
		for (j = red; j <= team_count; j++)
		{
			if (i == j)
				continue;
			if (g_team[i].score < g_team[j].score)
				continue;
			if (g_team[i].score > g_team[j].score || i < j)
				k++;
		}
		team[3 - k] = i;
	}
	for (i = 0; i < 4; i++)
		stat_pos[i] = team[i];
}

static void teamcount(void)
{
	int	i;
	edict_t	*ent;
	int	team[total_team];

	loopTeam
		team[i] = 0;
	loopPlayer
	{
		g_(ent)
		if (Is_team(ent) == none)
			continue;
		team[Is_team(ent)]++;
	}

	loopTeam
		g_team[i].count = team[i];
	if (!newteam->value)
	{
		team_count = blue;
		return;
	}

	if (team[yellow])
		team_count = yellow;
	else if (team[red] >= newteam->value && team[blue] >= newteam->value)
	{
		if (team[green] >= newteam->value)
			team_count = yellow;
		else
			team_count = green;
	}
	else if (team[green])
		team_count = green;
	else
		team_count = blue;
}

void menu_close(edict_t *ent)
{
	if (!ent->client->menu)
		return;
	free(ent->client->menu);
	ent->client->menu = NULL;
	ent->client->showscores = false;
}

void menu_update(edict_t *ent)
{
	menuhnd_t	*hnd;
	char	string[1400];
	int	i;
	menu_t	*p;
	char	*t;
	qboolean	alt = false;
	int	x;

	if (!ent->client->menu)
		return;
	hnd = ent->client->menu;

	if (hnd->num == 24)
		strcpy(string, "xv 32 yv 32 picn help ");
	else
		string[0] = 0;

	for (i = 0, p = hnd->entries; i < hnd->num; i++, p++)
	{
		if (!p->text || !*p->text)
			continue;
		t = p->text;
		if (*t == '*')
		{
			alt = true;
			t++;
		}

		if (p->align == align_center)
			x = (20 - (int)(strlen(t) / 2)) * 8;
		else if (p->align == align_right)
			x = (33 - strlen(t)) * 8;
		else
			x = 56;

		sprintf(string + strlen(string), "xv %d yv %d ", x - (hnd->cur == i ? 8 : 0), 32 + i * 8);

		if (hnd->cur == i)
			sprintf(string + strlen(string), "string2 \"\xd%s\" ", t);
		else if (alt)
			sprintf(string + strlen(string), "string2 \"%s\" ", t);
		else
			sprintf(string + strlen(string), "string \"%s\" ", t);

		alt = false;
	}

	gi.WriteByte(svc_layout);
	gi.WriteString(string);
}

static void menu_open(edict_t *ent, menu_t *entries, int cur, int num)
{
	menuhnd_t	*hnd;
	int	i;
	menu_t	*p;

	if (!ent->client)
		return;
	if (ent->client->menu)
		menu_close(ent);
	hnd = malloc(sizeof(*hnd));
	hnd->entries = entries;
	hnd->num = num;
	if (cur < 0 || !entries[cur].selectfunc)
	{
		for (i = 0, p = entries; i < num; i++, p++)
			if (p->selectfunc)
				break;
	}
	else
		i = cur;

	if (i >= num)
		hnd->cur = -1;
	else
		hnd->cur = i;

	ent->client->showscores = true;
	ent->client->menu = hnd;
	menu_update(ent);
	gi.unicast(ent, true);
}

void menu_next(edict_t *ent)
{
	menuhnd_t	*hnd;
	int	i;
	menu_t	*p;

	if (!ent->client->menu)
		return;
	hnd = ent->client->menu;
	if (hnd->cur < 0)
		return;
	i = hnd->cur;
	p = hnd->entries + hnd->cur;
	do
	{
		i++, p++;
		if (i == hnd->num)
			i = 0, p = hnd->entries;
		if (p->selectfunc)
			break;
	} while (i != hnd->cur);
	hnd->cur = i;
	menu_update(ent);
	gi.unicast(ent, true);
}

void menu_prev(edict_t *ent)
{
	menuhnd_t	*hnd;
	int	i;
	menu_t	*p;

	if (!ent->client->menu)
		return;
	hnd = ent->client->menu;
	if (hnd->cur < 0)
		return;
	i = hnd->cur;
	p = hnd->entries + hnd->cur;
	do
	{
		if (i == 0)
		{
			i = hnd->num - 1;
			p = hnd->entries + i;
		}
		else
			i--, p--;
		if (p->selectfunc)
			break;
	} while (i != hnd->cur);
	hnd->cur = i;
	menu_update(ent);
	gi.unicast(ent, true);
}

void menu_select(edict_t *ent)
{
	menuhnd_t	*hnd;
	menu_t	*p;

	if (!ent->client->menu)
		return;
	hnd = ent->client->menu;
	if (hnd->cur < 0)
		return;
	p = hnd->entries + hnd->cur;
	if (p->selectfunc)
		p->selectfunc(ent);
}

static void menu_red(edict_t *ent)
{
	menu_close(ent);

	gi.WriteByte(svc_stufftext);
	gi.WriteString("team red");
	gi.unicast(ent, true);
}

static void menu_blue(edict_t *ent)
{
	menu_close(ent);

	gi.WriteByte(svc_stufftext);
	gi.WriteString("team blue");
	gi.unicast(ent, true);
}

static void menu_green(edict_t *ent)
{
	menu_close(ent);

	gi.WriteByte(svc_stufftext);
	gi.WriteString("team green");
	gi.unicast(ent, true);
}

static void menu_yellow(edict_t *ent)
{
	menu_close(ent);

	gi.WriteByte(svc_stufftext);
	gi.WriteString("team yellow");
	gi.unicast(ent, true);
}

static void menu_main(edict_t *ent);

menu_t	credit_menu[] = {
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Programming", align_center, NULL}, 
	{"Darrell Bircsak", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Menu and Team Macros", align_center, NULL}, 
	{"Dave Kirsch", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Team Skins", align_center, NULL}, 
	{"Grimlock", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Standard Log", align_center, NULL}, 
	{"Mark Davies", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Swinging Hook", align_center, NULL}, 
	{"Perecli Manole", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{"Press Enter to Continue", align_left, menu_main}, 
	{NULL, align_left, NULL}
};

static void menu_credit(edict_t *ent)
{
	menu_close(ent);
	menu_open(ent, credit_menu, -1, sizeof(credit_menu) / sizeof(menu_t));
}

menu_t	main_menu[] = {
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"*www.planetquake.com/freeze", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"*Freeze Tag Capture", align_center, NULL}, 
	{"*by", align_center, NULL}, 
	{"*Darrell Bircsak", align_center, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"Team Red", align_left, menu_red}, 
	{"Team Blue", align_left, menu_blue}, 
	{"Team Green", align_left, menu_green}, 
	{"Team Yellow", align_left, menu_yellow}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"Credits", align_left, menu_credit}, 
	{NULL, align_left, NULL}, 
	{"*1.01", align_right, NULL}, 
	{NULL, align_left, NULL}
};

static void menu_main(edict_t *ent)
{
	int	i;
	int	best_total = 999, best_team = blue;

	teamcount();

	loopTeam
	{
		if (g_team[i].count < best_total)
		{
			best_total = g_team[i].count;
			best_team = i;
		}
	}

	if (green > team_count)
	{
		main_menu[15].text = NULL;
		main_menu[15].selectfunc = NULL;
	}
	else
	{
		main_menu[15].text = "Team Green";
		main_menu[15].selectfunc = menu_green;
	}

	if (yellow > team_count)
	{
		main_menu[16].text = NULL;
		main_menu[16].selectfunc = NULL;
	}
	else
	{
		main_menu[16].text = "Team Yellow";
		main_menu[16].selectfunc = menu_yellow;
	}

	menu_close(ent);
	menu_open(ent, main_menu, 13 + best_team, sizeof(main_menu) / sizeof(menu_t));
}

menu_t	motd_menu[] = {
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{NULL, align_left, NULL}, 
	{"Press Enter to Continue", align_left, menu_main}, 
	{NULL, align_left, NULL}
};

void menu_motd(edict_t *ent)
{
	if (motd && Is_team(ent) == none)
		menu_open(ent, motd_menu, -1, sizeof(motd_menu) / sizeof(menu_t));
	else
		menu_main(ent);
}

void freeze_spawn(void)
{
	memset(&g_team, 0, sizeof(g_team));
	gib_que = 0;

	g_team[red].team_icon = gi.imageindex("k_redkey");
	g_team[blue].team_icon = gi.imageindex("k_bluekey");
	g_team[green].team_icon = gi.imageindex("k_security");
	g_team[yellow].team_icon = gi.imageindex("k_powercube");

	teamcount();
	team_pos();

	sound_moan_index = gi.soundindex("insane/insane1.wav");
	gi.soundindex("insane/insane2.wav");
	gi.soundindex("insane/insane3.wav");
	gi.soundindex("insane/insane4.wav");
	gi.soundindex("insane/insane6.wav");
	gi.soundindex("insane/insane8.wav");
	gi.soundindex("insane/insane9.wav");
	gi.soundindex("insane/insane10.wav");
}

qboolean freeze_nextmap(void)
{
	int	i, used = 0;
	int	n;

	for (i = 0; i < maplist_size; i++)
	{
		if (!maplist[i].name)
			break;
		if (!maplist[i].used)
			used++;
	}
	if (!used)
	{
		for (i = 0; i < maplist_size; i++)
		{
			if (!maplist[i].name)
				break;
			if (Q_stricmp(maplist[i].name, level.mapname) == 0)
				continue;
			maplist[i].used = false;
			used++;
		}

		if (!used)
			return false;
	}

	n = (rand() % used) + 1;
	used = 0;
	for (i = 0; i < maplist_size; i++)
	{
		if (!maplist[i].name)
			break;
		if (maplist[i].used)
			continue;

		used++;
		if (used == n)
		{
			maplist[i].used = true;
			freeze_mapname = maplist[i].name;
			return true;
		}
	}
	return false;
}

qboolean freeze_CheckRules(void)
{
	if (pointlimit->value)
	{
		int	i;

		loopTeam
		{
			if (g_team[i].score < pointlimit->value)
				continue;
			gi.bprintf(PRINT_HIGH, "Pointlimit hit.\n");
			return true;
		}
	}

	return false;
}

static char *ftc_CopyString(char *in)
{
	char	*out;

	out = gi.TagMalloc(strlen(in) + 1, TAG_GAME);
	strcpy(out, in);
	return out;
}

static void freeze_Load(void)
{
	cvar_t	*game;
	char	name[MAX_OSPATH];
	FILE	*f;
	char	st[128];
	int	index;

	motd = false;

	game = gi.cvar("game", "", 0);
	if (!*game->string)
		sprintf(name, "baseq2/ftc.ini");
	else
		sprintf(name, "%s/ftc.ini", game->string);
	if (!(f = fopen(name, "r")))
		return;

	while (fgets(st, sizeof(st), f))
	{
		if (strstr(st, "[motd]"))
			break;
	}

	if (feof(f))
	{
		fclose(f);
		return;
	}

	index = 0;
	while (fgets(st, sizeof(st), f))
	{
		if (strstr(st, "//"))
			continue;
		if (strstr(st, "###"))
			break;
		if (motd_menu[index].selectfunc)
			break;

		st[strlen(st) - 1] = 0;
		if (strlen(st))
		{
			motd_menu[index].text = ftc_CopyString(st);
			motd_menu[index].align = align_center;
			motd = true;
		}
		index++;
	}

	rewind(f);

	while (fgets(st, sizeof(st), f))
	{
		if (strstr(st, "[maplist]"))
			break;
	}

	if (feof(f))
	{
		fclose(f);
		return;
	}

	index = 0;
	while (fgets(st, sizeof(st), f))
	{
		if (strstr(st, "//"))
			continue;
		if (strstr(st, "###"))
			break;

		st[strlen(st) - 1] = 0;
		if (strlen(st))
		{
			maplist[index].name = ftc_CopyString(st);
			maplist[index].used = false;
			index++;
		}
	}
	fclose(f);
}

void freeze_Init(void)
{
	hook_min_len = gi.cvar("hook_min_len", "40", 0);
	hook_max_len = gi.cvar("hook_max_len", "1000", 0);
	hook_rpf = gi.cvar("hook_rpf", "40", 0);
	hook_speed = gi.cvar("hook_speed", "1000", 0);
	pointlimit = gi.cvar("pointlimit", "0", 0);
	newteam = gi.cvar("newteam", "0", 0);
	body_total = gi.cvar("body_total", "0", 0);
	break_all = gi.cvar("break_all", "0", 0);

	freeze_Load();
}

static char *team_tag(int team)
{
	switch (team)
	{
	case red:
		return "../players/male/psycho_i";
	case blue:
		return "../players/male/recon_i";
	case green:
		return "../players/male/nightops_i";
	case yellow:
	default:
		return "../players/male/major_i";
	}
}

char *team_name(int team)
{
	switch (team)
	{
	case red:
		return "Red";
	case blue:
		return "Blue";
	case green:
		return "Green";
	case yellow:
		return "Yellow";
	case none:
	default:
		return "None";
	}
}

void freeze_score(edict_t *ent)
{
	char	string[1400];
	int	total[total_team + 1];
	int	i, j, k;
	edict_t	*other;
	int	team, score;
	int	sorted[total_team + 1][MAX_CLIENTS], sortedscores[total_team + 1][MAX_CLIENTS];
	int	count, best_total, best_team;
	int	x, y, move_over;
	int	stringlength;
	char	entry[1024];
	gclient_t	*cl;

	for (i = red; i <= none; i++)
		total[i] = 0;

	loopPlayer
	{
		g_(other)
		team = Is_team(other);
		score = other->client->resp.score;
		for (j = 0; j < total[team]; j++)
		{
			if (score > sortedscores[team][j])
				break;
		}
		for (k = total[team]; k > j; k--)
		{
			sorted[team][k] = sorted[team][k - 1];
			sortedscores[team][k] = sortedscores[team][k - 1];
		}
		sorted[team][j] = i;
		sortedscores[team][j] = score;
		total[team]++;
	}

	for (;;)
	{
		count = 0;
		loopTeam
			count += 2 + total[i];
		if (count <= 48)
			break;
		best_total = 0;
		loopTeam
		{
			if (total[i] > best_total)
			{
				best_total = total[i];
				best_team = i;
			}
		}
		if (best_total)
			total[best_team]--;
	}

	x = 0, y = 32, count = 4;
	for (i = red; i <= none; i++)
	{
		if (total[i])
			count += 3 + total[i];
	}
	move_over = (int)(count / 2) * 8;

	string[0] = 0;
	stringlength = strlen(string);

	for (i = red; i <= none; i++)
	{
		if (i == none)
			Com_sprintf(entry, sizeof(entry), "yv %d xv %d string \"%s\" ", y, x + 32, team_name(none));
		else
			Com_sprintf(entry, sizeof(entry), "xv %d yv %d picn %s xv %d picn %s string \"%s\" ", x, y, team_tag(i), x + 32, i == blue ? "tag2" : "tag1", team_name(i));
		k = strlen(entry);
		if (stringlength + k > 1024)
			break;
		if (total[i])
		{
			strcpy(string + stringlength, entry);
			stringlength += k;
			y += 16;
		}
		else
			continue;

		for (j = 0; j < total[i]; j++)
		{
			if (y >= 224)
			{
				if (x == 0)
					x = 160;
				else
					break;
				y = 32;
			}
			cl = &game.clients[sorted[i][j]];
			Com_sprintf(entry, sizeof(entry), "ctf %d %d %d %d %d ", x, y, sorted[i][j], cl->resp.score, cl->ping > 999 ? 999 : cl->ping);
			k = strlen(entry);
			if (stringlength + k > 1024)
				break;
			strcpy(string + stringlength, entry);
			stringlength += k;
			y += 8;
		}

		if (y >= 208 || (y >= move_over && x == 0))
		{
			if (x == 0)
				x = 160;
			else
				break;
			y = 32;
		}
		else
			y += 8;
	}

	gi.WriteByte(svc_layout);
	gi.WriteString(string);
}

void freeze_stat(edict_t *ent)
{
	int	i;
	int	Is_team_ = Is_team(ent);

	for (i = 0; i < 4; i++)
	{
		if (stat_pos[i] == none)
		{
			ent->client->ps.stats[26 + i] = 0;
			ent->client->ps.stats[18 + i] = 0;
			ent->client->ps.stats[22 + i] = 0;
			continue;
		}

		if (Is_team_ == stat_pos[i])
			ent->client->ps.stats[26 + i] = gi.imageindex("field_3");
		else
			ent->client->ps.stats[26 + i] = 0;

		if (g_team[stat_pos[i]].score_time > level.time && !(level.framenum &8))
		{
			ent->client->ps.stats[18 + i] = 0;
			ent->client->ps.stats[22 + i] = 0;
		}
		else
		{
			ent->client->ps.stats[18 + i] = g_team[stat_pos[i]].team_icon;
			ent->client->ps.stats[22 + i] = g_team[stat_pos[i]].score;
		}
	}

	if (ent->client->sight)
		ent->client->ps.stats[30] = CS_PLAYERSKINS + ent->client->sight - 1;
	else
		ent->client->ps.stats[30] = 0;
}

static qboolean Is_laser(edict_t *ent)
{
	if (ent->client)
	{
		if (ent->client->resp.laser)
			return true;
		return false;
	}
	if (body_laser(ent))
		return true;
	return false;
}

static void freezeG_ProjectSource(gclient_t *cl, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	d;

	VectorCopy(distance, d);
	if (cl->pers.hand == CENTER_HANDED)
		d[1] = 0;
	else if (cl->pers.hand != LEFT_HANDED)
		d[1] *= -1;
	G_ProjectSource(point, d, forward, right, result);
}

static void drop_hook(edict_t *ent)
{
	if (ent->owner->client)
		ent->owner->client->hookstate = 0;
	gi.sound(ent->owner, chan_hook, gi.soundindex("medic/medatck5.wav"), 1, ATTN_IDLE, 0);
	G_FreeEdict(ent);
}

static void maintain_links(edict_t *ent)
{
	float	multiplier;
	vec3_t	norm_hookvel, pred_hookpos;
	vec3_t	forward, right, offset;
	vec3_t	start, chainvec, norm_chainvec;

	multiplier = VectorLength(ent->velocity) / 22;
	VectorNormalize2(ent->velocity, norm_hookvel);
	VectorMA(ent->s.origin, multiplier, norm_hookvel, pred_hookpos);

	if (ent->owner->client)
	{
		AngleVectors(ent->owner->client->v_angle, forward, right, NULL);
		VectorSet(offset, 8, 8, ent->owner->viewheight - 8);
		freezeG_ProjectSource(ent->owner->client, ent->owner->s.origin, offset, forward, right, start);
	}
	else
		VectorCopy(ent->owner->s.origin, start);

	VectorSubtract(pred_hookpos, start, chainvec);
	VectorNormalize2(chainvec, norm_chainvec);
	VectorMA(pred_hookpos, -20, norm_chainvec, pred_hookpos);
	VectorMA(start, 10, norm_chainvec, start);

	if (Is_laser(ent->owner))
	{
		VectorCopy(start, ent->s.old_origin);
		return;
	}

	gi.WriteByte(svc_temp_entity);
	gi.WriteByte(TE_MEDIC_CABLE_ATTACK);
	gi.WriteShort(ent - g_edicts);
	gi.WritePosition(pred_hookpos);
	gi.WritePosition(start);
	gi.multicast(pred_hookpos, MULTICAST_PVS);
}

void SV_CheckVelocity(edict_t *ent);
static void hook_behavior(edict_t *ent)
{
	edict_t	*targ;
	qboolean	chain_moving;
	vec3_t	forward, right;
	vec3_t	offset, start;
	vec3_t	chainvec, velpart;
	float	chainlen, force;

	targ = ent->owner;
	if (!targ->inuse || (targ->health < 1 && !Is_freeze(targ)) || !Is_hook(targ) || level.intermissiontime || targ->s.event == EV_PLAYER_TELEPORT || ent->enemy->solid == SOLID_NOT || (Is_freeze_body(targ) && targ->solid == SOLID_NOT))
	{
		drop_hook(ent);
		return;
	}

	chain_moving = false;
	if (targ->client)
	{
		if (targ->client->hookstate &grow_on && ent->angle < hook_max_len->value)
		{
			ent->angle += hook_rpf->value;
			if (ent->angle > hook_max_len->value)
				ent->angle = hook_max_len->value;
			chain_moving = true;
		}
		if (targ->client->hookstate &shrink_on && ent->angle > hook_min_len->value)
		{
			ent->angle -= hook_rpf->value;
			if (ent->angle < hook_min_len->value)
				ent->angle = hook_min_len->value;
			chain_moving = true;
		}
	}

	if (chain_moving)
	{
		if (ent->sounds == motor_off)
		{
			gi.sound(targ, chan_hook, gi.soundindex("parasite/paratck2.wav"), 1, ATTN_IDLE, 0);
			ent->sounds = motor_start;
		}
		else if (ent->sounds == motor_start)
		{
			gi.sound(targ, chan_hook, gi.soundindex("parasite/paratck3.wav"), 1, ATTN_IDLE, 0);
			ent->sounds = motor_on;
		}
	}
	else if (ent->sounds != motor_off)
	{
		gi.sound(targ, chan_hook, gi.soundindex("parasite/paratck4.wav"), 1, ATTN_IDLE, 0);
		ent->sounds = motor_off;
	}
	VectorCopy(ent->enemy->velocity, ent->velocity);

	if (ent->owner->client)
	{
		AngleVectors(ent->owner->client->v_angle, forward, right, NULL);
		VectorSet(offset, 8, 8, ent->owner->viewheight - 8);
		freezeG_ProjectSource(ent->owner->client, ent->owner->s.origin, offset, forward, right, start);
	}
	else
		VectorCopy(ent->owner->s.origin, start);

	targ = NULL;
	if (ent->enemy->client || Is_freeze_body(ent->enemy))
	{
		targ = ent->enemy;
		if (!targ->inuse || (targ->health < 1 && !Is_freeze(targ)) || targ->s.event == EV_PLAYER_TELEPORT || (targ->client && targ->client->buttons &button_jump && random() < 0.3))
		{
			drop_hook(ent);
			return;
		}

		VectorCopy(ent->s.origin, offset);
		VectorCopy(start, ent->s.origin);
		VectorCopy(offset, start);

		targ = ent->owner;
		ent->owner = ent->enemy;
		ent->enemy = targ;
	}

	VectorSubtract(ent->s.origin, start, chainvec);
	chainlen = VectorLength(chainvec);
	if (chainlen > ent->angle)
	{
		VectorScale(chainvec, _DotProduct(ent->owner->velocity, chainvec) / _DotProduct(chainvec, chainvec), velpart);
		force = (chainlen - ent->angle) * 5;
		if (_DotProduct(ent->owner->velocity, chainvec) < 0)
		{
			if (chainlen > ent->angle + 25)
				VectorSubtract(ent->owner->velocity, velpart, ent->owner->velocity);
		}
		else
		{
			if (VectorLength(velpart) < force)
				force -= VectorLength(velpart);
			else
				force = 0;
		}
	}
	else
		force = 0;

	VectorNormalize(chainvec);
	VectorMA(ent->owner->velocity, force, chainvec, ent->owner->velocity);
	SV_CheckVelocity(ent->owner);

	if (chain_moving && ent->owner->client && ent->owner->client->hookstate &shrink_on && !ent->owner->client->resp.oldhook)
		ent->owner->velocity[2] += ent->gravity * sv_gravity->value * FRAMETIME;

	if (targ)
	{
		targ = ent->enemy;
		ent->enemy = ent->owner;
		ent->owner = targ;

		VectorCopy(ent->enemy->s.origin, ent->s.origin);
	}

	maintain_links(ent);
	ent->nextthink = level.time + FRAMETIME;
}

static void hook_touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t	forward, right, offset;
	vec3_t	start, chainvec;

	AngleVectors(ent->owner->client->v_angle, forward, right, NULL);
	VectorSet(offset, 8, 8, ent->owner->viewheight - 8);
	freezeG_ProjectSource(ent->owner->client, ent->owner->s.origin, offset, forward, right, start);

	VectorSubtract(ent->s.origin, start, chainvec);
	ent->angle = VectorLength(chainvec);

	if (surf && surf->flags &SURF_SKY)
	{
		drop_hook(ent);
		return;
	}
	if (other->takedamage)
		T_Damage(other, ent, ent->owner, ent->velocity, ent->s.origin, plane->normal, ent->dmg, 100, 0, MOD_HIT);
	if (other->client || Is_freeze_body(other))
	{
		gi.sound(other, CHAN_VOICE, gi.soundindex("parasite/paratck1.wav"), 1, ATTN_IDLE, 0);
		ent->owner->client->hookstate |= hook_entity;
	}
	else if (other->solid == SOLID_BSP)
	{
		if (Is_laser(ent->owner))
		{
			gi.WriteByte(svc_temp_entity);
			gi.WriteByte(TE_LASER_SPARKS);
			gi.WriteByte(8);
			gi.WritePosition(ent->s.origin);
			if (!plane)
				gi.WriteDir(vec3_origin);
			else
				gi.WriteDir(plane->normal);
			gi.WriteByte(ent->s.skinnum);
			gi.multicast(ent->s.origin, MULTICAST_PVS);
		}
		else
		{
			gi.WriteByte(svc_temp_entity);
			gi.WriteByte(TE_SHOTGUN);
			gi.WritePosition(ent->s.origin);
			if (!plane)
				gi.WriteDir(vec3_origin);
			else
				gi.WriteDir(plane->normal);
			gi.multicast(ent->s.origin, MULTICAST_PVS);
		}
		gi.sound(ent, CHAN_VOICE, gi.soundindex("medic/medatck3.wav"), 1, ATTN_IDLE, 0);
	}
	else
	{
		drop_hook(ent);
		return;
	}

	VectorCopy(other->velocity, ent->velocity);
	VectorClear(ent->avelocity);
	if (!ent->owner->client->resp.oldhook)
		VectorClear(ent->owner->velocity);
	ent->owner->client->hookstate |= hook_in;
	ent->enemy = other;
	ent->touch = NULL;
	ent->think = hook_behavior;
	ent->nextthink = level.time + FRAMETIME;
}

static void hook_airborne(edict_t *ent)
{
	vec3_t	chainvec;
	float	chainlen;

	VectorSubtract(ent->s.origin, ent->owner->s.origin, chainvec);
	chainlen = VectorLength(chainvec);
	if (!(ent->owner->client->hookstate &hook_on) || chainlen > hook_max_len->value)
	{
		drop_hook(ent);
		return;
	}
	maintain_links(ent);
	ent->nextthink = level.time + FRAMETIME;
}

static void fire_hook(edict_t *ent)
{
	int	damage;
	vec3_t	forward, right;
	vec3_t	offset, start;
	edict_t	*newhook;

	damage = 10;
	if (ent->client->quad_framenum > level.framenum)
		damage *= 4;
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 8, 8, ent->viewheight - 8);
	freezeG_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);

	newhook = G_Spawn();
	newhook->svflags = SVF_DEADMONSTER;
	VectorCopy(start, newhook->s.origin);
	vectoangles(forward, newhook->s.angles);
	VectorScale(forward, hook_speed->value, newhook->velocity);
	VectorCopy(forward, newhook->movedir);
	VectorSet(newhook->avelocity, 0, 0, random() * 600);
	newhook->movetype = MOVETYPE_FLYMISSILE;
	newhook->clipmask = MASK_SHOT;
	newhook->solid = SOLID_BBOX;
	if (Is_laser(ent))
	{
		newhook->s.renderfx |= RF_BEAM | RF_TRANSLUCENT;
		newhook->s.modelindex = 1;
		newhook->s.frame = 4;
		newhook->s.skinnum = 0xf2f2f0f0;
		newhook->spawnflags |= 0x80000001;
	}
	else
		newhook->s.modelindex = gi.modelindex("models/monsters/parasite/tip/tris.md2");
	newhook->classname = "hook";
	VectorClear(newhook->mins);
	VectorClear(newhook->maxs);
	newhook->owner = ent;
	newhook->dmg = damage;
	newhook->sounds = 0;
	newhook->touch = hook_touch;
	newhook->think = hook_airborne;
	newhook->nextthink = level.time + FRAMETIME;
	gi.linkentity(newhook);
	if (ent->client->quad_framenum > level.framenum)
		gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);
	gi.sound(ent, chan_hook, gi.soundindex("medic/medatck2.wav"), 1, ATTN_IDLE, 0);
}

void Cmd_Hook_f(edict_t *ent)
{
	char	*s;
	int	*hookstate;

	s = gi.argv(1);
	if (!*s)
	{
		gi.cprintf(ent, PRINT_HIGH, "usage: hook <value> [action / stop / grow / shrink]\n");
		if (ent->client->resp.oldhook)
			ent->client->resp.oldhook = false;
		else
			ent->client->resp.oldhook = true;
		return;
	}

	if (ent->health < 1 || ent->client->resp.spectator)
		return;
	hookstate = &ent->client->hookstate;
	if (!(*hookstate &hook_on) && Q_stricmp(s, "action") == 0)
	{
		*hookstate = hook_on;
		fire_hook(ent);
		return;
	}
	if (*hookstate &hook_on);
	{
		if (Q_stricmp(s, "action") == 0)
		{
			*hookstate = 0;
			return;
		}
		if (Q_stricmp(s, "stop") == 0)
		{
			if (ent->client->resp.oldhook || *hookstate &hook_entity)
				*hookstate -= *hookstate &(grow_on | shrink_on);
			else
				*hookstate = 0;
			return;
		}
		if (Q_stricmp(s, "grow") == 0)
		{
			*hookstate |= grow_on;
			*hookstate -= *hookstate &shrink_on;
			return;
		}
		if (Q_stricmp(s, "shrink") == 0)
		{
			*hookstate |= shrink_on;
			*hookstate -= *hookstate &grow_on;
			return;
		}
	}
}

void Cmd_Play_Team_f(edict_t *ent)
{
	char	*s;
	int	i;
	edict_t	*other;
	int	n;

	s = gi.argv(1);
	if (!*s || strlen(s) > 32 || Is_team(ent) == none)
	{
		gi.cprintf(ent, PRINT_HIGH, "usage: play_team <filename>\n");
		return;
	}

	if ((n = atoi(s)) == 0)
		n = gi.soundindex(va("%s.wav", s));

	gi.WriteByte(svc_stufftext);
	gi.WriteString(va("say_team %d\n", n));
	gi.unicast(ent, true);

	if (flood_msgs->value)
	{
		if (level.time < ent->client->flood_locktill)
			return;
	}

	loopPlayer
	{
		g_(other)
		if (Is_team(other) != Is_team(ent))
			continue;
		gi.sound(other, CHAN_VOICE, n, 1, ATTN_STATIC, 0);
	}
}

void Cmd_Team_f(edict_t *ent)
{
	char	*s;
	int	team;

	s = gi.argv(1);
	if (!*s || Is_freeze(ent))
	{
		gi.cprintf(ent, PRINT_HIGH, "You are on the %s team.\n", team_name(Is_team(ent)));
		return;
	}

	teamcount();
	if (Q_stricmp(s, "red") == 0)
		team = red;
	else if (Q_stricmp(s, "blue") == 0)
		team = blue;
	else if (Q_stricmp(s, "green") == 0 && green <= team_count)
		team = green;
	else if (Q_stricmp(s, "yellow") == 0 && yellow <= team_count)
		team = yellow;
	else if (Q_stricmp(s, "none") == 0)
	{
		gi.WriteByte(svc_stufftext);
		gi.WriteString("spectator 1\n");
		gi.unicast(ent, true);
		return;
	}
	else
	{
		gi.cprintf(ent, PRINT_HIGH, "Unknown team %s.\n", s);
		return;
	}

	if (ent->client->resp.spectator)
	{
		if (ent->client->resp.team == none)
		{
			gi.WriteByte(svc_stufftext);
			gi.WriteString("alias +hook \"hook action;wait;hook shrink\"\nalias -hook hook stop\n");
			gi.unicast(ent, true);
			gi.WriteByte(svc_stufftext);
			gi.WriteString("alias +grow hook grow\nalias -grow hook stop\n");
			gi.unicast(ent, true);
			gi.WriteByte(svc_stufftext);
			gi.WriteString("alias +shrink hook shrink\nalias -shrink hook stop\n");
			gi.unicast(ent, true);

			ent->client->resp.spectator = false;
		}
		gi.WriteByte(svc_stufftext);
		gi.WriteString("spectator 0\n");
		gi.unicast(ent, true);
		ent->client->resp.team = team;
	}
	else if (Is_team(ent) == team)
	{
		gi.cprintf(ent, PRINT_HIGH, "You are already on the %s team.\n", team_name(Is_team(ent)));
		return;
	}
	else
	{
		ent->client->resp.team = team;
		ent->flags &= ~FL_GODMODE;
		ent->health = 0;
		meansOfDeath = mod_team;
		player_die(ent, ent, ent, 100000, vec3_origin);
		gi.bprintf(PRINT_HIGH, "%s changed to the %s team.\n", ent->client->pers.netname, team_name(Is_team(ent)));
	}
}

qboolean team_damage(edict_t *targ, edict_t *attacker, int damage)
{
	if (meansOfDeath == MOD_TELEFRAG)
		return false;
	if (!attacker->client)
		return false;
	if (!targ->client)
	{
		if (Is_freeze_body(targ))
		{
			if (random_small)
				ThrowDebris(targ, "models/objects/debris2/tris.md2", 2, targ->s.origin);
			if (Is_hook(targ) && random_small)
				body_hook(targ) = 0;
			return true;
		}
		return false;
	}
	if (Is_hook(targ) && random_small)
		targ->client->hookstate = 0;
	if (targ->health > 0)
	{
		if (targ == attacker)
			return false;
		if (Is_team(targ) != Is_team(attacker))
		{
			if (targ->client->respawn_time + 3 < level.time)
				return false;
			return true;
		}
		if ((int)(dmflags->value) &DF_NO_FRIENDLY_FIRE)
			return true;
		else
		{
			meansOfDeath |= MOD_FRIENDLY_FIRE;
			return false;
		}
	}
	if (Is_freeze(targ))
	{
		if (random_small)
			ThrowDebris(targ, "models/objects/debris2/tris.md2", 2, targ->s.origin);
		return true;
	}
	return false;
}

qboolean freeze_make(edict_t *ent)
{
	if (ent->deadflag)
		return false;
	if (meansOfDeath &MOD_FRIENDLY_FIRE)
		return false;
	switch (meansOfDeath)
	{
	case MOD_SUICIDE:
	case MOD_FALLING:
	case MOD_CRUSH:
	case MOD_WATER:
	case MOD_EXIT:
	case MOD_TRIGGER_HURT:
	case MOD_BFG_EFFECT:
	case MOD_TELEFRAG:
	case mod_team:
		return false;
	}
	return true;
}

qboolean IsFemale(edict_t *ent);
void freeze_anim(edict_t *ent)
{
	int	frame, anim_end;

	ent->client->anim_priority = ANIM_DEATH;
	if (ent->client->ps.pmove.pm_flags &PMF_DUCKED)
	{
		if (rand() &1)
			frame = FRAME_crpain1, anim_end = 4;
		else
			frame = FRAME_crdeath1, anim_end = 5;
	}
	else
	{
		switch (rand() % 8)
		{
		case 0:
			frame = FRAME_run1, anim_end = 6;
			break;
		case 1:
			frame = FRAME_pain101, anim_end = 4;
			break;
		case 2:
			frame = FRAME_pain201, anim_end = 4;
			break;
		case 3:
			frame = FRAME_pain301, anim_end = 4;
			break;
		case 4:
			frame = FRAME_jump1, anim_end = 6;
			break;
		case 5:
			frame = FRAME_death101, anim_end = 6;
			break;
		case 6:
			frame = FRAME_death201, anim_end = 6;
			break;
		case 7:
			frame = FRAME_death301, anim_end = 6;
			break;
		}
	}
	ent->s.frame = frame - 1;
	ent->client->anim_end = frame + rand() % anim_end;

	if (random() < 0.07 && !IsFemale(ent))
		gi.sound(ent, CHAN_VOICE, gi.soundindex("player/lava2.wav"), 1, ATTN_NORM, 0);
	else
		gi.sound(ent, CHAN_VOICE, gi.soundindex("boss3/d_hit.wav"), 1, ATTN_NORM, 0);

	ent->deadflag = DEAD_DEAD;
	ent->client->freeze = true;
}

void freeze_skin(edict_t *ent, char *s)
{
	char	t[64];
	char	*p;
	int	playernum = ent - g_edicts - 1;

	Com_sprintf(t, sizeof(t), "%s", s);

	if ((p = strchr(t, '/')) != NULL)
		p[1] = 0;
	else
		strcpy(t, "male/");

	switch (Is_team(ent))
	{
	case red:
		gi.configstring(CS_PLAYERSKINS + playernum, va("%s\\%sctf_r", ent->client->pers.netname, t));
		break;
	case blue:
		gi.configstring(CS_PLAYERSKINS + playernum, va("%s\\%sctf_b", ent->client->pers.netname, t));
		break;
	case green:
		gi.configstring(CS_PLAYERSKINS + playernum, va("%s\\%sctf_g", ent->client->pers.netname, t));
		break;
	case yellow:
		gi.configstring(CS_PLAYERSKINS + playernum, va("%s\\%sctf_y", ent->client->pers.netname, t));
		break;
	default:
		gi.configstring(CS_PLAYERSKINS + playernum, va("%s\\%s", ent->client->pers.netname, s));
	}
}

void freeze_Intermission(void)
{
	int	i;
	int	score = 0;
	int	team, team_score;

	loopTeam
	{
		if (g_team[i].score > score)
			score = g_team[i].score;
	}

	team = none, team_score = 0;
	loopTeam
	{
		if (g_team[i].score == score)
		{
			team = i;
			team_score++;
		}
	}

	loopTeam
		g_team[i].score_time = 0;
	if (team_score == 1)
	{
		gi.bprintf(PRINT_HIGH, "%s team is %s!\n", team_name(team), (rand () &1) ? "victorious" : "the winner");
		g_team[team].score_time = far_time;
	}
	else if (!team_score)
		gi.bprintf(PRINT_HIGH, "%s.\n", (rand() &1) ? "Stalemate" : "Draw");
}

static char *models_debris(void)
{
	switch (rand() % 5)
	{
	case 0:
		return "models/objects/gibs/arm/tris.md2";
	case 1:
		return "models/objects/gibs/bone/tris.md2";
	case 2:
		return "models/objects/gibs/bone2/tris.md2";
	case 3:
		return "models/objects/gibs/chest/tris.md2";
	case 4:
	default:
		return "models/objects/gibs/leg/tris.md2";
	}
}

static void freeze_debris(edict_t *ent)
{
	int	n;

	if (ent->waterlevel)
		gi.positioned_sound(ent->s.origin, ent, CHAN_VOICE, gi.soundindex("misc/fhit3.wav"), 1, ATTN_NORM, 0);
	else
		gi.positioned_sound(ent->s.origin, ent, CHAN_VOICE, gi.soundindex("world/brkglas.wav"), 1, ATTN_NORM, 0);
	if (rand() &1)
		ThrowDebris(ent, models_debris(), 2, ent->s.origin);
	n = rand() % 5;
	while (n--)
		ThrowDebris(ent, "models/objects/debris1/tris.md2", 2, ent->s.origin);
	ent->s.effects = 0, ent->s.renderfx = 0;
	ThrowClientHead(ent, 50);
}

void freeze_Effects(edict_t *ent, int team)
{
	ent->s.effects |= EF_COLOR_SHELL;
	if (team == red)
		ent->s.renderfx |= RF_SHELL_RED;
	else if (team == blue)
		ent->s.renderfx |= RF_SHELL_RED | RF_SHELL_GREEN | RF_SHELL_BLUE;
	else if (team == green)
		ent->s.renderfx |= RF_SHELL_GREEN;
	else
		ent->s.renderfx |= RF_SHELL_RED | RF_SHELL_GREEN;
}

static void freeze_FallingDamage(edict_t *ent)
{
	float	delta;
	int	damage;
	vec3_t	dir;

	if (ent->movetype == MOVETYPE_NOCLIP)
		return;

	if (ent->pos1[2] < 0 && ent->velocity[2] > ent->pos1[2] && !ent->groundentity)
	{
		delta = ent->pos1[2];
	}
	else
	{
		if (!ent->groundentity)
			return;
		delta = ent->velocity[2] - ent->pos1[2];
	}
	delta = delta * delta * 0.0001;
	if (ent->waterlevel)
		return;

	if (delta > 30)
	{
		damage = (delta - 30) / 2;
		if (damage < 1)
			damage = 1;
		VectorSet(dir, 0, 0, 1);
		T_Damage(ent, world, world, dir, ent->s.origin, vec3_origin, damage, 0, 0, MOD_FALLING);
	}
}

static void freeze_WorldEffects(edict_t *ent)
{
	qboolean	wasinwater;
	qboolean	isinwater;

	wasinwater = ent->watertype &MASK_WATER;
	ent->watertype = gi.pointcontents(ent->s.origin);
	isinwater = ent->watertype &MASK_WATER;

	if (isinwater)
		ent->waterlevel = 3;
	else
		ent->waterlevel = 0;

	if (!wasinwater && isinwater)
	{
		if (ent->watertype &CONTENTS_LAVA)
			gi.positioned_sound(ent->s.origin, ent, CHAN_AUTO, gi.soundindex("player/lava_in.wav"), 1, ATTN_NORM, 0);
		else if (ent->watertype &CONTENTS_SLIME)
			gi.positioned_sound(ent->s.origin, ent, CHAN_AUTO, gi.soundindex("player/watr_in.wav"), 1, ATTN_NORM, 0);
		else if (ent->watertype &CONTENTS_WATER)
			gi.positioned_sound(ent->s.origin, ent, CHAN_AUTO, gi.soundindex("player/watr_in.wav"), 1, ATTN_NORM, 0);
	}
	else if (wasinwater && !isinwater)
		gi.positioned_sound(ent->s.origin, ent, CHAN_AUTO, gi.soundindex("player/watr_out.wav"), 1, ATTN_NORM, 0);

	if (ent->watertype &CONTENTS_LAVA)
	{
		if (ent->damage_debounce_time < level.time)
		{
			ent->damage_debounce_time = level.time + 0.2;
			T_Damage(ent, world, world, vec3_origin, ent->s.origin, vec3_origin, 10 * ent->waterlevel, 0, 0, MOD_LAVA);
		}
	}
	if (ent->watertype &CONTENTS_SLIME)
	{
		if (ent->damage_debounce_time < level.time)
		{
			ent->damage_debounce_time = level.time + 1;
			T_Damage(ent, world, world, vec3_origin, ent->s.origin, vec3_origin, 4 * ent->waterlevel, 0, 0, MOD_SLIME);
		}
	}
	if (ent->waterlevel && ent->watertype &(CONTENTS_LAVA | CONTENTS_SLIME))
		ent->s.sound = snd_fry;
	else
		ent->s.sound = 0;

	if (!body_melt(ent) || level.framenum &8)
		freeze_Effects(ent, Is_team(ent));
	else
		ent->s.effects = 0, ent->s.renderfx = 0;

	if (body_moan(ent) < level.time)
	{
		body_moan(ent) = level.time + 9;

		if (random() < 0.3)
		{
			if (ent->waterlevel)
			{
				if (rand() &1)
					gi.sound(ent, CHAN_VOICE, gi.soundindex("flipper/flpidle1.wav"), 1, ATTN_IDLE, 0);
				else
					gi.sound(ent, CHAN_VOICE, gi.soundindex("flipper/flpsrch1.wav"), 1, ATTN_IDLE, 0);
			}
			else
				gi.sound(ent, CHAN_VOICE, sound_moan_index + rand() % 8, 1, ATTN_IDLE, 0);
		}
	}

	freeze_FallingDamage(ent);
	VectorCopy(ent->velocity, ent->pos1);
}

static void freeze_melt(edict_t *ent)
{
	int	i, j;
	edict_t	*other;
	vec3_t	eorg;

	loopPlayer
	{
		g_(other)
		if (other->health < 1)
			continue;
		if (Is_team(other) != Is_team(ent))
			continue;
		for (j = 0; j < 3; j++)
			eorg[j] = ent->s.origin[j] - (other->s.origin[j] - (other->mins[j] + other->maxs[j]) * 0.5);
		if (VectorLength(eorg) > MELEE_DISTANCE)
			continue;
		if (!body_melt(ent))
		{
			body_melt(ent) = level.time + 3;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("world/steam3.wav"), 1, ATTN_NORM, 0);
		}
		return;
	}
	body_melt(ent) = 0;
}

static void break_team(int team, vec3_t spot1)
{
	int	i;
	edict_t	*ent;
	float	delay;
	vec3_t	dist;

	delay = 0;
	loopBody
	{
		g_(ent)
		if (ent->takedamage == DAMAGE_NO)
			continue;
		if (Is_team(ent) != team)
			continue;
		if (!break_all->value)
		{
			VectorSubtract(ent->s.origin, spot1, dist);
			if (VectorLength(dist) > 300)
				continue;
		}
		body_respawn(ent) = level.time + delay;
		delay += 0.2;
	}

	gi.bprintf(PRINT_HIGH, "%s team was %s their foe.\n", team_name(team), rand() &1 ? "run circles around by" : "less than a match for");
	g_team[team].break_time = level.time + delay;

	for (i = red; i <= team_count; i++)
	{
		if (i == team)
			continue;
		if (!g_team[i].count)
			continue;
		g_team[i].score++;
		g_team[i].score_time = level.time + 5;
	}
	team_pos();
	if (team_count < green)
		gi.positioned_sound(vec3_origin, world, CHAN_VOICE | CHAN_RELIABLE, gi.soundindex("world/xian1.wav"), 1, ATTN_NONE, 0);
}

static void freeze_near(edict_t *ent)
{
	int	i;
	edict_t	*other;
	vec3_t	dist;
	int	n = 0;

	loopBody
	{
		g_(other)
		if (other->takedamage == DAMAGE_NO)
			continue;
		if (body_team(other) != body_team(ent))
			continue;
		VectorSubtract(other->s.origin, ent->s.origin, dist);
		if (VectorLength(dist) > 300)
			continue;
		n++;
	}

	teamcount();
	if (!g_team[Is_team(ent)].count)
		return;
	if (body_total->value)
		i = (int)body_total->value;
	else
		i = 1;
	if (n > g_team[Is_team(ent)].count * i)
	{
		break_team(Is_team(ent), ent->s.origin);
	}
}

static void freeze_think(edict_t *self)
{
	if (self->takedamage == DAMAGE_NO)
	{
		self->movetype = MOVETYPE_NONE;
		self->svflags |= SVF_NOCLIENT;
		self->nextthink = far_time;
		return;
	}

	freeze_WorldEffects(self);
	if (g_team[Is_team(self)].break_time < level.time)
	{
		int	framenum = (int)body_respawn(self) + level.framenum;

		if (!(framenum % 5))
			freeze_melt(self);

		if (!(framenum % 50))
			freeze_near(self);
	}

	if (body_respawn(self) < level.time || (body_melt(self) && body_melt(self) < level.time))
	{
		freeze_debris(self);
		self->think = freeze_think;
		self->nextthink = level.time + 30 + random() * 10;
		return;
	}
	self->nextthink = level.time + FRAMETIME;
}

void freeze_que_Init(void)
{
	int	i;
	edict_t	*ent;

	freeze_que = 0;
	for (i = 0; i < freeze_queue_size; i++)
	{
		ent = G_Spawn();
		ent->classname = "freeze_body";
	}
}

static void freeze_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	if (self->health < -175)
		body_respawn(self) = level.time;
}

void freeze_CopyToQue(edict_t *ent)
{
	edict_t	*body;

	body = &g_edicts[(int)maxclients->value + BODY_QUEUE_SIZE + freeze_que + 1];
	freeze_que = (freeze_que + 1) % freeze_queue_size;

	gi.unlinkentity(ent);

	gi.unlinkentity(body);
	body->s = ent->s;
	body->s.number = body - g_edicts;
	body->svflags = ent->svflags;
	VectorCopy(ent->mins, body->mins);
	VectorCopy(ent->maxs, body->maxs);
	VectorCopy(ent->absmin, body->absmin);
	VectorCopy(ent->absmax, body->absmax);
	VectorCopy(ent->size, body->size);
	body->solid = ent->solid;
	body->clipmask = ent->clipmask;
	body->owner = ent->owner;
	body->movetype = MOVETYPE_STEP;
	body->mass = 150;
	body_moan(body) = level.time + 12;
	body_team(body) = ent->client->resp.team;
	body_respawn(body) = level.time + 900;
	body_laser(body) = ent->client->resp.laser;
	body_melt(body) = 0;

	body->die = freeze_die;
	body->takedamage = DAMAGE_YES;

	body->think = freeze_think;
	body->nextthink = level.time + FRAMETIME;

	body_hook(body) = 0;
	if (Is_hook(ent))
	{
		int	i;
		edict_t	*e2;

		for (i = 0; i < globals.num_edicts; i++)
		{
			e2 = &g_edicts[i];
			if (!e2->inuse)
				continue;
			if (e2->owner != ent)
				continue;
			if (!e2->classname || Q_stricmp(e2->classname, "hook"))
				continue;
			e2->owner = body;
			body_hook(body) = hook_in;
		}
	}

	gi.linkentity(body);
}

void player_sight(edict_t *ent)
{
	float	best_dot = 0.7;
	int	sight = 0;
	vec3_t	spot1, spot2;
	vec3_t	forward;
	int	i;
	edict_t	*other;
	vec3_t	dist;
	trace_t	trace;
	float	dot;

	if (ent->client->chase_target || level.intermissiontime)
	{
		ent->client->sight = 0;
		return;
	}
	if (level.framenum % 5)
		return;

	VectorCopy(ent->s.origin, spot1);
	spot1[2] += ent->viewheight;
	AngleVectors(ent->s.angles, forward, NULL, NULL);

	loopPlayer
	{
		g_(other)
		if (other->client->resp.spectator)
			continue;
		if (other == ent)
			continue;
		if (other->light_level < 10)
			continue;
		if (other->health < 1)
			continue;
		VectorCopy(other->s.origin, spot2);
		spot2[2] += other->viewheight;
		VectorSubtract(spot2, spot1, dist);
		if (VectorLength(dist) > 800)
			continue;
		trace = gi.trace(spot1, vec3_origin, vec3_origin, spot2, ent, MASK_OPAQUE);
		if (trace.fraction != 1)
			continue;
		VectorNormalize(dist);
		dot = _DotProduct(dist, forward);
		if (dot > best_dot)
		{
			best_dot = dot;
			sight = other - g_edicts;
		}
		if (ent->client->resp.splash)
		{
			if (dot < 0.7)
				continue;
			if (Is_team(other) != Is_team(ent))
				continue;

			gi.WriteByte(svc_temp_entity);
			gi.WriteByte(TE_SPLASH);
			gi.WriteByte(8);
			gi.WritePosition(spot2);
			gi.WriteDir(vec3_origin);
			gi.WriteByte(SPLASH_SLIME);
			gi.unicast(ent, true);
		}
	}

	if (sight)
		ent->client->sight = sight;
	else
		ent->client->sight = 0;
}

void Cmd_Splash_f(edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH, "usage: flashlight\n");
	if (ent->client->resp.splash)
		ent->client->resp.splash = false;
	else
		ent->client->resp.splash = true;
}

void Cmd_Laser_f(edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH, "usage: vote\n");
	if (Is_hook(ent) || !ent->client->resp.oldhook)
		return;
	if (ent->client->resp.laser)
		ent->client->resp.laser = false;
	else
		ent->client->resp.laser = true;
}

void Cmd_Vote_f(edict_t *ent)
{
	char	*s;
	int	i;

	s = gi.argv(1);
	if (!*s)
	{
		return;
	}

	for (i = 0; i < maplist_size; i++)
	{
		if (!maplist[i].name)
			break;
		if (Q_stricmp(maplist[i].name, s))
			break;
	}
}

static void sayArmor(edict_t *ent, char *buf)
{
	int	power_armor_type;
	int	cells;
	int	armor_type;
	gitem_t	*item;

	*buf = 0;
	power_armor_type = PowerArmorType(ent);
	if (power_armor_type)
	{
		cells = ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))];
		if (cells)
			sprintf(buf + strlen(buf), "%s with %d cells", power_armor_type == POWER_ARMOR_SCREEN ? "Power Screen" : "Power Shield", cells);
	}
	armor_type = ArmorIndex(ent);
	if (armor_type)
	{
		item = GetItemByIndex(armor_type);
		if (item)
		{
			if (*buf)
				strcat(buf, " and ");
			sprintf(buf + strlen(buf), "%i units of %s", ent->client->pers.inventory[armor_type], item->pickup_name);
		}
	}
	if (!*buf)
		strcpy(buf, "no armor");
}

static void sayHealth(edict_t *ent, char *buf)
{
	if (ent->health <= 0)
		strcpy(buf, "dead");
	else
		sprintf(buf, "%i health", ent->health);
}

static void sayTech(edict_t *ent, char *buf)
{
	strcpy(buf, "none");
}

static void sayWeapon(edict_t *ent, char *buf)
{
	if (ent->client->pers.weapon)
		strcpy(buf, ent->client->pers.weapon->pickup_name);
	else
		strcpy(buf, "none");
}

static qboolean loc_cansee(edict_t *targ, edict_t *inflictor)
{
	vec3_t	viewpoint;
	trace_t	trace;

	if (targ->movetype == MOVETYPE_PUSH)
		return false;
	if (targ->spawnflags &(DROPPED_ITEM | DROPPED_PLAYER_ITEM))
		return false;
	VectorCopy(inflictor->s.origin, viewpoint);
	viewpoint[2] += inflictor->viewheight;
	trace = gi.trace(viewpoint, vec3_origin, vec3_origin, targ->s.origin, inflictor, MASK_SOLID);
	if (trace.fraction == 1)
		return true;
	else
		return false;
}

static void saySight(edict_t *who, char *buf)
{
	char	s[1024], s2[1024];
	int	i;
	edict_t	*targ;
	int	n = 0;

	*s = 0;
	*s2 = 0;
	loopPlayer
	{
		g_(targ)
		if (targ == who || targ->client->resp.spectator || targ->deadflag)
			continue;
		if (!loc_cansee(targ, who))
			continue;
		if (*s2)
		{
			if (strlen(s) + strlen(s2) + 3 < sizeof(s))
			{
				if (n)
					strcat(s, ", ");
				strcat(s, s2);
				*s2 = 0;
			}
			n++;
		}
		strcpy(s2, targ->client->pers.netname);
	}
	if (*s2 && !level.intermissiontime)
	{
		if (strlen(s) + strlen(s2) + 6 < sizeof(s))
		{
			if (n)
				strcat(s, " and ");
			strcat(s, s2);
		}
		strcpy(buf, s);
	}
	else
		strcpy(buf, "no one");
}

static edict_t *loc_findradius(edict_t *from, vec3_t org, float rad)
{
	int	j;
	vec3_t	eorg;

	if (!from)
		from = g_edicts;
	else
		from++;
	for (; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (!from->inuse)
			continue;
		for (j = 0; j < 3; j++)
			eorg[j] = org[j] - (from->s.origin[j] + (from->mins[j] + from->maxs[j]) * 0.5);
		if (VectorLength(eorg) > rad)
			continue;
		return from;
	}
	return NULL;
}

struct {
	char	*classname;
	int	priority;
} loc_names[] = {
	{"item_quad", 1}, 
	{"item_invulnerability", 1}, 
	{"weapon_bfg", 2}, 
	{"weapon_railgun", 2}, 
	{"weapon_rocketlauncher", 3}, 
	{"weapon_hyperblaster", 3}, 
	{"weapon_chaingun", 3}, 
	{"weapon_grenadelauncher", 3}, 
	{"weapon_machinegun", 3}, 
	{"weapon_supershotgun", 3}, 
	{"weapon_shotgun", 3}, 
	{"item_power_screen", 4}, 
	{"item_power_shield", 4}, 
	{"item_armor_body", 5}, 
	{"item_armor_combat", 5}, 
	{"item_armor_jacket", 5}, 
	{"item_silencer", 6}, 
	{"item_breather", 6}, 
	{"item_enviro", 6}, 
	{"item_adrenaline", 7}, 
	{"item_bandolier", 7}, 
	{"item_pack", 7}, 
	{NULL, 0}
};

static void sayLocation(edict_t *who, char *buf)
{
	edict_t	*what = NULL;
	int	i;
	qboolean	cansee;
	qboolean	hotsee = false;
	int	hotindex = 999;
	edict_t	*hot = NULL;
	vec3_t	v;
	float	hotdist = 999999;
	float	newdist;
	gitem_t	*item;

	while ((what = loc_findradius(what, who->s.origin, 1024)) != NULL)
	{
		for (i = 0; loc_names[i].classname; i++)
		{
			if (strcmp(what->classname, loc_names[i].classname) == 0)
				break;
		}
		if (!loc_names[i].classname)
			continue;
		cansee = loc_cansee(what, who);
		if (cansee && !hotsee)
		{
			hotsee = true;
			hotindex = loc_names[i].priority;
			hot = what;
			VectorSubtract(what->s.origin, who->s.origin, v);
			hotdist = VectorLength(v);
			continue;
		}
		if (hotsee && !cansee)
			continue;
		if (hotsee && hotindex < loc_names[i].priority)
			continue;
		VectorSubtract(what->s.origin, who->s.origin, v);
		newdist = VectorLength(v);
		if (newdist < hotdist || (cansee && loc_names[i].priority < hotindex))
		{
			hot = what;
			hotdist = newdist;
			hotindex = i;
			hotsee = loc_cansee(hot, who);
		}
	}
	if (!hot || (item = FindItemByClassname(hot->classname)) == NULL)
	{
		strcpy(buf, "nowhere");
		return;
	}
	if (who->waterlevel)
		strcpy(buf, "in the water ");
	else
		*buf = 0;
	VectorSubtract(who->s.origin, hot->s.origin, v);
	if (fabs(v[2]) > fabs(v[0]) && fabs(v[2]) > fabs(v[1]))
	{
		if (v[2] > 0)
			strcat(buf, "above the ");
		else
			strcat(buf, "below the ");
	}
	else
		strcat(buf, "near the ");
	strcat(buf, item->pickup_name);
}

static qboolean floodCheck(edict_t *ent)
{
	gclient_t	*cl;
	int	i;

	if (flood_msgs->value)
	{
		cl = ent->client;
		if (level.time < cl->flood_locktill)
		{
			gi.cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n", (int)(cl->flood_locktill - level.time));
			return true;
		}
		i = cl->flood_whenhead - flood_msgs->value + 1;
		if (i < 0)
			i = (sizeof(cl->flood_when) / sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && level.time - cl->flood_when[i] < flood_persecond->value)
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
			gi.cprintf(ent, PRINT_CHAT, "You can't talk for %d seconds.\n", (int)flood_waitdelay->value);
			return true;
		}
		cl->flood_whenhead = (cl->flood_whenhead + 1) %(sizeof(cl->flood_when) / sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}
	return false;
}

void sayTeam(edict_t *who)
{
	char	outmsg[1024];
	char	*p;
	char	buf[1024];
	int	i;
	edict_t	*cl_ent;
	char	*msg;

	if (floodCheck(who))
		return;
	msg = gi.args();
	outmsg[0] = 0;
	if (*msg == '\"')
	{
		msg[strlen(msg) - 1] = 0;
		msg++;
	}
	for (p = outmsg; *msg && p - outmsg < sizeof(outmsg) - 1; msg++)
	{
		if (*msg == '%')
		{
			switch (*++msg)
			{
			case 'l':
			case 'L':
				sayLocation(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			case 'a':
			case 'A':
				sayArmor(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			case 't':
			case 'T':
				sayTech(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			case 'h':
			case 'H':
				sayHealth(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			case 'w':
			case 'W':
				sayWeapon(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			case 'n':
			case 'N':
				saySight(who, buf);
				strcpy(p, buf);
				p += strlen(buf);
				break;
			default:
				*p++ = *msg;
			}
		}
		else
			*p++ = *msg;
	}

	*p = 0;
	if (strlen(outmsg) > 150)
		outmsg[150] = 0;
	loopPlayer
	{
		g_(cl_ent)
		if (Is_team(cl_ent) != Is_team(who))
			continue;
		gi.cprintf(cl_ent, PRINT_CHAT, "(%s): %s\n", who->client->pers.netname, outmsg);
	}
	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "(%s): %s\n", who->client->pers.netname, outmsg);
}
