/* os.cpp
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Brian Risinger contact info:

troz_@xoommail.com		preferred
troz_@hotmail.com		also ok
risinger@hoflink.com	if unable to reach otherwise

98 Stone Lane
Levittown, NY  11756
USA

*/


//This file has functions for all operating system specific calls.
//if you find something that is operaing system specific, please move it
// into this file to make porting easier.  That way only os.h and os.cpp
// need to be ported to have Fragistics run on another operating system.
// if something here doesn't work, put an #ifdef WIN32 around it and add an
// ifdef for your OS.  Then send the update to troz_@xoommail.com for future releases 

#include <stdio.h>
#include "os.h"
#include "defines.h"



#ifdef WIN32
//for Sleep
#include <windows.h>
#include <winbase.h>
#endif





#ifndef WIN32
// No itoa() in libc
char *itoa(int value, char *string, int radix){
	if (radix != 10){
		fprintf(stderr, "This version of itoa() only supports a radix of 10\n");
		exit(1);
	}
	sprintf(string, "%d", value);
	return string;
}

char getch(){
	char a='\0';
	while(a=='\0'){
		a=getchar();
	}
}
#endif



///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


bool File::Exists(){
	//not used yet
	return false;
}

int File::OpenRead(){
	fp=fopen(name,"r");
	if(fp==NULL){
		return false;
	}
	open=true;
	read=true;
	return true;
}

int File::OpenWrite(){
	fp=fopen(name,"w+");		//write and create
	if(fp==NULL){
		fp=NULL;
		return false;
	}
	open=true;
	write=true;
	return true;
}


int File::Close(){
	if(open==true && fp!=NULL){
		fclose(fp);
		open=false;
		read=false;
		write=false;
		fp=NULL;
		return true;
	}
	return false;
}


char *File::ReadLine(char *buf,int bufsize){
	if(open==true && read==true){
		return fgets(buf,bufsize,fp);
	}
	return NULL;
}

int File::WriteLine(const char *buf){
	if(open==true && write==true){
		fprintf(fp,"%s\n",buf);
		return true;
	}
	return false;
}
int File::WriteStr(const char *buf){
	if(open==true && write==true){
		fputs(buf,fp);
		return true;
	}
	return false;
}

bool File::GetFile(string *buf){
	if(!OpenRead())
		return false;
	char tmp[1024];

	buf->erase();
	while(ReadLine(tmp,1023)!=NULL)
		(*buf)+=tmp;

	Close();
	return true;
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////




int OS::SetLowPriority(){
	return false;
}


void OS::Delay(int seconds){
#ifdef WIN32
	Sleep(seconds*1000);
#endif //WINDOWS
}

#ifdef WIN32
const char OS::PathSeparator = '\\';
#else
const char OS::PathSeparator = '/';
#endif



int OS::GetVersion(char *ver,int size){
	//puts the program version into ver and return 0 or returns the size needed for ver if ver is too small
#ifdef WIN32
	//todo read from resource
	if(size>=10){
		sprintf(ver,"1.5");
		return 0;
	}
	return 10;
	
#else //WIN32

	if(size>=10){
		sprintf(ver,"1.5");
		return 0;
	}
	return 10;
#endif //WIN32

	
}