/* main.cpp
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Brian Risinger contact info:

troz_@xoommail.com		preferred
troz_@hotmail.com		also ok
risinger@hoflink.com	if unable to reach otherwise

98 Stone Lane
Levittown, NY  11756
USA

*/


#include <string>
#ifdef WIN32
#include <conio.h>
#else
#include <stdio.h>
#endif

#include "os.h"
#include "stats.h"
#include "htmlfile.h"
#include "settings.h"
#include "database.h"


extern char kill_strings[26][32];


OS os;
Settings settings;
ErrorLog *logparserLog;
ErrorLog *templateparserLog;
ErrorLog *custrankLog;
ErrorLog *mainLog;

int main(int argc ,char** argv){

	bool error=false;
	bool pause=false;

	mainLog=new ErrorLog("fragistics.log.txt");
	logparserLog=new ErrorLog("logparser.log.txt");
	templateparserLog=new ErrorLog("templateparser.log.txt");
	custrankLog=new ErrorLog("custrank.log.txt");
	mainLog->setTimestamp(false);
	logparserLog->setTimestamp(false);
	templateparserLog->setTimestamp(false);
	custrankLog->setTimestamp(false);

	char ver[50];
	os.GetVersion(ver,50);

/*
	printf("Fragistics version %s, Copyright (C) 2000  Brian Risinger\n",ver);
	printf("Fragistics comes with ABSOLUTELY NO WARRANTY.\n");
	printf("This is free software, and you are welcome\n");
	printf("to redistribute it under certain conditions;\n");
	printf("For details, see the readme.txt that should have come with\n");
	printf("this program or see http://www.planetquake.com/fragistics\n");
	*/
	mainLog->Log(ErrorLog.FORCEBOTH,"Fragistics version %s, Copyright (C) 2000  Brian Risinger",ver);
	mainLog->Log(ErrorLog.FORCEBOTH,"Fragistics comes with ABSOLUTELY NO WARRANTY.");
	mainLog->Log(ErrorLog.FORCEBOTH,"This is free software, and you are welcome");
	mainLog->Log(ErrorLog.FORCEBOTH,"to redistribute it under certain conditions;");
	mainLog->Log(ErrorLog.FORCEBOTH,"For details, see the readme.txt that should have come with");
	mainLog->Log(ErrorLog.FORCEBOTH,"this program or see http://www.planetquake.com/fragistics\n");
	mainLog->setTimestamp(true);
//	os.Delay(2);


/*test 1
	CrossTable *ct;
	ct=new CrossTable();

	ct->AddName("brian");

	delete ct;
	*/

/*test 2
	SimplePlayer *troz;
	HTMLFile *test;
	string temp;

	troz = new SimplePlayer("^6T^4r^5o^2Z");
	test = new HTMLFile("test.html");

	if(test->Open()){
		test->Write("<html><head><title>Test</title></head>");
		test->Write("<body bgcolor=\"#808080\">");

		troz->Write(&temp);
		test->Write(&temp);

		test->Write("<P>");
		temp.erase();

		troz->Write(&temp,true);
		test->Write(&temp);

		test->Write("</body></html>");
	}else{
		printf("failed to open file");
	}

	delete troz;
	delete test;
*/

/*test 3
	Stats *stats;
	stats=new Stats("games.log");

	if(stats->ParseFile()){
		printf("\n%d games played\n%d players\n%d kills\n%d items\n\n",stats->games,stats->players,stats->kills,stats->items);
	}else{
		printf("\nunable to open file");
	}
*/


/* test 4 - this was actually simpler before but was converted to tests 5 and 6 and to near final code
	Stats *stats;
	stats=new Stats("games.log");

	if(stats->ParseFile()){
		HTMLFile *test;
		string temp,temp2;
		char numbuf[50];

		
		printf("\nGames List Page\n");

		temp="<HTML><HEAD>\n";
		temp+="<title>Last Game</title>\n</head>\n";
		//temp+="<body bgcolor=\"#808080\">";
		temp+="<body bgcolor=\"#000000\" text=\"999999\" link=\"#0000ff\" vlink=\"#ff0000\" alink=\"00ff00\">";
		temp+="You have gone past the last game.<P>Please choose one of the following<br>\n<a href=\"games.html\">Games List</a> <a href=\"stats.html\">Overall Stats</a> <a href=\"players.html\">Player stats</a>\n</body></html>";

//		test = new HTMLFile("game0.html");
//		if(test->Open()){
//			test->Write(&temp);
//		}else{
//			printf("failed to open game0 html file");
//		}
//		delete test;
//		test=NULL;

		sprintf(numbuf,"game%d.html",stats->games+1);
		test = new HTMLFile(numbuf);
		if(test->Open()){
			test->Write(&temp);
		}else{
			printf("failed to open %s html file",numbuf);
		}
		delete test;
		test=NULL;
		temp.erase();


		test = new HTMLFile("games.html");

		if(test->Open()){

			test->Write(&stats->gamelisthtml);
			test->Write("</table>");
			test->Write("<P><HR><P><font size=-2>This file was generated by <a href=\"http://members.xoom.com/TroZ_/q3logger/index.html\">Q3Logger</a></font>");
			test->Write("</body></html>");
		}else{
			printf("failed to open gamelist html file");
		}

		delete test;
		test=NULL;

		printf("\nPlayer Stats\n");
		printf("%d players\n",stats->player_list.GetCount());

		test = new HTMLFile("players.html");

		if(test->Open()){
			test->Write("<html><head><title>Player Stats</title></head>");
			//test->Write("<body bgcolor=\"#808080\"><CENTER>");
			test->Write("<body bgcolor=\"#000000\" text=\"999999\" link=\"#0000ff\" vlink=\"#ff0000\" alink=\"00ff00\"><center>");
			
			test->Write("<h1>Player Stats</H1>");
			test->Write("<P><HR><P>");
			test->Write("<a href=\"stats.html\">Overall Stats</a> <a href=\"games.html\">Game Stats</a>");
			test->Write("<P><HR><P>");
			test->Write("<H3>Player Ranks</H3>");
			
			test->Write("<table border=1>");
			test->Write("<tr><td>&nbsp;</TD><td colspan=2>Games</td><td colspan=2>Time</td><td colspan=2>Kills</td><td colspan=2>Deaths</td><td colspan=2>Suicides</td><td colspan=2>Frags</td><td colspan=2>Efficiency</td><td colspan=2>Items</td></TR>");

			PList game,time,kill,death,suicide,frag,eff,item;
			game.DupeList(&stats->player_list);
			time.DupeList(&stats->player_list);
			kill.DupeList(&stats->player_list);
			death.DupeList(&stats->player_list);
			suicide.DupeList(&stats->player_list);
			frag.DupeList(&stats->player_list);
			eff.DupeList(&stats->player_list);
			item.DupeList(&stats->player_list);
			game.ReSortList(0);
			time.ReSortList(1);
			kill.ReSortList(2);
			death.ReSortList(3);
			suicide.ReSortList(4);
			frag.ReSortList(5);
			eff.ReSortList(6);
			item.ReSortList(7);

			Player *g,*t,*k,*d,*s,*f,*e,*i;
			g=game.GetFirst();
			t=time.GetFirst();
			k=kill.GetFirst();
			d=death.GetFirst();
			s=suicide.GetFirst();
			f=frag.GetFirst();
			e=eff.GetFirst();
			i=item.GetFirst();
			int c=0;
			if(g!=NULL && t!=NULL && k!=NULL && d!=NULL && s!=NULL && f!=NULL && e!=NULL && i!=NULL ){
				do{
					c++;
					temp.erase();
					temp+="<tr><td>";
					temp+=itoa(c,numbuf,10);  //count
					temp+="</td><td>";
					temp2.erase();
					g->Write(&temp2);
					temp+=temp2;							//games name
					temp+="</td><td>";
					temp+=itoa(g->GetGames(),numbuf,10);	//games value
					temp+="</td><td>";
					temp2.erase();
					t->Write(&temp2);
					temp+=temp2;							//time name
					temp+="</td><td>";
					t->GetTimeStr(numbuf);
					temp+=numbuf;							//time value
					temp+="</td><td>";
					temp2.erase();
					k->Write(&temp2);
					temp+=temp2;							//kill name
					temp+="</td><td>";
					temp+=itoa(k->GetKill(0),numbuf,10);	//kill value
					temp+="</td><td>";
					temp2.erase();
					d->Write(&temp2);
					temp+=temp2;							//deaths name
					temp+="</td><td>";
					temp+=itoa(d->GetDeath(0),numbuf,10);	//deaths value
					temp+="</td><td>";
					temp2.erase();
					s->Write(&temp2);
					temp+=temp2;							//suicide name
					temp+="</td><td>";
					temp+=itoa(s->GetSuicide(0),numbuf,10);//suicide value
					temp+="</td><td>";
					temp2.erase();
					f->Write(&temp2);
					temp+=temp2;							//frag name
					temp+="</td><td>";
					temp+=itoa(f->GetFrags(0),numbuf,10);	//frag value
					temp+="</td><td>";
					temp2.erase();
					e->Write(&temp2);
					temp+=temp2;							//eff name
					temp+="</td><td>";
					e->GetEff(0,numbuf);
					temp+=numbuf;							//eff value
					temp+="</td><td>";
					temp2.erase();
					i->Write(&temp2);
					temp+=temp2;							//items name
					temp+="</td><td>";
					temp+=itoa(i->GetItemsTotal(),numbuf,10);//items value
					temp+="</td></tr>";
					test->Write(&temp);

					g=game.GetNext();
					t=time.GetNext();
					k=kill.GetNext();
					d=death.GetNext();
					s=suicide.GetNext();
					f=frag.GetNext();
					e=eff.GetNext();
					i=item.GetNext();
				}while(g!=NULL && t!=NULL && k!=NULL && d!=NULL && s!=NULL && f!=NULL && e!=NULL && i!=NULL );
			}
			test->Write("</table>");
					

			test->Write("<P><HR><P>");
			test->Write("<H3>Player Stats</H3>");
			Player *p;
			p=stats->player_list.GetFirst();
			if(p!=NULL){
				do{
					temp.erase();
					p->WriteStats(&temp,false);
					test->Write(&temp);
				}while((p=stats->player_list.GetNext())!=NULL);
			}
			
			test->Write("</table>");
			test->Write("<P><HR><P><font size=-2>This file was generated by <a href=\"http://members.xoom.com/TroZ_/q3logger/index.html\">Q3Logger</a></font>");
			test->Write("</body></html>");
		}else{
			printf("failed to open player html file");
		}

		delete test;
		test=NULL;



		printf("\nOverall Stats\n");
		test = new HTMLFile("stats.html");

		if(test->Open()){
			test->Write("<html><head><title>Overall Stats</title></head>");
			//test->Write("<body bgcolor=\"#808080\"><CENTER>");
			test->Write("<body bgcolor=\"#000000\" text=\"999999\" link=\"#0000ff\" vlink=\"#ff0000\" alink=\"00ff00\"><center>");

			temp="<h1>Overall Stats</H1>\n";
			temp+=itoa(stats->games,numbuf,10);
			temp+=" games played<BR>\n";
			temp+=itoa(stats->players,numbuf,10);
			temp+=" players / ";
			temp+=itoa(stats->player_list.GetCount(),numbuf,10);
			temp+=" unique players<BR>\n";
			temp+=itoa(stats->kills,numbuf,10);
			temp+=" kills<BR>\n";
			temp+=itoa(stats->items,numbuf,10);
			temp+=" items<BR>\n";
			int temptime=stats->time_sec;
			if(temptime>(60*60*24)){
				temp+=itoa((temptime/(60*60*24)),numbuf,10);
				temp+="&nbsp;D, ";
				temptime%=(60*60*24);
			}
			if(temptime>(60*60)){
				temp+=itoa((temptime/(60*60)),numbuf,10);
				temp+="&nbsp;H, ";
				temptime%=(60*60);
			}
			temp+=itoa((temptime/(60)),numbuf,10);
			temp+="&nbsp;M, ";
			temptime%=(60);
			temp+=itoa((temptime),numbuf,10);
			temp+="&nbsp;S";
			test->Write(&temp);

//			test->Write("Player List<BR>\n<TABLE>\n");
//			Player *p;
//			p=stats->player_list.GetFirst();
//			if(p!=NULL){
//				do{
//					temp.erase();
//					temp2.erase();
//					temp="<TR><TD>";
//					p->Write(&temp2,0);
//					temp+=temp2;
//					temp+="</TD><TD>";
//					temp+=p->GetModel();
//					temp+="</TD><TD>";
//					temp+=itoa(p->GetTeam(),numbuf,10);
//					temp+="</TD></TR>";
//					test->Write(&temp);
//				}while((p=stats->player_list.GetNext())!=NULL);
//			}
//			test->Write("</table>");

			test->Write("<P><HR><P>");
			test->Write("<a href=\"games.html\">Game Stats</a> <a href=\"players.html\">Player stats</a>");
			test->Write("<P><HR><P>");

			test->Write("<H3>Kills by Type</H3><P>");
			test->Write("<TABLE border=1>");
			
			int i;
			for(i=0;i<MAX_KILLTYPE;i+=2){

				test->Write("<TR><TD align=right>");
				test->Write(kill_strings[i]);
				test->Write("</TD>");
				test->Write("<TD>");
				itoa(stats->all_kills[i],numbuf,10);
				test->Write(numbuf);
				test->Write("</TD>\n");

				test->Write("<TD width=50></TD><TD align=right>");
				test->Write(kill_strings[i+1]);
				test->Write("</TD>");
				test->Write("<TD>");
				itoa(stats->all_kills[i+1],numbuf,10);
				test->Write(numbuf);
				test->Write("</TD></TR>\n");
			}
			
			test->Write("</table>\n");
				

			test->Write("<P><HR><P>");
			test->Write("<h3>Kill Tables</H3><P>");

			Player *p;
			for(i=0;i<CROSSTABLE_MAX_KILL;i++){
				//add players to table
				printf("rendering table %d\n",i);
				p=stats->player_list.GetFirst();
				if(p!=NULL){
					do{
						stats->killtypes[i].AddPlayer(p);	
					}while((p=stats->player_list.GetNext())!=NULL);
				}

				temp.erase();
				temp2.erase();
				temp2=kill_strings[i];
				temp2+="<BR>";
				test->Write(&temp2);
				stats->killtypes[i].WriteRowCompress(&temp);
				test->Write(&temp);
				test->Write("<P>");
			
			}


			test->Write("</CENTER>");
			test->Write("<P><HR><P><font size=-2>This file was generated by <a href=\"http://members.xoom.com/TroZ_/q3logger/index.html\">Q3Logger</a></font>");
			test->Write("</body></html>");
		}else{
			printf("failed to open stats html file");
		}

		


	}else{
		printf("\nunable to open log file");
	}

*/

/*test 8 - config file

config file used follows
------------------------
//This is a config file for Q3Logger
//By TroZ
// comments begin with //
;  or with ;

default=setting

[settings]
//these are settings
name=value
;or with spaces
 value = name

//eof
------------------------
there was no \r\n on the last line



	ConfigFile *cf;
	cf=new ConfigFile("config.cfg");

	string val;
	cf->GetValue("","default",&val);
	printf(" default =\'%s\'\n",(char*)val.c_str());

	cf->GetValue("settings","name",&val);
	printf(" settings/name =\'%s\'\n",(char*)val.c_str());

	cf->GetValue("settings","value",&val);
	printf(" settings/value =\'%s\'\n",(char*)val.c_str());

	cf->Write("config.new1.cfg");

	cf->AddValue("new","test","success");

	cf->Write("config.new2.cfg");

	delete cf;
*/



	
/*  real code  */

	settings.ParseSettings("fragistics.cfg",argc,argv);
	
	int i=0;
	Stats stats;
	string filename;
	database db(&stats);

	int dbstatus=DB_DONTADD;
	int logtype;
	int logdb;
	int startline=0;
	int temp;
	bool juststore=false;
	bool parse=true;

	//setup log files
	mainLog->setStatus(settings.GetELMain());
	logparserLog->setStatus(settings.GetELLog());
	templateparserLog->setStatus(settings.GetELTemplate());
	custrankLog->setStatus(settings.GetELCustRank());

	//see if any file are being added to database
	for(i=0;i<settings.GetLogsNumber();i++){
		temp=settings.GetLogsType(i)/1000;
		if(dbstatus<temp) dbstatus=temp;
	}
	if(dbstatus=DB_ACTIVEFILE) dbstatus=DB_FILESTORED;
	if(dbstatus>=DB_STOREFILE && settings.GetUseDB()){
		juststore=true;
	}

	if(settings.GetUseDB() && !juststore){
		mainLog->Log(ErrorLog.SEVERE,"Reading Database");
		db.read();
		mainLog->Log(ErrorLog.SEVERE,"Done Reading Database\n");
	}

	
	printf("\n");
	//parse all the log files
	for(i=0;i<settings.GetLogsNumber();i++){

		settings.GetLogsPath(i,&filename);
		FileParser *fparse=NULL;
				
		logtype=settings.GetLogsType(i);
		logdb=logtype/1000;
		logtype%=1000;
		startline=0;

		//figure out what to do with db
		if(settings.GetUseDB()){
			if(logdb>=dbstatus){
				//posible problem - cant skip a file 
				if(dbstatus==DB_FILESTORED && logdb==DB_STOREFILE && juststore){
					logdb=DB_FILESTORED;
				}else if(dbstatus==DB_FILESTORED && logdb==DB_STOREFILE && !juststore){
					logdb=DB_DONTADD;
				}else if(dbstatus==DB_ACTIVEFILE && logdb>=DB_ACTIVEFILE){
					logdb=DB_DONTADD;
				}else if(dbstatus==DB_DONTADD && logdb>DB_DONTADD){
					logdb=DB_DONTADD;
				}

				settings.SetLogsType(i,logdb*1000+logtype);
			}

			if( logdb==DB_ACTIVEFILE ){
				startline=db.GetStartLine();
			}

			//is it time to save database
			if(juststore && dbstatus<DB_FILESTORED){
				parse=false;
				mainLog->Log(ErrorLog.SEVERE,"\nWritting Database");
				db.write();
				mainLog->Log(ErrorLog.SEVERE,"Done Writting Database\n");
				
			}
			if(dbstatus>DB_DONTADD && logdb==DB_DONTADD && !juststore){
				mainLog->Log(ErrorLog.SEVERE,"\nWritting Database");
				db.write();
				mainLog->Log(ErrorLog.SEVERE,"Done Writting Database\n");
			}

		}

		if(parse){
			mainLog->Log(ErrorLog.SEVERE,"Parsing file %s",filename.c_str());
			mainLog->incTab();
			//get correct parser for file
			switch(logtype){
			case LOGTYPE_GAMESLOG:
				fparse=new GameslogParser(&filename,&stats);
				break;
			default:	fparse=NULL; break;
			}

			//parse file
			if(fparse!=NULL){
				stats.SetCurrentFile(filename.c_str(),startline);
				
				if(fparse->Parse(startline)==true){
					mainLog->decTab();
					mainLog->Log(ErrorLog.SEVERE,"Done Parsing file %s\n",filename.c_str());
				}else{
					mainLog->decTab();
					error=true;
					mainLog->Log(ErrorLog.SEVERE,"ERROR Parsing file %s!\n",filename.c_str());
					break;
				}
				delete fparse;
			}else{
				mainLog->decTab();
				pause=true;
				mainLog->Log(ErrorLog.SEVERE,"ERROR - Unknown file type: %d for %s!\n",logtype,filename.c_str());
			}
			fparse=NULL;
			
		}

		dbstatus=logdb;

	}
	delete custrankLog;
	delete logparserLog;

	//is it time to save database
	if(settings.GetUseDB() && dbstatus>DB_DONTADD && !juststore){
		mainLog->Log(ErrorLog.SEVERE,"Writting Database");
		db.write();
		mainLog->Log(ErrorLog.SEVERE,"Done Writting Database\n");
	}

	if(error==false ){
//old way with hard coded pages
//		bool result;
//		result=stats.WriteMainStats();
//		error=(!result);
		mainLog->Log(ErrorLog.SEVERE,"Writting Main Stats");
		error=stats.WriteMainStats();
		if(error)
			mainLog->Log(ErrorLog.SEVERE,"Error writing main stats!\n");
	}
	
	delete templateparserLog;
	delete mainLog;

#ifdef _DEBUG
	pause=true;
#endif

	if(pause || error){
		printf("\n\nPress a key");
		char c=getch();
	}

	return 0;
}



