/* htmlfile.h
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

see htmlfile.cpp or main.cpp for license info
*/

#ifndef HTMLFILE_H_INCLUDED
#define HTMLFILE_H_INCLUDED


#include <stdio.h>
#include <string>
#include "os.h"
#include "settings.h"
#include "stats.h"

extern Settings settings;

using namespace std;




bool GetNextWord(string *text,string *word);




class HTMLFile {
	File *fp;

	
public:
	HTMLFile( char* filename);
	~HTMLFile(){
		if(fp!=NULL){
			fp->Close();
			delete fp;
		}
	};

	bool Open();

	bool Write(string *str);
	bool Write(const char *str);

	bool WriteHeader(const char *title);

};



class HtmlTemplate {

/* 

Implements a class to parse html templates for reporting the stats
##variable_name##	is replaced by the value of the variable
$$file_name$$		is replaced by the parsed contents of the file 'file_name' in the path contained by the srcpath variable
**IF( condition )**  **ELSE**  **ENDIF**	implements if then else functionality where
					condition is made up of  value operator value
					value <- variable_name || "const" ||  ( condition )
					operator <- &&, ||, >, <, =, <=, >=, !=
@@LOOP( loop_name )@@  @@ENDLOOP@@			implements loop functionality where loop_name
					is the name of a special loop variable.  Inside the loop, you can access parameters of that iteration of the loop
!!format,expression!!		is replaces by the value of the evualted experssion  (math)
					expression consists of variables and operators  
					format specifies the output format such as %2.2f or %g
					format is optional and defaults to %f

*/
private:
	string srcpath;
	string destpath;

	File *srcfile;
	File *destfile;
	bool closedest;

	Stats *stats;
public:
	HtmlTemplate( Stats *stat, File *dest = NULL){
		stats=stat;
		srcfile=NULL;
		destfile=dest;
		closedest=false;
	};
	HtmlTemplate(const char *src, Stats *stat, File *dest = NULL){
		string temp;
		stats=stat;
		srcfile=NULL;
		destfile=dest;
		closedest=false;

		settings.GetTemplateSrcpath(&srcpath);
		if(srcpath.length()>0){
			temp=srcpath;
			temp+=os.PathSeparator;
		}
		temp+=src;
		if(strstr(src,".htmlt")==NULL)
			temp+=".htmlt";
		srcpath=temp;
		srcfile=os.GetFile(srcpath.c_str());
	};
	HtmlTemplate(const char *src, const char *dest, Stats *stat){
		string temp,ext;
		stats=stat;
		srcfile=NULL;
		destfile=NULL;
		closedest=true;

		settings.GetHTMLFileExt(&ext);

		settings.GetTemplateDestpath(&destpath);
		settings.GetTemplateSrcpath(&srcpath);
		if(srcpath.length()>0){
			temp=srcpath;
			temp+=os.PathSeparator;
		}
		temp+=src;
		if(strstr(src,".htmlt")==NULL)
			temp+=".htmlt";
		srcpath=temp;
		srcfile=os.GetFile(srcpath.c_str());
		temp.erase();
		if(destpath.length()>0){
			temp=destpath;
			temp+=os.PathSeparator;
		}
		temp+=dest;
		if(strstr(dest,ext.c_str())==NULL)
			temp+=ext.c_str();
		destpath=temp;
		destfile=os.GetFile(destpath.c_str());
	};
	~HtmlTemplate(){
		if(srcfile)
			delete srcfile;
		if(destfile && closedest)
			delete destfile;
	};

	bool Write();
	bool ParseFile(string *buf);	//parses the source file, puts result in buffer
	
	void Parse(char *text, string *buf);		//parses the text, calls ParseToken to interpret the tokens in the text 
	
private:
	char* ParseToken(char *token, string *buf);  //parses the first token in the string token and removes it from that string, returns the parsed token in buf

	bool Eval(char *condition);

	//void DoLoop(string *looptype,string *text,string *result);
	char* DoLoop(char *looptype,char *text,string *result);
	char* DoIf(char *condition,char *text,string *result);

	void Compute(char *expression, string *buf);  //parses the expression
	
};

#endif //HTMLFILE_H_INCLUDED