/* htmlfile.cpp
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Brian Risinger contact info:

troz_@xoommail.com		preferred
troz_@hotmail.com		also ok
risinger@hoflink.com	if unable to reach otherwise

98 Stone Lane
Levittown, NY  11756
USA

*/

#include "htmlfile.h"
#include "settings.h"


extern OS os;
extern Settings settings;
extern ErrorLog *templateparserLog;



bool GetNextWord(string *text,string *word){
	int pos;
	pos=text->find_first_of(' ');
	if(pos>-1){
		(*word)=text->substr(0,pos+1);
		(*text)=text->substr(pos+1);
		return true;
	}else{
		(*word)=(*text);
		text->erase();
		return false;
	}
}





HTMLFile::HTMLFile( char* filename){
	fp=os.GetFile(filename);
};

bool HTMLFile::Open(){
	if(fp->OpenWrite())
		return true;
	else{
		delete fp;
		fp=NULL;
		return false;
	}
}


bool HTMLFile::Write(string *str){
	if(!fp->canWrite()) return false;
	fp->WriteLine((char*)(*str).c_str());
	return true;
};

bool HTMLFile::Write(const char *str){
	if(!fp->canWrite()) return false;
	fp->WriteLine(str);
	return true;
};

bool HTMLFile::WriteHeader(const char *title){
	string temp,tmp;

	temp = "<html><head>\n<title>";
	temp+= title;
	temp+= "</title>\n</head>";
	temp+= "<body bgcolor=\"";
	settings.GetColorBg(&tmp);
	temp+= tmp;
	temp+= "\" text=\"";
	settings.GetColorText(&tmp);
	temp+= tmp;
	temp+= "\" link=\"";
	settings.GetColorLink(&tmp);
	temp+= tmp;
	temp+= "\" vlink=\"";
	settings.GetColorVlink(&tmp);
	temp+= tmp;
	temp+= "\" alink=\"";
	settings.GetColorAlink(&tmp);
	temp+= tmp;
	temp+= "\">";

	return Write(&temp);
};





bool HtmlTemplate::Write(){
	string source;
	source.erase();

	templateparserLog->setTimestamp(true);
	templateparserLog->Log(ErrorLog.NORMAL,"Parsing file %s to file %s",srcpath.c_str(),destpath.c_str());
	templateparserLog->setTimestamp(false);
	
	if(!srcfile->GetFile(&source)){
		templateparserLog->Log(ErrorLog.SEVERE,"Error opening template %s for reading!",srcfile->GetName());
		return false;
	}
	if(!destfile->OpenWrite()){
		templateparserLog->Log(ErrorLog.SEVERE,"Error opening %s for writing!",destfile->GetName());
		return false;
	}

	//now parse file - file contains plain-text with tokens inserted
	char *text=new char[source.length()+2];
	if(text!=NULL){
		templateparserLog->incTab();
		strcpy(text,source.c_str());
		Parse(text,NULL);
		templateparserLog->decTab();
	}else{
		templateparserLog->Log(ErrorLog.SEVERE,"OUT OF MEMORY ERROR!\n");
		destfile->Close();
		return false;
	}
	delete text;
	
	templateparserLog->setTimestamp(true);
	templateparserLog->Log(ErrorLog.NORMAL,"Done.");
	templateparserLog->setTimestamp(false);
	destfile->Close();
	return true;
}


bool HtmlTemplate::ParseFile(string *buf){
	string source;
	source.erase();

	templateparserLog->setTimestamp(true);
	if(destfile!=NULL && destfile->canWrite()){
		templateparserLog->Log(ErrorLog.NORMAL,"Parsing file %s to %s",srcpath.c_str(),destfile->GetName());
	}else{
		templateparserLog->Log(ErrorLog.NORMAL,"Parsing file %s to a buffer",srcpath.c_str());
	}
	templateparserLog->setTimestamp(false);

	//very similar to Write above
	if(!srcfile->GetFile(&source)){
		templateparserLog->Log(ErrorLog.SEVERE,"Error opening template %s for reading!",srcfile->GetName());
		return false;
	}
	
	if(buf)
		buf->erase();

	//now parse file - file contains plain-text with tokens inserted
	char *text=new char[source.length()+2];
	if(text!=NULL){
		templateparserLog->incTab();
		strcpy(text,source.c_str());
		Parse(text,buf);
		templateparserLog->decTab();
	}else{
		templateparserLog->Log(ErrorLog.SEVERE,"OUT OF MEMORY ERROR!\n");
		return false;
	}
	delete text;

	templateparserLog->setTimestamp(true);
	templateparserLog->Log(ErrorLog.NORMAL,"Done.");
	templateparserLog->setTimestamp(false);
	return true;

}

void HtmlTemplate::Parse(char *text, string *buf){
// write out the plain text  find and parse tokens, write out result
	char *pos,tempc,*end;
	char *eepos=text-1,*sspos=text-1,*ddpos=text-1,*aapos=text-1,*pppos=text-1;
	string temp;
	if(buf!=NULL)
		buf->erase();
	end=text+strlen(text);
	pos=text;
	while(end>text && pos>=text && pos<end){
		
		pos=end;

		//find first tag
		if(pppos<text && pppos!=NULL)
			pppos=strstr(text,"##");
		if(pppos!=NULL && pppos<pos)
			pos=pppos;

		if(eepos<text && eepos!=NULL)
			eepos=strstr(text,"!!");
		if(eepos!=NULL && eepos<pos)
			pos=eepos;
		
		if(sspos<text && sspos!=NULL)
			sspos=strstr(text,"**");
		if(sspos!=NULL && sspos<pos)
			pos=sspos;
		
		if(aapos<text && aapos!=NULL)
			aapos=strstr(text,"@@");
		if(aapos!=NULL && aapos<pos)
			pos=aapos;

		if(ddpos<text && ddpos!=NULL)
			ddpos=strstr(text,"$$");
		if(ddpos!=NULL && ddpos<pos)
			pos=ddpos;
		
		if(pos!=NULL && pos<end){
			tempc=*pos;
			*pos='\0';
			if(buf!=NULL)
				buf->append(text);
			else if(destfile!=NULL && destfile->canWrite())
				destfile->WriteStr(text);
			else {templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!"); return;};
			*pos=tempc;
			text=pos;

			if(buf!=NULL){
				temp.erase();
				text=ParseToken(text,&temp);
				buf->append(temp);
			}else if(destfile!=NULL && destfile->canWrite())
				text=ParseToken(text,NULL);
			else {templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!"); return;};
			
			pos=text;
		}
	}

	if(text!=NULL && text[0]!='\0'){
		if(buf!=NULL)
			buf->append(text);
		else if(destfile!=NULL && destfile->canWrite())
			destfile->WriteStr(text);
		else {templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!"); return;};
	}

}


char* HtmlTemplate::ParseToken(char *token, string *buf){
	
	char type;
	type=token[0];

	char *param;
	param=token+2;

	switch(type){
	case '#':{
				token=strstr(param,"##");
				if(token!=NULL){
					*token='\0';
					token+=2;
			
					stats->GetVariableValue(param,buf,destfile);
					
				}else{
					templateparserLog->Log(ErrorLog.SEVERE,"Bad Variable - no end: %s\n", param);
				}
			 }
		break;
	case '$':{
				token=strstr(param,"$$");
				if(token!=NULL){
					*token='\0';
					token+=2;

					HtmlTemplate *temph=new HtmlTemplate(param,stats,destfile);
					if(buf!=NULL)
						temph->ParseFile(buf);
					else if(destfile!=NULL && destfile->canWrite()){
						temph->ParseFile(NULL);
					}else {templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!"); return token;};
					delete temph;

				}else{
					templateparserLog->Log(ErrorLog.SEVERE,"Bad Include - no end: %s\n", param);
				}
			 }
		break;
	case '*':{
				token=strstr(param,"**");
				if(token!=NULL){
					*token='\0';
					token+=2;
				
					if(strncmp(param,"IF(",3)){
						templateparserLog->Log(ErrorLog.SEVERE,"Got \'%s\' while expecting \'IF(\'\n",param);
						return token;
					}
					param+=3;
					param[strlen(param)-1]='\0';
					os.TrimStr(param);
					token=DoIf(param,token,buf);
				}else{
					templateparserLog->Log(ErrorLog.SEVERE,"Bad IF - no end: %s\n", param);
				}
			 }
		break;
	case '@':{
				token=strstr(param,"@@");
				if(token!=NULL){
					*token='\0';
					token+=2;

					if(strncmp(param,"LOOP(",5)){
						templateparserLog->Log(ErrorLog.SEVERE,"ENDLOOP while not in loop\n");
						return token;
					}
					//param=param.substr(5,param.length()-6);
					param+=5;
					param[strlen(param)-1]='\0';
//					char paramt[256];
//					strncpy(paramt,param.c_str(),254);
//					paramt[255]='\0';
					os.TrimStr(param);
					//todo:change to char*

					token=DoLoop(param,token,buf);

				}else{
					templateparserLog->Log(ErrorLog.SEVERE,"Bad Loop - no end: %s\n", param);
				}
			 }
		break;
	case '!':{
				token=strstr(param,"!!");
				if(token!=NULL){
					*token='\0';
					token+=2;

					Compute(param,buf);

				}else{
					templateparserLog->Log(ErrorLog.SEVERE,"Bad Math - no end: %s\n", param);
				}
			 }
		break;
	}
	
	return token;
}

void HtmlTemplate::Compute(char *expression, string *buf){
	char format[50];
	char *temp;
	char *tempformat;
	char *pos;
	char numbuf[50];
	char formattype;
	int num;
	double result;

	//parse format
	pos=strchr(expression,',');
	if(pos!=NULL){
		strcpy(format,"%");
		tempformat=expression;
		*pos='\0';
		expression=pos+1;
		if(pos!=tempformat){
			formattype=*(pos-1);
			*(pos-1)='\0';
			if(formattype!='e' && formattype!='f' && formattype!='g'){
				formattype='f';
			}
			if(tempformat[0]=='%'){
				tempformat++;
			}
			pos=strchr(tempformat,'.');
			if(pos!=NULL){
				*pos='\0';
				temp=tempformat;
				tempformat=pos+1;
				if(temp[0]!='\0'){
					num=atoi(temp);
					strcat(format,itoa(num,numbuf,10));
				}
				if(tempformat[0]!='\0'){
					strcat(format,".");
					num=atoi(tempformat);
					strcat(format,itoa(num,numbuf,10));
				}
			}else{
				if(tempformat[0]!='\0'){
					num=atoi(tempformat);
					strcat(format,itoa(num,numbuf,10));
				}
			}
			num=strlen(format);
			format[num]=formattype;
			format[num+1]='\0';
		}else{
			strcat(format,".2f");
		}
	}else{
		strcpy(format,"%.2f");
	}
			
	result=stats->DoMath(expression);

	sprintf(numbuf,format,result);

	if(buf!=NULL)
		buf->assign(numbuf);
	else if(destfile!=NULL && destfile->canWrite())
		destfile->WriteStr(numbuf);
	else {templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!"); return;};
}


char *HtmlTemplate::DoIf(char *condition,char *text,string *result){
	int depth=1;
	char *starstar, *thenpart, *elsepart=NULL;
	starstar=thenpart=text;
	do{
		starstar=strstr(starstar,"**");
		if(starstar!=NULL){
			if(!strncmp(starstar,"**IF(",5) ){
				starstar=strstr(starstar+1,"**")+2;
				depth++;
			} else if(!strncmp(starstar,"**ELSE**",8) ){
				if(depth==1){
					*starstar='\0';
					starstar+=8;
					elsepart=starstar;
				}else{
					starstar+=8;
				}
			} else if(!strncmp(starstar,"**ENDIF**",9) ){
				depth--;
				
				if(depth==0){
					*starstar='\0';
					starstar+=9;
					text=starstar;
				}else{
					starstar+=9;
				}
			}else{
				templateparserLog->Log(ErrorLog.SEVERE,"Unknown IF type tag found!\n");
				starstar++;
			}
		}else{
			templateparserLog->Log(ErrorLog.SEVERE,"Unexpected end of file found inside of IF!\n");
			break;
		}
	}while( depth>0 && starstar!=NULL && *starstar!='\0');

	if(Eval(condition)){
		Parse(thenpart,result);
	}else if(elsepart!=NULL){
		Parse(elsepart,result);
	}

	return text;
}

bool HtmlTemplate::Eval(char *con){
/*	string cond;
	string *condition=&cond;
	cond=con;
//todo: really use char*
	string var1,val1,var2,val2,oper;
	double v1,v2;
	char trim[256];

	//simple expressions for now   value operator value  only
	//TODO make this handle complex expressions

	GetNextWord(condition,&var1);
	strncpy(trim,var1.c_str(),254);
	trim[255]='\0';
	var1=os.TrimStr(trim);
	GetNextWord(condition,&oper);
	GetNextWord(condition,&var2);
	strncpy(trim,var2.c_str(),254);
	trim[255]='\0';
	var2=os.TrimStr(trim);

	if(var1.length()<2 || var2.length()<2){
		templateparserLog->Log(ErrorLog.SEVERE,"Bad condition: %s %s %s\n",var1.c_str(),oper.c_str(),var2.c_str());
		return true;
	}

	if(var1.at(0)!='\"'){
		char *buf;
		buf=makeNewStr(&var1);
		stats->GetVariableValue(buf,&val1,NULL);
		delete buf;
	}else{
		val1=var1.substr(1,var1.length()-2);
	}
	if(var2.at(0)!='\"'){
		char *buf;
		buf=makeNewStr(&var2);
		stats->GetVariableValue(buf,&val2,NULL);
		delete buf;
	}else{
		val2=var2.substr(1,var2.length()-2);
	}

	v1=atof(val1.c_str());
	v2=atof(val2.c_str());
*/
///////////////////////////////////////////////////////////////////////////
	char *var1,*var2,*oper;
	double v1,v2;
	string val1,val2;

	var1=con;
	oper=strchr(var1,' ');
	(*oper)='\0';
	oper++;
	var2=strchr(oper,' ');
	(*var2)='\0';
	var2++;
	os.TrimStr(var1);
	os.TrimStr(oper);
	os.TrimStr(var2);

	if(strlen(var1)<2 || strlen(var2)<2){
		templateparserLog->Log(ErrorLog.SEVERE,"Bad condition: %s %s %s\n",var1,oper,var2);
		return true;
	}

	if(var1[0]!='\"'){
		stats->GetVariableValue(var1,&val1,NULL);
		v1=atof(val1.c_str());
	}else{
		var1++;
		var1[strlen(var1)-1]='\0';
		val1=var1;
		v1=atof(var1);
	}
	if(var2[0]!='\"'){
		stats->GetVariableValue(var2,&val2,NULL);
		v1=atof(val2.c_str());
	}else{
		var2++;
		var2[strlen(var2)-1]='\0';
		val2=var2;
		v2=atof(var2);
	}

	if(!strncmp(oper,"=",1)){
		if(!strcmp(val1.c_str(),val2.c_str())){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,">=",2)){
		if(v1>=v2){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,"<=",2)){
		if(v1 <= v2){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,">",1)){
		if(v1 > v2){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,"<",1)){
		if(v1 < v2){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,"%=",1)){
		if( (v2 != 0) && (((int)v1 % (int)v2) == 0) ){
			return true;
		}else{
			return false;
		}
	}else if(!strncmp(oper,"!=",1)){
		if(!strcmp(val1.c_str(),val2.c_str())){
			return false;
		}else{
			return true;
		}
	}

	templateparserLog->Log(ErrorLog.SEVERE,"UNKNOWN operator \'%s\' in if",oper);

	return true;
}

char* HtmlTemplate::DoLoop(char *looptype,char *text,string *result){

	char *cur,*last=NULL;
	int depth=1;

	//find end of loop
	cur=text;
	while(depth>0){
		cur=strstr(cur,"@@");
		if(cur==NULL){
			templateparserLog->Log(ErrorLog.SEVERE,"Unexpected end of file found inside of LOOP!");
			break;
		}
		if(*(cur+2)=='L'){
			depth++;				//open loop (loop inside of loop)
			cur=strstr(cur+1,"@@")+2;
		}else if(*(cur+2)=='E'){
			depth--;				//close loop
			if(depth==0){
				*cur='\0';
				last=strstr(cur+1,"@@")+2;
			}else{
				cur=strstr(cur+1,"@@")+2;
			}
		}else{
			templateparserLog->Log(ErrorLog.SEVERE,"Unknown loop tag found!");
			cur++;
		}
	}
	cur=text;
	if(last!=NULL){
		text=last;
	}else{
		text='\0';
	}
		
	//find sort type
	last=strchr(looptype,'.');
	if(last!=NULL){
		*last='\0';
		last++;
	}

	//find type of loop
	int ltype=LOOP_NONE;
	if(!strcmp(looptype,"LOOP_STATS_PLAYERS") ){
		ltype=LOOP_ALLPLAYER_FULL;
	}else if(!strcmp(looptype,"LOOP_STATS_PLAYERS_T") ){
		ltype=LOOP_ALLPLAYER_TRIM;
	}else if(!strcmp(looptype,"LOOP_GAME_PLAYERS") ){
		ltype=LOOP_GAMEPLAYER_FULL;
	}else if(!strcmp(looptype,"LOOP_GAME_PLAYERS_T") ){
		ltype=LOOP_GAMEPLAYER_TRIM;
	}else if(!strcmp(looptype,"LOOP_MAP_PLAYERS") ){
		ltype=LOOP_MAPPLAYER_FULL;
	}else if(!strcmp(looptype,"LOOP_MAP_PLAYERS_T") ){
		ltype=LOOP_MAPPLAYER_TRIM;
	}else if(!strcmp(looptype,"LOOP_MAPS") ){
		ltype=LOOP_MAPS;
	}else if(!strcmp(looptype,"LOOP_PLAYER_GAMES") ){
		ltype=LOOP_PLAYERGAMES;
	}else if(!strcmp(looptype,"LOOP_PLAYER_KILLS") ){
		ltype=LOOP_PLAYERKILLS;
	}else if(!strcmp(looptype,"LOOP_PLAYER_DEATHS") ){
		ltype=LOOP_PLAYERDEATHS;
	}else if(!strcmp(looptype,"LOOP_PLAYER_TEAMKILLS") ){
		ltype=LOOP_PLAYERTEAMKILLS;
	}else if(!strcmp(looptype,"LOOP_MAP_GAMES") ){
		ltype=LOOP_MAPGAMES;
	}else{
		templateparserLog->Log(ErrorLog.SEVERE,"ERROR: Bad loop type: %s!",looptype);
		return text;
	}

	//do the loop
	if(stats->SetupLoop(ltype,last)){
		char *temp = new char[strlen(cur)+5];
		do{
			strcpy(temp,cur);

			if(result!=NULL){
				string buf;
				Parse(temp,&buf);
				(*result)+=buf;
			}else if(destfile!=NULL && destfile->canWrite())
				Parse(temp,NULL);
			else {
				templateparserLog->Log(ErrorLog.SEVERE,"ERROR! No file and no buf!");
				return text;
			}

		}while(stats->NextLoop(ltype));
		delete temp;
	}
	
	
	return text;
}




