/* game.cpp
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Brian Risinger contact info:

troz_@xoommail.com		preferred
troz_@hotmail.com		also ok
risinger@hoflink.com	if unable to reach otherwise

98 Stone Lane
Levittown, NY  11756
USA

*/

#include "game.h"
#include "htmlfile.h"


extern char kill_strings[26][32];
extern ErrorLog *logparserLog;



void Game::HandleEvent(GameEvent *evt){
	switch(evt->event){

		case EVENT_PLAYERJOIN:{
				if(pindex[evt->player]==NULL && !gameover){
					pindex[evt->player]=new Player();
					//pindex[evt->player]->AddTime(-(evt->time_min*60+evt->time_sec));
				}else{
					if(!cont1v1 && !gameover)
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player connect - %d still connected",evt->line,evt->player);
				}
				break;
			}
		case EVENT_PLAYERLEAVE:{
				if(pindex[evt->player]!=NULL && !gameover){
					pindex[evt->player]->PlayerLeave(evt->time_min*60+evt->time_sec);
					if(pindex[evt->player]->GetTime()<0){
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Enter or leave time in Player leave",evt->line);
					}
					pindex[evt->player]=NULL;
				}else{
					if(!gameover)
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player in Player leave",evt->line);
				}
				break;
			}
		case EVENT_ITEMPICKUP:{
				if( !gameover){
					total_items++;
					all_items[evt->other]++;
					if(pindex[evt->player]!=NULL){
						pindex[evt->player]->AddItem(evt->other);
					}else{
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player in item pickup",evt->line);
					}
				}
				break;
			}
		case EVENT_KILL:{
				if( !gameover){
//					total_kills++;

					all_kills[evt->how]++;
					all_kills[0]++;
					
					if(pindex[evt->player]!=NULL){
						Player  *killer,*killee;
					
						killer=pindex[evt->player];

						if(pindex[evt->other]!=NULL){
							killee=pindex[evt->other];

/*							kills[0].AddValue(killer,killee);
							if(evt->how<CROSSTABLE_MAX_KILL){
								kills[evt->how].AddValue(killer,killee);
							}*/
							AddKillToTables(kills,evt->how,killer,killee);

							if(evt->player == evt->other ){
								pindex[evt->player]->AddSuicide(evt->how);
							}else{
								//add death
								pindex[evt->other]->AddDeath(pindex[evt->player]->GetName(),evt->how);

								//add kill
								if((this->gametype==GAMETYPE_TDM || gametype== GAMETYPE_CTF) && pindex[evt->player]->GetTeam() == pindex[evt->other]->GetTeam() ){
									//team kill - no rank change
									pindex[evt->player]->AddTeamKill(pindex[evt->other]->GetName(),evt->how);

								}else{
									//normal kill - add rank
									pindex[evt->player]->AddKill(pindex[evt->other]->GetName(),evt->how);

									//calc new rank
									int delta, diff, keerank, kerrank, custdelta;
									kerrank=pindex[evt->player]->GetRank();
									keerank=pindex[evt->other]->GetRank();
									diff=kerrank-keerank;
									delta=keerank/100-diff/200;
									if(delta<1) delta=1;
									//custom rank calc;
									st->SetKillerKillee(pindex[evt->player],pindex[evt->other],evt->how);
									custdelta=st->DoCustMath();

									pindex[evt->player]->AddRank(delta);
									pindex[evt->other]->AddRank((-delta));
									pindex[evt->player]->AddCustRank(custdelta);
									pindex[evt->other]->AddCustRank((-custdelta));
								}

							}

						}else{
							pindex[evt->player]->AddKill("UNKNOWN",evt->how);
							logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Killee", evt->line);
						}
					}else{
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Killer",evt->line);
					}
				}
				break;
			}
		case EVENT_GAMEEND:{
				{	
					if(!gameover){
						total_time_sec+=evt->time_min*60+evt->time_sec;
						for(int i=0;i<GAME_MAX_SIMU_CLIENTS;i++){
							if(pindex[i]!=NULL){
								pindex[i]->AddTime(evt->time_min*60+evt->time_sec);
							}	
						}
					}
					if(!cont1v1){
						Player *p;
						p=players.GetFirst();
						if(p!=NULL){
							do{
								p->AddGame();
							}while((p=players.GetNext())!=NULL);
						}
					}
				}
				break;
			}
		case EVENT_SAY:{
				msgs++;
				char name[50],*cptr;
				cptr=strchr(evt->msg,':');
				int dist=cptr-evt->msg;
				if(dist<48){
					memcpy(name,evt->msg,dist);
					name[dist]='\0';
					Player *p;
					p=players.FindPlayer(name);
					if(p!=NULL){
						p->AddMsg();
					}else{
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player in msg",evt->line);
					}
				}else{
					logparserLog->Log(ErrorLog.SEVERE,"line %d: Name too long in msg",evt->line);
				}
				break;
			}
		case EVENT_SAY_TEAM:{
				msgs_team++;
				char name[50],*cptr;
				cptr=strchr(evt->msg,':');
				int dist=cptr-evt->msg;
				if(dist<48){
					memcpy(name,evt->msg,dist);
					name[dist]='\0';
					Player *p;
					p=players.FindPlayer(name);
					if(p!=NULL){
						p->AddMsgTeam();
					}else{
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player in msg",evt->line);
					}
				}else{
					logparserLog->Log(ErrorLog.SEVERE,"line %d: Name too long in msg",evt->line);
				}
				break;
			}
		case EVENT_PLAYERINFO:{
				if(pindex[evt->player]!=NULL && !gameover){

					if(pindex[evt->player]->GetName()==NULL || *(pindex[evt->player]->GetName())=='\0'){
						//first set info - check for reconnect 
						bool found=false;
						Player *p,*pp;
						p=players.GetFirst();
						if(p!=NULL){
							do{
								if(!strcmp(p->GetName(),evt->name)){
									//already player of same name
									if(!strcmp(p->GetModel().c_str(),evt->model)){
										//already player with same model
										pp=p;
										found=true;
										for(int i=0;i<GAME_MAX_SIMU_CLIENTS;i++){
											if(pindex[i]==p){
												//new player - player with same name still playing
												found=false;
											}
										}
									}
									if(found==true)
										break;
								}
							}while((p=players.GetNext())!=NULL);
						}

						if(found &&pp!=NULL){
							//player reconnected
							int temptime=pindex[evt->player]->GetTime();
							delete pindex[evt->player];
							pindex[evt->player]=pp;
							pp->AddTime(temptime);
						}
					}

					pindex[evt->player]->SetInfo(evt->name,evt->model,evt->team,evt->how, evt->other, evt->wins, evt->losses,evt->time_min*60+evt->time_sec,st);
					if(!players.ContainsPlayer(pindex[evt->player])){
						players.AddPlayer(pindex[evt->player],pindex[evt->player]->GetName());
					}

				}else{
					if(!gameover)
						logparserLog->Log(ErrorLog.SEVERE,"line %d: Bad Player in setinfo",evt->line);
				}

				break;
			}
		case EVENT_LIMITHIT:{
				if(!gameover){
					gameoverreason=evt->how;
					gameover=true;
					total_time_sec+=evt->time_min*60+evt->time_sec;
					for(int i=0;i<GAME_MAX_SIMU_CLIENTS;i++){
						if(pindex[i]!=NULL){
							pindex[i]->AddTime(evt->time_min*60+evt->time_sec);
						}	
					}
				}
				break;
			}
		case EVENT_PLAYER_SCORE:{
				if(gameover){
					if(pindex[evt->player]!=NULL){
						pindex[evt->player]->SetScore(evt->other,evt->how);
					}
				}
				break;
			}
		case EVENT_TEAM_SCORE:{
				if(gameover){
					teamscores[TEAM_RED] =evt->player;
					teamscores[TEAM_BLUE]=evt->other;
				}
				break;
			}


		default: break;

	}
}

void Game::GetVariableValue(char *variable, Stats *stats, string *value, File *fp){



	
	char *begining,*end,*ptr=NULL;
//	int pos;
	char numbuf[50];

//	pos=variable->find_first_of('.');
//	begining=variable->substr(0,pos);
//	end=variable->substr(pos+1);
	end=strchr(variable,'.');
	begining=variable;
			
	if(end==NULL){

		if(!strcmp(variable,"MAPNAME")){
			if(fp!=NULL){
				fp->WriteStr(mapname.c_str());
			}else
				(*value)=mapname;
		}else if(!strcmp(variable,"MAPIMAGE")){
			if(fp!=NULL){
				fp->WriteStr(mapname.c_str());
				fp->WriteStr(".jpg");
			}else{
				(*value)=mapname;
				(*value)+=".jpg";
			}
		}else if(!strcmp(variable,"PLAYERCOUNT")){
			ptr=itoa(players.GetCount(),numbuf,10);
		}else if(!strcmp(variable,"TOTKILLS")){
			ptr=itoa(all_kills[0],numbuf,10);
		}else if(!strcmp(variable,"TOTITEMS")){
			ptr=itoa(total_items,numbuf,10);
		}else if(!strcmp(variable,"TOTMSGS")){
			ptr=itoa(msgs,numbuf,10);
		}else if(!strcmp(variable,"TOTTEAMMSGS")){
			ptr=itoa(msgs_team,numbuf,10);
		}else if(!strcmp(variable,"TOTSECONDS")){
			ptr=itoa(total_time_sec,numbuf,10);
		}else if(!strcmp(variable,"GAMETYPE")){
			switch(gametype){
			case GAMETYPE_1V1:	ptr="1V1"; break;
			case GAMETYPE_TDM:	ptr="TDM"; break;
			case GAMETYPE_CTF:	ptr="CTF"; break;
			default:			ptr="FFA"; break;
			}
		}else if(!strcmp(variable,"GAMEOVERREASON")){
			switch(gameoverreason){
			case LIMIT_TIME:	ptr="Time Limit"; break;
			case LIMIT_FRAG:	ptr="Frag Limit"; break;
			case LIMIT_CAPTURE:	ptr="Capture Limit"; break;
			default:			ptr="UNKNOWN"; break;
			}
		}else if(!strcmp(variable,"WINNER")){
			switch(gametype){
			case GAMETYPE_1V1:{
									char sorttype[50];
									strcpy(sorttype,"PLAYER_WINS.1V1");
									PList templist;
									templist.DupeList(&players);
									templist.ReSortList(sorttype,stats);
									Player *p;
									p=templist.GetFirst();
									if(p!=NULL){
										if(fp!=NULL){
											string str;
											p->Write(&str);
											fp->WriteStr(str.c_str());
										}else
											p->Write(value);
									}
									break;
							  }
			case GAMETYPE_TDM:
			case GAMETYPE_CTF:	if(teamscores[TEAM_RED]>teamscores[TEAM_BLUE]){
									ptr="RED"; 
								}else if(teamscores[TEAM_RED]<teamscores[TEAM_BLUE]){
									ptr="BLUE";
								}else{
									ptr="TIE";
								}
								break;
			default:			{
									PList templist;
									templist.DupeList(&players);
									char sorttype[50];
									
									if(gameover){
										strcpy(sorttype,"PLAYER_SCORE");
									}else{
										strcpy(sorttype,"PLAYER_FRAGS.ALL");
									}
									templist.ReSortList(sorttype,stats);
									Player *p;
									p=templist.GetFirst();
									if(p!=NULL){
										if(fp!=NULL){
											string str;
											p->Write(&str);
											fp->WriteStr(str.c_str());
										}else
											p->Write(value);
									}
								}
								break;
			}
		}

	}else{
		*end='\0';
		end++;

		if(!strcmp(begining,"TIME")){
			if(!strcmp(end,"DAYS")){
				ptr=itoa(total_time_sec/(60*60*24),numbuf,10);
			}else if(!strcmp(end,"HOURS")){
				ptr=itoa((total_time_sec/(60*60))%24,numbuf,10);
			}else if(!strcmp(end,"MINUTES")){
				ptr=itoa((total_time_sec/60)%60,numbuf,10);
			}else if(!strcmp(end,"SECONDS")){
				ptr=itoa(total_time_sec%60,numbuf,10);
			}else if(!strcmp(end,"STR")){
				GetTimeStr(numbuf);
				ptr=numbuf;
			}
		}else if(!strcmp(begining,"LIMIT")){
			if(!strcmp(end,"TIME")){
				ptr=itoa(timelimit,numbuf,10);
			}else if(!strcmp(end,"FRAG")){
				ptr=itoa(fraglimit,numbuf,10);
			}else if(!strcmp(end,"CAPTURE")){
				ptr=itoa(capturelimit,numbuf,10);
			}
		}else if(!strcmp(begining,"ALLKILLS")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<MAX_KILLTYPE){
				ptr=itoa(all_kills[type],numbuf,10);
			}else if(type>=AGGREGATE_KILLS_MIN && type<AGGREGATE_KILLS_MAX){
				ptr=itoa(GetAggregateKills(all_kills,type),numbuf,10);
			}
		}else if(!strcmp(begining,"KILLTABLE")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<CROSSTABLE_MAX_KILL){
				if(fp!=NULL){
					string str;
					kills[type].Write(&str);
					fp->WriteStr(str.c_str());
				}else
					kills[type].Write(value);
			}
		}else if(!strcmp(begining,"KILLTABLE_C")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<CROSSTABLE_MAX_KILL){
				if(fp!=NULL){
					string str;
					kills[type].WriteRowCompress(&str);
					fp->WriteStr(str.c_str());
				}else
					kills[type].WriteRowCompress(value);
			}
		}else if(!strcmp(begining,"TEAMSCORE")){
			if(!strcmp(end,"RED")){
				ptr=itoa(teamscores[TEAM_RED],numbuf,10);
			}else if(!strcmp(end,"BLUE")){
				ptr=itoa(teamscores[TEAM_BLUE],numbuf,10);
			}
		}else if(!strcmp(begining,"ITEM")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseItemStr(end);
			}
			if(type>=0 && type<ITEM_LAST){
				ptr=itoa(all_items[type],numbuf,10);
			}
		}
	}
	
	if(ptr!=NULL){
		if(fp!=NULL)
			fp->WriteStr(ptr);
		else
			(*value)=ptr;
	}

}

/*
void Game::WriteResults(int num){
	string temp,temp2;
	char numbuf[50];
	HTMLFile *file;

	temp="game";
	temp+=itoa(num,numbuf,10);
	temp+=".html";

	file = new HTMLFile((char*)temp.c_str());

	if(file->Open()){


//		file->Write("<html><head><title>");
//		file->Write(&mapname);	
//		file->Write(" - Game ");
//		file->Write(itoa(num,numbuf,10));
//		file->Write("</title></head>");
		//file->Write("<body bgcolor=\"#808080\" link=\"#0000ff\" vlink=\"#ff0000\" alink=\"00ff00\">");
//		file->Write("<body bgcolor=\"#000000\" text=\"999999\" link=\"#0000ff\" vlink=\"#ff0000\" alink=\"00ff00\">");

		temp = mapname;
		temp+= " - Game ";
		temp+=itoa(num,numbuf,10);
		file->WriteHeader(temp.c_str());
		
		temp="<CENTER><h2>Game ";
		temp+=itoa(num,numbuf,10);
		temp+="</h2>\n<h1>";
		temp+=mapname;
		temp+="</H1>\n";

		if(num!=1){
			temp+="<a href=\"game";
			temp+=itoa(num-1,numbuf,10);
			temp+=".html\">Previous game</A>\n";
		}else{
			temp+="<a href=\"games.html\">Games List</A>\n";
		}


		temp+="<img src=\"images/levelshots/";
		temp+=mapname;
		temp+=".jpg\" width=\"256\" height=\"256\">\n";

		temp+="<a href=\"game";
		temp+=itoa(num+1,numbuf,10);
		temp+=".html\">Next game</A><BR>\n";

		temp+="<a href=\"games.html\">Game List</a> <a href=\"stats.html\">Overall Stats</a> <a href=\"players.html\">Player stats</a>\n";

		temp+="<P></CENTER><P><HR><P>\n<table><tr><td>\n";

		

		temp+="Time ";
		GetTimeStr(numbuf);
		temp+=numbuf;
		temp+="<BR>\n";
		

		temp+=itoa(players.GetCount(),numbuf,10);
		temp+=" players<BR>\n";
		temp+=itoa(total_kills,numbuf,10);
		temp+=" kills<BR>\n";
		temp+=itoa(total_items,numbuf,10);
		temp+=" items<BR>\n";
		temp+=itoa(msgs,numbuf,10);
		temp+=" messages<BR>\n";
		temp+=itoa(msgs_team,numbuf,10);
		temp+=" team messages<P>\n";
		if(gameoverreason!=0){
			if(gameoverreason==1){
				temp+="Time Limit Hit\n";
			}
			if(gameoverreason==2){
				temp+="Frag Limit Hit\n";
			}
		}

		temp+="</td><td>\n";
		file->Write(&temp);


		file->Write("Scores:<BR>\n<TABLE border=1>\n");
		file->Write("<TR><TD>Name</TD><TD>Model</TD><TD>Ping</TD><TD>HC</TD><TD>Team</TD><TD>Kills</TD><TD>Deaths</TD><TD>Suicides</TD><TD>Frags</TD><TD>Score</TD><TD>Kill Dif.</TD><TD>Eff %</TD><TD>Skill</TD></TR>\n");
		Player *p;
		p=players.GetFirst();
		if(p!=NULL){
			do{
				temp.erase();
				temp2.erase();
				temp="<TR><TD>";
				p->Write(&temp2,0);
				temp+=temp2;
				temp+="</TD><TD>";
				temp+=p->GetModel();
				temp+="</TD><TD>";
				temp+=itoa(p->GetAvePing(),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa(p->GetAveHc(),numbuf,10);
				if(p->GetAveSkill()>=0){
					temp+=" B:";
					temp+=itoa(p->GetAveSkill()/100,numbuf,10);
				}
				temp+="</TD><TD>";
				switch(p->GetTeam()){
				case TEAM_RED:
					temp+="<font color=red>RED</font>";
					break;
				case TEAM_BLUE:
					temp+="<font color=blue>BLUE</font>";
					break;
				case TEAM_SPECTATOR:
					temp+="SPECT";
					break;
				default: break;
				}
				temp+="</TD><TD>";
				temp+=itoa(p->GetKill(TOTAL_KILLS),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa(p->GetDeath(TOTAL_KILLS),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa(p->GetSuicide(TOTAL_KILLS),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa((p->GetFrags(TOTAL_KILLS)),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa(p->GetScore(),numbuf,10);
				temp+="</TD><TD>";
				temp+=itoa((p->GetKillDiff(TOTAL_KILLS)),numbuf,10);
				temp+="</TD><TD>";
				p->GetEff(TOTAL_KILLS,numbuf);
				temp+=numbuf;
				temp+="</TD><TD>";
				p->GetWepSkill(TOTAL_KILLS,numbuf);
				temp+=numbuf;
				temp+="</TD></TR>";
				file->Write(&temp);
			}while((p=players.GetNext())!=NULL);
		}
		file->Write("</table>");


		file->Write("</td></tr></table>\n<P><HR><P>");

		file->Write("<h3>Kill Tables</H3><P>");

		file->Write("<table>\n");

		int c=0;
		for(int i=0;i<CROSSTABLE_MAX_KILL;i++){
			if(!kills[i].empty() || i==0){

				//add players to table
				p=players.GetFirst();
				if(p!=NULL){
					do{
						kills[i].AddPlayer(p);	
					}while((p=players.GetNext())!=NULL);
				}

				if(c%2==0){
					file->Write("<TR><TD>");
				}else{
					file->Write("<td>");
				}
				temp.erase();
				temp2.erase();
				temp2=kill_strings[i];
				temp2+="<BR>";
				file->Write(&temp2);
				kills[i].Write(&temp);
				file->Write(&temp);
				file->Write("<P>");
				if(c%2==0){
					file->Write("</TD><TD width=50>&nbsp;</TD>");
				}else{
					file->Write("</td></tr>");
				}
				c++;
			}
				
		}
		if(c%2)
			file->Write("<td>&nbsp;</td></tr>");
		file->Write("</table>");

		file->Write("<P><HR><P>");
		file->Write("<h3>Player Stats</H3><P>");
		p=players.GetFirst();
		if(p!=NULL){
			do{
				temp.erase();
				p->WriteStats(&temp,true);
				file->Write(&temp);
			}while((p=players.GetNext())!=NULL);
		}
		file->Write("<P><HR><P><font size=-2>This file was generated by <a href=\"http://members.xoom.com/TroZ_/q3logger/index.html\">Q3Logger</a></font>");

		file->Write("</body></html>");
	}else{
		printf("failed to open game %d html file",num);
	}

	delete file;
	
}
*/



///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////



void Map::AddGame(Game *game){
	int i;

	games++;

	gamelist.AddGame(game->GetGameNumber());

	PList *oplayers;

	oplayers=game->GetPlayers();

	Player *p,*pl;
	p=oplayers->GetFirst();
	if(p!=NULL){
		do{
			pl=players.FindPlayer(p->GetName());
			if(pl==NULL){
				pl=new Player(p->GetName());
				players.AddPlayer(pl,pl->GetName());
			}
			pl->AddStats(p);
			pl->AddGameNum(game->GetGameNumber());
		}while((p=oplayers->GetNext())!=NULL);
	}

	total_items+=game->GetTotalItems();
	total_time_sec+=game->GetTotalTime();
	msgs+=game->GetMsgs();
	msgs_team+=game->GetMsgsTeam();

	for(i=0;i<TEAM_MAX;i++)
		teamscores[i]+=game->GetTeamScore(i);
	for(i=0;i<MAX_KILLTYPE;i++)
		all_kills[i]+=game->GetKills(i);
	for(i=0;i<ITEM_LAST;i++)
		all_items[i]+=game->GetItem(i);
	
	gametype[game->GetType()]++;
	gameoverreason[game->GetGameOverReason()]++;
	modified=true;

}

void Map::GetVariableValue(char *variable, string *value, File *fp){
	char *begining,*end,*ptr=NULL;
	char numbuf[50];

	end=strchr(variable,'.');
	begining=variable;
	
	if(end==NULL){

		if(!strcmp(variable,"MAPNAME")){
			if(fp!=NULL){
				fp->WriteStr(mapname.c_str());
			}else
				(*value)=mapname;
		}else if(!strcmp(variable,"MAPIMAGE")){
			if(fp!=NULL){
				fp->WriteStr(mapname.c_str());
				fp->WriteStr(".jpg");
			}else{
				(*value)=mapname;
				(*value)+=".jpg";
			}
		}else if(!strcmp(variable,"GAMES")){
			ptr=itoa(games,numbuf,10);;
		}else if(!strcmp(variable,"PLAYERCOUNT")){
			ptr=itoa(players.GetCount(),numbuf,10);
		}else if(!strcmp(variable,"TOTKILLS")){
			ptr=itoa(all_kills[0],numbuf,10);
		}else if(!strcmp(variable,"TOTITEMS")){
			ptr=itoa(total_items,numbuf,10);
		}else if(!strcmp(variable,"TOTMSGS")){
			ptr=itoa(msgs,numbuf,10);
		}else if(!strcmp(variable,"TOTTEAMMSGS")){
			ptr=itoa(msgs_team,numbuf,10);
		}else if(!strcmp(variable,"TOTSECONDS")){
			ptr=itoa(total_time_sec,numbuf,10);
		}

	}else{

		*end='\0';
		end++;

		if(!strcmp(begining,"TIME")){
			if(!strcmp(end,"DAYS")){
				ptr=itoa(total_time_sec/(60*60*24),numbuf,10);
			}else if(!strcmp(end,"HOURS")){
				ptr=itoa((total_time_sec/(60*60))%24,numbuf,10);
			}else if(!strcmp(end,"MINUTES")){
				ptr=itoa((total_time_sec/60)%60,numbuf,10);
			}else if(!strcmp(end,"SECONDS")){
				ptr=itoa(total_time_sec%60,numbuf,10);
			}else if(!strcmp(end,"STR")){
				GetTimeStr(numbuf);
				ptr=numbuf;
			}
		}else if(!strcmp(begining,"ALLKILLS")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<MAX_KILLTYPE){
				ptr=itoa(all_kills[type],numbuf,10);
			}else if(type>=AGGREGATE_KILLS_MIN && type<AGGREGATE_KILLS_MAX){
				ptr=itoa(GetAggregateKills(all_kills,type),numbuf,10);
			}
		}else if(!strcmp(begining,"KILLTABLE")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<CROSSTABLE_MAX_KILL){
				if(fp!=NULL){
					string str;
					kills[type].Write(&str);
					fp->WriteStr(str.c_str());
				}else
					kills[type].Write(value);
			}
		}else if(!strcmp(begining,"KILLTABLE_C")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseKilltypeStr(end);
			}
			if(type>=0&&type<CROSSTABLE_MAX_KILL){
				if(fp!=NULL){
					string str;
					kills[type].WriteRowCompress(&str);
					fp->WriteStr(str.c_str());
				}else
					kills[type].WriteRowCompress(value);
			}
		}else if(!strcmp(begining,"TEAMSCORE")){
			if(!strcmp(end,"RED")){
				ptr=itoa(teamscores[TEAM_RED],numbuf,10);
			}else if(!strcmp(end,"BLUE")){
				ptr=itoa(teamscores[TEAM_BLUE],numbuf,10);
			}
		}else if(!strcmp(begining,"ITEM")){
			int type;
			if(end[0]>='0' && end[0]<='9'){
				type=atoi(end);
			}else{
				type=ParseItemStr(end);
			}
			if(type>=0 && type<ITEM_LAST){
				ptr=itoa(all_items[type],numbuf,10);
			}
		}else if(!strcmp(begining,"GAMETYPE")){
			if(!strcmp(end,"1V1")){
				ptr=itoa(gametype[GAMETYPE_1V1],numbuf,10);
			}else if(!strcmp(end,"TDM")){
				ptr=itoa(gametype[GAMETYPE_TDM],numbuf,10);
			}else if(!strcmp(end,"CTF")){
				ptr=itoa(gametype[GAMETYPE_CTF],numbuf,10);
			}else if(!strcmp(end,"FFA")){
				ptr=itoa(gametype[GAMETYPE_FFA],numbuf,10);
			}
		}else if(!strcmp(begining,"GAMEOVERREASON")){
			if(!strcmp(end,"TIME")){
				ptr=itoa(gameoverreason[LIMIT_TIME],numbuf,10);
			}else if(!strcmp(end,"FRAG")){
				ptr=itoa(gameoverreason[LIMIT_FRAG],numbuf,10);
			}else if(!strcmp(end,"CAPTURE")){
				ptr=itoa(gameoverreason[LIMIT_CAPTURE],numbuf,10);
			}else{
				ptr=itoa(games-(gameoverreason[LIMIT_CAPTURE]+gameoverreason[LIMIT_FRAG]+gameoverreason[LIMIT_TIME]),numbuf,10);
			}
		}
	}

	if(ptr!=NULL){
		if(fp!=NULL)
			fp->WriteStr(ptr);
		else
			(*value)=ptr;
	}

}

void Map::InitKilltables(){
	//add players to kill tables
	Player *p;
	int i;
	p=players.GetFirst();
	if(p!=NULL){
		do{
			//add player
			for(i=0;i<CROSSTABLE_MAX_KILL;i++){
				kills[i].AddPlayer(p);	
			}
			//add player's kills
			Player *killee;
			//loop through player's kills
			PlayerKillList *pk;
			pk=p->GetKillList();
			pk=pk->GetFirst();
			if(pk!=NULL){
				do{
					killee=players.FindPlayer(pk->GetName());
					if(killee!=NULL){
						for(i=1;i<MAX_KILLTYPE;i++){
							for(int j=0;j<pk->GetKill(i);j++){
								AddKillToTables(kills,i,p,killee);
							}
						}
					}
				}while((pk=pk->GetNext())!=NULL);
			}
		}while((p=players.GetNext())!=NULL);
	}
}



void Map::WriteToDb(ConfigFile *cf){
	char temp[500],temp2[50];

	cf->AddValue("","map",mapname.c_str());
	cf->AddValue("","games",itoa(games,temp,10));
	cf->AddValue("","total_time_sec",itoa(total_time_sec,temp,10));
	cf->AddValue("","total_items",itoa(total_items,temp,10));
	cf->AddValue("","msgs",itoa(msgs,temp,10));
	cf->AddValue("","msgs_team",itoa(msgs_team,temp,10));

	int i;
	for(i=0;i<ITEM_LAST;i++){
		sprintf(temp2,"item_%d",i);
		cf->AddValue("",temp2,itoa(all_items[i],temp,10));
	}
	for(i=0;i<MAX_KILLTYPE;i++){
		sprintf(temp2,"kill_%d",i);
		cf->AddValue("",temp2,itoa(all_kills[i],temp,10));
	}
	for(i=0;i<LIMIT_MAX;i++){
		sprintf(temp2,"gameover_%d",i);
		cf->AddValue("",temp2,itoa(gameoverreason[i],temp,10));
	}
	for(i=0;i<GAMETYPE_MAX;i++){
		sprintf(temp2,"gametype_%d",i);
		cf->AddValue("",temp2,itoa(gametype[i],temp,10));
	}
	for(i=0;i<TEAM_MAX;i++){
		sprintf(temp2,"teamscore_%d",i);
		cf->AddValue("",temp2,itoa(teamscores[i],temp,10));
	}
	
	string buf;
	gamelist.Write(&buf);
	cf->AddValue("","gamelist",buf.c_str());

	Player *p;
	//players
	p=players.GetFirst();
	if(p!=NULL){
		do{
			p->WriteToDb(cf);
		}while((p=players.GetNext())!=NULL);
	}

}


Map::Map(ConfigFile *cf){
	const char *temp=NULL;
	char temp2[50];

	cf->GetValue("","map",&temp);
	mapname=temp;

	printf("reading map %s\t",mapname.c_str());

	cf->GetValue("","games",&temp);
	games=atoi(temp);
	cf->GetValue("","total_time_sec",&temp);
	total_time_sec=atoi(temp);
	cf->GetValue("","total_items",&temp);
	total_items=atoi(temp);
	cf->GetValue("","msgs",&temp);
	msgs=atoi(temp);
	cf->GetValue("","msgs_team",&temp);
	msgs_team=atoi(temp);

	int i;
	for(i=0;i<ITEM_LAST;i++){
		sprintf(temp2,"item_%d",i);
		cf->GetValue("",temp2,&temp);
		all_items[i]=atoi(temp);
	}
	for(i=0;i<MAX_KILLTYPE;i++){
		sprintf(temp2,"kill_%d",i);
		cf->GetValue("",temp2,&temp);
		all_kills[i]=atoi(temp);
	}
	for(i=0;i<LIMIT_MAX;i++){
		sprintf(temp2,"gameover_%d",i);
		cf->GetValue("",temp2,&temp);
		gameoverreason[i]=atoi(temp);
	}
	for(i=0;i<GAMETYPE_MAX;i++){
		sprintf(temp2,"gametype_%d",i);
		cf->GetValue("",temp2,&temp);
		gametype[i]=atoi(temp);
	}
	for(i=0;i<TEAM_MAX;i++){
		sprintf(temp2,"teamscore_%d",i);
		cf->GetValue("",temp2,&temp);
		teamscores[i]=atoi(temp);
	}

	cf->GetValue("","gamelist",&temp);
//	os.TrimStr(temp);
	while(*temp!='\0'){
		gamelist.AddGame(atoi(temp));
		temp=strchr(temp+1,' ');
		if(temp==NULL){
			break;
		}
	}

	//now add players
	Section *s;
	Player *p;
	s=cf->GetSettings();
	if(s!=NULL){
		s=s->GetNext();
		while(s!=NULL){
			p=new Player(s);
			players.AddPlayer(p,p->GetName());
			s=s->GetNext();
		}
	}

	modified=false;

}


///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////

void MapList::ReSort(char *sort){
	//todo

}



