/* common.h
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

see common.cpp or main.cpp for license info
*/

#ifndef COMMON_H_INCLUDED
#define COMMON_H_INCLUDED

#include "os.h"
#include "defines.h"



int GetAggregateKills(int *killarray, int type);
int ParseKilltypeStr(char *str);
int ParseItemStr(char *str);
char* toucase( char* ptr);
char *makeNewStr(string *src);
char *makeNewStr(char *src);
char *safestrcpy(char* dest, const char* src,int length);
char *safestrcat(char* dest, const char* src,int length);

class ErrorLog {
	File *fp;

	bool stoscreen;
	bool stofile;
	bool ntoscreen;
	bool ntofile;
	bool timestamp;
	bool autonewline;

	int tab;

public:
	static int NORMAL;
	static int SEVERE;
	static int FILEONLY;
	static int SCREENONLY;
	static int FORCEBOTH;

	ErrorLog(const char *filename);
	~ErrorLog(){
		tab=0;
		timestamp=true;
		Log(FILEONLY,"Log Stopped");
		if(fp)
			delete fp;
	};

	void Log(int severe,char *format, ...);

	bool getSToScreen(){return stoscreen;};
	void setSToScreen(bool v){stoscreen=v;};

	bool getSToFile(){return stofile;};
	void setSToFile(bool v){stofile=v;};

	bool getNToScreen(){return ntoscreen;};
	void setNToScreen(bool v){ntoscreen=v;};

	bool getNToFile(){return ntofile;};
	void setnToFile(bool v){ntofile=v;};

	void setStatus(int s){
		if(s&1)
			ntofile=true;
		else
			ntofile=false;
		
		if(s&2)
			ntoscreen=true;
		else
			ntoscreen=false;

		if(s&4 || ntofile)
			stofile=true;
		else
			stofile=false;

		if(s&8 || ntoscreen)
			stoscreen=true;
		else
			stoscreen=false;
	};

	bool getTimestamp(){return timestamp;};
	void setTimestamp(bool v){timestamp=v;};

	bool getAutoNewline(){return autonewline;};
	void setAutoNewline(bool v){autonewline=v;};

	int getTab(){return tab;};
	void setTab(int v){tab=v;};
	int incTab(){tab++;return tab;};
	int decTab(){
		if(tab>0)
			--tab;
		return tab;
	};

};






#endif //COMMON_H_INCLUDED