/* common.cpp
 Fragistics  -  Game Statistics program for Quake 3 Arena
 Copyright (C) 2000   Brian Risinger

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Brian Risinger contact info:

troz_@xoommail.com		preferred
troz_@hotmail.com		also ok
risinger@hoflink.com	if unable to reach otherwise

98 Stone Lane
Levittown, NY  11756
USA

*/



#include "common.h"
#include <stdarg.h>
#include <stdio.h>
#include <time.h>
#include "settings.h"


extern OS os;
extern Settings settings;


char* toucase( char* ptr){
	char *ptr2=ptr;
 	while(*ptr2!='\0'){ 
		*ptr2=toupper(*ptr2);
		ptr2++;
	}
	return ptr;
}


int GetAggregateKills(int *killarray, int type){
	//must match AddKillToTables in crosstable.cpp
	if(type>=0&&type<MAX_KILLTYPE){
		return killarray[type];
	}else if(type>=AGGREGATE_KILLS_MIN && type<AGGREGATE_KILLS_MAX){
		switch(type){
		case A_ROCKET_KILL:		return killarray[ROCKET_KILL_DIRECT] +	killarray[ROCKET_KILL_SPLASH];
		case A_GRENADE_KILL:	return killarray[GRENADE_KILL_DIRECT] +	killarray[GRENADE_KILL_SPLASH];
		case A_PLASMA_KILL:		return killarray[PLASMA_KILL_DIRECT] +	killarray[PLASMA_KILL_SPLASH];
		case A_BFG_KILL:		return killarray[BFG_KILL_DIRECT] +		killarray[BFG_KILL_SPLASH];
		case A_EXPLOSIVE_KILL:	return killarray[GRENADE_KILL_DIRECT] + killarray[GRENADE_KILL_SPLASH]+ killarray[ROCKET_KILL_DIRECT] + killarray[ROCKET_KILL_SPLASH];
		case A_BULLET_KILL:		return killarray[SHOTGUN_KILL] +		killarray[MACHINEGUN_KILL];
		case A_ENERGY_KILL:		return killarray[PLASMA_KILL_DIRECT] + 	killarray[PLASMA_KILL_SPLASH] + killarray[BFG_KILL_DIRECT] +	killarray[BFG_KILL_SPLASH];
		case A_OTHER_KILL:		return killarray[GAUNTLET_KILL] +		killarray[RAILGUN_KILL] +		killarray[LIGHTNING_KILL] +		killarray[TELEFRAG_KILL];
		case A_HITSCAN_KILL:	return killarray[SHOTGUN_KILL] +		killarray[GAUNTLET_KILL] +		killarray[MACHINEGUN_KILL] +	killarray[RAILGUN_KILL] +		killarray[LIGHTNING_KILL];
		case A_NONHITSCAN_KILL: return killarray[GRENADE_KILL_DIRECT] + killarray[GRENADE_KILL_SPLASH]+ killarray[ROCKET_KILL_DIRECT] + killarray[ROCKET_KILL_SPLASH] + killarray[PLASMA_KILL_DIRECT] + killarray[PLASMA_KILL_SPLASH] + killarray[BFG_KILL_DIRECT] +	killarray[BFG_KILL_SPLASH];
		case A_SUICIDE_KILL:	return killarray[SELF_WATER] +			killarray[SELF_SLIME] +			killarray[SELF_LAVA] +			killarray[SELF_CRUSH] +			killarray[SELF_FALLING] +		killarray[SELF_SUICIDE] +		killarray[SELF_TRIGGER_HURT];
		case A_NONWEP_KILL:		return killarray[SELF_WATER] +			killarray[SELF_SLIME] +			killarray[SELF_LAVA] +			killarray[SELF_CRUSH] +			killarray[TELEFRAG_KILL] +		killarray[SELF_FALLING] +		killarray[SELF_SUICIDE] +		killarray[SELF_TRIGGER_HURT];
		default: return -1;
		}
	}
	return -1;
}



int ParseKilltypeStr(char *str){

	if(!strcmp(str,"TOTAL_KILLS")){
		return TOTAL_KILLS;
	}else if(!strcmp(str,"ALL_KILLS")){
		return TOTAL_KILLS;
	}else if(!strcmp(str,"ALL")){
		return TOTAL_KILLS;
	}else if(!strcmp(str,"TOTAL")){
		return TOTAL_KILLS;
	}else if(!strcmp(str,"SHOTGUN_KILL")){
		return SHOTGUN_KILL;
	}else if(!strcmp(str,"GAUNTLET_KILL")){
		return GAUNTLET_KILL;
	}else if(!strcmp(str,"MACHINEGUN_KILL")){
		return MACHINEGUN_KILL;
	}else if(!strcmp(str,"GRENADE_KILL_DIRECT")){
		return GRENADE_KILL_DIRECT;
	}else if(!strcmp(str,"GRENADE_KILL_SPLASH")){
		return GRENADE_KILL_SPLASH;
	}else if(!strcmp(str,"ROCKET_KILL_DIRECT")){
		return ROCKET_KILL_DIRECT;
	}else if(!strcmp(str,"ROCKET_KILL_SPLASH")){
		return ROCKET_KILL_SPLASH;
	}else if(!strcmp(str,"PLASMA_KILL_DIRECT")){
		return PLASMA_KILL_DIRECT;
	}else if(!strcmp(str,"PLASMA_KILL_SPLASH")){
		return PLASMA_KILL_SPLASH;
	}else if(!strcmp(str,"RAILGUN_KILL")){
		return RAILGUN_KILL;
	}else if(!strcmp(str,"LIGHTNING_KILL")){
		return LIGHTNING_KILL;
	}else if(!strcmp(str,"BFG_KILL_DIRECT")){
		return BFG_KILL_DIRECT;
	}else if(!strcmp(str,"BFG_KILL_SPLASH")){
		return BFG_KILL_SPLASH;
	}else if(!strcmp(str,"SELF_WATER")){
		return SELF_WATER;
	}else if(!strcmp(str,"SELF_SLIME")){
		return SELF_SLIME;
	}else if(!strcmp(str,"SELF_LAVA")){
		return SELF_LAVA;
	}else if(!strcmp(str,"SELF_CRUSH")){
		return SELF_CRUSH;
	}else if(!strcmp(str,"TELEFRAG_KILL")){
		return TELEFRAG_KILL;
	}else if(!strcmp(str,"SELF_FALLING")){
		return SELF_FALLING;
	}else if(!strcmp(str,"SELF_SUICIDE")){
		return SELF_SUICIDE;
	}else if(!strcmp(str,"SELF_TRIGGER_HURT")){
		return SELF_TRIGGER_HURT;
	}else if(!strcmp(str,"A_ROCKET_KILL")){
		return A_ROCKET_KILL;
	}else if(!strcmp(str,"A_GRENADE_KILL")){
		return A_GRENADE_KILL;
	}else if(!strcmp(str,"A_PLASMA_KILL")){
		return A_PLASMA_KILL;
	}else if(!strcmp(str,"A_BFG_KILL")){
		return A_BFG_KILL;
	}else if(!strcmp(str,"A_EXPLOSIVE_KILL")){
		return A_EXPLOSIVE_KILL;
	}else if(!strcmp(str,"A_BULLET_KILL")){
		return A_BULLET_KILL;
	}else if(!strcmp(str,"A_ENERGY_KILL")){
		return A_ENERGY_KILL;
	}else if(!strcmp(str,"A_OTHER_KILL")){
		return A_OTHER_KILL;
	}else if(!strcmp(str,"A_HITSCAN_KILL")){
		return A_HITSCAN_KILL;
	}else if(!strcmp(str,"A_NONHITSCAN_KILL")){
		return A_NONHITSCAN_KILL;
	}else if(!strcmp(str,"A_SUICIDE_KILL")){
		return A_SUICIDE_KILL;
	}else if(!strcmp(str,"A_NONWEP_KILL")){
		return A_NONWEP_KILL;
	}else{
		printf("UNKNOWN KILLTYPE IN TEMPLATE! :   %s\n",str);
		return UNKNOWN_KILL;
	}

}

int ParseItemStr(char *str){

	if(!strcmp(str,"SHOTGUN")){
		return ITEM_SHOTGUN;
	}else if(!strcmp(str,"GAUNTLET")){
		return ITEM_GAUNTLET;
	}else if(!strcmp(str,"MACHINEGUN")){
		return ITEM_MACHINEGUN;
	}else if(!strcmp(str,"GRENADEL")){
		return ITEM_GRENADEL;
	}else if(!strcmp(str,"ROCKETL")){
		return ITEM_ROCKETL;
	}else if(!strcmp(str,"LIGHTNING")){
		return ITEM_LIGHTNINGGUN;
	}else if(!strcmp(str,"RAILGUN")){
		return ITEM_RAILGUN;
	}else if(!strcmp(str,"PLASMA")){
		return ITEM_PLASMAGUN;
	}else if(!strcmp(str,"PLASMA_KILL_SPLASH")){
		return PLASMA_KILL_SPLASH;
	}else if(!strcmp(str,"BFG")){
		return ITEM_BFG;
	}else if(!strcmp(str,"ARMOR_SHARD")){
		return ITEM_ARMORSHARD;
	}else if(!strcmp(str,"ARMOR_YELLOW")){
		return ITEM_YELLOWARMOR;
	}else if(!strcmp(str,"ARMOR_RED")){
		return ITEM_REDARMOR;
	}else if(!strcmp(str,"HEALTH_5")){
		return ITEM_5HEALTH;
	}else if(!strcmp(str,"HEALTH_25")){
		return ITEM_25HEALTH;
	}else if(!strcmp(str,"HEALTH_50")){
		return ITEM_50HEALTH;
	}else if(!strcmp(str,"BATTLESUIT")){
		return ITEM_BATTLESUIT;
	}else if(!strcmp(str,"FLIGHT")){
		return ITEM_FLIGHT;
	}else if(!strcmp(str,"HASTE")){
		return ITEM_HASTE;
	}else if(!strcmp(str,"INVIS")){
		return ITEM_INVISIBILITY;
	}else if(!strcmp(str,"HEALTH_MEGA")){
		return ITEM_MEGAHEALTH;
	}else if(!strcmp(str,"QUAD")){
		return ITEM_QUADDAMAGE;
	}else if(!strcmp(str,"REGEN")){
		return ITEM_REGENERATION;
	}else if(!strcmp(str,"MEDKIT")){
		return ITEM_MEDKIT;
	}else if(!strcmp(str,"TELE")){
		return ITEM_TELEPORTER;
	}else if(!strcmp(str,"FLAG_RED")){
		return ITEM_REDFLAG;
	}else if(!strcmp(str,"FLAG_BLUE")){
		return ITEM_BLUEFLAG;
	}else if(!strcmp(str,"MACHINEGUN_A")){
		return ITEM_BULLETS;
	}else if(!strcmp(str,"SHOTGUN_A")){
		return ITEM_SHELLS;
	}else if(!strcmp(str,"GRENADEL_A")){
		return ITEM_GRENADES;
	}else if(!strcmp(str,"ROCKETL_A")){
		return ITEM_ROCKETS;
	}else if(!strcmp(str,"LIGHTNING_A")){
		return ITEM_LIGHTNING;
	}else if(!strcmp(str,"RAILGUN_A")){
		return ITEM_SLUGS;
	}else if(!strcmp(str,"PLASMA_A")){
		return ITEM_PLASMAAMMO;
	}else if(!strcmp(str,"BFG_A")){
		return ITEM_BFGAMMO;
	}else{
		printf("UNKNOWN ITEM IN TEMPLATE! :   %s\n",str);
		return UNKNOWN_KILL;
	}

}


char *makeNewStr(string *src){
	char *dest = new char[src->length()+5];
	strcpy(dest,src->c_str());
	return dest;
}


char *makeNewStr(char *src){
	char *dest = new char[strlen(src)+5];
	strcpy(dest,src);
	return dest;
}



char *safestrcpy(char* dest, const char* src,int length){
	int ssize,rlen=length-1;
	char *ptr = dest;
	if(dest==NULL && src==NULL) return ptr;
	ssize=strlen(src);
	if(ssize<rlen){
		return strcpy(dest,src);
	}
	ptr=strncpy(dest,src,length);
	dest[length]='\0';
	printf("WARNING: string trunc of %d occured trying to copy \'%s\' into %d!\n",ssize-rlen,src,length);
	return ptr;
}

char *safestrcat(char* dest, const char* src,int length){
	int dsize,ssize,rlen=length-1;
	char *ptr = dest;
	if(dest==NULL && src==NULL) return ptr;
	dsize=strlen(dest);
	if(dsize>=rlen) return ptr;
	ssize=strlen(src);
	if(dsize+ssize<rlen){
		return strcat(dest,src);
	}
	ptr=strncat(dest,src,length);
	dest[length]='\0';
	printf("WARNING: string trunc of %d occured trying to concat \'%s\' into %d!\n",(ssize+dsize)-rlen,src,length);
	return ptr;
}



int ErrorLog::NORMAL = 0;
int ErrorLog::SEVERE = 1;
int ErrorLog::FILEONLY = 2;
int ErrorLog::SCREENONLY = 3;
int ErrorLog::FORCEBOTH = 4;

ErrorLog::ErrorLog(const char *filename){
	tab=0;
	ntofile=false;
	ntoscreen=false;
	stofile=false;
	stoscreen=true;
	timestamp=true;
	autonewline=true;
	fp=os.GetFile(filename);
	if(fp!=NULL && fp->OpenWrite()){
		stofile=true;
	}else{
		printf("Failed to open file %s for logging!\n",filename);
	}
	Log(FILEONLY,"Log Started");
};


void ErrorLog::Log(int severe,char *format, ...){
	char buffer[2048];
	bool toscreen=false, tofile=false;
	va_list ap;
	
	{
		va_start(ap, format);
		_vsnprintf(buffer,2046,format,ap);
		va_end(ap);
	}
	buffer[2046]='\0';
	if(autonewline){
		strcat(buffer,"\n");
	}

	if(severe==FILEONLY){
		tofile=true;
	}else if(severe==SCREENONLY){
		toscreen=true;
	}else if(severe==FORCEBOTH){
		tofile=true;
		toscreen=true;
	}else if(severe==SEVERE){
		toscreen=stoscreen;
		tofile=stofile;
	}else if(severe==NORMAL){
		toscreen=ntoscreen;
		tofile=ntofile;
	}

	if(toscreen){
		printf(buffer);
	}
	if(tofile){
		if(fp!=NULL){
			if(timestamp){
				char buf[512];
				time_t now;
				now=time(NULL);
				strftime(buf,511,"%X %x - ",localtime(&now));
				fp->WriteStr(buf);
			}
			for(int i=0;i<tab;i++){
				fp->WriteStr("\t");
			}
			fp->WriteStr(buffer);
		}
	}
}



