#include "g_local.h"

/*
 * Player ID system
 * Adapted from CTF ID system in Quake 2 Threewave CTF 1.02
 */

void Cmd_ID_f (edict_t *ent)
{
	if (ent->client->resp.id_state) {
		gi.cprintf(ent, PRINT_HIGH, "Disabling player identication display.\n");
		ent->client->resp.id_state = false;
	} else {
		gi.cprintf(ent, PRINT_HIGH, "Activating player identication display.\n");
		ent->client->resp.id_state = true;
	}
}

void SetIDView(edict_t *ent)
{
	// Use Expert's ID-fetching system instead of CTF's

	vec3_t	forward, dir;
	trace_t	tr;
	edict_t	*who, *best;
	float	bd = 0, d;
	int i;

	ent->client->ps.stats[STAT_PLAYER_ID] = 0;

	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 1024, forward);
	VectorAdd(ent->s.origin, forward, forward);
	tr = gi.trace(ent->s.origin, NULL, NULL, forward, ent, MASK_SOLID);
	// Note don't id dead bodies
	if (tr.fraction < 1 && tr.ent &&
	    tr.ent->client && !tr.ent->deadflag) {
		ent->client->ps.stats[STAT_PLAYER_ID] = 
			CS_PLAYERNAMES + (ent - g_edicts - 1);
			//CS_PLAYERSKINS + (ent - g_edicts - 1);
		return;
	}

	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	best = NULL;
	for (i = 1; i <= maxclients->value; i++) {
		who = g_edicts + i;
		// Note don't id dead bodies
		if (!who->inuse || who->deadflag)
			continue;
		VectorSubtract(who->s.origin, ent->s.origin, dir);
		VectorNormalize(dir);
		d = DotProduct(forward, dir);
		if (d > bd && loc_CanSee(ent, who)) {
			bd = d;
			best = who;
		}
	}
	if (bd > 0.82)
		ent->client->ps.stats[STAT_PLAYER_ID] = 
			CS_PLAYERNAMES + (best - g_edicts - 1);
			//CS_PLAYERSKINS + (best - g_edicts - 1);

	/*
	edict_t	*target = NULL,	*bestTarget = NULL;
	vec3_t targetDir, viewDir, diffDir;
	// note that setting bestAngleOffset to 0.5 initially means we will
	// return null and not display a name if no players are visible 
	// within about 60 degrees of the viewpoint
	float angleOffset, bestAngleOffset = 0.5;
	trace_t tr;

	viewer->client->ps.stats[STAT_PLAYER_ID] = 0;
/*
	while ((target = G_Find (target, FOFS(classname), "player")) != NULL)
//	for (target = g_edicts + 1; target <= g_edicts + maxclients->value; target++)
	{
		if (!target->inuse)
			continue;

		// get a vector from viewer to target
		VectorSubtract(target->s.origin, viewer->s.origin, targetDir);

		// normalize the vector to the target and change to angular coordinates
		VectorNormalize(targetDir);
	
		// get a vector for the player's view angle
		AngleVectors(viewer->client->v_angle, viewDir, NULL, NULL);

		// angle difference from viewpoint to target
		_VectorSubtract(targetDir, viewDir, diffDir);

		// since both angles were normalized, cLayoutLengthgth of difference vector
		// represents difference in angle.
		angleOffset = VectorLength(diffDir);

		if (angleOffset < bestAngleOffset) {
			// angle to target is smallest so far. check LOS between target and viewer
			tr = gi.trace (viewer->s.origin, NULL, NULL, target->s.origin, 
					viewer, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
			if (tr.ent->client != NULL)	{
				// best so far
			 	bestAngleOffset = angleOffset;
				bestTarget = target;
			}
		}
	}
	
	if (bestTarget != NULL)
		viewer->client->ps.stats[STAT_PLAYER_ID] =
			CS_PLAYERSKINS + (bestTarget - g_edicts - 1);
*/
  }
