/*
  e_obit.h

  Definitions for Expert Obituary Functions

*/

//
// Constants
//
#define OBIT_BUFF_SIZE			512

#define OBIT_COMMENT			"#;\'"
#define OBIT_DELIMITER			",\n"
#define OBIT_NULL_WEAPON		"*"
#define OBIT_CONSOLE_KILL		"Console Kill"

#define OBIT_SEP				"\n  ================================\n\n"

#define OBIT_GENDER_OTHER		0				// Treat other as male for subst.
#define OBIT_GENDER_MALE		0
#define OBIT_GENDER_FEMALE		1

//
// Gender Strings
//

#define OBIT_HE					"he"
#define OBIT_HIM				"him"
#define OBIT_HIS				"his"

#define OBIT_SHE				"she"
#define OBIT_HER				"her"
#define OBIT_HER				"her"

/* ERRORS */
#define ERR_OBIT_FILEOPEN		"   ERROR: Couldn't read/open\n          \"%s\"."
#define ERR_OBIT_NOCAUSEMAP 	"   ERROR: Couldn't initialize Obit\n          Cause Map. Default message\n          will be used.\n"
#define ERR_OBIT_MALLOC 		"   ERROR: Couldn't allocate enough\n	       memory for obituary. Default\n	       messages will be used.\n"

#define ERR_OBIT_SUCCESS		"   Expert Obituary Initialized!\n"

#define ERR_OBIT_SEP			"********************\n"

/* Files */
#define E_OBIT_CAUSEFILE		"causes.txt"
#define E_OBIT_CONTEXTFILE		"contexts.txt"
#define E_OBIT_OBITUARYFILE 	"obituary.txt"

//
// Contexts
//

#define EXP_PING_MERCY_MIN		900
#define EXP_MOVE_THRESH_MIN		300
#define EXP_SKUNK_MIN			20
#define EXP_KILLING_SPREE		4
#define EXP_RANGE_POINTBLANK	75
#define EXP_RANGE_EXTREME		500

#define CON_UNDEF				0 << 0				// 0
#define CON_VICTIM_FEMALE		1 << 0				// 1
#define CON_ATTACKER_FEMALE 	1 << 1				// 2
#define CON_VICTIM_AIRBORNE 	1 << 2				// 4
#define CON_ATTACKER_AIRBORNE	1 << 3				// 8
#define CON_VICTIM_QUAD 		1 << 4				// 16
#define CON_VICTIM_INVULN		1 << 5				// 32
#define CON_VICTIM_MV_THRESH	1 << 6				// 64
#define CON_ATTACKER_MV_THRESH	1 << 7				// 128
/*
#define							1 << 8				// 256
#define							1 << 9				// 512
#define 						1 << 10 			// 1024
#define 						1 << 11 			// 2048
#define 						1 << 12 			// 4096
#define 						1 << 13 			// 8192
#define 						1 << 14 			// 16384
#define 						1 << 15 			// 32768
#define 						1 << 16 			// 65536
#define 						1 << 17 			// 131072
#define 						1 << 18 			// 262144
#define 						1 << 19 			// 524288
#define 						1 << 20 			// 1048576
#define 						1 << 21 			// 2097152
*/
#define CON_VICTIM_SKUNKING		1 << 22 			// 4194304
#define CON_ATTACKER_SKUNKING	1 << 23 			// 8388608
#define CON_VICTIM_SPREE_END	1 << 24 			// 33554432
#define CON_ATTACKER_SPREE		1 << 25 			// 16777216
#define CON_MERCY_KILL			1 << 26 			// 67108864
#define CON_ATTACKER_QUAD		1 << 27 			// 268435456
#define CON_ATTACKER_INVULN 	1 << 28 			// 536870912
#define CON_GIBBED		1 << 29 			// 134217728		
#define CON_KILL_SELF		1 << 30 			// 1073741824
	
//
// Tokens
//

#define OTOK_VICTIM_NAME		"$VName"
#define OTOK_VICTIM_HE			"$VHe"
#define OTOK_VICTIM_HIM			"$VHim"
#define OTOK_VICTIM_HIS			"$VHis"

#define OTOK_ATTACKER_NAME		"$AName"
#define OTOK_ATTACKER_HE		"$AHe"
#define OTOK_ATTACKER_HIM		"$AHim"
#define OTOK_ATTACKER_HIS		"$AHis"

//
// Structures
//

typedef struct cFlagsMap_s {
	unsigned int	cFlags;
	char*			key;
} cFlagsMap_t;

typedef struct obits_s{
	unsigned int	cFlags;
	unsigned int	msgCount;
	char			**messages;
} obits_t;

typedef struct obitContainer_s{
	unsigned int entryCount;
	obits_t **obituary;
} obitContainer_t;

typedef struct obitInfo_s {
	unsigned int memAllocated; // Total bytes allocated for Obituaries.
	unsigned int countCause;	// Total number of "cause" keys loaded.
	unsigned int countContext; // Total number of "context" keys loaded.
	unsigned int countMsgs;	// Total number of messages loaded.
	obitContainer_t **causes;
} obitInfo_t;

obitInfo_t *obits;				// Main obituary structure.
char **obitCauseMap;			// Array of strings. Index == Cause map number

//
// e_obit.c
//
void InitExpertObituary(void);
void ExpertClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker);
int GetEntityGender(edict_t *ent);
void PrintRandObitMsg(char *aName, char *vName, int aGender, int vGender, obits_t *ob);
unsigned int DiscoverContexts(edict_t *vict, edict_t *infl, edict_t *attk);
int StrBeginsWith (char *s1, char *s2);
int InsertValue(char *mess, char *format_str, char *field, char *value, int max_size);
void DisplayBestObituaryMessage(unsigned int cause, unsigned int context, int aGender, int vGender, char *aName, char *vName);
obits_t* FindContext(unsigned int cause, unsigned int cFlag, obitInfo_t *obit);
qboolean ReTagObitData(obitInfo_t *obit);
obits_t** TagMallocObituary(obitContainer_t *obitCont, obitInfo_t *obit);
char** TagMallocMessages(obits_t *obitEntry, obitInfo_t *obit);
unsigned int FindCause(char *szCause, char **szMap, unsigned int cCount);
unsigned int GetContext(cFlagsMap_t **cMap, char *szContext, unsigned int count);
obitContainer_t **LoadMessageTree(const char *szFilename, cFlagsMap_t ** cFlagsMap, char **szCauses, obitInfo_t *obits);
cFlagsMap_t** LoadContextTranslator(const char *szFilename, obitInfo_t *obits);
char** LoadCauseMap(const char *szFilename, obitInfo_t *obit);
void FreeContextTranslator(cFlagsMap_t **cTrans, obitInfo_t *obit);
void ConsoleKill (edict_t *self);
void GreenText(char *szDest, const char *szSrc);
void DumpChars(void);
