#include <stdio.h>
#include "g_local.h"

char *motd;

// InitMOTD: Initializes the MOTD on each level start
void InitMOTD(void)
{
	FILE *motdfile;
	char *filename;

	// Create the filename.
	filename = malloc(strlen(gamedir->string) + strlen(EXPERT_MOTD_FILENAME) + 2);
	strcpy(filename, gamedir->string);
	strcat(filename, "/");
	strcat(filename, EXPERT_MOTD_FILENAME);

//	filename = MOTD_FILENAME;

	// Open the MOTD
	motdfile = fopen(filename, "r");
	free(filename);

	// If a file was found, copy it over
	if (motdfile)
	{
		char line[256];				// more columns than ever possible
		char *motdbuf = NULL;
		int motdlen = 1, linelen = 0;

//		gi.dprintf("Reading %s..\n", MOTD_FILENAME);

		motdbuf = calloc(1, 1);
		if (motdbuf == NULL)			// Ran out of memory... uh oh
		{
			gi.dprintf("ERROR: Ran out of memory while initializing MOTD. Continuting execution.\n");
			fclose(motdfile);
			return;
		}

		// FIXME: This is probably a terribly inefficient way to set this up, but it works
		while (fgets(line, 256, motdfile))
		{
			linelen = strlen(line);
			motdlen += linelen;
			motdbuf = realloc(motdbuf, motdlen);		// Tagged allocation doesn't have realloc
			if (motdbuf == NULL)			// Ran out of memory... uh oh
			{
				gi.dprintf("ERROR: Ran out of memory while initializing MOTD. Continuting execution.\n");
				if (motdbuf)
					free(motdbuf);
				fclose(motdfile);
				return;
			}
			strncat(motdbuf, line, linelen);
		}
		
		motd = gi.TagMalloc(motdlen, TAG_LEVEL);
		strncpy(motd, motdbuf, motdlen);

		fclose(motdfile);
		free(motdbuf);
	} else {
		// Didn't find the file

//		gi.dprintf("Didn't find %s\n", MOTD_FILENAME);
		motd = NULL;
	}
}

// DisplayMOTD: Display the MOTD to the client
void DisplayMOTD(edict_t *client)
{
	if (motd)
		gi.centerprintf(client, "Expert Quake2 v%s\n"
			"http://www.planetquake.com/expert/\n\n"
			"\"settings\" for settings\n\n%s",
			EXPERT_VERSION, motd);
	else
		gi.centerprintf(client, "Expert Quake2 v%s\n"
			"http://www.planetquake.com/expert/\n",
			EXPERT_VERSION);
}

// DisplayRespawnLine: Displays an info line on respawn
void DisplayRespawnLine(edict_t *client)
{
	gi.cprintf(client, PRINT_MEDIUM, "Expert %s - \"help\" for info\n", GAMESTRING);
}

void DisplaySettings(edict_t *client)
{
	int flags = (int)sv_expflags->value;

	gi.cprintf(client, PRINT_MEDIUM, "The following options are in effect: ");
	
	if (flags & EXPERT_BALANCED_WEAPONS)
		gi.cprintf(client, PRINT_MEDIUM, "Balanced_Weapons ");
	if (flags & EXPERT_BALANCED_ITEMS)
		gi.cprintf(client, PRINT_MEDIUM, "Balanced_Items ");
	if (flags & EXPERT_FREE_GEAR)
		gi.cprintf(client, PRINT_MEDIUM, "Free_Gear ");
	if (flags & EXPERT_BALANCED_POWERUPS)
		gi.cprintf(client, PRINT_MEDIUM, "Balanced_Powerups ");
	if (flags & EXPERT_NO_POWERUPS)
		gi.cprintf(client, PRINT_MEDIUM, "No_Powerups ");
	if (flags & EXPERT_HOOK)
		gi.cprintf(client, PRINT_MEDIUM, "Expert_Hook ");
	if (flags & EXPERT_NO_HACKS)
		gi.cprintf(client, PRINT_MEDIUM, "Client_Cheating_Reduction ");
	if (flags & EXPERT_LEVEL_CYCLE)
		gi.cprintf(client, PRINT_MEDIUM, "Level_Cycling ");
	if (flags & EXPERT_PLAYERID)
		gi.cprintf(client, PRINT_MEDIUM, "Player_Identification ");
	if (flags & EXPERT_RADAR)
		gi.cprintf(client, PRINT_MEDIUM, "Radar ");
	if ((int)sv_utilflags->value & EXPERT_ENABLE_GIBSTAT_LOGGING)
		gi.cprintf(client, PRINT_MEDIUM, "GibStat_Logging ");

	gi.cprintf(client, PRINT_MEDIUM, "\nLethality multiplier is %.2f\n", sv_lethality->value);
}
