/*
	e_gbstat.c

	Implimentation of GibStat logging specification for Expert Server

	Updated from 1.1 to 1.2 on Jan. 27, 1998: Blitherakt!

								----------
								Due Credit
								----------

		GibStat page at: http://www.planetquake.com/gibstat
		Great idea for a modification! I plan to follow this standard 
		where ever it's applicable to a Q2 project I work on.

						------------------------------
						Musical Selections of the Hour
						------------------------------

		Tool..........................................  AEnima
		The Mighty Mighty Bostones....................	Let's Face it
		Prodigy.......................................	Fat of the Land
		The Chemical Brothers.........................	Dig Your Own Hole
		Nine Inch Nails...............................	Pretty Hate Machine
														The Downward Spiral

		
*/

#include <stdlib.h>
#include <stdio.h>
#include "g_local.h"
#include "e_gbstat.h"

// Only these functions need to have access to the file pointer.
static FILE		*gsFile;

//
// Start/Stop logging functions
//
qboolean gsStartLogging(char *szFilename)
{
	char *filename;

	time_t curTime;
	struct tm *now;

	time ( &curTime );			// Get current date/time
	now = localtime(&curTime);	// Convert it to local time

	// File is open
	if (gsFile != NULL)
		return (true);

	// Create the filename.
	filename = malloc(strlen(gamedir->string) + strlen(szFilename) + 2);
	strcpy(filename, gamedir->string);
	strcat(filename, "/");
	strcat(filename, szFilename);

	// We want to open in append mode so as not to delete any previous logs.
	gsFile = fopen(filename, "a+");
	if ( gsFile == NULL)
	{
		gi.dprintf("***************************\n");
		gi.dprintf("ERROR: Couldn't open %s (GibStat).\n", filename);
		gi.dprintf("***************************\n");
		return (false);
	}

	// GS 1.2: Log Start Added.

	fprintf(gsFile, GS_LOG_START, GS_VERSION);
	fprintf(gsFile, GS_PATCH_NAME, GAMEVERSION);

	// Create the time/date log entries
	fprintf(gsFile, GS_LOG_DATE,	(1900 + now->tm_year), 
									now->tm_mon + 1,
									now->tm_mday);
	fprintf(gsFile, GS_LOG_TIME,	now->tm_hour,
									now->tm_min,
									now->tm_sec);

	gi.dprintf("Started GibStats %s Logging...\n", GS_VERSION);
	return (true);
}

qboolean gsStopLogging()
{

	if (gsFile == NULL)
		return (true);

	if (fclose(gsFile))
		return (false);

	gi.dprintf("Stopped GibStats %s Logging...\n", GS_VERSION);

	return (true);
}

//
// Game Start/Game End logs
//

void gsEnumConnectedClients()
{
	int i = 0;

	if (gsFile == NULL)
		return;

	for (i = 0 ; i < game.maxclients ; i++)
	{
		if (strlen(game.clients[i].pers.netname) != 0)
		{
			fprintf(gsFile, GS_PLAYER_INFO,
							game.clients[i].pers.netname,
							GS_EMPTY_STRING,
							(int)level.time);
		}
	}

}

void gsPlayerNameChange(char* szOldName, char* szNewName)
{
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_PLAYER_NAME_CHANGE,
					szOldName,
					szNewName,
					(int)level.time);
}

void gsLogLevelStart()
{
	if (gsFile == NULL)
		return;

	// Log the level name
	fprintf(gsFile, GS_MAP_NAME, level.level_name);
	// Log the DM Flags setting
	fprintf(gsFile, GS_DM_SETTINGS, (int)dmflags->value);

}

// This isn't really used. It's only here in case somebody wants to create
// a Clan server out of Expert Quake 2
void gsGameStart()
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// Since fprintf returns a negative value when an error occurs, I'm not going
	// to bother checking it. If we want checking later, let me know... I'll add it.
	fprintf(gsFile, GS_GAME_START);
}

// This isn't really used. It's only here in case somebody wants to create
// a Clan server out of Expert Quake 2
void gsGameEnd()
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_GAME_END);
}

//
// Map and Client Connect/Disconnect logging.
//

void gsLogClientConnect(edict_t *ent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	if (ent->team != NULL)
	{	// Teamplay writing.
		fprintf(gsFile, GS_PLAYER_CONNECT, 
						ent->client->pers.netname, 
						ent->team, 
						(int)level.time);
	} else {
		fprintf(gsFile, GS_PLAYER_CONNECT, 
						ent->client->pers.netname, 
						GS_EMPTY_STRING, (int)level.time);
	}
}

void gsLogClientDisconnect(edict_t *ent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, GS_PLAYER_DROP, 
					ent->client->pers.netname, 
					(int)level.time);
}

//
// Frag Logging
//

void gsLogFrag(edict_t *vict, edict_t *attk)
{
	// This implimentation is specific to the Expert server as it uses the
	// vict->client->killedBy add on.

	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// TODO:	As mods are created, extra parsing info must be done here.
	//			i.e. Flag Capture, Flag Defense, etc...

	fprintf(gsFile,	GS_SCORE,
			attk->client->pers.netname,
			vict->client->pers.netname,
			GS_TYPE_KILL,
			vict->client->killedBy,
			1,
			(int)level.time,
			attk->client->ping);
	return;
}

void gsLogKillSelf(edict_t *vict, char *szCause)
{
	// This implimentation is specific to the Expert server as it uses the
	// vict->client->killedBy add on.

	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	// TODO:	As mods are created, extra parsing info must be done here.
	//			i.e. Flag Capture, Flag Defense, etc...

	fprintf(gsFile, GS_SCORE,
			vict->client->pers.netname,
			vict->client->pers.netname,
			szCause,
			GS_TYPE_SUICIDE,
			-1,
			(int)level.time,
			vict->client->ping);
	return;
}

//
// Roll your own special stuff!
// USE WITH CAUTION! Improper formatting could totally screw up the log.
//

void gsLogMisc(char *logEvent)
{
	// Don't write to an unopened file.
	if (gsFile == NULL)
		return;

	fprintf(gsFile, logEvent);
}






