/*
 * Expert Quake2 definitions
 */

// Expert: Added so that the DLL version can be available by a server query
#define EXPERT_VERSION "0.89.4"

// expflags cvars
#define EXPERT_BALANCED_WEAPONS		1 << 0		// 1
#define EXPERT_BALANCED_ITEMS		1 << 1		// 2
#define EXPERT_FREE_GEAR			1 << 2		// 4
#define EXPERT_BALANCED_POWERUPS	1 << 3		// 8
#define EXPERT_NO_POWERUPS			1 << 4		// 16
#define EXPERT_HOOK					1 << 5		// 32
#define	EXPERT_NO_HACKS				1 << 6		// 64
#define EXPERT_LEVEL_CYCLE			1 << 7		// 128
#define EXPERT_PLAYERID				1 << 8		// 256
#define EXPERT_RADAR                1 << 9      // 512

// utilflags cvars
#define EXPERT_ENABLE_GIBSTAT_LOGGING		1 << 0		// 1	Log to GibStat compat. file
#define EXPERT_DISABLE_CLIENT_OBITUARIES	1 << 1		// 2	Enable Context Obit code
//		EXPERT_WHATEVER				1 << 2		// 4	This was for move threshold stuff, but we changed the way it worked.
#define EXPERT_DISABLE_MOTD			1 << 3		// 8	Enable/Disable MOTD
#define EXPERT_DISABLE_SPAWNMSGS	1 << 4		// 16	Enable/Disable Spawn messages

// Default Values for Obit/Context cvars
#define EXPS_PING_MERCY_MIN		"900"
#define EXPS_MOVE_THRESH_MIN	"300"
#define EXPS_SKUNK_MIN			"20"
#define EXPS_KILLING_SPREE		"4"
#define EXPS_RANGE_POINTBLANK	"75"
#define EXPS_RANGE_EXTREME		"500"

// giblog Default filename
#define EXPERT_GIB_FILENAME			"gibstats.log"

// Ground checking distance.
#define EXP_AIRBORNE_THRESH		-96.0				// Two player heights.

#ifdef _WIN32
// MSVC++ #pragma to disable warnings about unreferenced formal parameters,
// constant conditional expressions, and assignments in conditionals
#pragma warning(disable : 4100 4127)
// MSVC++ #pragma to disable warnings about vars being used before being initialized.
// As it turns out, they DO get initialized, but the compiler isn't smart enough to
// figure it out..
#pragma warning(disable : 4701)
// MSVC++ #pragma to disable warnings about wacky typecasts. Admittedly dangerous,
// use at your own risk
#pragma warning(disable : 4054)
#endif

// Place to store MOTD
extern char *motd;

// Log filename
extern FILE *logfile;

// Possible game types
enum gametype_t {
	GAME_SINGLE,
	GAME_DM,
	GAME_CTF,
	GAME_ARENA,
} gametype;

#define GAMESTRING			(gametype == GAME_DM ? "DM" : (gametype == GAME_CTF ? "CTF" : (gametype == GAME_ARENA ? "Arena" : "SP")))

// Client resolutions possible
// Not used, but may be in the future..
typedef enum res_t {
	RES_320_240,
	RES_400_300,
	RES_512_384,
	RES_640_480,
	RES_800_600,
	RES_960_720,
	RES_1024_768,
	RES_1152_864,
	RES_1280_960,
	RES_1600_1200,
} res_t;

// Used for obituary movement checking for contexts.
typedef struct movDelta_s {
	vec3_t	threshOrigin;
	int		lastMoveFrame;			// Last time the moved outsied of threshhold box
} movDelta_t;

// Filename for logs and MOTD
#define EXPERT_LOG_FILENAME					"debuglog.txt"
#define EXPERT_MOTD_FILENAME				"motd.txt"

// Expert Overlay: Number of frames between statusbar updates
#define	EXPERT_UPDATE_FRAMES				6

// Expert: Shorter timer and faster speed with balanced weapons
#define BALANCED_GRENADE_TIMER				1.5
#define BALANCED_GRENADE_MINSPEED			400
#define BALANCED_GRENADE_MAXSPEED			1200

// Expert: Constrain the shot spread with balanced weapons
#define BALANCED_MACHINEGUN_HSPREAD			75
#define BALANCED_MACHINEGUN_VSPREAD			75
#define BALANCED_CHAINGUN_HSPREAD			150
#define BALANCED_CHAINGUN_VSPREAD			150

// Expert: Increase the shot count
#define BALANCED_DEATHMATCH_SHOTGUN_COUNT	20

// Expert: Modified damages
#define BALANCED_SPREAD_BLASTER_DAMAGE		12
#define BALANCED_HYPER_BLASTER_DAMAGE		10
#define BALANCED_MACHINEGUN_DAMAGE			9
#define BALANCED_CHAINGUN_DAMAGE			6

// Expert: Modified radii, speeds, and detonation damage
#define BALANCED_BFG_RADIUS					500
#define BALANCED_BFG_SPEED					300
#define BALANCED_BFG_DIVIDER				10
// The radius for BFG lasers
#define BALANCED_BFG_LASER_RADIUS			512

// Expert: Modified health sizes
#define BALANCED_HEALTH_SMALL				10
#define BALANCED_HEALTH_MEDIUM				20
#define BALANCED_HEALTH_LARGE				30

// Maximum Vampire Artifact health
#define BALANCED_MAX_VAMPIRE_HEALTH			180

// Percentage of health lost returned as armor by Blood Armor
#define BALANCED_BLOOD_ARMOR_INCREASE		0.5

// Balanced armor stats are handled in g_items.c

// The amount of health-points that shards are now equal to.
// Divide by armor resistance (.3, .6, .8) to yield how many points to add to armor.
#define BALANCED_SHARD_POINTS				4.5

// How long a dropped item stays in the world
#define BALANCED_DROPPED_ITEM_TIME			30


//
// e_grapple.c
//
qboolean Started_Grappling(gclient_t *client);
qboolean Ended_Grappling(gclient_t *client);
qboolean Is_Grappling(gclient_t *client);
void Throw_Grapple(edict_t *ent);
void Release_Grapple(edict_t *ent);
void Grapple_Touch(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void Think_Grapple(edict_t *ent);
void Make_Hook(edict_t *ent);
void Pull_Grapple(edict_t *ent);

//
// e_motd.c
//
void InitMOTD(void);
void DisplayMOTD(edict_t *client);
void DisplayRespawnLine(edict_t *client);
void DisplaySettings(edict_t *client);

//
// e_overlay.c
//

void LoadImages (void);
qboolean OverlayCommand (edict_t *pedPlayer);
void OverlayThink (edict_t *pedViewer, qboolean force);
void AppendScoresBar (edict_t *pedViewer, char *psLayout);
void UpdateMatrixScores (edict_t *pedTarget, edict_t *pedKiller);
void ExpandMatrix (edict_t *pedJoining);
void ContractMatrix (edict_t *pedLeaving);

//
// e_util.c
//
int numchr(char *str, int c);
void StuffCmd(edict_t *player, char *cmd);
void InitCmds(edict_t *player);
void E_ClearItemEffect(edict_t *dropped);
void E_ClearQuadEffect(edict_t *dropped);
void E_ClearPentEffect(edict_t *dropped);
void BootPlayer(edict_t *player, char *error, char *global);
int ShardPoints(int armor_index);
void E_LogAppend(char *desc, char *fmt, ...);
void E_LogClose(void);
qboolean NearToGround(edict_t *ent);
void TrimSpaces(char *szString);

//
// e_obit.c
//

void InitExpertObituary(void);
void ExpertClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker);
void DisplayObituaryInfo(edict_t *ent);

//
// e_gibstat.c
//

qboolean gsStartLogging(char *szFilename);
qboolean gsStopLogging();

void gsGameStart();
void gsGameEnd();
void gsLogMap();
void gsLogClientConnect(edict_t *ent);
void gsLogClientDisconnect(edict_t *ent);
void gsLogFrag(edict_t *vict, edict_t *attk);
void gsLogKillSelf(edict_t *vict, char *szCause);
void gsLogMisc(char *logEvent);
