#include "g_local.h"

// new client commands

// print name & title of current map from client
void mapname(edict_t *client)
{
    gi.cprintf(client, PRINT_MEDIUM, "%s:  \"%s\"\n",
               level.mapname, level.level_name);
}

// time left for level
void timeleft(edict_t *client)
{
    int secondsleft = (int)(timelimit->value)*60 - level.time;
    
    gi.cprintf(client, PRINT_MEDIUM, "%d min %d secs\n", secondsleft/60, 
	       secondsleft%60); 
}

// print current x y z coordinates
void whereami(edict_t *client)
{
    gi.cprintf(client, PRINT_MEDIUM, "I am at %s\n", vtos(client->s.origin));
    gi.dprintf("I am at %s angles %s\n", vtos(client->s.origin), 
	       vtos(client->s.angles));
}


          // Joe for g_cmds.c, ClientCommand()
//	  else if (Q_stricmp(cmd, "mapname") == 0)
//	      mapname(ent);
//	  else if (Q_stricmp(cmd, "timeleft") == 0)
//	      timeleft(ent);
//	  else if (Q_stricmp(cmd, "whereami") == 0)
//	      whereami(ent);
          // end Joe


// new server commands

//Joe
//ctfgame has to be extern or put in g_ctf.c

// see current number of caps & timeleft from server console
//void Svcmd_Score_f (void)
//{
//    int secondsleft = (int)(timelimit->value)*60 - level.time;
//
//
//    gi.cprintf(NULL, PRINT_HIGH,
//		 "Red: %d Blue: %d Timeleft: %d m %d s\n",
//		 ctfgame.teamScore[0], ctfgame.teamScore[1],
//		 secondsleft/60, secondsleft%60);
//}
// end Joe

void Svcmd_PrintEffect_f (void)
{
    edict_t *player;
    int playerNum;

    playerNum = atoi(gi.argv(2));
    player = g_edicts + 1 + playerNum;

    gi.bprintf(PRINT_HIGH, "effect is now %x\n", player->s.effects);

}


  // Joe for g_svcmds.c, ServerCommand()
//else if (Q_stricmp (cmd, "score") == 0)
//    Svcmd_Score_f ();
//else if (Q_stricmp (cmd, "score") == 0)
//    Svcmd_PrintEffect_f ();
  // end Joe


// rate capping!  set a maxrate maxrate variable on the server
// if maxrate unset or 0 rate will be unlimited

// Joe rates
// call ratecap() at bottom of ClientUserinfoChanged() in p_client.c
void ratecap(edict_t *ent)
{
    cvar_t *sv_maxrate;
    int maxrate, currentrate;
    char cmdstring[80];

    sv_maxrate = gi.cvar("maxrate", "0", CVAR_SERVERINFO);
    maxrate = (int)(sv_maxrate->value);
    if(maxrate){
	if(ent->inuse){
	    currentrate = atoi(Info_ValueForKey
			       (ent->client->pers.userinfo, "rate"));
	    if(currentrate > maxrate){
		gi.cprintf(ent, PRINT_HIGH,
			   "rate %d high, setting rate to %d\n",
			   currentrate, maxrate);
		Com_sprintf(cmdstring, sizeof(cmdstring), "rate %d\n",
			    maxrate);
		StuffCmd(ent, cmdstring);
	    }
	}
    }
}
//end Joe rates

// and add joe.o to the .o files in the Makefile and run make ...

