
#include "g_local.h"
#include "bot_procs.h"

void	Svcmd_Test_f (void)
{
	gi.cprintf (NULL, PRINT_HIGH, "Svcmd_Test_f()\n");
}

void	Svcmd_Bots_f (void)
{
	int i=2, j, len;
	char	name[128];

	while (i < gi.argc())
	{
		strcpy(name, gi.argv(i));
		len = strlen(name);

		// convert '~' to ' '
		for (j=0; j<len; j++)
			if (name[j] == '~')
				name[j] = ' ';

		spawn_bot(name);

		i++;
	}
}

void	Svcmd_Teams_f (void)
{
	int arg=2, i;
	char	team[128];

	while (arg < gi.argc())
	{
		strcpy(team, gi.argv(arg));

		i=0;
		while (i<MAX_TEAMS)
		{
			if (!bot_teams[i])
				break;

#ifdef _WIN32
			if (!_stricmp(bot_teams[i]->teamname, team) || !_stricmp(bot_teams[i]->abbrev, team))
#else
			if (!strcasecmp(bot_teams[i]->teamname, team) || !strcasecmp(bot_teams[i]->abbrev, team))
#endif
			{	// found the team, so add the bots
				bot_teams[i]->ingame = true;	// bots will be added automatically (below)
				break;
			}

			i++;
		}

		arg++;
	}
}

int	force_team = CTF_NOTEAM;

void	Svcmd_Blueteam_f (void)
{
	int i=2;

	force_team = CTF_TEAM2;
	while (i < gi.argc())
	{
//gi.dprintf("Spawning: \"%s\"\n", gi.argv(i));
		spawn_bot(gi.argv(i));

		i++;
	}

	force_team = CTF_NOTEAM;
}

void	Svcmd_Redteam_f (void)
{
	int i=2;

	force_team = CTF_TEAM1;
	while (i < gi.argc())
	{
		spawn_bot(gi.argv(i));

		i++;
	}

	force_team = CTF_NOTEAM;
}

/**
 * Clear all properties
 * 
 * argv(1) clearprops
 */
void Svcmd_ClearProps_f (void)
{
	if (gi.argc() != 2) {
		gi.cprintf(NULL, PRINT_HIGH, "clearprops: Usage: clearprops\n");
	} else {
		gi.cprintf(NULL, PRINT_HIGH, "All properties cleared\n");
		freeProps(gProperties);
		gProperties = newProps();
	}
}

/**
 * Set, change or view global properties
 * 
 * argv(1) prop
 */
void Svcmd_Prop_f (void) {

	if (gi.argc() > 4 || gi.argc() < 2) {
		gi.cprintf(NULL, PRINT_HIGH, "prop: Usage: prop [property] [value]\n");
		return;
	}
	
	if (gi.argc() == 2) {
		// show all global properties
		gi.cprintf(NULL, PRINT_HIGH, "Properties defined:\n");
		printProps(gProperties);
		return;
	} else if (gi.argc() == 3) {
		// display the value of a particular property
		char *value = getProp(gProperties, gi.argv(2)); 
		gi.cprintf(NULL, PRINT_HIGH, "\"%s\" is %s\n", gi.argv(2), value);
		return;
	} else { // gi.argc() == 4
		// set a new property (or override an old one)
		if (Q_stricmp("", gi.argv(3)) == 0) {
			// user entered : sv prop someprop ""
			// treat as removing a property
			removeProp(gProperties, gi.argv(2));
			gi.cprintf(NULL, PRINT_HIGH, "Removed property \"%s\"\n", gi.argv(2)); 
		} else {
			// user entered either a new prop or a real value
			// with which to override an old one
			addProp(gProperties, gi.argv(2), gi.argv(3));
			gi.cprintf(NULL, PRINT_HIGH, "Property \"%s\" is now \"%s\"\n", gi.argv(2), gi.argv(3));
		}
		return;
	}
}

/**
 * Set or unset a flag in expflags
 * 
 * argv(1) set
 */
void Svcmd_ExpflagsSet_f (void)
{
	char* settingName;
	int settingBit;

	if (gi.argc() < 3 || gi.argc() > 4) {
		gi.cprintf(NULL, PRINT_HIGH, "set: Usage: set \"flagname\" [off|on]\n");
		return;
	} 

	settingName = gi.argv(2);
	settingBit = getSettingBit(settingName);
	if (settingBit <= 0) {
		gi.cprintf(NULL, PRINT_HIGH, "Unrecognized setting \"%s\"\n", settingName);
		return;
	}

	if (gi.argc() == 3) {
		// used form "sv set setting", which means turn setting on
		gi.cvar_set("expflags", va("%d", expflags | settingBit));
		gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now enabled\n", settingName);
	} else {
		// used form "sv set setting off"
		if (Q_stricmp("off", gi.argv(3)) == 0) {
			gi.cvar_set("expflags", va("%d", expflags & ~settingBit));
			gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now disabled\n", settingName);
		} else if (Q_stricmp("on", gi.argv(3)) == 0) {
			gi.cvar_set("expflags", va("%d", expflags | settingBit));
			gi.cprintf(NULL, PRINT_HIGH, "Setting \"%s\" is now enabled\n", settingName);
		} else {
			gi.cprintf(NULL, PRINT_HIGH, "set: Usage: set \"flagname\" [off|on]\n");
		}
	}
}

/*
=================
ServerCommand

ServerCommand will be called when an "sv" command is issued.
The game can issue gi.argc() / gi.argv() commands to get the rest
of the parameters
=================
*/
void	ServerCommand (void)
{
	char	*cmd;

	cmd = gi.argv(1);
	if (Q_stricmp (cmd, "test") == 0)
		Svcmd_Test_f ();
	else if (Q_stricmp (cmd, "bots") == 0)
		Svcmd_Bots_f ();
	else if (Q_stricmp (cmd, "teams") == 0)
		Svcmd_Teams_f ();
	else if (Q_stricmp (cmd, "bluebots") == 0)
		Svcmd_Blueteam_f ();
	else if (Q_stricmp (cmd, "redbots") == 0)
		Svcmd_Redteam_f ();
	else if (Q_stricmp (cmd, "prop") == 0)
		Svcmd_Prop_f ();
	else if (Q_stricmp (cmd, "clearprops") == 0)
		Svcmd_ClearProps_f ();
	else if (Q_stricmp (cmd, "set") == 0)
		Svcmd_ExpflagsSet_f();
	else
		gi.cprintf (NULL, PRINT_HIGH, "Unknown server command \"%s\"\n", cmd);
}

