#!/bin/sh
#
#ident  "@(#)q2-install.sh    1.2     99/05/28 SMI"
# 
# size of full installation: 341928 kB
# size of linked installation: 2105 kB
#

BYPASS_SOLARIS_VERSION_CHECK="no"

USAGE="usage: $0 [-l] [-c location of CD] <quake directory>"

FILES="license.txt baseq2/pak0.pak baseq2/players baseq2/video"
QCD="/cdrom/quake2"
QDATA="install/data"
INSTALL_DIR=""
LINK="no"

WHERE=`pwd`

# check if we are running on a Solaris version prior to 7
if [ $BYPASS_SOLARIS_VERSION_CHECK = "no" ]; then
    RELEASE=`/usr/bin/uname -r`
    if [ $RELEASE != "5.7" ] && [ $RELEASE != "5.8" ]; then
	echo "You're running an incompatible version on Solaris!"
	echo "Upgrade to Solaris 7 or later..."
	exit
    fi
fi

#
# run interactive installation if we don't get any arguments
#
if [ $# = 0 ]; then
    echo "Running Quake II installation in interactive mode..."
    echo ""

    # get the CD location
    while [ 1 ]; do
	echo "Location of the Quake II CD [/cdrom/quake2]: \c"
	read line
	if [ -z "$line" ]; then
	    line=$QCD
	fi

	if [ ! -d "$line" ]; then
	    echo "Quake II CD not found!\n"
	elif [ ! -d "$line/$QDATA" ]; then
	    echo "Quake II installation directory not found!\n"
	else
	    QCD=$line
	    break
	fi

    done
    echo ""

    # get installation method
    echo "Installation options:"
    echo "  1) Full (~345 MB)"
    echo "  2) Linked (~3 MB) requires the CD to play"
    while [ 1 ]; do
	echo "Enter option [2]: \c"
	read line

	if [ -z "$line" ]; then
	    LINK=yes
	    break
	fi

	if [ "$line" = "1" ]; then
	    break
	elif [ "$line" = "2" ]; then
	    LINK="yes"
	    break
	else
	    echo "Unknown option: $line\n"
	fi

    done
    echo ""

    # get installation directory
    while [ 1 ]; do
	echo "Enter installation directory [$HOME/quake2]: \c"
	read INSTALL_DIR
	if [ -z "$INSTALL_DIR" ]; then
	    INSTALL_DIR=$HOME/quake2
	fi

	if [ ! -d "$INSTALL_DIR" ]; then
	    mkdir -p $INSTALL_DIR
	    if [ $? -eq 0 ]; then
		break
	    fi
	    echo ""
	else
	    if [ ! -w "$INSTALL_DIR" ]; then
		echo "Can't write to directory $INSTALL_DIR\n"
	    elif [ `ls -a $INSTALL_DIR | wc -l` -ne 2 ]; then
		echo "$INSTALL_DIR not empty!\n"
	    else
		break
	    fi
	fi

    done
    echo ""

#
# we got arguments so treat it as regular command line arguments
#
else

    # pick the options
    while getopts lxc: c; do
	case $c in
	l)  LINK="yes";;
	c)  QCD=$OPTARG;;
	\?) echo $USAGE
	    exit 1;;
	esac
    done
    shift `expr $OPTIND - 1`

    # check that we got a install directory
    if [ $# != 1 ]; then
	echo $USAGE
	exit 1
    fi

    INSTALL_DIR=$1

    # use the provided CD location
    if [ $# = 2 ]; then
	QCD=$2
    fi

    if [ ! -d $QCD ]; then
	echo "Quake II CD directory not found!"
	exit 1
    fi

    if [ ! -d $QCD/$QDATA ]; then
	echo "Quake II data directory not found!"
	exit 1
    fi


    # create the INSTALL_DIR if it doesn't exist
    if [ ! -d $INSTALL_DIR ]; then
	mkdir $INSTALL_DIR
	if [ $? != 0 ]; then
	    exit 1
	fi
    else
	if [ ! -w "$INSTALL_DIR" ]; then
	    echo "Can't write to directory $INSTALL_DIR\n"
	    exit 1
	elif [ `ls -a $INSTALL_DIR | wc -l` -ne 2 ]; then
	    echo "$INSTALL_DIR not empty!"
	    exit 1
    	fi
    fi

fi

# now we're ready to go...
cd $QCD/$QDATA

echo "Copying files. This may take a while... \c"

if [ $LINK = "yes" ]; then
    FILES="license.txt baseq2/players"
    tar cf - $FILES | ( cd $INSTALL_DIR; tar fx - )

    # now setup links to the cd
    cd $INSTALL_DIR/baseq2
    ln -s $QCD/$QDATA/baseq2/pak0.pak
    ln -s $QCD/$QDATA/baseq2/video
else
    tar cf - $FILES | ( cd $INSTALL_DIR; tar fx - )
fi
echo "done!"

# now fix the names of the player skins
cd $INSTALL_DIR/baseq2/players/female
if [ -f briann~1.pcx ]; then
    mv briann~1.pcx brianna_i.pcx
    mv jezebe~1.pcx jezebel_i.pcx
    mv stilet~1.pcx stiletto_i.pcx

    cd ../male
    mv claymo~1.pcx claymore_i.pcx
    mv howitz~1.pcx howitzer_i.pcx
    mv nighto~1.pcx nightops_i.pcx
    mv pointm~1.pcx pointman_i.pcx
    mv rampag~1.pcx rampage_i.pcx
fi

# now tell the user to untar the files to the right location
echo "Now perform the following commands to install the binaries:\n"
echo "1) cd $INSTALL_DIR"
echo "2) gzip -d q2-`uname -p`-beta2.tar.gz | tar fxv -"


